/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model;

import com.intellij.database.dialects.postgres.model.PgRoot;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRole;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PgRole
extends PgGPlumBaseRole {
    public static final BasicMetaProperty<Boolean> REPLICATION = BasicMetaProperty.create((String)"Replication", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, PgRole.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> BYPASS_RLS = BasicMetaProperty.create((String)"BypassRls", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, PgRole.class, (boolean)false);

    @Override
    @Nullable
    default public PgRoot getRoot() {
        return this.getParent();
    }

    @Override
    @Nullable
    public PgRoot getParent();

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PgRole> getParentFamily() {
        return null;
    }

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            PgRole.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            PgRole.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getConfig();

    public boolean isReplication();

    public boolean isBypassRls();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean bypassRls;
        boolean replication;
        boolean canLogin;
        boolean createRole;
        boolean inherit;
        List<String> config;
        String validUntil;
        long connectionLimit;
        boolean createDb;
        boolean superRole;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer == null) {
            PgRole.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", (Object)PropertyConverter.export((long)objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", (Object)PropertyConverter.export((String)comment));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if (superRole = this.isSuperRole()) {
            consumer.accept("SuperRole", (Object)PropertyConverter.export((boolean)superRole));
        }
        if (createDb = this.isCreateDb()) {
            consumer.accept("CreateDb", (Object)PropertyConverter.export((boolean)createDb));
        }
        if ((connectionLimit = this.getConnectionLimit()) != -1L) {
            consumer.accept("ConnectionLimit", (Object)PropertyConverter.export((long)connectionLimit));
        }
        if ((validUntil = this.getValidUntil()) != null) {
            consumer.accept("ValidUntil", (Object)PropertyConverter.export((String)validUntil));
        }
        if (!(config = this.getConfig()).isEmpty()) {
            consumer.accept("Config", (Object)PropertyConverter.exportListOfString(config));
        }
        if (!(inherit = this.isInherit())) {
            consumer.accept("Inherit", (Object)PropertyConverter.export((boolean)inherit));
        }
        if (createRole = this.isCreateRole()) {
            consumer.accept("CreateRole", (Object)PropertyConverter.export((boolean)createRole));
        }
        if (canLogin = this.isCanLogin()) {
            consumer.accept("CanLogin", (Object)PropertyConverter.export((boolean)canLogin));
        }
        if (replication = this.isReplication()) {
            consumer.accept("Replication", (Object)PropertyConverter.export((boolean)replication));
        }
        if (bypassRls = this.isBypassRls()) {
            consumer.accept("BypassRls", (Object)PropertyConverter.export((boolean)bypassRls));
        }
    }

    @Override
    public void setConfig(@NotNull List<String> var1);

    @Override
    default public void setConfig(String ... config) {
        this.setConfig(Arrays.asList(config));
    }

    public void setReplication(boolean var1);

    public void setBypassRls(boolean var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            PgRole.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String superRole = _properties.get("SuperRole");
        String createDb = _properties.get("CreateDb");
        String connectionLimit = _properties.get("ConnectionLimit");
        String validUntil = _properties.get("ValidUntil");
        String config = _properties.get("Config");
        String inherit = _properties.get("Inherit");
        String createRole = _properties.get("CreateRole");
        String canLogin = _properties.get("CanLogin");
        String replication = _properties.get("Replication");
        String bypassRls = _properties.get("BypassRls");
        this.setObjectId(objectId != null ? PropertyConverter.importLong((String)objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString((String)comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setSuperRole(superRole != null ? PropertyConverter.importBoolean((String)superRole) : false);
        this.setCreateDb(createDb != null ? PropertyConverter.importBoolean((String)createDb) : false);
        this.setConnectionLimit(connectionLimit != null ? PropertyConverter.importLong((String)connectionLimit) : -1L);
        this.setValidUntil(validUntil != null ? PropertyConverter.importString((String)validUntil) : null);
        this.setConfig(config != null ? PropertyConverter.importListOfString((String)config) : Collections.emptyList());
        this.setInherit(inherit != null ? PropertyConverter.importBoolean((String)inherit) : true);
        this.setCreateRole(createRole != null ? PropertyConverter.importBoolean((String)createRole) : false);
        this.setCanLogin(canLogin != null ? PropertyConverter.importBoolean((String)canLogin) : false);
        this.setReplication(replication != null ? PropertyConverter.importBoolean((String)replication) : false);
        this.setBypassRls(bypassRls != null ? PropertyConverter.importBoolean((String)bypassRls) : false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgres/model/PgRole";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgres/model/PgRole";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

