/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraDescriptionService$WhenMappings;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraMatLog;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraSynonym;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.TableOrganization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u0004*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/oracle/model/OraDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeOraCluster", "cluster", "Lcom/intellij/database/dialects/oracle/model/OraCluster;", "describeOraClusterColumn", "column", "Lcom/intellij/database/dialects/oracle/model/OraClusterColumn;", "describeOraIndex", "index", "Lcom/intellij/database/dialects/oracle/model/OraIndex;", "describeOraMatLog", "ml", "Lcom/intellij/database/dialects/oracle/model/OraMatLog;", "describeOraMatView", "view", "Lcom/intellij/database/dialects/oracle/model/OraMatView;", "describeOraTable", "table", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "options", "suffix", "dependsOnNames", "Lcom/intellij/database/dialects/oracle/model/OraSourceAware;", "withSurrogates", "", "intellij.database.dialects.oracle"})
public final class OraDescriptionService
extends DescriptionService {
    @NotNull
    public String suffix(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        String dep;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof OraSourceAware ? ((dep = this.dependsOnNames((OraSourceAware)e, context.getWithSurrogates())) != null ? context.getIndent() + this.getIndentStep() + "^ depends on " + dep + this.getEoln() : "") : super.suffix(e, context);
    }

    @NotNull
    public String options(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return super.options(e, context) + (e instanceof OraSourceAware && ((OraSourceAware)e).isObfuscated() ? " [obfuscated]" : "") + (e instanceof OraMatView && ((OraMatView)e).isPrebuilt() ? " [prebuilt]" : "") + (e instanceof OraSynonym && ((OraSynonym)e).isInvalid() ? " [invalid]" : "");
    }

    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof OraCluster ? this.describeOraCluster((OraCluster)e) : (basicElement instanceof OraClusterColumn ? this.describeOraClusterColumn((OraClusterColumn)e) : (basicElement instanceof OraTable ? this.describeOraTable((OraTable)e) : (basicElement instanceof OraMatLog ? this.describeOraMatLog((OraMatLog)e) : (basicElement instanceof OraMatView ? this.describeOraMatView((OraMatView)e) : (basicElement instanceof OraIndex ? this.describeOraIndex((OraIndex)e) : super.content(e, context))))));
    }

    /*
     * WARNING - void declaration
     */
    private final String dependsOnNames(@NotNull OraSourceAware $this$dependsOnNames, boolean withSurrogates) {
        void $this$mapNotNullTo$iv$iv;
        Set<Long> set = $this$dependsOnNames.getDependsOnIds();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"this.dependsOnIds");
        Set<Long> ids = set;
        if (ids.isEmpty()) {
            return null;
        }
        BasicDatabase basicDatabase = $this$dependsOnNames.getDatabase();
        if (basicDatabase == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)basicDatabase, (String)"this.database!!");
        BasicDatabase database = basicDatabase;
        BasicSchema basicSchema = $this$dependsOnNames.getSchema();
        if (basicSchema == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)basicSchema, (String)"this.schema!!");
        BasicSchema schema = basicSchema;
        Iterable $this$mapNotNull$iv = ids;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Long it = (Long)element$iv$iv;
            boolean bl2 = false;
            Long l = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"it");
            BasicIdentifiedElement o = database.findIdentifiedElement(l.longValue());
            if (o == null) {
                string = withSurrogates ? String.valueOf(it) : null;
            } else if (o.getSchema() == schema) {
                string = o.getName();
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                Object object = o.getSchema();
                if (object == null || (object = object.getName()) == null) {
                    object = "<unknown-schema>";
                }
                string = stringBuilder.append((String)object).append('.').append(o.getName()).toString();
            }
            if (string == null) continue;
            String string2 = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List items = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        if (items.isEmpty()) {
            return null;
        }
        return CollectionsKt.joinToString$default((Iterable)items, null, null, null, (int)0, null, null, (int)63, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String describeOraCluster(OraCluster cluster) {
        ModPositioningNamingFamily<? extends OraClusterColumn> modPositioningNamingFamily = cluster.getColumns();
        Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"cluster.columns");
        List list = modPositioningNamingFamily.getNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cluster.columns.names");
        String columns = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
        String s = null;
        ClusterType clusterType = cluster.getClusterType();
        if (clusterType == null) return "cluster (" + columns + ')';
        switch (OraDescriptionService$WhenMappings.$EnumSwitchMapping$0[clusterType.ordinal()]) {
            case 1: {
                return "index cluster (" + columns + ") block size " + cluster.getBlockSize();
            }
            case 2: {
                String exp = cluster.getHashExpression();
                s = exp == null ? "hash cluster (" + columns + ") hash by column cardinality " + cluster.getHashCardinality() : "hash cluster (" + columns + ") hash by (" + exp + ") cardinality " + cluster.getHashCardinality();
                if (!cluster.isSingleTable()) return s;
                return s + " (single table)";
            }
            default: {
                return "cluster (" + columns + ')';
            }
        }
    }

    private final String describeOraClusterColumn(OraClusterColumn column2) {
        String string = column2.getDataType().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"column.dataType.toString()");
        String s = string;
        if (column2.isSorted()) {
            s = s + " sort";
        }
        return s;
    }

    @NotNull
    public final String describeOraTable(@NotNull OraTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        String d = table.getOrganization() == TableOrganization.ORA_CLUSTERED_BY_INDEX ? "cluster table" : (table.getOrganization() == TableOrganization.ORA_CLUSTERED_BY_HASH ? "cluster table" : (table.isTemporary() && table.isTemporaryPreserve() ? "temporary table (preserve rows)" : (table.isTemporary() && !table.isTemporaryPreserve() ? "temporary table" : this.describeTable((BasicTable)table))));
        switch (OraDescriptionService$WhenMappings.$EnumSwitchMapping$1[table.getTableType().ordinal()]) {
            case 1: {
                d = d + " (mat.log)";
                break;
            }
            case 2: {
                d = d + " (mat.view)";
                break;
            }
        }
        if (table.isSecondary()) {
            d = d + " secondary";
        }
        return d;
    }

    private final String describeOraMatLog(OraMatLog ml) {
        String s = ml.withOptions();
        if (ml.isWithNewValues()) {
            s = s + " including new values";
        }
        String string = s;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"s");
        return string;
    }

    private final String describeOraMatView(OraMatView view) {
        return this.describeView((BasicView)view) + " " + view.getRefreshSpecification();
    }

    private final String describeOraIndex(OraIndex index2) {
        String desc = super.describeIndex((BasicIndex)index2);
        if (index2.getIndextypeName() != null) {
            desc = desc + " indextype: ";
            if (index2.getIndextypeOwner() != null) {
                desc = desc + index2.getIndextypeOwner() + ".";
            }
            desc = desc + index2.getIndextypeName();
        }
        return desc;
    }
}

