/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraClusterIndex;
import com.intellij.database.dialects.oracle.model.OraMajorObject;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraStoredSchemaObject;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraCluster
extends OraMajorObject,
DasCluster,
OraStoredSchemaObject {
    public static final BasicMetaProperty<ClusterType> CLUSTER_TYPE = BasicMetaProperty.create((String)"ClusterType", (BasicMetaType)BasicMetaType.Types.CLUSTER_TYPE, null, OraCluster.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> SINGLE_TABLE = BasicMetaProperty.create((String)"SingleTable", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, OraCluster.class, (boolean)false);
    public static final BasicMetaProperty<Integer> BLOCK_SIZE = BasicMetaProperty.create((String)"BlockSize", (BasicMetaType)BasicMetaType.Types.INT, (Object)0, OraCluster.class, (boolean)false);
    public static final BasicMetaProperty<String> HASH_EXPRESSION = BasicMetaProperty.create((String)"HashExpression", (BasicMetaType)BasicMetaType.Types.STRING, null, OraCluster.class, (boolean)false);
    public static final BasicMetaProperty<Integer> HASH_CARDINALITY = BasicMetaProperty.create((String)"HashCardinality", (BasicMetaType)BasicMetaType.Types.INT, (Object)0, OraCluster.class, (boolean)false);

    @Nullable
    default public OraSchema getSchema() {
        return this.getParent();
    }

    @Nullable
    public OraSchema getParent();

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraCluster> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModPositioningNamingFamily<@NotNull ? extends OraClusterColumn> getColumns();

    @NotNull
    public @NotNull ModSingletonFamily<@NotNull ? extends OraClusterIndex> getIndices();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.INDEX);
        if (list == null) {
            OraCluster.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getIndices());
        if (list == null) {
            OraCluster.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public ClusterType getClusterType();

    public boolean isSingleTable();

    public int getBlockSize();

    @Nullable
    public String getHashExpression();

    public int getHashCardinality();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        int hashCardinality;
        String hashExpression;
        int blockSize;
        boolean singleTable;
        ClusterType clusterType;
        String tablespaceName;
        Date modifiedTimestamp;
        Date createdTimestamp;
        boolean outdated;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer == null) {
            OraCluster.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", (Object)PropertyConverter.export((long)objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", (Object)PropertyConverter.export((Date)createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", (Object)PropertyConverter.export((Date)modifiedTimestamp));
        }
        if ((tablespaceName = this.getTablespaceName()) != null) {
            consumer.accept("TablespaceName", (Object)PropertyConverter.export((String)tablespaceName));
        }
        if ((clusterType = this.getClusterType()) != null) {
            consumer.accept("ClusterType", (Object)PropertyConverter.export((Enum)clusterType));
        }
        if (singleTable = this.isSingleTable()) {
            consumer.accept("SingleTable", (Object)PropertyConverter.export((boolean)singleTable));
        }
        if ((blockSize = this.getBlockSize()) != 0) {
            consumer.accept("BlockSize", (Object)PropertyConverter.export((int)blockSize));
        }
        if ((hashExpression = this.getHashExpression()) != null) {
            consumer.accept("HashExpression", (Object)PropertyConverter.export((String)hashExpression));
        }
        if ((hashCardinality = this.getHashCardinality()) != 0) {
            consumer.accept("HashCardinality", (Object)PropertyConverter.export((int)hashCardinality));
        }
    }

    public void setClusterType(@Nullable ClusterType var1);

    public void setSingleTable(boolean var1);

    public void setBlockSize(int var1);

    public void setHashExpression(@Nullable String var1);

    public void setHashCardinality(int var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            OraCluster.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String outdated = _properties.get("Outdated");
        String createdTimestamp = _properties.get("CreatedTimestamp");
        String modifiedTimestamp = _properties.get("ModifiedTimestamp");
        String tablespaceName = _properties.get("TablespaceName");
        String clusterType = _properties.get("ClusterType");
        String singleTable = _properties.get("SingleTable");
        String blockSize = _properties.get("BlockSize");
        String hashExpression = _properties.get("HashExpression");
        String hashCardinality = _properties.get("HashCardinality");
        this.setObjectId(objectId != null ? PropertyConverter.importLong((String)objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setCreatedTimestamp(createdTimestamp != null ? PropertyConverter.importDate((String)createdTimestamp) : null);
        this.setModifiedTimestamp(modifiedTimestamp != null ? PropertyConverter.importDate((String)modifiedTimestamp) : null);
        this.setTablespaceName(tablespaceName != null ? PropertyConverter.importString((String)tablespaceName) : null);
        this.setClusterType(clusterType != null ? PropertyConverter.importClusterType((String)clusterType) : null);
        this.setSingleTable(singleTable != null ? PropertyConverter.importBoolean((String)singleTable) : false);
        this.setBlockSize(blockSize != null ? PropertyConverter.importInt((String)blockSize) : 0);
        this.setHashExpression(hashExpression != null ? PropertyConverter.importString((String)hashExpression) : null);
        this.setHashCardinality(hashCardinality != null ? PropertyConverter.importInt((String)hashCardinality) : 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/model/OraCluster";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraCluster";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

