/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.generator.producers;

import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateSequence;
import com.intellij.database.dialects.mssql.generator.MsScriptGeneratorHelperKt;
import com.intellij.database.dialects.mssql.model.MsSequence;
import com.intellij.database.model.DataType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u001a\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/mssql/generator/producers/MsCreateSequence;", "Lcom/intellij/database/dialects/base/generator/producers/CreateSequence;", "Lcom/intellij/database/dialects/mssql/model/MsSequence;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/mssql/model/MsSequence;)V", "gatherSequenceIdentityParameters", "", "sequence", "parameters", "", "", "getDefaultMax", "Ljava/math/BigInteger;", "getDefaultMin", "produceComment", "exists", "", "comment", "intellij.database.dialects.mssql"})
public final class MsCreateSequence
extends CreateSequence<MsSequence> {
    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        MsScriptGeneratorHelperKt.msAlterComment(this, exists, comment);
    }

    private final BigInteger getDefaultMin(MsSequence sequence) {
        BigInteger bigInteger;
        DataType dataType = sequence.getUnderlyingDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"sequence.underlyingDataType");
        DataType dataType2 = dataType;
        String string = dataType2.typeName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dataType.typeName");
        String string2 = string;
        int n = 0;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        switch (string4) {
            case "tinyint": {
                bigInteger = BigInteger.ZERO;
                break;
            }
            case "smallint": {
                n = Short.MIN_VALUE;
                boolean bl = false;
                BigInteger bigInteger2 = BigInteger.valueOf(n);
                bigInteger = bigInteger2;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2, (String)"BigInteger.valueOf(this.toLong())");
                break;
            }
            case "int": {
                n = Integer.MIN_VALUE;
                boolean bl = false;
                BigInteger bigInteger3 = BigInteger.valueOf(n);
                bigInteger = bigInteger3;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger3, (String)"BigInteger.valueOf(this.toLong())");
                break;
            }
            case "bigint": {
                long l = Long.MIN_VALUE;
                boolean bl = false;
                BigInteger bigInteger4 = BigInteger.valueOf(l);
                bigInteger = bigInteger4;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger4, (String)"BigInteger.valueOf(this)");
                break;
            }
            case "numeric": 
            case "decimal": {
                String string5 = "-" + StringsKt.repeat((CharSequence)"9", (int)dataType2.getLength());
                boolean bl = false;
                bigInteger = new BigInteger(string5);
                break;
            }
            default: {
                bigInteger = null;
            }
        }
        return bigInteger;
    }

    private final BigInteger getDefaultMax(MsSequence sequence) {
        BigInteger bigInteger;
        DataType dataType = sequence.getUnderlyingDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"sequence.underlyingDataType");
        DataType dataType2 = dataType;
        String string = dataType2.typeName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dataType.typeName");
        String string2 = string;
        int n = 0;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        switch (string4) {
            case "tinyint": {
                n = 255;
                boolean bl = false;
                BigInteger bigInteger2 = BigInteger.valueOf(n);
                bigInteger = bigInteger2;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2, (String)"BigInteger.valueOf(this.toLong())");
                break;
            }
            case "smallint": {
                n = Short.MAX_VALUE;
                boolean bl = false;
                BigInteger bigInteger3 = BigInteger.valueOf(n);
                bigInteger = bigInteger3;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger3, (String)"BigInteger.valueOf(this.toLong())");
                break;
            }
            case "int": {
                n = Integer.MAX_VALUE;
                boolean bl = false;
                BigInteger bigInteger4 = BigInteger.valueOf(n);
                bigInteger = bigInteger4;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger4, (String)"BigInteger.valueOf(this.toLong())");
                break;
            }
            case "bigint": {
                long l = Long.MAX_VALUE;
                boolean bl = false;
                BigInteger bigInteger5 = BigInteger.valueOf(l);
                bigInteger = bigInteger5;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger5, (String)"BigInteger.valueOf(this)");
                break;
            }
            case "numeric": 
            case "decimal": {
                String string5 = StringsKt.repeat((CharSequence)"9", (int)dataType2.getLength());
                boolean bl = false;
                bigInteger = new BigInteger(string5);
                break;
            }
            default: {
                bigInteger = null;
            }
        }
        return bigInteger;
    }

    @Override
    public void gatherSequenceIdentityParameters(@NotNull MsSequence sequence, @NotNull List<String> parameters2) {
        block12: {
            block11: {
                boolean bl;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
                Intrinsics.checkParameterIsNotNull(parameters2, (String)"parameters");
                if (Intrinsics.areEqual((Object)sequence.getDataType(), (Object)DataType.UNKNOWN) ^ true && !StringsKt.equals((String)sequence.getDataType().typeName, (String)"bigint", (boolean)true)) {
                    object = parameters2;
                    StringBuilder stringBuilder = new StringBuilder().append("as ");
                    DataType dataType = sequence.getDataType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"sequence.dataType");
                    String string = stringBuilder.append(this.script(dataType)).toString();
                    bl = false;
                    object.add(string);
                }
                SequenceIdentity sequenceIdentity = sequence.getSequenceIdentity();
                if (sequenceIdentity != null) {
                    BigInteger defStart;
                    BigInteger bigInteger;
                    object = sequenceIdentity;
                    boolean bl2 = false;
                    bl = false;
                    Object identity = object;
                    boolean bl3 = false;
                    BigInteger defaultMin = this.getDefaultMin(sequence);
                    BigInteger defaultMax = this.getDefaultMax(sequence);
                    if (((SequenceIdentity)identity).increment.compareTo(BigInteger.ZERO) > 0) {
                        bigInteger = ((SequenceIdentity)identity).min;
                        if (bigInteger == null) {
                            bigInteger = defaultMin;
                        }
                    } else {
                        bigInteger = ((SequenceIdentity)identity).max;
                        if (bigInteger == null) {
                            bigInteger = defStart = defaultMax;
                        }
                    }
                    if (((SequenceIdentity)identity).next != null && Intrinsics.areEqual((Object)((SequenceIdentity)identity).next, (Object)defStart) ^ true && ((Boolean)this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE)).booleanValue()) {
                        parameters2.add("start with " + ((SequenceIdentity)identity).next);
                    }
                    if (Intrinsics.areEqual((Object)((SequenceIdentity)identity).increment, (Object)BigInteger.ONE) ^ true) {
                        parameters2.add("increment by " + ((SequenceIdentity)identity).increment);
                    }
                    if (((SequenceIdentity)identity).min != null && Intrinsics.areEqual((Object)((SequenceIdentity)identity).min, (Object)defaultMin) ^ true) {
                        parameters2.add("minvalue " + ((SequenceIdentity)identity).min);
                    }
                    if (((SequenceIdentity)identity).max != null && Intrinsics.areEqual((Object)((SequenceIdentity)identity).max, (Object)defaultMax) ^ true) {
                        parameters2.add("maxvalue " + ((SequenceIdentity)identity).max);
                    }
                }
                if (sequence.isCycled()) {
                    parameters2.add("cycle");
                }
                if (sequence.getCacheSize() >= 0L) break block11;
                parameters2.add("no cache");
                break block12;
            }
            if (sequence.getCacheSize() <= 0L) break block12;
            parameters2.add("cache " + sequence.getCacheSize());
        }
    }

    public MsCreateSequence(@NotNull ScriptingContext context, @NotNull MsSequence element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, (BasicSequence)element);
    }
}

