/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.greenplum;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.greenplum.GPlumObjectBuilder;
import com.intellij.database.dialects.greenplum.model.GPlumExternalTable;
import com.intellij.database.dialects.greenplum.model.GPlumLocalTable;
import com.intellij.database.dialects.greenplum.model.GPlumLocalTableColumn;
import com.intellij.database.dialects.greenplum.model.GPlumPartition;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBaseObjectBuilder;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.properties.GPlumExternalTableFormat;
import com.intellij.database.model.properties.GPlumPartitionKind;
import com.intellij.database.model.properties.GPlumPartitionTree;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.dialects.greenplum.GPlumElementTypes;
import com.intellij.sql.dialects.greenplum.GPlumTypes;
import com.intellij.sql.dialects.greenplum.psi.GPlumCreateTableStatement;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u0014H\u0002J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0012H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002J\u0014\u0010(\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0015\u0010)\u001a\u00070*\u00a2\u0006\u0002\b+2\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020%0\u001f2\u0006\u0010-\u001a\u00020!H\u0002J\u0015\u0010.\u001a\u00020/2\u000b\u00100\u001a\u00070\u0012\u00a2\u0006\u0002\b+H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010%2\u0006\u00102\u001a\u00020'H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00063"}, d2={"Lcom/intellij/database/dialects/greenplum/GPlumObjectBuilder;", "Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBaseObjectBuilder;", "()V", "lazyCodeBlock", "Lcom/intellij/psi/tree/IElementType;", "getLazyCodeBlock", "()Lcom/intellij/psi/tree/IElementType;", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/sql/database/SqlObjectBuilder$Context;", "buildExternalTable", "Lcom/intellij/database/dialects/greenplum/model/GPlumExternalTable;", "buildLocalTable", "Lcom/intellij/database/dialects/greenplum/model/GPlumLocalTable;", "buildPartition", "Lcom/intellij/database/dialects/greenplum/model/GPlumPartition;", "buildPartitionSpec", "Lcom/intellij/sql/psi/SqlDefinition;", "calcPartitionId", "", "calcPosition", "", "def", "Lcom/intellij/sql/psi/SqlColumnDefinition;", "(Lcom/intellij/sql/psi/SqlColumnDefinition;)Ljava/lang/Integer;", "findColumns", "", "clause", "Lcom/intellij/sql/psi/SqlClause;", "table", "findDistributedKeys", "findExecLocation", "", "el", "Lcom/intellij/psi/PsiElement;", "findFormatOptions", "findPartitionKind", "Lcom/intellij/database/model/properties/GPlumPartitionKind;", "Lorg/jetbrains/annotations/NotNull;", "findStrings", "it", "getOrCreateTree", "Lcom/intellij/database/model/properties/GPlumPartitionTree;", "localTable", "joinExpressions", "e", "intellij.database.dialects.greenplum"})
public final class GPlumObjectBuilder
extends PgGPlumBaseObjectBuilder {
    @Override
    @NotNull
    protected IElementType getLazyCodeBlock() {
        IElementType iElementType = GPlumElementTypes.Misc.GPLUM_LAZY_CODE_BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"GPlumElementTypes.Misc.GPLUM_LAZY_CODE_BLOCK");
        return iElementType;
    }

    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof GPlumExternalTable) {
            this.buildExternalTable((GPlumExternalTable)obj2, source, context);
        } else if (basicModElement instanceof GPlumPartition) {
            this.buildPartition((GPlumPartition)obj2, source, context);
        } else if (basicModElement instanceof GPlumLocalTable) {
            this.buildLocalTable((GPlumLocalTable)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    private final void buildPartition(GPlumPartition obj2, DasObject source, SqlObjectBuilder.Context context) {
        super.buildBasicElement((BasicModElement)obj2, source, context);
        if (!(source instanceof SqlDefinition)) {
            return;
        }
        GPlumLocalTable gPlumLocalTable = obj2.getLocalTable();
        if (gPlumLocalTable == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gPlumLocalTable, (String)"obj.localTable!!");
        GPlumPartitionTree tree = this.getOrCreateTree(gPlumLocalTable);
        obj2.setObjectId(this.calcPartitionId(obj2));
        if (obj2.getObjectId() != Long.MIN_VALUE) {
            tree.addEdge(0L, obj2.getObjectId());
        }
        this.buildPartitionSpec(obj2, (SqlDefinition)source, context);
        PsiElement psiElement = ((SqlDefinition)source).getParent();
        if (!(psiElement instanceof SqlClause)) {
            psiElement = null;
        }
        SqlClause sqlClause = (SqlClause)psiElement;
        if (sqlClause == null) {
            return;
        }
        SqlClause clause = sqlClause;
        obj2.setPartitionKind(this.findPartitionKind(clause));
        GPlumLocalTable gPlumLocalTable2 = obj2.getLocalTable();
        if (gPlumLocalTable2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gPlumLocalTable2, (String)"obj.localTable!!");
        obj2.setColumns(this.findColumns(clause, gPlumLocalTable2));
    }

    private final void buildPartitionSpec(GPlumPartition obj2, SqlDefinition source, SqlObjectBuilder.Context context) {
        String values = null;
        String startValue = null;
        String endValue = null;
        String everyValue = null;
        boolean isStartInclusive = false;
        boolean isEndInclusive = false;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$forEachChild = false;
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
        PsiElement psiElement = (PsiElement)source;
        PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            PsiElement it = tmp$iv$iv;
            boolean bl = false;
            PsiElement first2 = it.getFirstChild();
            if (!(it instanceof SqlClause)) continue;
            PsiElement psiElement2 = first2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"first");
            ASTNode aSTNode = psiElement2.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"first.node");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)GPlumTypes.GPLUM_VALUES)) {
                values = this.joinExpressions(it);
                continue;
            }
            if (!(first2 instanceof SqlClause)) continue;
            SqlObjectBuilderImpl this_$iv2 = this;
            boolean $i$f$forEachChild2 = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this_$iv2;
            PsiElement first$iv$iv2 = it.getFirstChild();
            boolean $i$f$forEachSibling2 = false;
            for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                IElementType iElementType;
                PsiElement e = tmp$iv$iv2;
                boolean bl2 = false;
                PsiElement psiElement3 = e.getFirstChild();
                IElementType iElementType2 = psiElement3 != null && (psiElement3 = psiElement3.getNode()) != null ? psiElement3.getElementType() : (iElementType = null);
                if (Intrinsics.areEqual((Object)iElementType, (Object)GPlumTypes.GPLUM_START)) {
                    startValue = this.joinExpressions(e);
                    isStartInclusive = SqlImplUtil.getChildOfType((PsiElement)e, (IElementType)GPlumTypes.GPLUM_EXCLUSIVE) == null;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)GPlumTypes.GPLUM_END)) {
                    endValue = this.joinExpressions(e);
                    isEndInclusive = SqlImplUtil.getChildOfType((PsiElement)e, (IElementType)GPlumTypes.GPLUM_INCLUSIVE) != null;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)GPlumTypes.GPLUM_EVERY)) continue;
                everyValue = this.joinExpressions(e);
            }
        }
        obj2.setValues(values);
        obj2.setStartValue(startValue);
        obj2.setEndValue(endValue);
        obj2.setEveryValue(everyValue);
        obj2.setStartInclusive(isStartInclusive);
        obj2.setEndInclusive(isEndInclusive);
        obj2.setDefaultPartition(SqlImplUtil.getChildOfType((PsiElement)((PsiElement)source), (IElementType)GPlumTypes.GPLUM_DEFAULT) != null);
    }

    private final GPlumPartitionKind findPartitionKind(SqlClause clause) {
        if (SqlImplUtil.getChildOfType((PsiElement)((PsiElement)clause), (IElementType)GPlumTypes.GPLUM_RANGE) != null) {
            return GPlumPartitionKind.RANGE;
        }
        return GPlumPartitionKind.LIST;
    }

    private final GPlumPartitionTree getOrCreateTree(GPlumLocalTable localTable) {
        GPlumPartitionTree tree = localTable.getPartitionsTree();
        if (tree == null) {
            tree = new GPlumPartitionTree();
            localTable.setPartitionsTree(tree);
        }
        return tree;
    }

    private final List<Integer> findColumns(SqlClause clause, GPlumLocalTable table) {
        SqlReferenceExpression[] columnRefs = (SqlReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)clause), SqlReferenceExpression.class);
        if (columnRefs != null) {
            boolean bl = false;
            List columns = new ArrayList();
            SqlReferenceExpression[] $this$forEach$iv = columnRefs;
            boolean $i$f$forEach = false;
            SqlReferenceExpression[] sqlReferenceExpressionArray = $this$forEach$iv;
            int n = sqlReferenceExpressionArray.length;
            for (int j = 0; j < n; ++j) {
                GPlumLocalTableColumn column2;
                SqlColumnDefinition colDef;
                SqlReferenceExpression element$iv;
                SqlReferenceExpression ref = element$iv = sqlReferenceExpressionArray[j];
                boolean bl2 = false;
                PsiElement psiElement = ref.resolve();
                if (!(psiElement instanceof SqlColumnDefinition)) {
                    psiElement = null;
                }
                if ((SqlColumnDefinition)psiElement == null) {
                    continue;
                }
                if ((GPlumLocalTableColumn)table.getColumns().get(colDef.getName()) == null) {
                    continue;
                }
                columns.add(Integer.valueOf(column2.getPosition()));
            }
            return columns;
        }
        return CollectionsKt.emptyList();
    }

    private final long calcPartitionId(GPlumPartition obj2) {
        long id = 1L;
        GPlumLocalTable gPlumLocalTable = obj2.getLocalTable();
        if (gPlumLocalTable == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gPlumLocalTable, (String)"obj.localTable!!");
        for (GPlumPartition partition : gPlumLocalTable.getPartitions()) {
            if (Intrinsics.areEqual((Object)partition, (Object)obj2)) {
                return id;
            }
            long l = id;
            id = l + 1L;
        }
        return Long.MIN_VALUE;
    }

    private final String joinExpressions(PsiElement e) {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)e, SqlExpression.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"PsiTreeUtil.getChildrenO\u2026qlExpression::class.java)");
        return CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)joinExpressions.1.INSTANCE, (int)31, null);
    }

    private final void buildLocalTable(GPlumLocalTable obj2, DasObject source, SqlObjectBuilder.Context context) {
        super.buildBasicElement(obj2, source, context);
        List<Integer> distributionKeys = CollectionsKt.emptyList();
        if (source instanceof GPlumCreateTableStatement) {
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                if (!(it instanceof SqlClause)) continue;
                PsiElement psiElement = ((SqlClause)it).getFirstChild();
                if (!Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)GPlumTypes.GPLUM_DISTRIBUTED)) continue;
                distributionKeys = this.findDistributedKeys((SqlClause)it);
            }
        }
        obj2.setDistributionKeys(distributionKeys);
    }

    private final void buildExternalTable(GPlumExternalTable obj2, DasObject source, SqlObjectBuilder.Context context) {
        super.buildBasicElement(obj2, source, context);
        boolean writable = false;
        List<String> locations = CollectionsKt.emptyList();
        String command2 = null;
        String execLocation = null;
        GPlumExternalTableFormat format = null;
        String formatOptions = null;
        String encoding = null;
        List<Integer> distributionKeys = CollectionsKt.emptyList();
        boolean isDistributedRandomly = false;
        int rejectLimit = 0;
        if (source instanceof GPlumCreateTableStatement) {
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement first2;
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)GPlumTypes.GPLUM_WRITABLE)) {
                    writable = true;
                }
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)GPlumTypes.GPLUM_EXTERNAL_TABLE_ERROR_HANDLING) && this.findNumber(it) != null) {
                    Long l;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    long n = ((Number)l).longValue();
                    boolean bl4 = false;
                    rejectLimit = (int)n;
                }
                if (!(it instanceof SqlClause)) continue;
                if (((SqlClause)it).getFirstChild() == null) {
                    continue;
                }
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)first2);
                if (Intrinsics.areEqual((Object)iElementType, (Object)GPlumTypes.GPLUM_LOCATION)) {
                    locations = this.findStrings((SqlClause)it);
                    execLocation = this.findExecLocation(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)GPlumTypes.GPLUM_EXECUTE)) {
                    command2 = this.findString(first2);
                    execLocation = this.findExecLocation(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)GPlumTypes.GPLUM_FORMAT)) {
                    GPlumExternalTableFormat gPlumExternalTableFormat;
                    GPlumExternalTableFormat gPlumExternalTableFormat2;
                    block14: {
                        GPlumExternalTableFormat[] gPlumExternalTableFormatArray = this.findString(first2);
                        if (gPlumExternalTableFormatArray == null) continue;
                        GPlumExternalTableFormat[] gPlumExternalTableFormatArray2 = gPlumExternalTableFormatArray;
                        boolean bl5 = false;
                        if (gPlumExternalTableFormatArray2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string = gPlumExternalTableFormatArray2.toLowerCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
                        gPlumExternalTableFormatArray = string;
                        if (string == null) {
                            continue;
                        }
                        GPlumExternalTableFormat[] formatString = gPlumExternalTableFormatArray;
                        gPlumExternalTableFormatArray2 = GPlumExternalTableFormat.values();
                        bl5 = false;
                        GPlumExternalTableFormat[] gPlumExternalTableFormatArray3 = gPlumExternalTableFormatArray2;
                        boolean bl6 = false;
                        GPlumExternalTableFormat[] gPlumExternalTableFormatArray4 = gPlumExternalTableFormatArray3;
                        int n = gPlumExternalTableFormatArray4.length;
                        for (int j = 0; j < n; ++j) {
                            GPlumExternalTableFormat gPlumExternalTableFormat3;
                            GPlumExternalTableFormat f = gPlumExternalTableFormat3 = gPlumExternalTableFormatArray4[j];
                            boolean bl7 = false;
                            if (!Intrinsics.areEqual((Object)f.getName(), (Object)formatString)) continue;
                            gPlumExternalTableFormat2 = gPlumExternalTableFormat3;
                            break block14;
                        }
                        gPlumExternalTableFormat2 = null;
                    }
                    format = gPlumExternalTableFormat = gPlumExternalTableFormat2;
                    formatOptions = this.findFormatOptions(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)GPlumTypes.GPLUM_ENCODING)) {
                    encoding = this.findString(first2);
                    if (encoding != null) continue;
                    Long l = this.findNumber(it);
                    encoding = l != null ? String.valueOf(l) : null;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)GPlumTypes.GPLUM_DISTRIBUTED)) continue;
                if (SqlImplUtil.getChildOfType((PsiElement)it, (IElementType)GPlumTypes.GPLUM_RANDOMLY) != null) {
                    isDistributedRandomly = true;
                    continue;
                }
                distributionKeys = this.findDistributedKeys((SqlClause)it);
            }
        }
        obj2.setWritable(writable);
        obj2.setLocations(locations);
        obj2.setCommand(command2);
        obj2.setExecLocation(execLocation);
        GPlumExternalTableFormat gPlumExternalTableFormat = format;
        if (gPlumExternalTableFormat != null) {
            GPlumExternalTableFormat gPlumExternalTableFormat4 = gPlumExternalTableFormat;
            boolean bl = false;
            boolean bl8 = false;
            GPlumExternalTableFormat it = gPlumExternalTableFormat4;
            boolean bl9 = false;
            obj2.setFormat(it);
        }
        obj2.setFormatOptions(formatOptions);
        obj2.setEncoding(encoding);
        obj2.setRejectLimit(rejectLimit);
        obj2.setDistributionKeys(distributionKeys);
        obj2.setDistributedRandomly(isDistributedRandomly);
    }

    private final List<Integer> findDistributedKeys(SqlClause clause) {
        boolean bl = false;
        List distributionKeys = new ArrayList();
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)((PsiElement)clause), SqlReferenceExpression.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"PsiTreeUtil.getChildrenO\u2026ceExpression::class.java)");
        List distributionColumns = list;
        for (SqlReferenceExpression refExpr : distributionColumns) {
            Integer n;
            SqlColumnDefinition def;
            PsiElement psiElement = refExpr.resolve();
            if (!(psiElement instanceof SqlColumnDefinition)) {
                psiElement = null;
            }
            if ((SqlColumnDefinition)psiElement == null) {
                continue;
            }
            if (this.calcPosition(def) == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            int it = ((Number)n).intValue();
            boolean bl4 = false;
            distributionKeys.add(it);
        }
        return distributionKeys;
    }

    private final Integer calcPosition(SqlColumnDefinition def) {
        SqlColumnDefinition[] sqlColumnDefinitionArray = (SqlColumnDefinition[])PsiTreeUtil.getChildrenOfType((PsiElement)SqlImplUtil.sqlParent((PsiElement)((PsiElement)def)), SqlColumnDefinition.class);
        if (sqlColumnDefinitionArray == null) {
            return null;
        }
        SqlColumnDefinition[] children2 = sqlColumnDefinitionArray;
        int pos = 1;
        for (SqlColumnDefinition child : children2) {
            if (Intrinsics.areEqual((Object)child, (Object)def)) {
                return pos;
            }
            ++pos;
        }
        return null;
    }

    private final String findFormatOptions(PsiElement el) {
        boolean bl = false;
        List formatOptions = new ArrayList();
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$forEachChild = false;
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
        PsiElement psiElement = el;
        PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            PsiElement c = tmp$iv$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)c), (Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE)) continue;
            String string = c.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.text");
            formatOptions.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)formatOptions, (CharSequence)" ", null, null, (int)0, null, (Function1)findFormatOptions.2.INSTANCE, (int)30, null);
    }

    private final String findExecLocation(PsiElement el) {
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$forEachChild = false;
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
        PsiElement psiElement = el;
        PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            PsiElement it = tmp$iv$iv;
            boolean bl = false;
            PsiElement psiElement2 = it.getFirstChild();
            if (!Intrinsics.areEqual((Object)(psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null), (Object)GPlumTypes.GPLUM_ON)) continue;
            if (SqlImplUtil.getChildOfType((PsiElement)it, (IElementType)GPlumTypes.GPLUM_ALL) != null) {
                return "ALL_SEGMENTS";
            }
            if (SqlImplUtil.getChildOfType((PsiElement)it, (IElementType)GPlumTypes.GPLUM_MASTER) != null) {
                return "MASTER_ONLY";
            }
            if (SqlImplUtil.getChildOfType((PsiElement)it, (IElementType)GPlumTypes.GPLUM_HOST) != null) {
                String string = this.findString(it.getFirstChild());
                if (string == null) {
                    return "PER_HOST";
                }
                String host = string;
                return "HOST:" + host;
            }
            if (SqlImplUtil.getChildOfType((PsiElement)it, (IElementType)GPlumTypes.GPLUM_SEGMENT) != null) {
                Long l = this.findNumber(it);
                if (l == null) {
                    return null;
                }
                long segment = l;
                return "SEGMENT_ID:" + segment;
            }
            Long l = this.findNumber(it);
            if (l == null) {
                return null;
            }
            long totalSegments = l;
            return "TOTAL_SEGS:" + totalSegments;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findStrings(SqlClause it) {
        void $this$mapNotNullTo$iv$iv;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)((PsiElement)it), SqlStringLiteralExpression.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"PsiTreeUtil.getChildrenO\u2026alExpression::class.java)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SqlStringLiteralExpression it2 = (SqlStringLiteralExpression)element$iv$iv;
            boolean bl2 = false;
            SqlStringLiteralExpression sqlStringLiteralExpression = it2;
            if (sqlStringLiteralExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.SqlStringLiteralExpression");
            }
            if (sqlStringLiteralExpression.getValue() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

