/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.BaseDmlGenerator;
import com.intellij.database.dialects.generic.GenericDmlGeneratorKt;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0012\u0010\u0011\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\b\u0010\u0014\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/generic/GenericDmlGenerator;", "Lcom/intellij/database/dialects/base/BaseDmlGenerator;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "appendLimit", "Lcom/intellij/database/util/DdlBuilder;", "builder", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "system", "Lcom/intellij/database/model/DasDataSource;", "limit", "", "offset", "atBeginning", "", "getDbms", "getPlaceForLimit", "Lcom/intellij/database/dialects/base/BaseDmlGenerator$Companion$LimitPlace;", "shouldUseLimit", "intellij.database.dialects.generic"})
public final class GenericDmlGenerator
extends BaseDmlGenerator {
    @Override
    @NotNull
    protected BaseDmlGenerator.Companion.LimitPlace getPlaceForLimit(@Nullable DasDataSource system) {
        Dbms dbms = this.getDbms(system);
        return Intrinsics.areEqual((Object)dbms, (Object)Dbms.TIBERO) ? BaseDmlGenerator.Companion.LimitPlace.BOTH : (GenericDmlGeneratorKt.DEFAULT_LIMIT_DBS.contains(dbms) || Intrinsics.areEqual((Object)dbms, (Object)Dbms.FILEMAKER) ? BaseDmlGenerator.Companion.LimitPlace.END : BaseDmlGenerator.Companion.LimitPlace.BEGIN);
    }

    private final Dbms getDbms(DasDataSource system) {
        DasDataSource dasDataSource;
        if (Intrinsics.areEqual((Object)this.getDbms(), (Object)Dbms.UNKNOWN)) {
            dasDataSource = system;
            if (dasDataSource == null || (dasDataSource = dasDataSource.getDbms()) == null) {
                Dbms dbms = Dbms.UNKNOWN;
                dasDataSource = dbms;
                Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"Dbms.UNKNOWN");
            }
        } else {
            dasDataSource = this.getDbms();
        }
        return dasDataSource;
    }

    @Override
    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, @Nullable DasDataSource system, int limit, int offset, boolean atBeginning) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)dialect, (String)"dialect");
        Dbms dbms = this.getDbms(system);
        if (!this.shouldUseLimit()) {
            return builder;
        }
        return DbImplUtil.isPageSizeUnlimited((int)limit) ? builder : (GenericDmlGeneratorKt.DEFAULT_LIMIT_DBS.contains(dbms) ? super.appendLimit(builder, dialect, system, limit, offset, atBeginning) : (GenericDmlGeneratorKt.TOP_LIMIT_DBS.contains(dbms) ? this.top(builder, "TOP", limit) : (Intrinsics.areEqual((Object)dbms, (Object)Dbms.INGRES) ? this.top(builder, "FIRST", limit) : (Intrinsics.areEqual((Object)dbms, (Object)Dbms.TIBERO) ? this.rowNumLimit(builder, limit, atBeginning) : (Intrinsics.areEqual((Object)dbms, (Object)Dbms.FILEMAKER) ? this.fetchFirst(builder, limit) : builder)))));
    }

    private final boolean shouldUseLimit() {
        return Registry.is((String)"database.generic_dialect.limit", (boolean)true);
    }

    public GenericDmlGenerator(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        super(dbms);
    }
}

