/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.com.intellij.database.dialects.db2.model;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.db2.model.Db2IndexExtension;
import com.intellij.database.dialects.db2.model.Db2IndexExtensionArgument;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.sql.dialects.SqlLanguageDialect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/db2/com/intellij/database/dialects/db2/model/Db2DescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "describeIndexExtension", "", "project", "Lcom/intellij/openapi/project/Project;", "o", "Lcom/intellij/database/dialects/db2/model/Db2IndexExtension;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "updatePresentation", "Lcom/intellij/database/model/DasObject;", "intellij.database.dialects.db2"})
public final class Db2DescriptionService
extends DescriptionService {
    public void updatePresentation(@NotNull Project project, @NotNull DasObject o, @NotNull PresentationData presentation) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        DasObject dasObject = o;
        if (dasObject instanceof Db2IndexExtension) {
            this.describeIndexExtension(project, (Db2IndexExtension)o, presentation);
        } else {
            super.updatePresentation(project, o, presentation);
        }
    }

    private final void describeIndexExtension(Project project, Db2IndexExtension o, PresentationData presentation) {
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)o);
        DatabaseDialectEx databaseDialectEx = dataSource != null ? DbImplUtil.getDatabaseDialect((DbElement)((DbElement)dataSource)) : DatabaseDialects.getGenericDialect();
        Intrinsics.checkExpressionValueIsNotNull((Object)databaseDialectEx, (String)"if (dataSource != null) \u2026lects.getGenericDialect()");
        DatabaseDialectEx dialect = databaseDialectEx;
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((DbElement)((DbElement)dataSource));
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlLanguageDialect, (String)"DbSqlUtil.getSqlDialect(dataSource)");
        SqlLanguageDialect sqlDialect = sqlLanguageDialect;
        DdlBuilder builder = new DdlBuilder().applyCodeStyle(project, sqlDialect).withDialect(dialect);
        builder.symbol("(");
        boolean first2 = true;
        for (Db2IndexExtensionArgument parameter : o.getIndexExtensionArguments()) {
            if (first2) {
                first2 = false;
            } else {
                Intrinsics.checkExpressionValueIsNotNull((Object)builder.symbol(",").space(), (String)"builder.symbol(\",\").space()");
            }
            DialectUtils.sqlParameter((DdlBuilder)builder, (DasArgument)((DasArgument)parameter), (boolean)false, (int)0, (boolean)false);
        }
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"builder");
        presentation.addText(ddlBuilder.getStatement(), DbNodeDescriptor.INFO_ATTRS);
    }
}

