/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.model;

import com.intellij.database.dialects.cassandra.model.CassDefType;
import com.intellij.database.dialects.cassandra.model.CassDefTypeAttribute;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/cassandra/model/CassModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "", "vars", "", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getIcon", "Ljavax/swing/Icon;", "o", "Lcom/intellij/database/model/DasObject;", "getName", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.cassandra"})
public final class CassModelHelper
extends ModelHelper {
    @NotNull
    public String getName(@NotNull ObjectKind kind) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA)) {
            string = "KEYSPACE";
        } else {
            String string2 = super.getName(kind);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"super.getName(kind)");
        }
        return string;
    }

    @Nullable
    public Icon getIcon(@NotNull DasObject o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        return o instanceof CassRole && ((CassRole)o).isCanLogin() ? this.getIcon(ObjectKind.USER) : super.getIcon(o);
    }

    @NotNull
    public JBIterable<String> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable jBIterable;
        Intrinsics.checkParameterIsNotNull(meta, (String)"meta");
        ObjectKind objectKind = meta.kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
            JBIterable jBIterable2 = JBIterable.of((Object)"Function");
            jBIterable = jBIterable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"JBIterable.of(\"Function\")");
        } else {
            JBIterable jBIterable3 = super.generationVariants(meta);
            jBIterable = jBIterable3;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable3, (String)"super.generationVariants(meta)");
        }
        return jBIterable;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull String variant, @NotNull Map<String, String> vars) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull(vars, (String)"vars");
        super.fillPropertiesWithExamples(e, variant, vars);
        if (e instanceof CassSchema) {
            String replication = "{'class': 'SimpleStrategy', 'replication_factor': 1}";
            ((CassSchema)e).setReplication(replication);
            vars.put("replication", replication);
        }
        if (e instanceof CassFunction) {
            ((CassFunction)e).setLanguage("java");
            vars.put("language", "java");
        }
        if (e instanceof CassDefType) {
            CassDefTypeAttribute attr = (CassDefTypeAttribute)((CassDefType)e).getAttributes().createNewOne();
            this.setTemplateName((BasicModNamedElement)attr, "attr");
            CassDefTypeAttribute cassDefTypeAttribute = attr;
            Intrinsics.checkExpressionValueIsNotNull((Object)cassDefTypeAttribute, (String)"attr");
            cassDefTypeAttribute.setDataType(DataTypeFactory.of((String)"int"));
            vars.put("attrs", "attr int");
        }
    }
}

