/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospectorKt;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospectorKt;
import com.intellij.database.dialects.base.introspector.DBFacadeProvider;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcIntrospectorHelper;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcIntrospectorLegacyModelUtils;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcSourceLoader;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.MetaDataUtil;
import com.intellij.database.introspection.DBIntrospectionException;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBFacade;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSingleDatabaseRoot;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.JdbcTableType;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcIntrospector
implements DBIntrospector {
    private String database;
    private final Dbms myDbms;
    private DatabaseConnection myConnection;
    private ProgressIndicator myIndicator;
    private ModelFactory myModelFactory;
    private PairConsumer<String, Throwable> myErrorSink;
    private String[] myTableTypes;
    private Set<ObjectKind> myTableKinds;
    private JdbcIntrospectorHelper myHelper;
    private ConnectionInfo myInfo;
    @Nullable
    private JdbcSourceLoader mySrcLoader;
    private DBIntrospectionOptions myOptions;

    public JdbcIntrospector(@NotNull Dbms dbms) {
        if (dbms == null) {
            JdbcIntrospector.$$$reportNull$$$0(0);
        }
        this.myIndicator = DumbProgressIndicator.INSTANCE;
        this.mySrcLoader = null;
        this.myOptions = BaseIntrospectionFunctions.DEFAULT_OPTIONS;
        this.myDbms = dbms;
    }

    public void setModelFactory(ModelFactory modelFactory) {
        this.myModelFactory = modelFactory;
    }

    @NotNull
    public BasicModModel init(@Nullable BasicModModel model) {
        if (this.myHelper != null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " already initialized");
        }
        BasicModModel theModel = model != null && model.getDbms() == this.myDbms ? model : this.myModelFactory.createModel(this.myDbms);
        this.myHelper = new JdbcIntrospectorHelper(theModel, this.myDbms);
        BasicModModel basicModModel = theModel;
        if (basicModModel == null) {
            JdbcIntrospector.$$$reportNull$$$0(1);
        }
        return basicModModel;
    }

    @Nullable
    public String getCurrentDatabase() {
        return this.myInfo.databaseName;
    }

    public void attachToDB(@NotNull DatabaseConnection connection) {
        if (connection == null) {
            JdbcIntrospector.$$$reportNull$$$0(2);
        }
        if (this.myConnection != null) {
            this.detachFromDB();
        }
        this.myConnection = connection;
        if (this.myDbms != connection.getDbms()) {
            throw new AssertionError((Object)(this.myDbms.getDisplayName() + " does not match " + connection.getDbms().getDisplayName() + ")"));
        }
        DBFacade db = null;
        try {
            db = DBFacadeProvider.createFacadeWithSingleLeasedConnection(connection);
            this.myInfo = db.getConnectionInfo();
        }
        finally {
            if (db != null) {
                db.disconnect();
            }
        }
        if (this.myDbms.isDb2()) {
            this.myInfo = new ConnectionInfo(this.myInfo.rdbmsName, this.myInfo.databaseName, this.myInfo.schemaName == null ? null : this.myInfo.schemaName.trim(), this.myInfo.userName, this.myInfo.serverVersion, this.myInfo.driverVersion);
        }
        this.ensureHaveSourceLoader();
    }

    public void ensureHaveSourceLoader() {
        boolean withSources = this.myOptions.getSources() != DBIntrospectionOptions.SourceLoading.NO_SOURCES;
        if (withSources == (this.mySrcLoader != null)) {
            return;
        }
        this.mySrcLoader = withSources ? (JdbcSourceLoader)JdbcSourceLoader.EP.forDbms(this.myDbms) : null;
    }

    @NotNull
    public Map<BasicElement, Boolean> retrieveInvalid(@NotNull Iterable<? extends BasicElement> elements2) {
        if (elements2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(3);
        }
        Map<BasicElement, Boolean> map2 = Collections.emptyMap();
        if (map2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(4);
        }
        return map2;
    }

    public void detachFromDB() {
        this.myConnection = null;
        this.myInfo = null;
        this.mySrcLoader = null;
    }

    public void setOptions(@NotNull DBIntrospectionOptions options) {
        if (options == null) {
            JdbcIntrospector.$$$reportNull$$$0(5);
        }
        this.myOptions = options;
        this.ensureHaveSourceLoader();
    }

    @NotNull
    public TreePattern getDefaultScope() {
        BasicRoot root2 = this.myHelper.getModel().getRoot();
        TreePattern treePattern = root2 instanceof BasicSingleDatabaseRoot ? BaseSingleDatabaseIntrospectorKt.getSINGLE_DB_SCOPE() : BaseMultiDatabaseIntrospectorKt.getMULTI_DB_SCOPE();
        if (treePattern == null) {
            JdbcIntrospector.$$$reportNull$$$0(6);
        }
        return treePattern;
    }

    @NotNull
    public DBIntrospectionOptions getOptions() {
        DBIntrospectionOptions dBIntrospectionOptions = this.myOptions;
        if (dBIntrospectionOptions == null) {
            JdbcIntrospector.$$$reportNull$$$0(7);
        }
        return dBIntrospectionOptions;
    }

    @NotNull
    public BasicModModel getModel() {
        BasicModModel basicModModel = this.myHelper.getModel();
        if (basicModModel == null) {
            JdbcIntrospector.$$$reportNull$$$0(8);
        }
        return basicModModel;
    }

    public void setProgressIndicator(@Nullable ProgressIndicator indicator) {
        this.myIndicator = indicator != null ? indicator : DumbProgressIndicator.INSTANCE;
    }

    @Nullable
    public ProgressIndicator getProgressIndicator() {
        return this.myIndicator;
    }

    public void introspectAuto(BasicNamespace ... namespaces) {
        if (namespaces == null) {
            JdbcIntrospector.$$$reportNull$$$0(9);
        }
        if (this.myConnection == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.getModel().modify(BasicModRoot.class, root2 -> {
            DatabaseMetaDataWrapper meta = this.createMeta();
            this.myHelper.setCasing(meta.getCasing());
            if (namespaces.length == 0) {
                this.introspectDatabaseList(meta);
            }
            this.introspectSchemas(meta, this.schemas(namespaces));
        });
    }

    public void introspectNamespaces() {
        if (this.myConnection == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.getModel().modify(BasicModRoot.class, root2 -> {
            DatabaseMetaDataWrapper meta = this.createMeta();
            this.myHelper.setCasing(meta.getCasing());
            this.introspectDatabaseList(meta);
        });
    }

    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        if (databases == null) {
            JdbcIntrospector.$$$reportNull$$$0(10);
        }
        if (this.myConnection == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.getModel().modify(BasicModRoot.class, root2 -> {
            DatabaseMetaDataWrapper meta = this.createMeta();
            this.myHelper.setCasing(meta.getCasing());
            this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.of((Object[])databases).filter(BasicModDatabase.class));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectSchemas(@NotNull DatabaseMetaDataWrapper meta, @NotNull JBIterable<BasicModSchema> schemas2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(11);
        }
        if (schemas2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(12);
        }
        try {
            this.myTableTypes = meta.getAllTableTypes();
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)"Failed to retrieve table types", (Object)e);
            this.myTableTypes = null;
        }
        this.myTableKinds = ArrayUtil.isEmpty((Object[])this.myTableTypes) ? null : JBIterable.of((Object[])this.myTableTypes).transform(x -> JdbcTableType.findByName((String)x).getKind()).toSet();
        MultiMap byCatalog = MultiMap.create();
        for (BasicModSchema schema : schemas2) {
            byCatalog.putValue((Object)this.myHelper.getDatabase(schema), (Object)schema);
        }
        String catalog = null;
        try {
            catalog = (String)JdbcNativeUtil.computeRemote(() -> meta.getConnection().getRemoteConnection().getCatalog());
            this.introspectSchemasByCatalogs(meta, (MultiMap<BasicModNamespace, BasicModSchema>)byCatalog);
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)"Failed to get current catalog", (Object)e);
        }
        finally {
            if (catalog != null) {
                String finalCatalog = catalog;
                JdbcNativeUtil.performSafe(() -> meta.getConnection().getRemoteConnection().setCatalog(finalCatalog));
            }
        }
    }

    private void introspectSchemasByCatalogs(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> byCatalog) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(13);
        }
        if (byCatalog == null) {
            JdbcIntrospector.$$$reportNull$$$0(14);
        }
        JdbcIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            this.introspectTablesInSchema(meta, (BasicModSchema)s);
            this.introspectRoutinesInSchema(meta, (BasicModSchema)s);
            this.introspectTypesInSchema(meta, (BasicModSchema)s);
        });
        JdbcIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            this.introspectColumnsInSchema(meta, (BasicModSchema)s);
            this.introspectPrototypesInSchema(meta, (BasicModSchema)s);
            this.introspectTypeAttributesInSchema(meta, (BasicModSchema)s);
        });
        JdbcIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            ModNamingFamily tables = JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)s, ObjectKind.TABLE);
            if (tables != null) {
                tables.forEach(t -> this.introspectTableKeys(meta, (BasicModTableOrView)t, false));
                tables.forEach(t -> this.introspectTableForeignKeys(meta, (BasicModTableOrView)t));
                tables.forEach(t -> this.introspectTableIndices(meta, (BasicModTableOrView)t));
                tables.forEach(t -> JdbcIntrospector.cleanupFamily(t.familyOf(ObjectKind.KEY)));
            }
        });
        if (this.mySrcLoader != null) {
            this.getModel().writeSources(() -> JdbcIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
                this.myIndicator.checkCanceled();
                this.myIndicator.setText("Sources in " + MetaDataUtil.qName((BasicElement)s));
                this.mySrcLoader.loadSources((Iterable<BasicModSourceAware>)((JBTreeTraverser)DasUtil.dasTraverser().withRoot(s)).filter(BasicModSourceAware.class), this.myConnection);
            }));
        }
    }

    private static void forEachCatalog(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> grouped, @NotNull Consumer<Iterable<BasicModSchema>> process2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(15);
        }
        if (grouped == null) {
            JdbcIntrospector.$$$reportNull$$$0(16);
        }
        if (process2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(17);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            String catalog;
            String string = catalog = entry.getKey() == null ? null : ((BasicModNamespace)entry.getKey()).getName();
            if (catalog != null) {
                JdbcNativeUtil.performSafe(() -> meta.getConnection().getRemoteConnection().setCatalog(catalog));
            }
            process2.accept((Iterable<BasicModSchema>)entry.getValue());
        }
    }

    private static void forEachSchemaInCatalog(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> grouped, @NotNull Consumer<BasicModSchema> process2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(18);
        }
        if (grouped == null) {
            JdbcIntrospector.$$$reportNull$$$0(19);
        }
        if (process2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(20);
        }
        JdbcIntrospector.forEachCatalog(meta, grouped, ss -> ss.forEach(process2));
    }

    public void introspectTablesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(21);
        }
        if (schema == null) {
            JdbcIntrospector.$$$reportNull$$$0(22);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Table list in " + MetaDataUtil.qName((BasicElement)schema));
        JBIterable<ModFamily<? extends BasicModTableOrView>> families = this.getTableFamilies(schema);
        families.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<? extends DatabaseMetaDataWrapper.Table> tableIt = meta.tables(this.asSchema(schema), null, this.myTableTypes);){
            for (DatabaseMetaDataWrapper.Table table : JBIterable.once(tableIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createTable(schema, table);
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)("Failed to retrieve tables in " + MetaDataUtil.qName((BasicElement)schema)), (Object)e);
        }
        families.forEach(JdbcIntrospector::cleanupFamily);
    }

    @NotNull
    private JBIterable<ModFamily<? extends BasicModTableOrView>> getTableFamilies(@NotNull BasicModSchema schema) {
        if (schema == null) {
            JdbcIntrospector.$$$reportNull$$$0(23);
        }
        JBIterable kinds = JBIterable.from((Iterable)ModelConsts.TABLE_OR_VIEW_KINDS).append((Object)ObjectKind.SEQUENCE).append((Object)ObjectKind.SYNONYM);
        if (this.myTableKinds != null) {
            kinds = kinds.filter(this.myTableKinds::contains);
        }
        JBIterable jBIterable = kinds.transform(k -> JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)schema, k)).filter(Conditions.notNull());
        if (jBIterable == null) {
            JdbcIntrospector.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    public void introspectTableKeys(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModTableOrView table, boolean cleanup) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(25);
        }
        if (table == null) {
            JdbcIntrospector.$$$reportNull$$$0(26);
        }
        ModFamily keys = table.familyOf(ObjectKind.KEY);
        if (table.getKind() != ObjectKind.TABLE || keys == null) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Keys in " + MetaDataUtil.qName((BasicElement)table));
        keys.markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableKey, DatabaseMetaDataWrapper.TableKeyColumn> keyIt = meta.tableKeys(this.myHelper.asTable(table));){
            this.myHelper.createKeys(table, keyIt);
        }
        catch (Exception ex) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName((BasicElement)table), (Object)ex);
        }
        if (cleanup) {
            JdbcIntrospector.cleanupFamily(keys);
        }
    }

    public void introspectTableForeignKeys(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModTableOrView table) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(27);
        }
        if (table == null) {
            JdbcIntrospector.$$$reportNull$$$0(28);
        }
        ModFamily fKeys = table.familyOf(ObjectKind.FOREIGN_KEY);
        if (table.getKind() != ObjectKind.TABLE || fKeys == null) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Foreign keys in " + MetaDataUtil.qName((BasicElement)table));
        fKeys.markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableFKey, DatabaseMetaDataWrapper.TableFKeyColumn> fkColumnIt = meta.tableFKeyColumns(this.myHelper.asTable(table));){
            this.myHelper.createForeignKeys(table, fkColumnIt);
        }
        catch (Exception ex) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName((BasicElement)table), (Object)ex);
        }
        JdbcIntrospector.cleanupFamily(fKeys);
    }

    private void introspectTableIndices(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModTableOrView table) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(29);
        }
        if (table == null) {
            JdbcIntrospector.$$$reportNull$$$0(30);
        }
        ModFamily indices = table.familyOf(ObjectKind.INDEX);
        if (table.getKind() != ObjectKind.TABLE || indices == null) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Indices in " + MetaDataUtil.qName((BasicElement)table));
        indices.markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableIndex, DatabaseMetaDataWrapper.TableIndexColumn> indexColumnIt = meta.tableIndexColumns(this.myHelper.asTable(table));){
            this.myHelper.createIndices(table, indexColumnIt);
        }
        catch (Exception ex) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName((BasicElement)table), (Object)ex);
        }
        JdbcIntrospector.cleanupFamily(indices);
    }

    public void introspectColumnsInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(31);
        }
        if (schema == null) {
            JdbcIntrospector.$$$reportNull$$$0(32);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Table columns in " + MetaDataUtil.qName((BasicElement)schema));
        JBIterable tables = this.getTableFamilies(schema).flatten(s -> s).filter(BasicModTableOrView.class);
        HashMap<String, BasicModTableOrView> name2Table = new HashMap<String, BasicModTableOrView>();
        for (Object table : tables) {
            JdbcIntrospector.markChildrenAsSyncPending(JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)table, ObjectKind.COLUMN));
            name2Table.put(table.getName(), (BasicModTableOrView)table);
        }
        try {
            Object table;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.TableColumn> columnIt = meta.tableColumns(this.asSchema(schema), null, name2Table.keySet());
            table = null;
            try {
                for (DatabaseMetaDataWrapper.Table table2 : JBIterable.once(columnIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createColumns((BasicModTableOrView)name2Table.get(table2.name), (Iterator<DatabaseMetaDataWrapper.TableColumn>)columnIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                table = throwable;
                throw throwable;
            }
            finally {
                if (columnIt != null) {
                    if (table != null) {
                        try {
                            columnIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)table).addSuppressed(throwable);
                        }
                    } else {
                        columnIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName((BasicElement)schema), (Object)e);
        }
        for (Object table : tables) {
            JdbcIntrospector.cleanupFamily(table.familyOf(ObjectKind.COLUMN));
        }
    }

    private void introspectTypeAttributesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(33);
        }
        if (schema == null) {
            JdbcIntrospector.$$$reportNull$$$0(34);
        }
        this.myIndicator.checkCanceled();
        ModNamingFamily types = JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)schema, ObjectKind.OBJECT_TYPE);
        if (types == null || types.isEmpty()) {
            return;
        }
        this.myIndicator.setText("Type attributes in " + MetaDataUtil.qName((BasicElement)schema));
        HashMap<String, BasicModElement> name2Type = new HashMap<String, BasicModElement>();
        for (Object type : types) {
            JdbcIntrospector.markChildrenAsSyncPending(JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)type, ObjectKind.OBJECT_ATTRIBUTE));
            name2Type.put(type.getName(), (BasicModElement)type);
        }
        try {
            Object type;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.UserDefinedType, DatabaseMetaDataWrapper.UserDefinedTypeAttribute> attrIt = meta.userDefinedTypeAttributes(this.asSchema(schema), null, name2Type.keySet());
            type = null;
            try {
                for (DatabaseMetaDataWrapper.UserDefinedType type2 : JBIterable.once(attrIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createUserDefinedTypeAttributes((BasicModElement)name2Type.get(type2.name), (Iterator<DatabaseMetaDataWrapper.UserDefinedTypeAttribute>)attrIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                type = throwable;
                throw throwable;
            }
            finally {
                if (attrIt != null) {
                    if (type != null) {
                        try {
                            attrIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)type).addSuppressed(throwable);
                        }
                    } else {
                        attrIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName((BasicElement)schema), (Object)e);
        }
        for (Object type : types) {
            JdbcIntrospector.cleanupFamily(type.familyOf(ObjectKind.OBJECT_ATTRIBUTE));
        }
    }

    @NotNull
    private DatabaseMetaDataWrapper.Schema asSchema(@NotNull BasicModSchema schema) {
        if (schema == null) {
            JdbcIntrospector.$$$reportNull$$$0(35);
        }
        DatabaseMetaDataWrapper.Schema s = this.myHelper.asSchema(schema);
        if (s.database == null) {
            s.database = this.database;
        }
        DatabaseMetaDataWrapper.Schema schema2 = s;
        if (schema2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(36);
        }
        return schema2;
    }

    private void introspectPrototypesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(37);
        }
        if (schema == null) {
            JdbcIntrospector.$$$reportNull$$$0(38);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Prototypes in " + MetaDataUtil.qName((BasicElement)schema));
        JBIterable<ModFamily<?>> routineFamilies = this.getRoutineFamilies(schema);
        JBIterable routines = routineFamilies.flatten(r -> r).filter(BasicModRoutine.class);
        JdbcIntrospectorHelper.RoutineMap map2 = this.myHelper.createRoutineMap();
        for (Object routine : routines) {
            JdbcIntrospector.markChildrenAsSyncPending(JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)routine, ObjectKind.ARGUMENT));
            map2.put((BasicModRoutine)routine);
        }
        try {
            Object routine;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.Routine, DatabaseMetaDataWrapper.RoutineArgument> argumentIt = meta.routineArguments(this.asSchema(schema), null, (Function<DatabaseMetaDataWrapper.Routine, DasRoutine.Kind>)((Function)map2::guessType));
            routine = null;
            try {
                for (DatabaseMetaDataWrapper.Routine routine2 : JBIterable.once(argumentIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createArguments(map2.get(routine2), (Iterator<DatabaseMetaDataWrapper.RoutineArgument>)argumentIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                routine = throwable;
                throw throwable;
            }
            finally {
                if (argumentIt != null) {
                    if (routine != null) {
                        try {
                            argumentIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)routine).addSuppressed(throwable);
                        }
                    } else {
                        argumentIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName((BasicElement)schema), (Object)e);
        }
        for (Object routine : routines) {
            JdbcIntrospector.cleanupFamily(routine.familyOf(ObjectKind.ARGUMENT));
        }
        routineFamilies.forEach(ModFamily::sort);
    }

    private void introspectRoutinesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(39);
        }
        if (schema == null) {
            JdbcIntrospector.$$$reportNull$$$0(40);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Routine list in " + MetaDataUtil.qName((BasicElement)schema));
        JBIterable<ModFamily<?>> routineFamilies = this.getRoutineFamilies(schema);
        routineFamilies.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<DatabaseMetaDataWrapper.Routine> routineIt = meta.routines(this.asSchema(schema), null, null);){
            for (DatabaseMetaDataWrapper.Routine routine : JBIterable.once(routineIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createRoutine(schema, routine);
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)("Failed to retrieve routines in " + MetaDataUtil.qName((BasicElement)schema)), (Object)e);
        }
        routineFamilies.forEach(JdbcIntrospector::cleanupFamily);
    }

    private void introspectAdditionalTypes(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(41);
        }
        if (schema == null) {
            JdbcIntrospector.$$$reportNull$$$0(42);
        }
        ObjectKind target2 = null;
        String scName = schema.getName();
        if (this.myHelper.getDbms().isSybase() && "dbo".equalsIgnoreCase(scName)) {
            target2 = ObjectKind.ALIAS_TYPE;
        }
        if (target2 != null) {
            try (ClosableIt<? extends DatabaseMetaDataWrapper.Type> typesIt = meta.types();){
                for (DatabaseMetaDataWrapper.Type type : JBIterable.once(typesIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createType(schema, type, target2);
                }
            }
            catch (SQLException e) {
                this.myErrorSink.consume((Object)("Failed to retrieve types in " + MetaDataUtil.qName((BasicElement)schema)), (Object)e);
            }
        }
    }

    private void introspectTypesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(43);
        }
        if (schema == null) {
            JdbcIntrospector.$$$reportNull$$$0(44);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Types list in " + MetaDataUtil.qName((BasicElement)schema));
        JBIterable<ModFamily<?>> userDefinedTypeFamilies = this.getUserDefinedTypeFamilies(schema);
        userDefinedTypeFamilies.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<? extends DatabaseMetaDataWrapper.UserDefinedType> userDefinedTypesIt = meta.userDefinedTypes(this.asSchema(schema), null);){
            for (DatabaseMetaDataWrapper.UserDefinedType userDefinedType : JBIterable.once(userDefinedTypesIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createUserDefinedType(schema, userDefinedType);
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)("Failed to retrieve user types in " + MetaDataUtil.qName((BasicElement)schema)), (Object)e);
        }
        this.introspectAdditionalTypes(meta, schema);
        userDefinedTypeFamilies.forEach(JdbcIntrospector::cleanupFamily);
    }

    private void introspectDatabaseList(@NotNull DatabaseMetaDataWrapper meta) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(45);
        }
        if (this.getModel().getRoot().familyOf(ObjectKind.DATABASE) != null) {
            this.introspectDatabaseListImpl(meta);
        } else if (this.getModel().getRoot().familyOf(ObjectKind.SCHEMA) != null) {
            this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.empty());
        } else {
            throw new GenericIntrospectionException("Model does not contain database/schema namespace", null);
        }
    }

    private void introspectDatabaseListImpl(@NotNull DatabaseMetaDataWrapper meta) {
        boolean haveDb;
        ModNamingFamily databases;
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(46);
        }
        if ((databases = JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)this.getModel().getRoot(), ObjectKind.DATABASE)) == null) {
            return;
        }
        databases.markChildrenAsSyncPending();
        try (ClosableIt<String> dbIt = meta.databases();){
            haveDb = this.fillDatabases((Iterator<String>)((Object)dbIt));
        }
        catch (SQLException e) {
            throw new GenericIntrospectionException("Failed to retrieve databases", e);
        }
        if (haveDb) {
            JdbcIntrospector.cleanupFamily(databases);
            this.updateDatabaseFlags(databases);
            this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.from(databases).filter(BasicModDatabase.class).filter(db -> db.isCurrent()));
        } else {
            this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.empty());
            this.updateDatabaseFlags(databases);
        }
    }

    private void introspectSchemaList(@NotNull DatabaseMetaDataWrapper meta, @NotNull JBIterable<BasicModDatabase> databases) {
        Throwable throwable;
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(47);
        }
        if (databases == null) {
            JdbcIntrospector.$$$reportNull$$$0(48);
        }
        for (BasicModDatabase db : databases) {
            db.getSchemas().markChildrenAsSyncPending();
        }
        JBIterable dbs2 = databases.transform(DasUtil.TO_NAME);
        if (databases.isEmpty() && this.myHelper.isSchemaDbMode()) {
            try {
                throwable = null;
                try (ClosableIt<String> dbIt = meta.databases();){
                    dbs2 = JBIterable.from((Iterable)ContainerUtil.collect(dbIt));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new GenericIntrospectionException("Failed to retrieve schemas", e);
            }
        }
        try {
            throwable = null;
            try (ClosableIt<DatabaseMetaDataWrapper.Schema> schemaIt = meta.schemas((JBIterable<String>)dbs2);){
                this.fillSchemas((Iterator<DatabaseMetaDataWrapper.Schema>)((Object)schemaIt));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (SQLException e) {
            throw new GenericIntrospectionException("Failed to retrieve schemas", e);
        }
        for (BasicModDatabase db : databases) {
            JdbcIntrospector.cleanupFamily((ModFamily)db.getSchemas());
        }
    }

    @Nullable
    private <T extends BasicNamespace> T getCurrentOrSole(@NotNull Iterable<? extends T> namespaces) {
        JBIterable nsp;
        BasicNamespace current;
        if (namespaces == null) {
            JdbcIntrospector.$$$reportNull$$$0(49);
        }
        if ((current = (BasicNamespace)(nsp = JBIterable.from(namespaces)).filter(this::isCurrent).first()) != null) {
            return (T)current;
        }
        if (nsp.size() == 1) {
            return (T)((BasicNamespace)nsp.first());
        }
        return null;
    }

    private void fillSchemas(Iterator<DatabaseMetaDataWrapper.Schema> schemaIt) {
        LinkedHashSet schemaFamilies = new LinkedHashSet();
        ModNamingFamily root2 = JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)this.getModel().getRoot(), ObjectKind.SCHEMA);
        if (root2 != null) {
            root2.markChildrenAsSyncPending();
            schemaFamilies.add(root2);
        }
        for (DatabaseMetaDataWrapper.Schema schema : JBIterable.once(schemaIt)) {
            if (root2 == null) {
                ModNamingFamily schemas3;
                BasicModDatabase database = this.myHelper.createDatabase(schema.database);
                ModNamingFamily modNamingFamily = schemas3 = database == null ? null : JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)database, ObjectKind.SCHEMA);
                if (schemas3 != null && schemaFamilies.add(schemas3)) {
                    schemas3.markChildrenAsSyncPending();
                }
            } else if (this.database == null) {
                this.database = schema.database;
            }
            this.myHelper.createSchema(schema);
        }
        schemaFamilies.forEach(schemas2 -> {
            JdbcIntrospector.cleanupFamily((ModFamily)schemas2);
            this.updateSchemaFlags((ModNamingFamily<? extends BasicModSchema>)schemas2);
        });
    }

    private void updateSchemaFlags(ModNamingFamily<? extends BasicModSchema> schemas2) {
        BasicModSchema curSc = this.getCurrentOrSole((Iterable)schemas2);
        if (curSc != null) {
            schemas2.forEach(s -> s.setCurrent(false));
            curSc.setCurrent(true);
        }
    }

    private boolean inScope(@NotNull BasicElement e) {
        if (e == null) {
            JdbcIntrospector.$$$reportNull$$$0(50);
        }
        return DataSourceSchemaMapping.matches((TreePattern)this.myOptions.getScope(), (DasObject)e);
    }

    private boolean isIntrospected(@NotNull BasicElement e) {
        if (e == null) {
            JdbcIntrospector.$$$reportNull$$$0(51);
        }
        return this.inScope(e) || this.getOptions().getScope().isEmpty() && DataSourceSchemaMapping.matches((TreePattern)this.getDefaultScope(), (DasObject)e);
    }

    private boolean fillDatabases(Iterator<String> dbIt) {
        boolean empty = true;
        for (String db : JBIterable.once(dbIt)) {
            empty = false;
            this.myHelper.createDatabase(db);
        }
        return !empty;
    }

    private void updateDatabaseFlags(ModNamingFamily<?> root2) {
        JBIterable databases = JBIterable.from(root2).filter(BasicModMateDatabase.class);
        BasicModMateDatabase curDb = (BasicModMateDatabase)this.getCurrentOrSole((Iterable)databases);
        for (BasicModMateDatabase database : databases) {
            database.setCurrent(false);
        }
        if (curDb != null) {
            curDb.setCurrent(true);
        }
    }

    private boolean isCurrent(@Nullable BasicNamespace nsp) {
        if (nsp instanceof BasicDatabase) {
            return this.isCurrent((BasicDatabase)nsp);
        }
        if (nsp instanceof BasicSchema) {
            return this.isCurrent((BasicSchema)nsp);
        }
        return false;
    }

    private boolean isCurrent(@Nullable BasicDatabase db) {
        if (db == null || this.myInfo == null) {
            return false;
        }
        return db.getName().equals(this.myInfo.databaseName);
    }

    private boolean isCurrent(@Nullable BasicSchema sc2) {
        if (sc2 == null || this.myInfo == null) {
            return false;
        }
        return this.myHelper.isSchemaDbMode() ? sc2.getName().equals(this.myInfo.databaseName) : sc2.getName().equals(this.myInfo.schemaName) || this.myInfo.schemaName == null && sc2.getName().equals(this.myInfo.userName);
    }

    @NotNull
    private DatabaseMetaDataWrapper createMeta() {
        DatabaseMetaDataWrapper databaseMetaDataWrapper;
        if (this.myConnection == null) {
            throw new GenericIntrospectionException("Failed to get connection", null);
        }
        try {
            RemoteDatabaseMetaData metaData = this.myConnection.getRemoteMetaData();
            if (metaData == null) {
                throw new GenericIntrospectionException("Connection#getMetaData() returns null. No introspection could be performed", null);
            }
            databaseMetaDataWrapper = DatabaseMetaDataWrapper.create(this.myConnection, metaData).withErrorSink(this.myErrorSink);
        }
        catch (SQLException e) {
            throw new GenericIntrospectionException("Failed to retrieve meta data", e);
        }
        if (databaseMetaDataWrapper == null) {
            JdbcIntrospector.$$$reportNull$$$0(52);
        }
        return databaseMetaDataWrapper;
    }

    @NotNull
    public JBIterable<BasicModSchema> schemas(BasicNamespace ... namespaces) {
        JBTreeTraverser traverser2 = this.getModel().traverser();
        if (namespaces != null && namespaces.length != 0) {
            traverser2 = (JBTreeTraverser)traverser2.withRoots((Iterable)JBIterable.of((Object[])namespaces));
        }
        JBIterable jBIterable = ((JBTreeTraverser)traverser2.expand(Conditions.instanceOf(BasicDatabase.class))).filter(BasicModSchema.class).filter(s -> this.isIntrospected((BasicElement)s) || namespaces != null && ArrayUtil.indexOf((Object[])namespaces, (Object)s) != -1);
        if (jBIterable == null) {
            JdbcIntrospector.$$$reportNull$$$0(53);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ModFamily<?>> getRoutineFamilies(@NotNull BasicModSchema schema) {
        if (schema == null) {
            JdbcIntrospector.$$$reportNull$$$0(54);
        }
        JBIterable routineFamilies = JBIterable.of((Object)schema.familyOf(ObjectKind.ROUTINE));
        ModFamily packages = schema.familyOf(ObjectKind.PACKAGE);
        if (packages != null) {
            JBIterable pkg = JBIterable.of((Object)packages);
            routineFamilies = routineFamilies.append((Iterable)pkg).append((Iterable)pkg.flatten(p -> p).transform(f -> f.familyOf(ObjectKind.ROUTINE)).filter(Conditions.notNull()));
        }
        JBIterable jBIterable = routineFamilies;
        if (jBIterable == null) {
            JdbcIntrospector.$$$reportNull$$$0(55);
        }
        return jBIterable;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public JBIterable<ModFamily<?>> getUserDefinedTypeFamilies(@NotNull BasicModSchema schema) {
        if (schema == null) {
            JdbcIntrospector.$$$reportNull$$$0(56);
        }
        @NotNull JBIterable transform = JBIterable.of((Object[])new ObjectKind[]{ObjectKind.ALIAS_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.OBJECT_TYPE, ObjectKind.TABLE_TYPE}).transform(arg_0 -> ((BasicModSchema)schema).familyOf(arg_0));
        JBIterable jBIterable = transform.filter(Conditions.notNull());
        if (jBIterable == null) {
            JdbcIntrospector.$$$reportNull$$$0(57);
        }
        return jBIterable;
    }

    private static void markChildrenAsSyncPending(@Nullable ModFamily f) {
        if (f == null) {
            return;
        }
        f.markChildrenAsSyncPending();
    }

    private static void cleanupFamily(@Nullable ModFamily f) {
        if (f == null) {
            return;
        }
        f.removeSyncPendingChildren();
        f.sort();
    }

    public void introspectSessionState() {
        this.getModel().modify(BasicModRoot.class, root2 -> root2.setServerVersion(this.myConnection.getVersion()));
    }

    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        if (namespace == null) {
            JdbcIntrospector.$$$reportNull$$$0(58);
        }
        if (objectKind == null) {
            JdbcIntrospector.$$$reportNull$$$0(59);
        }
        if (objectNames == null) {
            JdbcIntrospector.$$$reportNull$$$0(60);
        }
    }

    @NotNull
    public Map<BasicElement, String[]> introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements2, boolean withNestedElements) {
        if (elements2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(61);
        }
        Map<BasicElement, String[]> map2 = Collections.emptyMap();
        if (map2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(62);
        }
        return map2;
    }

    public void introspectServerObjects() {
    }

    @NotNull
    public PairConsumer<String, Throwable> getErrorSink() {
        PairConsumer<String, Throwable> pairConsumer = this.myErrorSink;
        if (pairConsumer == null) {
            JdbcIntrospector.$$$reportNull$$$0(63);
        }
        return pairConsumer;
    }

    public void setErrorSink(@NotNull PairConsumer<String, Throwable> consumer) {
        if (consumer == null) {
            JdbcIntrospector.$$$reportNull$$$0(64);
        }
        this.myErrorSink = consumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 24: 
            case 36: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 62: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 24: 
            case 36: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 62: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 24: 
            case 36: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/JdbcIntrospector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 9: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 10: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databases";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemas";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byCatalog";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouped";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 22: 
            case 23: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectKind";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectNames";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/JdbcIntrospector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveInvalid";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableFamilies";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "asSchema";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createMeta";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "schemas";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutineFamilies";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedTypeFamilies";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "introspectNativeDefinitions";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 24: 
            case 36: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 62: 
            case 63: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "attachToDB";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "retrieveInvalid";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setOptions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "introspectAuto";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabaseSchemas";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemas";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemasByCatalogs";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "forEachCatalog";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "forEachSchemaInCatalog";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "introspectTablesInSchema";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTableFamilies";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "introspectTableKeys";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "introspectTableForeignKeys";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "introspectTableIndices";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "introspectColumnsInSchema";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "introspectTypeAttributesInSchema";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "asSchema";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "introspectPrototypesInSchema";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "introspectRoutinesInSchema";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "introspectAdditionalTypes";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "introspectTypesInSchema";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabaseList";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabaseListImpl";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemaList";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentOrSole";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "inScope";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isIntrospected";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getRoutineFamilies";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getUserDefinedTypeFamilies";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "introspectFragment";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "introspectNativeDefinitions";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "setErrorSink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 24: 
            case 36: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 62: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GenericIntrospectionException
    extends DBIntrospectionException {
        GenericIntrospectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Factory
    implements DBIntrospector.Factory {
        private static final Map<Dbms, PerObjectVersion> VERSIONS = FactoryMap.create(key2 -> PerObjectVersion.DEFAULT.INSTANCE);
        private final Dbms myDbms;

        public Factory(@NotNull Dbms dbms) {
            if (dbms == null) {
                Factory.$$$reportNull$$$0(0);
            }
            this.myDbms = dbms;
        }

        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            if (dbms == null) {
                Factory.$$$reportNull$$$0(1);
            }
            if (project == null) {
                Factory.$$$reportNull$$$0(2);
            }
            if (modelFactory == null) {
                Factory.$$$reportNull$$$0(3);
            }
            JdbcIntrospector introspector = new JdbcIntrospector(dbms);
            introspector.setModelFactory(modelFactory);
            JdbcIntrospector jdbcIntrospector = introspector;
            if (jdbcIntrospector == null) {
                Factory.$$$reportNull$$$0(4);
            }
            return jdbcIntrospector;
        }

        public boolean isSupported(@NotNull Version version) {
            if (version == null) {
                Factory.$$$reportNull$$$0(5);
            }
            return true;
        }

        public boolean isNative() {
            return false;
        }

        public int getVersion(@NotNull ObjectKind kind) {
            if (kind == null) {
                Factory.$$$reportNull$$$0(6);
            }
            return VERSIONS.get(this.myDbms).get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFactory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/JdbcIntrospector$Factory";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/JdbcIntrospector$Factory";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIntrospector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createIntrospector";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getVersion";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

