/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.ConsumerColumnRef;
import com.intellij.database.data.types.ContainsInIndexedTextOperation;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.FormatTestResult;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.NullPredicateValue;
import com.intellij.database.data.types.OperandType;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateSpec;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.Operation;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.Version;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J@\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J.\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J&\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J<\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010$\u001a\u00020\u0010H\u0014JR\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\"0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020 0\"2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010$\u001a\u00020\u0010H\u0016J\u001a\u0010(\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010)\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014JP\u0010*\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\r\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010$\u001a\u00020\u0010H\u0014J8\u0010-\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006."}, d2={"Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "Lcom/intellij/database/data/types/PredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "", "version", "Lcom/intellij/database/util/Version;", "alias", "", "equalsToPlaceholderPredicate", "Lcom/intellij/database/data/types/Placeholder;", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "ftsPredicate", "columnRef", "getDomain", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "getPredicateProducer", "spec", "Lcom/intellij/database/data/types/PredicateSpec;", "types", "", "Lcom/intellij/database/data/types/OperandType;", "inUpdate", "getPredicateProducers", "", "specs", "isNumber", "isText", "likePredicate", "Lcom/intellij/database/data/types/LikePredicateOperation;", "canCastToText", "nullPredicate", "intellij.database.dialects.base"})
public class BasePredicatesHelper
implements PredicatesHelper {
    @NotNull
    private final Dbms dbms;

    @NotNull
    public Map<ColumnRef, List<PredicatesHelper.PredicateProducer>> getPredicateProducers(@NotNull List<PredicateSpec> specs, @NotNull List<? extends OperandType> types, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Intrinsics.checkParameterIsNotNull(specs, (String)"specs");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        boolean bl = false;
        Map predicates = new LinkedHashMap();
        Iterable $this$forEach$iv = specs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PredicateSpec spec = (PredicateSpec)element$iv;
            boolean bl2 = false;
            PredicatesHelper.PredicateProducer predicate = this.getPredicateProducer(spec, types, alias, version, inUpdate);
            if (predicate == null) continue;
            predicates.put(spec.getColumnRef(), CollectionsKt.listOf((Object)predicate));
        }
        return predicates;
    }

    @Nullable
    protected PredicatesHelper.PredicateProducer getPredicateProducer(@NotNull PredicateSpec spec, @NotNull List<? extends OperandType> types, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Object v4;
        Object v3;
        ComparePredicateOperation compareOp;
        Domain domain;
        PredicateValue value;
        ColumnRef column2;
        block27: {
            Object v1;
            Object v0;
            block26: {
                PredicatesHelper.PredicateProducer predicate;
                Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
                Intrinsics.checkParameterIsNotNull(types, (String)"types");
                column2 = spec.getColumnRef();
                value = spec.getValue();
                if (types.contains(OperandType.INDEXED_TEXT) && spec.getOperations().contains(ContainsInIndexedTextOperation.INSTANCE) && (predicate = this.ftsPredicate(column2, value, alias, version)) != null) {
                    return predicate;
                }
                domain = this.getDomain(column2, version);
                Iterable iterable = spec.getOperations();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object object : iterable2) {
                    PredicateOperation it = (PredicateOperation)object;
                    boolean bl3 = false;
                    if (!(it instanceof ComparePredicateOperation)) continue;
                    v0 = object;
                    break block26;
                }
                v0 = v1 = null;
            }
            if (!(v0 instanceof ComparePredicateOperation)) {
                v1 = null;
            }
            compareOp = v1;
            if (types.contains(OperandType.NUMBER) && this.isNumber(column2, version) && compareOp != null) {
                boolean bl;
                PredicateValue predicateValue = value;
                if (predicateValue instanceof StringPredicateValue) {
                    bl = !((StringPredicateValue)value).getCheckTypeOfLiteral() || NumberUtils.isNumber((String)((StringPredicateValue)value).getStr());
                } else if (predicateValue instanceof Placeholder) {
                    bl = domain == null || domain.supports((Operation)OperationKt.EQUALS_TO_PLACEHOLDER_OPERATION);
                } else if (Intrinsics.areEqual((Object)predicateValue, (Object)NullPredicateValue.INSTANCE)) {
                    bl = domain == null || domain.supports((Operation)OperationKt.EQUALS_TO_NULL_OPERATION);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                boolean supports = bl;
                return supports ? this.equalsPredicate(column2, value, compareOp, false, version, alias) : null;
            }
            Iterable iterable = spec.getOperations();
            boolean bl = false;
            Iterable iterable3 = iterable;
            boolean bl4 = false;
            for (Object e : iterable3) {
                PredicateOperation it = (PredicateOperation)e;
                boolean bl5 = false;
                if (!(it instanceof LikePredicateOperation)) continue;
                v3 = e;
                break block27;
            }
            v3 = v4 = null;
        }
        if (!(v3 instanceof LikePredicateOperation)) {
            v4 = null;
        }
        LikePredicateOperation likeOp = v4;
        if (types.contains(OperandType.TEXT) && this.isText(column2, version)) {
            PredicatesHelper.PredicateProducer likePredicate2;
            if (Intrinsics.areEqual((Object)value, (Object)NullPredicateValue.INSTANCE) && compareOp != null) {
                return this.nullPredicate(column2, compareOp, domain, version, alias);
            }
            if (likeOp != null && (likePredicate2 = this.likePredicate(column2, value, domain, likeOp, false, alias, version, inUpdate)) != null) {
                return likePredicate2;
            }
            if (compareOp == null) {
                return null;
            }
            if (value instanceof Placeholder) {
                return this.equalsToPlaceholderPredicate(column2, (Placeholder)value, compareOp, domain, version, alias);
            }
            if (!(value instanceof StringPredicateValue)) {
                return null;
            }
            return domain != null && !domain.supports((Operation)OperationKt.EQUALS_TO_STRING_OPERATION) ? null : this.equalsPredicate(column2, value, compareOp, true, version, alias);
        }
        if (types.contains(OperandType.OTHER)) {
            if (compareOp != null) {
                if (Intrinsics.areEqual((Object)value, (Object)NullPredicateValue.INSTANCE)) {
                    return this.nullPredicate(column2, compareOp, domain, version, alias);
                }
                if (value instanceof StringPredicateValue) {
                    FormatTestResult testResult;
                    FormatTester formatTester = this.getFormatTester(column2, domain, version);
                    FormatTester formatTester2 = formatTester;
                    FormatTestResult formatTestResult = formatTester2 != null && (formatTester2 = formatTester2.getTest()) != null ? (FormatTestResult)formatTester2.invoke((Object)((StringPredicateValue)value).getStr()) : (testResult = null);
                    if (testResult == FormatTestResult.QUOTE || testResult == FormatTestResult.NOT_QUOTE) {
                        return this.equalsPredicate(column2, value, compareOp, testResult == FormatTestResult.QUOTE, version, alias);
                    }
                    if (!((StringPredicateValue)value).getCheckTypeOfLiteral()) {
                        return this.equalsPredicate(column2, value, compareOp, formatTester == null || formatTester.getQuoteIfForcedMatched(), version, alias);
                    }
                }
                if (value instanceof Placeholder) {
                    return this.equalsToPlaceholderPredicate(column2, (Placeholder)value, compareOp, domain, version, alias);
                }
            }
            if (likeOp != null) {
                return this.likePredicate(column2, value, domain, likeOp, true, alias, version, inUpdate);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PredicatesHelper.PredicateProducer equalsToPlaceholderPredicate(ColumnRef column2, Placeholder value, ComparePredicateOperation op, Domain domain, Version version, String alias) {
        Domain domain2 = domain;
        if (domain2 != null) {
            if (!domain2.supports((Operation)OperationKt.EQUALS_TO_PLACEHOLDER_OPERATION)) {
                return null;
            }
        }
        PredicatesHelper.PredicateProducer predicateProducer = this.equalsPredicate(column2, (PredicateValue)value, op, false, version, alias);
        return predicateProducer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PredicatesHelper.PredicateProducer nullPredicate(ColumnRef column2, ComparePredicateOperation op, Domain domain, Version version, String alias) {
        Domain domain2 = domain;
        if (domain2 != null) {
            if (!domain2.supports((Operation)OperationKt.EQUALS_TO_NULL_OPERATION)) {
                return null;
            }
        }
        PredicatesHelper.PredicateProducer predicateProducer = this.equalsPredicate(column2, (PredicateValue)NullPredicateValue.INSTANCE, op, false, version, alias);
        return predicateProducer;
    }

    @Nullable
    protected Domain getDomain(@NotNull ColumnRef columnRef, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)columnRef, (String)"columnRef");
        DomainRegistry registry = DomainRegistry.get((Dbms)this.dbms, (Version)version);
        ColumnDescriptor columnDescriptor = PredicatesUtilKt.getDescriptor((ColumnRef)columnRef);
        if (columnDescriptor == null) {
            return null;
        }
        ColumnDescriptor columnDescriptor2 = columnDescriptor;
        DomainRegistry domainRegistry = registry;
        return domainRegistry != null ? domainRegistry.getDomain(columnDescriptor2) : null;
    }

    private final boolean isNumber(ColumnRef columnRef, Version version) {
        Domain domain = this.getDomain(columnRef, version);
        return domain == null ? columnRef instanceof ConsumerColumnRef && JdbcUtil.isNumberType((int)((ConsumerColumnRef)columnRef).getCol().type) : domain.supports((Operation)OperationKt.EQUALS_TO_NUMBER_OPERATION);
    }

    protected boolean isText(@NotNull ColumnRef columnRef, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)columnRef, (String)"columnRef");
        Domain domain = this.getDomain(columnRef, version);
        return this.getFormatTester(columnRef, domain, version) == null && (domain == null || domain.supports((Operation)OperationKt.EQUALS_TO_STRING_OPERATION) || domain.supports(OperationKt.LIKE_OPERATION));
    }

    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)columnRef, (String)"columnRef");
        Domain domain2 = domain;
        LogicalType type = domain2 != null ? domain2.getLogicType() : null;
        return type == null || !ArraysKt.contains((Object[])new LogicalType[]{LogicalType.TIME_WITH_TIMEZONE, LogicalType.TIMESTAMP_WITH_TIMEZONE, LogicalType.TIMESTAMP, LogicalType.TIME, LogicalType.DATE, LogicalType.UUID, LogicalType.BOOLEAN}, (Object)type) ? null : PredicatesUtilKt.getFormatTester((ColumnRef)columnRef, (Dbms)this.dbms, (LogicalType)type);
    }

    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)op, (String)"op");
        return PredicatesUtilKt.defaultEqualsPredicate((ColumnRef)column2, (PredicateValue)value, (boolean)quote, (Dbms)this.dbms, (String)alias, (ComparePredicateOperation)op);
    }

    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Intrinsics.checkParameterIsNotNull((Object)columnRef, (String)"columnRef");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)op, (String)"op");
        return PredicatesUtilKt.defaultLikePredicate((ColumnRef)columnRef, (PredicateValue)value, (Domain)domain, (LikePredicateOperation)op, (Dbms)this.dbms, (Version)version, (String)alias, (boolean)inUpdate);
    }

    @Nullable
    protected PredicatesHelper.PredicateProducer ftsPredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable String alias, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)columnRef, (String)"columnRef");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return null;
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    public BasePredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        this.dbms = dbms;
    }
}

