/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.bool.ComparisonPredicate;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NotNull;

public class JSNegateComparisonIntention
extends JSMutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        JSBinaryExpression expression = (JSBinaryExpression)element;
        String operatorText = "";
        String negatedOperatorText = "";
        if (expression != null) {
            IElementType sign = expression.getOperationSign();
            operatorText = ComparisonUtils.getOperatorText((IElementType)sign);
            negatedOperatorText = ComparisonUtils.getNegatedOperatorText((IElementType)sign);
        }
        if (operatorText.equals(negatedOperatorText)) {
            return this.getSuffixedDisplayName("equals", operatorText);
        }
        return this.getSuffixedDisplayName("not-equals", operatorText, negatedOperatorText);
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new ComparisonPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSNegateComparisonIntention.$$$reportNull$$$0(0);
        }
        JSBinaryExpression exp = (JSBinaryExpression)element;
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType sign = exp.getOperationSign();
        String negatedOperator = ComparisonUtils.getNegatedOperatorText((IElementType)sign);
        String lhsText = lhs.getText();
        assert (rhs != null);
        ConditionalUtils.replaceExpressionWithNegatedExpressionString((JSExpression)exp, lhsText + negatedOperator + rhs.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/bool/JSNegateComparisonIntention", "processIntention"));
    }
}

