/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.debug;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeCommand;
import com.intellij.docker.debug.DockerBeforeRunComposeLauncher;
import com.intellij.docker.debug.DockerBeforeRunContainerLauncher;
import com.intellij.docker.debug.DockerBeforeRunTaskLauncherBase;
import com.intellij.docker.debug.DockerBeforeRunTaskProvider;
import com.intellij.docker.debug.DockerRunConfigurationUtils;
import com.intellij.docker.remoteDebug.RemotePortRequest;
import com.intellij.docker.remoteDebug.RemoteServerRequest;
import com.intellij.docker.remoteDebug.RemoteServerRequestAdapterFactory;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerBeforeRunTask
extends BeforeRunTask<DockerBeforeRunTask>
implements PersistentStateComponent<State> {
    private final Project myProject;
    private final RemoteServerRequest myRequest;
    private TargetRunConfigProxy myTargetRunConfig;
    private String myCustomCommand;
    private boolean myWaitForHealthCheck;

    public DockerBeforeRunTask(@NotNull Project project, @NotNull RemoteServerRequest request) {
        if (project == null) {
            DockerBeforeRunTask.$$$reportNull$$$0(0);
        }
        if (request == null) {
            DockerBeforeRunTask.$$$reportNull$$$0(1);
        }
        super(DockerBeforeRunTaskProvider.ID);
        this.myProject = project;
        this.myRequest = request;
    }

    public void setTargetRunConfig(@Nullable TargetRunConfig targetRunConfig) {
        this.myTargetRunConfig = new TargetRunConfigProxy(targetRunConfig);
    }

    public void setCustomCommand(String customCommand) {
        this.myCustomCommand = customCommand;
    }

    public String getCustomCommand() {
        return this.myCustomCommand;
    }

    @Nullable
    public String getAdjustedCommand(@NotNull RunConfiguration hostDebugConfig) {
        if (hostDebugConfig == null) {
            DockerBeforeRunTask.$$$reportNull$$$0(2);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myCustomCommand)) {
            return this.myCustomCommand;
        }
        TargetRunConfig targetRunConfig = this.getTargetRunConfig();
        RemoteServerRequestAdapterFactory adapterFactory = RemoteServerRequestAdapterFactory.findAdapterFactory(hostDebugConfig);
        if (targetRunConfig == null || adapterFactory == null) {
            return null;
        }
        return targetRunConfig.getAutoAdjustedCommand(adapterFactory, this.getRequest());
    }

    public String getCustomOptions() {
        return Stream.of(this.myRequest.getPortRequests()).map(mapping -> "-p " + mapping.getLocalPort() + ":" + mapping.getEffectiveRemotePort()).collect(Collectors.joining(" "));
    }

    public boolean isWaitForHealthCheck() {
        return this.myWaitForHealthCheck;
    }

    public void setWaitForHealthCheck(boolean waitForHealthCheck) {
        this.myWaitForHealthCheck = waitForHealthCheck;
    }

    public List<RemotePortRequest> getPortMappings() {
        return new ArrayList<RemotePortRequest>(Arrays.asList(this.myRequest.getPortRequests()));
    }

    @Nullable
    public TargetRunConfig getTargetRunConfig() {
        return this.myTargetRunConfig == null ? null : this.myTargetRunConfig.resolve(this.myProject);
    }

    @Nullable
    public DeployToServerRunConfiguration<?, ?> getDockerRunConfig() {
        TargetRunConfig targetRunConfig = this.getTargetRunConfig();
        return targetRunConfig == null ? null : targetRunConfig.getDockerRunConfig();
    }

    @NotNull
    public RemoteServerRequest getRequest() {
        RemoteServerRequest remoteServerRequest = this.myRequest;
        if (remoteServerRequest == null) {
            DockerBeforeRunTask.$$$reportNull$$$0(3);
        }
        return remoteServerRequest;
    }

    public boolean isForComposeService(@NotNull String serviceName) {
        TargetRunConfig targetRunConfig;
        if (serviceName == null) {
            DockerBeforeRunTask.$$$reportNull$$$0(4);
        }
        return (targetRunConfig = this.getTargetRunConfig()) instanceof TargetComposeRunConfig && ((TargetComposeRunConfig)targetRunConfig).isForComposeService(serviceName);
    }

    public boolean isForSourceFileAndType(@NotNull VirtualFile file2, @NotNull SingletonDeploymentSourceType dockerSourceType) {
        DeployToServerRunConfiguration<?, ?> dockerRunConfig;
        if (file2 == null) {
            DockerBeforeRunTask.$$$reportNull$$$0(5);
        }
        if (dockerSourceType == null) {
            DockerBeforeRunTask.$$$reportNull$$$0(6);
        }
        if ((dockerRunConfig = this.getDockerRunConfig()) == null) {
            return false;
        }
        DeploymentSource source = dockerRunConfig.getDeploymentSource();
        if (source == null || source.getType() != dockerSourceType) {
            return false;
        }
        DockerDeploymentConfiguration configuration = (DockerDeploymentConfiguration)dockerRunConfig.getDeploymentConfiguration();
        if (configuration == null) {
            return false;
        }
        return DockerDeploymentConfiguration.ProjectAwareHelper.isForSameFile(this.myProject, configuration, file2);
    }

    @NotNull
    public State getState() {
        State state = new State();
        state.setCustomCommand(this.myCustomCommand);
        state.setWaitForHealthCheck(this.myWaitForHealthCheck);
        if (this.myTargetRunConfig != null) {
            this.myTargetRunConfig.saveToState(state);
        }
        ArrayList<PortMappingState> ports = new ArrayList<PortMappingState>();
        for (RemotePortRequest nextPort : this.myRequest.getPortRequests()) {
            if (nextPort.getRemotePort() == -1) continue;
            PortMappingState nextPortState = new PortMappingState();
            nextPortState.setId(nextPort.getId());
            nextPortState.setRemotePort(nextPort.getRemotePort());
            ports.add(nextPortState);
        }
        state.setPortMappings(ports);
        State state2 = state;
        if (state2 == null) {
            DockerBeforeRunTask.$$$reportNull$$$0(7);
        }
        return state2;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            DockerBeforeRunTask.$$$reportNull$$$0(8);
        }
        this.myTargetRunConfig = new TargetRunConfigProxy(state);
        this.myCustomCommand = state.getCustomCommand();
        this.myWaitForHealthCheck = state.isWaitForHealthCheck();
        for (PortMappingState nextPortState : Optional.ofNullable(state.getPortMappings()).orElse(Collections.emptyList())) {
            RemotePortRequest portRequest;
            String id = nextPortState.getId();
            int remotePort = nextPortState.getRemotePort();
            if (id == null || remotePort == -1 || (portRequest = this.myRequest.findPortRequest(id)) == null) continue;
            portRequest.setRemotePort(remotePort);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDebugConfig";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/debug/DockerBeforeRunTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerSourceType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/debug/DockerBeforeRunTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequest";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedCommand";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isForComposeService";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isForSourceFileAndType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TargetContainerRunConfig
    extends TargetRunConfig {
        TargetContainerRunConfig(@NotNull DeployToServerRunConfiguration<?, ?> runConfig) {
            if (runConfig == null) {
                TargetContainerRunConfig.$$$reportNull$$$0(0);
            }
            super(runConfig);
        }

        @Override
        @NotNull
        public DockerBeforeRunTaskLauncherBase createLauncher(@NotNull ExecutionEnvironment env, @NotNull DockerBeforeRunTask task) {
            if (env == null) {
                TargetContainerRunConfig.$$$reportNull$$$0(1);
            }
            if (task == null) {
                TargetContainerRunConfig.$$$reportNull$$$0(2);
            }
            return new DockerBeforeRunContainerLauncher(env, task);
        }

        @Override
        @Nullable
        public String getBaseCommand() {
            return Optional.of(this.getDockerRunConfig()).map(DeployToServerRunConfiguration::getDeploymentConfiguration).map(o -> (DockerDeploymentConfiguration)((Object)((Object)ObjectUtils.tryCast((Object)o, DockerDeploymentConfiguration.class)))).map(DockerDeploymentConfiguration::getCommand).orElse(null);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TargetContainerRunConfig)) {
                return false;
            }
            TargetContainerRunConfig that = (TargetContainerRunConfig)obj;
            return Objects.equals(this.getDockerRunConfig().getName(), that.getDockerRunConfig().getName());
        }

        public int hashCode() {
            return this.getDockerRunConfig().getName().hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/debug/DockerBeforeRunTask$TargetContainerRunConfig";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLauncher";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TargetComposeRunConfig
    extends TargetRunConfig {
        private final String myServiceName;

        public TargetComposeRunConfig(@NotNull DeployToServerRunConfiguration<?, ?> runConfig, @NotNull String serviceName) {
            if (runConfig == null) {
                TargetComposeRunConfig.$$$reportNull$$$0(0);
            }
            if (serviceName == null) {
                TargetComposeRunConfig.$$$reportNull$$$0(1);
            }
            super(runConfig);
            this.myServiceName = serviceName;
        }

        @NotNull
        public TargetComposeRunConfig createWithServiceName(@NotNull String serviceName) {
            if (serviceName == null) {
                TargetComposeRunConfig.$$$reportNull$$$0(2);
            }
            return new TargetComposeRunConfig(this.getDockerRunConfig(), serviceName);
        }

        public boolean isForComposeService(@NotNull String serviceName) {
            if (serviceName == null) {
                TargetComposeRunConfig.$$$reportNull$$$0(3);
            }
            return this.myServiceName.equals(serviceName);
        }

        @NotNull
        public String getServiceName() {
            String string = this.myServiceName;
            if (string == null) {
                TargetComposeRunConfig.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public void saveToState(@NotNull State state) {
            if (state == null) {
                TargetComposeRunConfig.$$$reportNull$$$0(5);
            }
            super.saveToState(state);
            state.setComposeServiceName(this.myServiceName);
        }

        @Override
        @NotNull
        public DockerBeforeRunTaskLauncherBase createLauncher(@NotNull ExecutionEnvironment env, @NotNull DockerBeforeRunTask task) {
            if (env == null) {
                TargetComposeRunConfig.$$$reportNull$$$0(6);
            }
            if (task == null) {
                TargetComposeRunConfig.$$$reportNull$$$0(7);
            }
            return new DockerBeforeRunComposeLauncher(env, task, this);
        }

        @Override
        @Nullable
        public String getBaseCommand() {
            Map<String, DockerComposeCommand> parsedFile = this.parseServices();
            return Optional.ofNullable(parsedFile.get(this.myServiceName)).map(DockerComposeCommand::getCommand).map(o -> (String)ObjectUtils.tryCast((Object)o, String.class)).orElse(null);
        }

        public List<String> getAllServices() {
            Map<String, DockerComposeCommand> parsedFile = this.parseServices();
            return new ArrayList<String>(parsedFile.keySet());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TargetComposeRunConfig)) {
                return false;
            }
            TargetComposeRunConfig that = (TargetComposeRunConfig)obj;
            return Objects.equals(this.getServiceName(), that.getServiceName()) && Objects.equals(this.getDockerRunConfig().getName(), that.getDockerRunConfig().getName());
        }

        public int hashCode() {
            return this.getServiceName().hashCode() * 31 + this.getDockerRunConfig().getName().hashCode();
        }

        private Map<String, DockerComposeCommand> parseServices() {
            return DockerRunConfigurationUtils.parseServices(this.getDockerRunConfig());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfig";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/debug/DockerBeforeRunTask$TargetComposeRunConfig";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/debug/DockerBeforeRunTask$TargetComposeRunConfig";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServiceName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createWithServiceName";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isForComposeService";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "saveToState";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createLauncher";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TargetRunConfigProxy {
        private final String myRunConfigName;
        private final String myServiceName;
        private boolean myHasResolvedInstance;
        private TargetRunConfig myResolvedInstance;

        TargetRunConfigProxy(@NotNull State state) {
            if (state == null) {
                TargetRunConfigProxy.$$$reportNull$$$0(0);
            }
            this.myRunConfigName = state.getDockerRunConfigName();
            this.myServiceName = state.getComposeServiceName();
        }

        TargetRunConfigProxy(@Nullable TargetRunConfig resolvedInstance) {
            this.myRunConfigName = null;
            this.myServiceName = null;
            this.myResolvedInstance = resolvedInstance;
            this.myHasResolvedInstance = true;
        }

        public TargetRunConfig resolve(@NotNull Project project) {
            if (project == null) {
                TargetRunConfigProxy.$$$reportNull$$$0(1);
            }
            if (this.myHasResolvedInstance) {
                return this.myResolvedInstance;
            }
            if (this.myResolvedInstance == null) {
                this.myResolvedInstance = this.doResolve(project);
                this.myHasResolvedInstance = this.myResolvedInstance != null;
            }
            return this.myResolvedInstance;
        }

        public void saveToState(@NotNull State state) {
            if (state == null) {
                TargetRunConfigProxy.$$$reportNull$$$0(2);
            }
            if (this.myResolvedInstance == null) {
                state.setDockerRunConfigName(this.myRunConfigName);
                state.setComposeServiceName(this.myServiceName);
            } else {
                this.myResolvedInstance.saveToState(state);
            }
        }

        @Nullable
        private TargetRunConfig doResolve(@NotNull Project project) {
            if (project == null) {
                TargetRunConfigProxy.$$$reportNull$$$0(3);
            }
            if (this.myRunConfigName == null) {
                return null;
            }
            DeployToServerRunConfiguration<?, ?> runConfig = TargetRunConfigProxy.findDockerRunConfig(project, this.myRunConfigName);
            if (runConfig == null) {
                return null;
            }
            return StringUtil.isEmptyOrSpaces((String)this.myServiceName) ? new TargetContainerRunConfig(runConfig) : new TargetComposeRunConfig(runConfig, this.myServiceName);
        }

        @Nullable
        private static DeployToServerRunConfiguration<?, ?> findDockerRunConfig(@NotNull Project project, @NotNull String name) {
            if (project == null) {
                TargetRunConfigProxy.$$$reportNull$$$0(4);
            }
            if (name == null) {
                TargetRunConfigProxy.$$$reportNull$$$0(5);
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            return Optional.ofNullable(runManager.findConfigurationByTypeAndName((ConfigurationType)DockerCloudType.getRunConfigurationType(), name)).map(RunnerAndConfigurationSettings::getConfiguration).map(o -> (DeployToServerRunConfiguration)ObjectUtils.tryCast((Object)o, DeployToServerRunConfiguration.class)).orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/debug/DockerBeforeRunTask$TargetRunConfigProxy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolve";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveToState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doResolve";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findDockerRunConfig";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class TargetRunConfig {
        private final DeployToServerRunConfiguration<?, ?> myRunConfig;

        TargetRunConfig(@NotNull DeployToServerRunConfiguration<?, ?> runConfig) {
            if (runConfig == null) {
                TargetRunConfig.$$$reportNull$$$0(0);
            }
            this.myRunConfig = runConfig;
        }

        @NotNull
        public DeployToServerRunConfiguration<?, ?> getDockerRunConfig() {
            DeployToServerRunConfiguration<?, ?> deployToServerRunConfiguration = this.myRunConfig;
            if (deployToServerRunConfiguration == null) {
                TargetRunConfig.$$$reportNull$$$0(1);
            }
            return deployToServerRunConfiguration;
        }

        public void saveToState(@NotNull State state) {
            if (state == null) {
                TargetRunConfig.$$$reportNull$$$0(2);
            }
            state.setDockerRunConfigName(this.myRunConfig.getName());
        }

        @NotNull
        public abstract DockerBeforeRunTaskLauncherBase createLauncher(@NotNull ExecutionEnvironment var1, @NotNull DockerBeforeRunTask var2);

        @Nullable
        public abstract String getBaseCommand();

        @Nullable
        public String getAutoAdjustedCommand(@NotNull RemoteServerRequestAdapterFactory adapterFactory, @NotNull RemoteServerRequest request) {
            String baseCommand;
            if (adapterFactory == null) {
                TargetRunConfig.$$$reportNull$$$0(3);
            }
            if (request == null) {
                TargetRunConfig.$$$reportNull$$$0(4);
            }
            if ((baseCommand = this.getBaseCommand()) == null) {
                return null;
            }
            RemoteServerRequestAdapterFactory.CommandLineAdjuster commandAdjuster = Optional.ofNullable(adapterFactory.recognizeCommandLine(baseCommand)).filter(adjuster -> adjuster.understandsRequest(request)).filter(adjuster -> adjuster.canAdjust(baseCommand)).orElse(RemoteServerRequestAdapterFactory.CommandLineAdjuster.NULL);
            return commandAdjuster.adjust(baseCommand, request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/debug/DockerBeforeRunTask$TargetRunConfig";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "adapterFactory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/debug/DockerBeforeRunTask$TargetRunConfig";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDockerRunConfig";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "saveToState";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getAutoAdjustedCommand";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Tag(value="port")
    public static class PortMappingState {
        private String myId;
        private int myRemotePort = -1;

        @Attribute(value="id")
        public String getId() {
            return this.myId;
        }

        public void setId(String id) {
            this.myId = id;
        }

        @Attribute(value="remote")
        public int getRemotePort() {
            return this.myRemotePort;
        }

        public void setRemotePort(int remotePort) {
            this.myRemotePort = remotePort;
        }
    }

    public static class State {
        private String myDockerRunConfigName;
        private String myCustomCommand;
        private String myComposeServiceName;
        private boolean myWaitForHealthCheck;
        private List<PortMappingState> myPortMappings = new ArrayList<PortMappingState>();

        @Attribute(value="run-config")
        public void setDockerRunConfigName(String name) {
            this.myDockerRunConfigName = name;
        }

        @Attribute(value="command")
        public void setCustomCommand(String customCommand) {
            this.myCustomCommand = customCommand;
        }

        public String getCustomCommand() {
            return this.myCustomCommand;
        }

        @Attribute(value="compose-service")
        public void setComposeServiceName(String composeServiceName) {
            this.myComposeServiceName = composeServiceName;
        }

        public String getComposeServiceName() {
            return this.myComposeServiceName;
        }

        @Attribute(value="healthcheck")
        public void setWaitForHealthCheck(boolean waitForHealthCheck) {
            this.myWaitForHealthCheck = waitForHealthCheck;
        }

        public boolean isWaitForHealthCheck() {
            return this.myWaitForHealthCheck;
        }

        public String getDockerRunConfigName() {
            return this.myDockerRunConfigName;
        }

        @XCollection
        public List<PortMappingState> getPortMappings() {
            return this.myPortMappings;
        }

        public void setPortMappings(List<PortMappingState> portMappings) {
            this.myPortMappings = portMappings;
        }
    }
}

