/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

public class ShortArrayAssert
extends ArrayAssert<ShortArrayAssert, short[]> {
    protected ShortArrayAssert(short ... actual) {
        super(ShortArrayAssert.class, actual);
    }

    @Nonnull
    public ShortArrayAssert contains(short ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public ShortArrayAssert containsOnly(short ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public ShortArrayAssert excludes(short ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    @Nonnull
    public ShortArrayAssert isEqualTo(@Nullable short[] expected) {
        if (Arrays.equals((short[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    @Nonnull
    public ShortArrayAssert isNotEqualTo(@Nullable short[] array) {
        if (!Arrays.equals((short[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

