/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target.configuration;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.target.DockerEnvironmentFactory;
import com.intellij.docker.remote.run.target.configuration.DockerTargetConfigurable;
import com.intellij.docker.remote.run.target.configuration.DockerTargetEnvironmentConfiguration;
import com.intellij.docker.remote.run.target.configuration.wizard.ConfigureLanguageStep;
import com.intellij.docker.remote.run.target.configuration.wizard.DockerTargetBuildImageStep;
import com.intellij.docker.remote.run.target.configuration.wizard.DockerTargetMainStep;
import com.intellij.docker.remote.run.target.configuration.wizard.DockerTargetPullImageStep;
import com.intellij.docker.remote.run.target.configuration.wizard.DockerTargetStepBase;
import com.intellij.docker.remote.run.target.configuration.wizard.DockerTargetWizardModel;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentFactory;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.openapi.project.Project;
import icons.DockerIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J.\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001aH\u0016J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001aH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/docker/remote/run/target/configuration/DockerTargetType;", "Lcom/intellij/execution/target/TargetEnvironmentType;", "Lcom/intellij/docker/remote/run/target/configuration/DockerTargetEnvironmentConfiguration;", "()V", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "createConfigurable", "Lcom/intellij/docker/remote/run/target/configuration/DockerTargetConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "config", "createDefaultConfig", "createEnvironmentFactory", "Lcom/intellij/execution/target/TargetEnvironmentFactory;", "createSerializer", "createStepsForNewWizard", "", "Lcom/intellij/ide/wizard/AbstractWizardStepEx;", "configToConfigure", "runtimeType", "Lcom/intellij/execution/target/LanguageRuntimeType;", "providesNewWizard", "", "Companion", "intellij.clouds.docker.remoteRun"})
public final class DockerTargetType
extends TargetEnvironmentType<DockerTargetEnvironmentConfiguration> {
    @NotNull
    private final String displayName = "Docker";
    @NotNull
    private final Icon icon;
    @NotNull
    private static final String TYPE_ID = "docker";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public DockerTargetEnvironmentConfiguration createDefaultConfig() {
        return new DockerTargetEnvironmentConfiguration();
    }

    @NotNull
    public DockerTargetEnvironmentConfiguration createSerializer(@NotNull DockerTargetEnvironmentConfiguration config) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)config), (String)"config");
        return config;
    }

    @NotNull
    public DockerTargetConfigurable createConfigurable(@NotNull Project project, @NotNull DockerTargetEnvironmentConfiguration config) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)config), (String)"config");
        return new DockerTargetConfigurable(project, config);
    }

    public boolean providesNewWizard(@NotNull Project project, @Nullable LanguageRuntimeType<?> runtimeType) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return true;
    }

    @Nullable
    public List<AbstractWizardStepEx> createStepsForNewWizard(@NotNull Project project, @NotNull DockerTargetEnvironmentConfiguration configToConfigure, @Nullable LanguageRuntimeType<?> runtimeType) {
        ConfigureLanguageStep configureLanguageStep;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)configToConfigure), (String)"configToConfigure");
        DockerTargetWizardModel model = new DockerTargetWizardModel(project, configToConfigure, runtimeType);
        DockerTargetStepBase[] dockerTargetStepBaseArray = new DockerTargetStepBase[4];
        dockerTargetStepBaseArray[0] = new DockerTargetMainStep(model);
        dockerTargetStepBaseArray[1] = new DockerTargetBuildImageStep(model);
        dockerTargetStepBaseArray[2] = new DockerTargetPullImageStep(model);
        DockerTargetStepBase[] dockerTargetStepBaseArray2 = dockerTargetStepBaseArray;
        DockerTargetStepBase[] dockerTargetStepBaseArray3 = dockerTargetStepBaseArray;
        int n = 3;
        LanguageRuntimeType<?> languageRuntimeType = runtimeType;
        if (languageRuntimeType != null) {
            LanguageRuntimeType<?> languageRuntimeType2 = languageRuntimeType;
            int n2 = n;
            DockerTargetStepBase[] dockerTargetStepBaseArray4 = dockerTargetStepBaseArray2;
            DockerTargetStepBase[] dockerTargetStepBaseArray5 = dockerTargetStepBaseArray3;
            boolean bl = false;
            boolean bl2 = false;
            LanguageRuntimeType<?> it = languageRuntimeType2;
            boolean bl3 = false;
            ConfigureLanguageStep configureLanguageStep2 = new ConfigureLanguageStep(model);
            dockerTargetStepBaseArray3 = dockerTargetStepBaseArray5;
            dockerTargetStepBaseArray2 = dockerTargetStepBaseArray4;
            n = n2;
            configureLanguageStep = configureLanguageStep2;
        } else {
            configureLanguageStep = null;
        }
        dockerTargetStepBaseArray2[n] = configureLanguageStep;
        return CollectionsKt.listOfNotNull((Object[])dockerTargetStepBaseArray3);
    }

    @NotNull
    public TargetEnvironmentFactory createEnvironmentFactory(@NotNull Project project, @NotNull DockerTargetEnvironmentConfiguration config) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)config), (String)"config");
        DockerCloudConfiguration dockerCloudConfiguration = config.getDockerServer();
        if (dockerCloudConfiguration != null && (dockerCloudConfiguration = (DockerCloudConfiguration)dockerCloudConfiguration.getConfiguration()) != null) {
            DockerCloudConfiguration dockerCloudConfiguration2 = dockerCloudConfiguration;
            boolean bl = false;
            boolean bl2 = false;
            DockerCloudConfiguration it = dockerCloudConfiguration2;
            boolean bl3 = false;
            RemoteDockerRuntime dockerRuntime2 = RemoteDockerRuntime.create((DockerCloudConfiguration)it, (Project)project);
            String imageTag = config.getValues().getImageTag();
            DockerAgentApplication dockerAgentApplication = dockerRuntime2.findImageByName(imageTag);
            if (dockerAgentApplication == null) {
                throw (Throwable)new ExecutionException("Can't find image: " + imageTag);
            }
            DockerAgentApplication agentApp = dockerAgentApplication;
            RemoteDockerApplicationRuntime imageRuntime = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime2, (DockerAgentApplication)agentApp);
            return new DockerEnvironmentFactory(dockerRuntime2, imageRuntime, config);
        }
        throw (Throwable)new ExecutionException("Can't find docker server " + config.getValues().getDockerServerName());
    }

    public DockerTargetType() {
        super(TYPE_ID);
        Icon icon = DockerIcons.Docker;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"DockerIcons.Docker");
        this.icon = icon;
    }

    static {
        TYPE_ID = TYPE_ID;
    }

    @NotNull
    public static final String getTYPE_ID() {
        Companion companion = Companion;
        return TYPE_ID;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/remote/run/target/configuration/DockerTargetType$Companion;", "", "()V", "TYPE_ID", "", "TYPE_ID$annotations", "getTYPE_ID", "()Ljava/lang/String;", "intellij.clouds.docker.remoteRun"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void TYPE_ID$annotations() {
        }

        @NotNull
        public final String getTYPE_ID() {
            return TYPE_ID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

