/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.confusing.CalculationResult;
import com.sixrr.inspectjs.control.JSSimplifyIfStatementFix;
import com.sixrr.inspectjs.utils.BoolUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessBooleanExpressionJSInspection
extends JSInspection {
    private static final Set<IElementType> booleanTokens = ContainerUtil.immutableSet((Object[])new IElementType[]{JSTokenTypes.ANDAND, JSTokenTypes.AND, JSTokenTypes.OROR, JSTokenTypes.OR, JSTokenTypes.XOR});
    private static final Set<IElementType> equalsOperators = ContainerUtil.immutableSet((Object[])new IElementType[]{JSTokenTypes.EQEQ, JSTokenTypes.EQEQEQ});
    private static final Set<IElementType> nonEqualsOperators = ContainerUtil.immutableSet((Object[])new IElementType[]{JSTokenTypes.NE, JSTokenTypes.NEQEQ});

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("pointless.boolean.expression.display.name", new Object[0]);
        if (string == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(3);
        }
        PointlessBooleanExpressionVisitor pointlessBooleanExpressionVisitor = new PointlessBooleanExpressionVisitor(holder);
        if (pointlessBooleanExpressionVisitor == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(4);
        }
        return pointlessBooleanExpressionVisitor;
    }

    @NotNull
    private static CalculationResult checkPrefixExpression(@NotNull JSPrefixExpression expression, boolean conditionContext) {
        IElementType sign;
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(5);
        }
        if ((sign = expression.getOperationSign()) == null || !JSTokenTypes.EXCL.equals(sign)) {
            CalculationResult.SimpleResult simpleResult = new CalculationResult.SimpleResult((JSExpression)expression);
            if (simpleResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(6);
            }
            return simpleResult;
        }
        JSExpression innerExpression = expression.getExpression();
        if (innerExpression != null) {
            CalculationResult calculationResult = PointlessBooleanExpressionJSInspection.notExpressionIsPointless(innerExpression, conditionContext, (JSExpression)expression);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(7);
            }
            return calculationResult;
        }
        CalculationResult.SimpleResult simpleResult = new CalculationResult.SimpleResult((JSExpression)expression);
        if (simpleResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(8);
        }
        return simpleResult;
    }

    @NotNull
    private static CalculationResult notExpressionIsPointless(@NotNull JSExpression arg, boolean conditionContext, JSExpression expression) {
        JSExpression innerExpr;
        JSPrefixExpression prefixExpression;
        CalculationResult result2;
        if (arg == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(9);
        }
        if (CalculationResult.isTrueResult(result2 = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(arg, conditionContext))) {
            CalculationResult.ConstantResult constantResult = new CalculationResult.ConstantResult(expression, CalculationResult.ConstantType.FALSE);
            if (constantResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(10);
            }
            return constantResult;
        }
        if (CalculationResult.isFalseResult(result2)) {
            CalculationResult.ConstantResult constantResult = new CalculationResult.ConstantResult(expression, CalculationResult.ConstantType.TRUE);
            if (constantResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(11);
            }
            return constantResult;
        }
        if (result2.isSimplified()) {
            CalculationResult.NotResult notResult = new CalculationResult.NotResult(arg, conditionContext, expression);
            if (notResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(12);
            }
            return notResult;
        }
        if (arg instanceof JSPrefixExpression && (prefixExpression = (JSPrefixExpression)arg).getOperationSign() == JSTokenTypes.EXCL && (innerExpr = prefixExpression.getExpression()) != null && BoolUtils.isBoolean(innerExpr, false)) {
            CalculationResult calculationResult = new CalculationResult.SimpleResult(innerExpr, true).withExpression(expression);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(13);
            }
            return calculationResult;
        }
        CalculationResult.SimpleResult simpleResult = new CalculationResult.SimpleResult(expression);
        if (simpleResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(14);
        }
        return simpleResult;
    }

    private static boolean equalityExpressionCanBeSimplified(@NotNull JSExpression rhs, @NotNull JSExpression lhs, @NotNull CalculationResult lhsResult, @NotNull CalculationResult rhsResult) {
        if (rhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(15);
        }
        if (lhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(16);
        }
        if (lhsResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(17);
        }
        if (rhsResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(18);
        }
        if (DialectDetector.isTypeScript((PsiElement)rhs) && TypeScriptConfigUtil.strictNullChecks((PsiElement)rhs)) {
            return BoolUtils.isBoolean(lhs, false) && BoolUtils.isBoolean(rhs, false);
        }
        if (PointlessBooleanExpressionJSInspection.trueFalseResult(lhsResult) && PointlessBooleanExpressionJSInspection.trueFalseResult(rhsResult)) {
            return true;
        }
        return BoolUtils.isBoolean(lhs, false) || BoolUtils.isBoolean(rhs, false);
    }

    @NotNull
    private static CalculationResult calculateNullOrUndefinedGuard(@NotNull IElementType sign, @NotNull JSExpression left, @NotNull JSExpression right, @NotNull JSExpression initialExpression) {
        if (sign == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(19);
        }
        if (left == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(20);
        }
        if (right == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(21);
        }
        if (initialExpression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(22);
        }
        if (!JSTypeGuardChecker.isNarrowableReference(left)) {
            CalculationResult.SimpleResult simpleResult = new CalculationResult.SimpleResult(left);
            if (simpleResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(23);
            }
            return simpleResult;
        }
        boolean isEqualCheckToNullOrUndefined = equalsOperators.contains(sign);
        boolean isDoubleEq = sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NE;
        Set<JSDecoratedType.TypeDecoration> decoratorsToCheck = JSTypeGuardChecker.getDecoratorsForNullOrUndefinedExpression(isDoubleEq, right, false);
        if (decoratorsToCheck.isEmpty() || !(left instanceof JSReferenceExpression)) {
            CalculationResult.SimpleResult simpleResult = new CalculationResult.SimpleResult(left);
            if (simpleResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(24);
            }
            return simpleResult;
        }
        Set<JSDecoratedType.TypeDecoration> decorators = JSTypeGuardChecker.getDecoratorsForExpression((JSReferenceExpression)left);
        if (!decorators.containsAll(decoratorsToCheck)) {
            CalculationResult.SimpleResult simpleResult = new CalculationResult.SimpleResult(left);
            if (simpleResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(25);
            }
            return simpleResult;
        }
        CalculationResult.ConstantResult constantResult = isEqualCheckToNullOrUndefined ? new CalculationResult.ConstantResult(initialExpression, CalculationResult.ConstantType.FALSE) : new CalculationResult.ConstantResult(initialExpression, CalculationResult.ConstantType.TRUE);
        if (constantResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(26);
        }
        return constantResult;
    }

    @NotNull
    private static CalculationResult checkBinaryExpression(@NotNull JSBinaryExpression expression, boolean conditionContext) {
        CalculationResult result2;
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(27);
        }
        JSExpression rhs = expression.getROperand();
        JSExpression lhs = expression.getLOperand();
        IElementType sign = expression.getOperationSign();
        if (rhs == null || lhs == null || sign == null) {
            CalculationResult.SimpleResult simpleResult = new CalculationResult.SimpleResult((JSExpression)expression);
            if (simpleResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(28);
            }
            return simpleResult;
        }
        if (JSTokenTypes.ANDAND.equals(sign)) {
            CalculationResult calculationResult = PointlessBooleanExpressionJSInspection.checkAndExpression(expression, conditionContext, rhs, lhs, sign);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(29);
            }
            return calculationResult;
        }
        if (JSTokenTypes.OROR.equals(sign)) {
            CalculationResult calculationResult = PointlessBooleanExpressionJSInspection.checkOrExpression(expression, conditionContext, lhs, rhs, sign);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(30);
            }
            return calculationResult;
        }
        if (JSTokenTypes.EQUALITY_OPERATIONS.contains(sign)) {
            CalculationResult result3 = PointlessBooleanExpressionJSInspection.checkEqualityExpression(expression, conditionContext, rhs, lhs, sign);
            if (result3 != null) {
                CalculationResult calculationResult = result3;
                if (calculationResult == null) {
                    PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(31);
                }
                return calculationResult;
            }
        } else if (JSTokenTypes.XOR.equals(sign) && conditionContext && !ControlFlowUtils.isUndefinedOrNull(lhs) && !ControlFlowUtils.isUndefinedOrNull(rhs) && (result2 = PointlessBooleanExpressionJSInspection.checkXorExpression(expression, rhs, lhs, sign)) != null) {
            CalculationResult calculationResult = result2;
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(32);
            }
            return calculationResult;
        }
        CalculationResult.SimpleResult simpleResult = new CalculationResult.SimpleResult((JSExpression)expression);
        if (simpleResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(33);
        }
        return simpleResult;
    }

    @Nullable
    private static CalculationResult checkXorExpression(@NotNull JSBinaryExpression expression, @NotNull JSExpression rhs, @NotNull JSExpression lhs, @NotNull IElementType sign) {
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(34);
        }
        if (rhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(35);
        }
        if (lhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(36);
        }
        if (sign == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(37);
        }
        CalculationResult lhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(lhs, true);
        CalculationResult rhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(rhs, true);
        if (lhsResult.isSimplified() || rhsResult.isSimplified()) {
            if (CalculationResult.isFalseResult(lhsResult)) {
                return rhsResult.asSimplified().withExpression((JSExpression)expression);
            }
            if (CalculationResult.isFalseResult(rhsResult)) {
                return lhsResult.asSimplified().withExpression((JSExpression)expression);
            }
            if (CalculationResult.isTrueResult(rhsResult)) {
                if (CalculationResult.isTrueResult(lhsResult)) {
                    return new CalculationResult.ConstantResult((JSExpression)expression, CalculationResult.ConstantType.FALSE);
                }
                return new CalculationResult.NotResult(lhs, true, (JSExpression)expression);
            }
            if (CalculationResult.isTrueResult(lhsResult)) {
                return new CalculationResult.NotResult(rhs, true, (JSExpression)expression);
            }
            return new CalculationResult.ComplexResult(lhsResult.withExpression((JSExpression)expression), rhsResult.withExpression((JSExpression)expression), (JSExpression)expression, sign);
        }
        return null;
    }

    @Nullable
    private static CalculationResult checkEqualityExpression(@NotNull JSBinaryExpression expression, boolean conditionContext, @NotNull JSExpression rhs, @NotNull JSExpression lhs, @NotNull IElementType sign) {
        CalculationResult result2;
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(38);
        }
        if (rhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(39);
        }
        if (lhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(40);
        }
        if (sign == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(41);
        }
        JSExpression left = JSTypeGuardUtil.getReferenceCandidate(lhs);
        JSExpression right = JSTypeGuardUtil.getReferenceCandidate(rhs);
        if (left != null && right != null && (JSTypeGuardChecker.isUndefinedOrNullExpression(left) ? (result2 = PointlessBooleanExpressionJSInspection.calculateNullOrUndefinedGuard(sign, rhs, left, (JSExpression)expression)) instanceof CalculationResult.ConstantResult : JSTypeGuardChecker.isUndefinedOrNullExpression(right) && (result2 = PointlessBooleanExpressionJSInspection.calculateNullOrUndefinedGuard(sign, left, right, (JSExpression)expression)) instanceof CalculationResult.ConstantResult)) {
            return result2.withExpression((JSExpression)expression);
        }
        CalculationResult lhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(lhs, conditionContext);
        CalculationResult rhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(rhs, conditionContext);
        if (lhsResult instanceof CalculationResult.ConstantResult && rhsResult instanceof CalculationResult.ConstantResult) {
            if (equalsOperators.contains(sign)) {
                return ((CalculationResult.ConstantResult)lhsResult).equalsResult((CalculationResult.ConstantResult)rhsResult, (JSExpression)expression, sign);
            }
            if (nonEqualsOperators.contains(sign)) {
                return ((CalculationResult.ConstantResult)lhsResult).notEqualsResult((CalculationResult.ConstantResult)rhsResult, (JSExpression)expression, sign);
            }
        }
        if (PointlessBooleanExpressionJSInspection.equalityExpressionCanBeSimplified(lhs, rhs, lhsResult, rhsResult)) {
            if (equalsOperators.contains(sign)) {
                if (CalculationResult.isTrueResult(lhsResult)) {
                    return rhsResult.asSimplified().withExpression((JSExpression)expression);
                }
                if (CalculationResult.isFalseResult(lhsResult)) {
                    return new CalculationResult.NotResult(rhs, conditionContext, (JSExpression)expression);
                }
                if (CalculationResult.isTrueResult(rhsResult)) {
                    return lhsResult.asSimplified().withExpression((JSExpression)expression);
                }
                if (CalculationResult.isFalseResult(rhsResult)) {
                    return new CalculationResult.NotResult(lhs, conditionContext, (JSExpression)expression);
                }
            }
            if (nonEqualsOperators.contains(sign)) {
                if (CalculationResult.isTrueResult(lhsResult)) {
                    return new CalculationResult.NotResult(rhs, conditionContext, (JSExpression)expression);
                }
                if (CalculationResult.isFalseResult(lhsResult)) {
                    return rhsResult.asSimplified().withExpression((JSExpression)expression);
                }
                if (CalculationResult.isTrueResult(rhsResult)) {
                    return new CalculationResult.NotResult(lhs, conditionContext, (JSExpression)expression);
                }
                if (CalculationResult.isFalseResult(rhsResult)) {
                    return lhsResult.asSimplified().withExpression((JSExpression)expression);
                }
            }
        }
        if (lhsResult.isSimplified() && ControlFlowUtils.isNotConstantExpression(lhs) || rhsResult.isSimplified() && ControlFlowUtils.isNotConstantExpression(rhs)) {
            return new CalculationResult.ComplexResult(lhsResult, rhsResult, (JSExpression)expression, sign);
        }
        return null;
    }

    private static boolean trueFalseResult(@NotNull CalculationResult result2) {
        if (result2 == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(42);
        }
        return result2 instanceof CalculationResult.ConstantResult;
    }

    @NotNull
    private static CalculationResult checkAndExpression(@NotNull JSBinaryExpression expression, boolean conditionContext, @NotNull JSExpression rhs, @NotNull JSExpression lhs, @NotNull IElementType sign) {
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(43);
        }
        if (rhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(44);
        }
        if (lhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(45);
        }
        if (sign == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(46);
        }
        CalculationResult lhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(lhs, conditionContext);
        CalculationResult rhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(rhs, conditionContext);
        if (CalculationResult.isFalseNullUndefinedResult(lhsResult)) {
            CalculationResult calculationResult = CalculationResult.createConstantResult(lhsResult, (JSExpression)expression);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(47);
            }
            return calculationResult;
        }
        if (CalculationResult.isTrueResult(lhsResult)) {
            CalculationResult calculationResult = rhsResult.asSimplified().withExpression((JSExpression)expression);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(48);
            }
            return calculationResult;
        }
        if (conditionContext && CalculationResult.isTrueResult(rhsResult)) {
            CalculationResult calculationResult = lhsResult.asSimplified().withExpression((JSExpression)expression);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(49);
            }
            return calculationResult;
        }
        CalculationResult calculationResult = PointlessBooleanExpressionJSInspection.getAndOrResult(expression, rhs, sign, lhsResult, rhsResult);
        if (calculationResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(50);
        }
        return calculationResult;
    }

    @NotNull
    private static CalculationResult getAndOrResult(@NotNull JSBinaryExpression expression, @NotNull JSExpression rhs, @NotNull IElementType sign, @NotNull CalculationResult lhsResult, @NotNull CalculationResult rhsResult) {
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(51);
        }
        if (rhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(52);
        }
        if (sign == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(53);
        }
        if (lhsResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(54);
        }
        if (rhsResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(55);
        }
        if (rhsResult.isSimplified() && ControlFlowUtils.isNotConstantExpression(rhs)) {
            CalculationResult.ComplexResult complexResult = new CalculationResult.ComplexResult(lhsResult, rhsResult, (JSExpression)expression, sign);
            if (complexResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(56);
            }
            return complexResult;
        }
        if (lhsResult.isSimplified()) {
            CalculationResult.ComplexResult complexResult = new CalculationResult.ComplexResult(lhsResult, rhsResult, (JSExpression)expression, sign);
            if (complexResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(57);
            }
            return complexResult;
        }
        CalculationResult.SimpleResult simpleResult = new CalculationResult.SimpleResult((JSExpression)expression);
        if (simpleResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(58);
        }
        return simpleResult;
    }

    @NotNull
    private static CalculationResult checkOrExpression(@NotNull JSBinaryExpression expression, boolean conditionContext, @NotNull JSExpression lhs, @NotNull JSExpression rhs, @NotNull IElementType sign) {
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(59);
        }
        if (lhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(60);
        }
        if (rhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(61);
        }
        if (sign == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(62);
        }
        CalculationResult lhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(lhs, conditionContext);
        CalculationResult rhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(rhs, conditionContext);
        if (CalculationResult.isTrueResult(lhsResult)) {
            CalculationResult.ConstantResult constantResult = new CalculationResult.ConstantResult((JSExpression)expression, CalculationResult.ConstantType.TRUE);
            if (constantResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(63);
            }
            return constantResult;
        }
        if (CalculationResult.isFalseNullUndefinedResult(lhsResult)) {
            CalculationResult calculationResult = rhsResult.asSimplified().withExpression((JSExpression)expression);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(64);
            }
            return calculationResult;
        }
        if (conditionContext && CalculationResult.isFalseResult(rhsResult)) {
            CalculationResult calculationResult = lhsResult.asSimplified().withExpression((JSExpression)expression);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(65);
            }
            return calculationResult;
        }
        CalculationResult calculationResult = PointlessBooleanExpressionJSInspection.getAndOrResult(expression, rhs, sign, lhsResult, rhsResult);
        if (calculationResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(66);
        }
        return calculationResult;
    }

    @NotNull
    public static CalculationResult calculateSimplifiedExpression(@Nullable JSExpression expression, boolean conditionContext) {
        JSExpression nestedExpression;
        CalculationResult result2;
        if (expression instanceof JSParenthesizedExpression && (result2 = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(nestedExpression = JSUtils.unparenthesize(expression), conditionContext)).isSimplified()) {
            if (result2 instanceof CalculationResult.ConstantResult) {
                CalculationResult calculationResult = result2.withExpression(expression);
                if (calculationResult == null) {
                    PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(67);
                }
                return calculationResult;
            }
            CalculationResult.ParenthesizedResult parenthesizedResult = new CalculationResult.ParenthesizedResult(result2, expression);
            if (parenthesizedResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(68);
            }
            return parenthesizedResult;
        }
        if (ControlFlowUtils.isFalse(expression)) {
            CalculationResult.ConstantResult constantResult = new CalculationResult.ConstantResult(expression, CalculationResult.ConstantType.FALSE);
            if (constantResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(69);
            }
            return constantResult;
        }
        if (ControlFlowUtils.isNull(expression)) {
            CalculationResult.ConstantResult constantResult = new CalculationResult.ConstantResult(expression, CalculationResult.ConstantType.NULL);
            if (constantResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(70);
            }
            return constantResult;
        }
        if (ControlFlowUtils.isUndefined(expression)) {
            CalculationResult.ConstantResult constantResult = new CalculationResult.ConstantResult(expression, CalculationResult.ConstantType.UNDEFINED);
            if (constantResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(71);
            }
            return constantResult;
        }
        if (ControlFlowUtils.isTrue(expression)) {
            CalculationResult.ConstantResult constantResult = new CalculationResult.ConstantResult(expression, CalculationResult.ConstantType.TRUE);
            if (constantResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(72);
            }
            return constantResult;
        }
        if (expression instanceof JSBinaryExpression) {
            CalculationResult calculationResult = PointlessBooleanExpressionJSInspection.checkBinaryExpression((JSBinaryExpression)expression, conditionContext);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(73);
            }
            return calculationResult;
        }
        if (expression instanceof JSPrefixExpression) {
            CalculationResult calculationResult = PointlessBooleanExpressionJSInspection.checkPrefixExpression((JSPrefixExpression)expression, conditionContext);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(74);
            }
            return calculationResult;
        }
        CalculationResult.SimpleResult simpleResult = new CalculationResult.SimpleResult(expression);
        if (simpleResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(75);
        }
        return simpleResult;
    }

    private static boolean conditionContext(@NotNull PsiElement expression) {
        PsiElement parent;
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(76);
        }
        if (!((parent = expression.getParent()) instanceof JSStatement)) {
            return false;
        }
        return !(parent instanceof JSForInStatement) && parent instanceof JSConditionOwner && ((JSConditionOwner)parent).getCondition() == expression;
    }

    private static boolean isAcceptableExpressionParent(@Nullable PsiElement parent) {
        if (!(parent instanceof JSExpression)) {
            return false;
        }
        if (parent instanceof JSPrefixExpression) {
            return ((JSPrefixExpression)parent).getOperationSign() == JSTokenTypes.EXCL;
        }
        if (parent instanceof JSParenthesizedExpression) {
            return true;
        }
        if (parent instanceof JSBinaryExpression) {
            boolean isConditionalContext = PointlessBooleanExpressionJSInspection.conditionContext(parent);
            IElementType sign = ((JSBinaryExpression)parent).getOperationSign();
            if (sign == JSTokenTypes.XOR) {
                return isConditionalContext;
            }
            return booleanTokens.contains(sign) || JSTokenTypes.EQUALITY_OPERATIONS.contains(sign);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 76: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 76: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/confusing/PointlessBooleanExpressionJSInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: 
            case 27: 
            case 34: 
            case 38: 
            case 43: 
            case 51: 
            case 59: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 15: 
            case 35: 
            case 39: 
            case 44: 
            case 52: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rhs";
                break;
            }
            case 16: 
            case 36: 
            case 40: 
            case 45: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhs";
                break;
            }
            case 17: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhsResult";
                break;
            }
            case 18: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rhsResult";
                break;
            }
            case 19: 
            case 37: 
            case 41: 
            case 46: 
            case 53: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialExpression";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/confusing/PointlessBooleanExpressionJSInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPrefixExpression";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "notExpressionIsPointless";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateNullOrUndefinedGuard";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "checkBinaryExpression";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAndExpression";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndOrResult";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "checkOrExpression";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateSimplifiedExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkPrefixExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "notExpressionIsPointless";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "equalityExpressionCanBeSimplified";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "calculateNullOrUndefinedGuard";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkBinaryExpression";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "checkXorExpression";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkEqualityExpression";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "trueFalseResult";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "checkAndExpression";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getAndOrResult";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "checkOrExpression";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "conditionContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 76: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PointlessBooleanExpressionVisitor
    extends JSElementVisitor {
        @NotNull
        private final ProblemsHolder myProblemsHolder;

        private PointlessBooleanExpressionVisitor(@NotNull ProblemsHolder problemsHolder) {
            if (problemsHolder == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(0);
            }
            this.myProblemsHolder = problemsHolder;
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(1);
            }
            super.visitJSBinaryExpression(expression);
            this.checkExpression((JSExpression)expression);
        }

        private void checkExpression(@NotNull JSExpression expression) {
            PsiElement parent;
            if (expression == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(2);
            }
            if (PointlessBooleanExpressionJSInspection.isAcceptableExpressionParent(parent = expression.getParent())) {
                return;
            }
            boolean context = PointlessBooleanExpressionJSInspection.conditionContext((PsiElement)expression);
            CalculationResult result2 = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(expression, context);
            if (!result2.isSimplified()) {
                return;
            }
            Set<CalculationResult> simplifiedResults = result2.getSimplifiedResults();
            for (CalculationResult res : simplifiedResults) {
                String fix = res.getSimplifiedText();
                if (JSInheritedLanguagesHelper.isSimplifyBooleanFixEnabled((PsiElement)expression)) {
                    this.myProblemsHolder.registerProblem((PsiElement)res.getInitialExpression(), InspectionJSBundle.message("pointless.boolean.error.string", fix), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new BooleanLiteralComparisonFix(fix)});
                    return;
                }
                this.myProblemsHolder.registerProblem((PsiElement)res.getInitialExpression(), InspectionJSBundle.message("pointless.boolean.error.string", fix), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }

        public void visitJSParenthesizedExpression(@NotNull JSParenthesizedExpression node) {
            if (node == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(3);
            }
            super.visitJSParenthesizedExpression(node);
            this.checkExpression((JSExpression)node);
        }

        public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
            if (expression == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(4);
            }
            super.visitJSPrefixExpression(expression);
            this.checkExpression((JSExpression)expression);
        }

        public void visitJSIfStatement(@NotNull JSIfStatement node) {
            if (node == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(5);
            }
            super.visitJSIfStatement(node);
            this.checkIfStatement(node);
        }

        public void visitJSWhileStatement(JSWhileStatement node) {
            super.visitJSWhileStatement(node);
            this.checkLoopStatement((JSLoopStatement)node);
        }

        public void visitJSDoWhileStatement(JSDoWhileStatement node) {
            super.visitJSDoWhileStatement(node);
            this.checkLoopStatement((JSLoopStatement)node);
        }

        private void checkLoopStatement(JSLoopStatement statement) {
            JSExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            if (ControlFlowUtils.isFalse(condition) || ControlFlowUtils.isUndefinedOrNull(condition)) {
                this.myProblemsHolder.registerProblem((PsiElement)statement.getCondition(), InspectionJSBundle.message("pointless.statement.error.string", "While"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new JSSimplifyIfStatementFix(true)});
            }
        }

        private void checkIfStatement(@NotNull JSIfStatement node) {
            JSExpression condition;
            if (node == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(6);
            }
            if ((condition = node.getCondition()) == null) {
                return;
            }
            JSStatement thenBranch = node.getThen();
            if (thenBranch == null) {
                return;
            }
            if (ControlFlowUtils.isConstantExpression(condition)) {
                this.myProblemsHolder.registerProblem((PsiElement)node.getCondition(), InspectionJSBundle.message("pointless.statement.error.string", "If"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new JSSimplifyIfStatementFix(PointlessBooleanExpressionVisitor.getReturnValueForIfStatement(node.getCondition()))});
            }
        }

        private static boolean getReturnValueForIfStatement(@NotNull JSExpression condition) {
            if (condition == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(7);
            }
            if (ControlFlowUtils.isTrue(condition)) {
                return false;
            }
            return ControlFlowUtils.isFalse(condition) || ControlFlowUtils.isUndefinedOrNull(condition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemsHolder";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/confusing/PointlessBooleanExpressionJSInspection$PointlessBooleanExpressionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSBinaryExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSParenthesizedExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPrefixExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSIfStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkIfStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getReturnValueForIfStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BooleanLiteralComparisonFix
    extends InspectionJSFix {
        @NotNull
        private final String fix;

        public BooleanLiteralComparisonFix(@NotNull String fix) {
            if (fix == null) {
                BooleanLiteralComparisonFix.$$$reportNull$$$0(0);
            }
            this.fix = fix;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("simplify.fix", new Object[0]);
            if (string == null) {
                BooleanLiteralComparisonFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            if (element instanceof JSExpression) {
                BooleanLiteralComparisonFix.replaceExpression((JSExpression)element, this.fix);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/sixrr/inspectjs/confusing/PointlessBooleanExpressionJSInspection$BooleanLiteralComparisonFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/sixrr/inspectjs/confusing/PointlessBooleanExpressionJSInspection$BooleanLiteralComparisonFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

