/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSKeywordElementType;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.structuralsearch.JSMatchingStrategy;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.WordOptimizer;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;

class JSCompilingVisitor
extends JSRecursiveWalkingElementVisitor {
    private final GlobalCompilingVisitor myCompilingVisitor;
    private PsiElement myTopLevelElement = null;

    JSCompilingVisitor(GlobalCompilingVisitor compilingVisitor) {
        this.myCompilingVisitor = compilingVisitor;
    }

    public void compile(PsiElement[] topLevelElements) {
        JSWordOptimizer optimizer = new JSWordOptimizer();
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchOptions options = this.myCompilingVisitor.getContext().getOptions();
        Language dialect = options.getDialect();
        if (dialect != null) {
            pattern.setStrategy((MatchingStrategy)new JSMatchingStrategy(dialect));
        }
        for (PsiElement element : topLevelElements) {
            if (topLevelElements.length == 1) {
                this.myTopLevelElement = element;
            }
            if (element instanceof PsiWhiteSpace) {
                this.myCompilingVisitor.addLexicalNode(element);
                continue;
            }
            element.accept((PsiElementVisitor)this);
            element.accept((PsiElementVisitor)optimizer);
            pattern.setHandler(element, (MatchingHandler)new TopLevelMatchingHandler(pattern.getHandler(element)));
        }
    }

    public void visitElement(PsiElement element) {
        if (!(element instanceof JSReferenceListMember)) {
            this.myCompilingVisitor.handle(element);
        }
        super.visitElement(element);
    }

    public void visitJSVariable(JSVariable variable) {
        super.visitJSVariable(variable);
        MatchingHandler handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)variable);
        GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof JSVariable || e instanceof JSFunctionExpression);
    }

    public void visitJSFunctionDeclaration(JSFunction function) {
        super.visitJSFunctionDeclaration(function);
        MatchingHandler handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)function);
        GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof JSFunction);
    }

    public void visitJSClass(JSClass aClass) {
        super.visitJSClass(aClass);
        MatchingHandler handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)aClass);
        GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof JSClass);
    }

    public void visitJSReferenceExpression(JSReferenceExpression expression) {
        super.visitJSReferenceExpression(expression);
        PsiElement parent = expression.getParent();
        if (parent instanceof JSClass || parent instanceof JSExpressionStatement && parent != this.myTopLevelElement) {
            return;
        }
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        if (pattern.isRealTypedVar((PsiElement)expression)) {
            GlobalCompilingVisitor.setFilter((MatchingHandler)pattern.getHandler((PsiElement)expression), e -> e instanceof JSExpression || JSCompilingVisitor.isLeafToken(e, JSTokenTypes.IDENTIFIER));
        }
    }

    public void visitJSLiteralExpression(JSLiteralExpression expression) {
        MatchingHandler handler;
        super.visitJSLiteralExpression(expression);
        if ((expression.isQuotedLiteral() || expression.isRegExpLiteral()) && (handler = this.myCompilingVisitor.processPatternStringWithFragments(expression.getText(), GlobalCompilingVisitor.OccurenceKind.LITERAL)) != null) {
            expression.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
        }
    }

    public void visitJSExpressionStatement(JSExpressionStatement statement) {
        super.visitJSExpressionStatement(statement);
        JSExpression expression = statement.getExpression();
        MatchingHandler statementHandler = new MatchingHandler(){

            public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
                return context.getMatcher().match((PsiElement)((JSExpressionStatement)patternNode).getExpression(), matchedNode);
            }
        };
        if (this.myTopLevelElement == statement && expression != null && statement.getFirstChild() == statement.getLastChild()) {
            this.myCompilingVisitor.setHandler((PsiElement)statement, statementHandler);
            GlobalCompilingVisitor.setFilter((MatchingHandler)statementHandler, e -> e instanceof JSExpression || JSCompilingVisitor.isLeafToken(e, JSTokenTypes.IDENTIFIER));
        } else {
            MatchingHandler handler;
            CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
            if (expression instanceof JSReferenceExpression && pattern.isRealTypedVar((PsiElement)statement) && (handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)statement)) instanceof SubstitutionHandler) {
                ((SubstitutionHandler)handler).setMatchHandler(statementHandler);
                handler.setFilter(e -> e instanceof JSStatement && !(e.getParent() instanceof JSFunction) && !(e instanceof JSPackageStatement) || e instanceof PsiComment && e.getParent() instanceof JSBlockStatement);
            }
        }
    }

    public void visitJSAttributeNameValuePair(JSAttributeNameValuePair attributeNameValuePair) {
        super.visitJSAttributeNameValuePair(attributeNameValuePair);
        ASTNode valueNode = attributeNameValuePair.getValueNode();
        if (valueNode == null) {
            return;
        }
        String text = valueNode.getText();
        if (!StringUtil.isQuotedString((String)text)) {
            return;
        }
        MatchingHandler handler = this.myCompilingVisitor.processPatternStringWithFragments(text, GlobalCompilingVisitor.OccurenceKind.LITERAL);
        if (handler != null) {
            valueNode.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
        }
    }

    public void visitJSAttributeList(JSAttributeList list2) {
        super.visitJSAttributeList(list2);
        if (this.myTopLevelElement != list2) {
            return;
        }
        JSAttribute[] attributes = list2.getAttributes();
        if (attributes.length != 1) {
            return;
        }
        JSAttribute attribute = attributes[0];
        if (!attribute.getText().equals(list2.getText())) {
            return;
        }
        MatchingHandler handler = new MatchingHandler(){

            public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
                return super.match(patternNode, matchedNode, context) && context.getMatcher().match((PsiElement)((JSAttributeList)patternNode).getAttributes()[0], matchedNode);
            }
        };
        this.myCompilingVisitor.setHandler((PsiElement)list2, handler);
        handler.setFilter(element -> element instanceof JSAttribute);
    }

    private static boolean isLeafToken(PsiElement element, IElementType elementType) {
        return element instanceof LeafElement && ((LeafElement)element).getElementType() == elementType;
    }

    private class JSWordOptimizer
    extends JSRecursiveWalkingElementVisitor
    implements WordOptimizer {
        private JSWordOptimizer() {
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            if (element instanceof LeafPsiElement) {
                IElementType elementType = ((LeafPsiElement)element).getElementType();
                if (elementType instanceof JSKeywordElementType) {
                    JSKeywordElementType keywordElementType = (JSKeywordElementType)elementType;
                    String keyword = keywordElementType.getKeyword();
                    GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)keyword, (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)JSCompilingVisitor.this.myCompilingVisitor.getContext());
                } else if (elementType == JSTokenTypes.IDENTIFIER) {
                    this.handleWord(element.getText(), GlobalCompilingVisitor.OccurenceKind.CODE, JSCompilingVisitor.this.myCompilingVisitor.getContext());
                }
            }
        }
    }
}

