/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.intelliLang.inject;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.injections.JSFormattableInjectionUtil;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.intelliLang.inject.JSInjection;
import com.intellij.plugins.intelliLang.inject.JSLanguageInjectionSupport;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDontFormatInjectionAction
extends JavaScriptIntention {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            JSDontFormatInjectionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.inject.dont.format.intention.text", (Object[])new Object[0]);
        if (string == null) {
            JSDontFormatInjectionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiFile injectedFile;
        PsiLanguageInjectionHost host;
        if (project == null) {
            JSDontFormatInjectionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSDontFormatInjectionAction.$$$reportNull$$$0(3);
        }
        return (host = JSDontFormatInjectionAction.getInjectionHost(injectedFile = element.getContainingFile())) != null && JSFormattableInjectionUtil.isFormattableHost((PsiElement)host) && JSFormattableInjectionUtil.isReformattableInjectedPsi(injectedFile) && JSDontFormatInjectionAction.findJSInjection(injectedFile, host, null, true) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSDontFormatInjectionAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSDontFormatInjectionAction.$$$reportNull$$$0(5);
        }
        Ref commentRef = new Ref();
        PsiFile injectedFile = element.getContainingFile();
        PsiLanguageInjectionHost host = JSDontFormatInjectionAction.getInjectionHost(injectedFile);
        if (host == null) {
            return;
        }
        JSInjection oldInjection = JSDontFormatInjectionAction.findJSInjection(injectedFile, host, (Ref<PsiElement>)commentRef, true);
        if (oldInjection == null) {
            return;
        }
        JSInjection newInjection = oldInjection.copy();
        newInjection.setCanReformat(false);
        PsiElement comment = (PsiElement)commentRef.get();
        String commentText = JSDontFormatInjectionAction.getCommentText(newInjection, (PsiElement)host);
        if (comment != null) {
            comment.replace(JSDontFormatInjectionAction.createCommentFromText((PsiElement)host, commentText));
        } else {
            JSLanguageInjectionSupport.addCommentBeforeHost(host, commentText);
        }
        FileContentUtilCore.reparseFiles(Collections.singletonList(host.getContainingFile().getVirtualFile()));
    }

    @NotNull
    private static String getCommentText(@NotNull JSInjection injection, @NotNull PsiElement context) {
        if (injection == null) {
            JSDontFormatInjectionAction.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JSDontFormatInjectionAction.$$$reportNull$$$0(7);
        }
        String commentPrefix = JSCodeStyleSettings.getLineCommentPrefix(context);
        StringBuilder builder = new StringBuilder("//" + commentPrefix + "language=" + injection.getInjectedLanguageId());
        if (!StringUtil.isEmpty((String)injection.getPrefix())) {
            builder.append(" prefix=").append(StringUtil.replace((String)injection.getPrefix(), (String)" ", (String)""));
        }
        if (!StringUtil.isEmpty((String)injection.getPrefix())) {
            builder.append(" suffix=").append(StringUtil.replace((String)injection.getSuffix(), (String)" ", (String)""));
        }
        builder.append(" format=false");
        String string = builder.toString();
        if (string == null) {
            JSDontFormatInjectionAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    static JSInjection findJSInjection(@NotNull PsiFile injectedFile, @NotNull PsiLanguageInjectionHost host, @Nullable Ref<PsiElement> commentRef, boolean isFormattable) {
        JSLanguageInjectionSupport injectionSupport;
        if (injectedFile == null) {
            JSDontFormatInjectionAction.$$$reportNull$$$0(9);
        }
        if (host == null) {
            JSDontFormatInjectionAction.$$$reportNull$$$0(10);
        }
        if ((injectionSupport = (JSLanguageInjectionSupport)((Object)ObjectUtils.tryCast((Object)injectedFile.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT), JSLanguageInjectionSupport.class))) != null) {
            BaseInjection commentInjection = injectionSupport.findCommentInjection((PsiElement)host, (Ref)commentRef);
            if (commentInjection != null && commentInjection.canReformat() == isFormattable) {
                return commentInjection;
            }
            for (BaseInjection injection : Configuration.getProjectInstance((Project)injectedFile.getProject()).getInjections(injectionSupport.getId())) {
                if (!(injection instanceof JSInjection) || ((JSInjection)injection).canReformat() != isFormattable || !injection.acceptsPsiElement((PsiElement)host)) continue;
                return (JSInjection)injection;
            }
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    static PsiLanguageInjectionHost getInjectionHost(@Nullable PsiFile injectedFile) {
        if (injectedFile == null) {
            return null;
        }
        PsiElement host = injectedFile.getContext();
        return host instanceof PsiLanguageInjectionHost && host instanceof JSExpression ? (PsiLanguageInjectionHost)host : null;
    }

    @NotNull
    private static PsiElement createCommentFromText(@NotNull PsiElement element, String text) {
        if (element == null) {
            JSDontFormatInjectionAction.$$$reportNull$$$0(11);
        }
        PsiComment psiComment = JSPsiElementFactory.createPsiComment(text, element);
        if (psiComment == null) {
            JSDontFormatInjectionAction.$$$reportNull$$$0(12);
        }
        return psiComment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/intelliLang/inject/JSDontFormatInjectionAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/intelliLang/inject/JSDontFormatInjectionAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommentFromText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommentText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findJSInjection";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCommentFromText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

