/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig.checkers;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileInclude;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptConfigIncludeBase
implements TypeScriptFileInclude {
    @Nullable
    protected final Pattern myExcludePattern;
    @NotNull
    protected final VirtualFile myConfigDirectory;
    @NotNull
    protected final Collection<VirtualFile> myTypeRoots;
    @NotNull
    protected final Collection<String> myTypes;
    @NotNull
    protected final Collection<VirtualFile> myRootDirs;
    @NotNull
    private final Collection<String> myExcludePatterns;
    @NotNull
    private final TypeScriptFileImportsResolver myResolver;
    @NotNull
    private final String[] myExtensions;
    @NotNull
    private final NotNullLazyValue<Collection<VirtualFile>> myTypesDirectories;

    public boolean isFromFilesList(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(0);
        }
        return false;
    }

    public TypeScriptConfigIncludeBase(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(1);
        }
        this.myTypesDirectories = new NotNullLazyValue<Collection<VirtualFile>>(){

            @NotNull
            protected Collection<VirtualFile> compute() {
                if (TypeScriptConfigIncludeBase.this.myTypes.isEmpty() || TypeScriptConfigIncludeBase.this.myTypeRoots.isEmpty()) {
                    List list2 = ContainerUtil.emptyList();
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list2;
                }
                ArrayList<VirtualFile> typesDirectories = new ArrayList<VirtualFile>();
                for (VirtualFile virtualFile : TypeScriptConfigIncludeBase.this.myTypeRoots) {
                    for (String type : TypeScriptConfigIncludeBase.this.myTypes) {
                        VirtualFile child = virtualFile.findChild(type);
                        if (child == null || !child.isDirectory()) continue;
                        typesDirectories.add(child);
                    }
                }
                ArrayList<VirtualFile> arrayList = typesDirectories;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(1);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase$1", "compute"));
            }
        };
        this.myConfigDirectory = config2.getConfigDirectory();
        this.myRootDirs = config2.getRootDirsFiles();
        boolean hasTypes = config2.getRawCompilerOption("types") != null;
        this.myTypes = config2.getTypes();
        this.myTypeRoots = hasTypes && this.myTypes.isEmpty() ? Collections.emptyList() : config2.getTypeRoots();
        this.myExcludePatterns = config2.getExcludePatterns();
        this.myExcludePattern = TypeScriptConfigIncludeBase.getExcludePattern(this.myConfigDirectory, this.myExcludePatterns);
        this.myResolver = config2.getImportResolver();
        this.myExtensions = this.myResolver.getExtensionsWithDot();
    }

    @Override
    @NotNull
    public final Set<VirtualFile> getRootFiles(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(2);
        }
        ImmutableSet immutableSet = ImmutableSet.copyOf(this.getOwnRootFiles(project));
        if (immutableSet == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(3);
        }
        return immutableSet;
    }

    @NotNull
    protected final Collection<VirtualFile> getOwnRootFiles(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(4);
        }
        Collection<VirtualFile> collection = this.getFilesForScope(this.getScope(project));
        if (collection == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    private GlobalSearchScope getScope(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(6);
        }
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(GlobalSearchScope.allScope((Project)project)){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                return TypeScriptConfigIncludeBase.this.accept(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase$2", "contains"));
            }
        };
        if (delegatingGlobalSearchScope == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(7);
        }
        return delegatingGlobalSearchScope;
    }

    @Nullable
    private static Pattern getExcludePattern(@NotNull VirtualFile configDir, @Nullable Collection<String> excludePatterns) {
        if (configDir == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(8);
        }
        String wildcard = excludePatterns == null ? null : TypeScriptConfigUtil.getRegularExpressionForGlobPattern(excludePatterns, configDir, TypeScriptConfigUtil.WildCardType.EXCLUDE);
        return wildcard == null ? null : JSPathMappingsUtil.createMappingPattern(wildcard, configDir);
    }

    public final boolean isIncludeTypesFile(@NotNull VirtualFile file2) {
        boolean isEmptyTypes;
        if (file2 == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(9);
        }
        if (isEmptyTypes = this.myTypes.isEmpty()) {
            for (VirtualFile virtualFile : this.myTypeRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file2, (boolean)true)) continue;
                return true;
            }
        } else {
            for (VirtualFile typeDir : (Collection)this.myTypesDirectories.getValue()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)typeDir, (VirtualFile)file2, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    final boolean isExcludedFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(10);
        }
        if (this.myExcludePattern == null) {
            return false;
        }
        String path = file2.getPath();
        return JSPathMappingsUtil.checkMappingPattern(path, this.myExcludePattern);
    }

    @Override
    public abstract boolean accept(@NotNull VirtualFile var1);

    @NotNull
    protected Collection<VirtualFile> getFilesForScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(11);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.myResolver.processAllFilesInScope(scope, (Processor<VirtualFile>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(12);
        }
        return collection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeScriptConfigIncludeBase base = (TypeScriptConfigIncludeBase)o;
        if (!this.myConfigDirectory.equals(base.myConfigDirectory)) {
            return false;
        }
        if (!this.myTypeRoots.equals(base.myTypeRoots)) {
            return false;
        }
        if (!this.myTypes.equals(base.myTypes)) {
            return false;
        }
        if (!this.myRootDirs.equals(base.myRootDirs)) {
            return false;
        }
        if (!this.myExcludePatterns.equals(base.myExcludePatterns)) {
            return false;
        }
        return Arrays.equals(this.myExtensions, base.myExtensions);
    }

    public int hashCode() {
        int result2 = this.myConfigDirectory.hashCode();
        result2 = 31 * result2 + this.myTypeRoots.hashCode();
        result2 = 31 * result2 + this.myTypes.hashCode();
        result2 = 31 * result2 + this.myRootDirs.hashCode();
        result2 = 31 * result2 + this.myExcludePatterns.hashCode();
        result2 = 31 * result2 + this.myExtensions.length;
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnRootFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesForScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFromFilesList";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRootFiles";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOwnRootFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExcludePattern";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isIncludeTypesFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFilesForScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

