/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNewExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluatorBase;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.JavaScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeEvaluationFunction;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeSubstitutorType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptGenericTypesEvaluator
extends JSGenericTypesEvaluatorBase {
    private static final TypeScriptGenericTypesEvaluator INSTANCE = new TypeScriptGenericTypesEvaluator();

    private TypeScriptGenericTypesEvaluator() {
    }

    public static TypeScriptGenericTypesEvaluator getInstance() {
        return INSTANCE;
    }

    @Override
    public final JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context) {
        JSExpression qualifier;
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(0);
        }
        if (methodExpression == null) {
            return type;
        }
        Supplier<JSType> jsQualifierTypeSupplier = null;
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            jsQualifierTypeSupplier = () -> JSResolveUtil.getElementJSType((PsiElement)qualifier);
        }
        JSCallLikeExpression callLikeExpression = TypeScriptSignatureChooser.getCallLikeExpression((PsiElement)methodExpression);
        return this.doEvaluateGenerics(type, methodExpression, (JSCallItem)callLikeExpression, jsQualifierTypeSupplier, resolvedFunction, context);
    }

    @Override
    public JSType evaluateGenerics(@Nullable JSType type, @NotNull JSCallItem callItem, @Nullable PsiElement resolvedFunction, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context) {
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(1);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(2);
        }
        JSExpression methodExpression = callItem instanceof JSCallLikeExpression ? ((JSCallLikeExpression)callItem).getMethodExpression() : null;
        return this.doEvaluateGenerics(type, methodExpression, callItem, () -> ((JSCallItem)callItem).getQualifierType(), resolvedFunction, context);
    }

    private JSType doEvaluateGenerics(@Nullable JSType type, @Nullable JSExpression place, @Nullable JSCallItem callItem, @Nullable Supplier<JSType> jsQualifierTypeSupplier, @Nullable PsiElement resolvedFunction, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context) {
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(3);
        }
        if (!TypeScriptGenericTypesEvaluator.canHaveGenericParameters(type)) {
            return type;
        }
        resolvedFunction = TypeScriptGenericTypesEvaluator.getAssociatedElement(type, resolvedFunction);
        if (jsQualifierTypeSupplier != null) {
            type = TypeScriptGenericTypesEvaluator.evaluateJSGenericsFromQualifier(type, jsQualifierTypeSupplier);
        }
        if (!TypeScriptGenericTypesEvaluator.checkNeedGenericsApplying(type)) {
            return type;
        }
        JSTypeSubstitutor substitutor = this.getAllGenericTypeSubstitutor(place, resolvedFunction, resolvedFunction, callItem, context);
        return JSTypeUtils.applyGenericArguments(type, substitutor, callItem != null, context.reporter);
    }

    private static PsiElement getAssociatedElement(@NotNull JSType type, @Nullable PsiElement resolvedFunction) {
        PsiElement element;
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(4);
        }
        if (resolvedFunction == null && (resolvedFunction = type.getSourceElement()) instanceof JSDocComment && (element = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)resolvedFunction)) != null) {
            return element;
        }
        return resolvedFunction;
    }

    @Override
    @NotNull
    public final JSGenericTypeEvaluationFunction getEvaluationFunction(@NotNull JSCallLikeExpression callLikeExpression, @NotNull PsiElement resolvedFunctionOrField, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context) {
        JSExpression methodExpression;
        if (callLikeExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(5);
        }
        if (resolvedFunctionOrField == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(6);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(7);
        }
        if ((methodExpression = callLikeExpression.getMethodExpression()) == null) {
            JSGenericTypeEvaluationFunction jSGenericTypeEvaluationFunction = JSGenericTypeEvaluationFunction.SELF;
            if (jSGenericTypeEvaluationFunction == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(8);
            }
            return jSGenericTypeEvaluationFunction;
        }
        NotNullLazyValue qualifierGenericTypeEvaluator = NotNullLazyValue.createValue(() -> this.getJSQualifierGenericsRemapper(methodExpression));
        NotNullLazyValue substitutor = NotNullLazyValue.createValue(() -> this.getAllGenericTypeSubstitutor(methodExpression, resolvedFunctionOrField, resolvedFunctionOrField, (JSCallItem)callLikeExpression, context));
        JSGenericTypeEvaluationFunction jSGenericTypeEvaluationFunction = type -> {
            if (!TypeScriptGenericTypesEvaluator.canHaveGenericParameters(type)) {
                return type;
            }
            type = (JSType)((Function.Mono)qualifierGenericTypeEvaluator.getValue()).fun((Object)type);
            if (!TypeScriptGenericTypesEvaluator.checkNeedGenericsApplying(type)) {
                return type;
            }
            return JSTypeUtils.applyGenericArguments(type, (JSTypeSubstitutor)substitutor.getValue(), true, context.reporter);
        };
        if (jSGenericTypeEvaluationFunction == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(9);
        }
        return jSGenericTypeEvaluationFunction;
    }

    @NotNull
    private JSTypeSubstitutor getAllGenericTypeSubstitutor(@Nullable JSExpression place, @Nullable PsiElement resolvedFunctionOrField, @Nullable PsiElement resolvedContext, @Nullable JSCallItem callItem, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context) {
        JSTypeSubstitutor callSubstitutor;
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(10);
        }
        JSTypeSubstitutor explicit = JSTypeSubstitutor.EMPTY;
        resolvedFunctionOrField = TypeScriptGenericTypesEvaluator.getResolvedFunction(place, resolvedFunctionOrField);
        if (place instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)place).getQualifier();
            if (qualifier != null) {
                explicit = this.getQualifierTypeSubstitutor(qualifier, place, resolvedContext, resolvedFunctionOrField);
            }
        } else if (place == null && callItem != null) {
            explicit = this.getQualifierTypeSubstitutor(callItem.getQualifierType(), null, resolvedFunctionOrField, resolvedContext);
        }
        explicit = explicit.combine(TypeScriptGenericTypesEvaluator.getCallExplicitTypeSubstitutor(resolvedFunctionOrField, callItem, JSTypeSubstitutor.EMPTY));
        if (place != null) {
            explicit = explicit.combine(TypeScriptGenericTypesEvaluator.getSuperExpressionTypeSubstitutor(resolvedFunctionOrField, place));
        }
        if (resolvedFunctionOrField != null && callItem != null && !(callSubstitutor = this.getInferredCallLikeTypeSubstitutor(resolvedFunctionOrField, callItem, context, explicit)).isEmpty()) {
            JSTypeSubstitutor callWithApplied = JSTypeSubstitutor.combineWithApplying((JSTypeSubstitutor)explicit, (JSTypeSubstitutor)callSubstitutor, JSTypeUtils::applyGenericArguments);
            JSTypeSubstitutor jSTypeSubstitutor = callWithApplied.combine(explicit);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(11);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = explicit;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(12);
        }
        return jSTypeSubstitutor;
    }

    @Override
    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, @NotNull JSExpression methodExpression) {
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(13);
        }
        if (qualifier == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(14);
        }
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(15);
        }
        Function.Mono<JSType> mapper = this.getJSQualifierGenericsRemapper(methodExpression);
        JSTypeSubstitutor substitutor = this.getQualifierTypeSubstitutor(qualifier, methodExpression, type.getSourceElement(), null);
        JSType jSType = JSTypeUtils.applyGenericArguments((JSType)mapper.fun((Object)type), substitutor);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(16);
        }
        return jSType;
    }

    private static boolean checkNeedGenericsApplying(@Nullable JSType startType) {
        if (!TypeScriptGenericTypesEvaluator.canHaveGenericParameters(startType)) {
            return false;
        }
        boolean hasThisOrGenericType = JSTypeUtils.hasTypes(startType, JSGenericParameterImpl.class, TypeScriptGenericThisTypeImpl.class);
        if (!hasThisOrGenericType) {
            if (!(startType instanceof JSResolvableType)) {
                return true;
            }
            JSResolvableType jsType = (JSResolvableType)startType;
            JSResolvedTypeInfo resolvedType = jsType.resolveType();
            if (!resolvedType.isLocal()) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    private JSTypeSubstitutor getQualifierTypeSubstitutor(@NotNull JSExpression qualifier, @NotNull JSExpression methodExpression, @Nullable PsiElement sourceElement, @Nullable PsiElement resolvedFunction) {
        JSType qualifierType;
        if (qualifier == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(17);
        }
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(18);
        }
        if ((qualifierType = JSResolveUtil.getElementJSType((PsiElement)qualifier)) == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(19);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.getQualifierTypeSubstitutor(qualifierType, (PsiElement)methodExpression, resolvedFunction, sourceElement);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(20);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public JSTypeSubstitutor getQualifierTypeSubstitutor(@Nullable JSType qualifierType, @Nullable PsiElement methodExpression, @Nullable PsiElement resolvedFunction, @Nullable PsiElement sourceElement) {
        if (qualifierType == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(21);
            }
            return jSTypeSubstitutor;
        }
        sourceElement = sourceElement != null && sourceElement.isValid() ? sourceElement : (PsiElement)ObjectUtils.coalesce((Object)resolvedFunction, (Object)methodExpression);
        JSType expanded = qualifierType.substitute();
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        result2.putAll(TypeScriptGenericTypesEvaluator.getTypeSubstitutorForQualifierType(expanded, sourceElement, methodExpression));
        result2.putAll(TypeScriptGenericTypesEvaluator.getTypeSubstitutorForExplicitThisParameterType((Getter<? extends JSType>)((Getter)() -> expanded), resolvedFunction));
        if (expanded.isTypeScript() && (!(expanded instanceof JSRecordType) || TypeScriptGenericTypesEvaluator.isApplicableRecordTypeForThis((JSRecordType)expanded))) {
            result2.put(TypeScriptGenericThisTypeImpl.createThisTypeGenericId(expanded), expanded);
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(22);
        }
        return jSTypeSubstitutor;
    }

    private static boolean isApplicableRecordTypeForThis(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(23);
        }
        if (!(recordType instanceof JSSimpleRecordTypeImpl)) {
            return false;
        }
        PsiElement sourceElement = recordType.getSource().getSourceElement();
        return sourceElement instanceof JSClassExpression;
    }

    public boolean hasGenericsCompatibilityErrors(@NotNull List<? extends JSType> parameterTypes, @NotNull List<? extends JSType> arguments, @NotNull TypeScriptFunction context) {
        Condition condition;
        Object[] parameters;
        if (parameterTypes == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(24);
        }
        if (arguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(25);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(26);
        }
        if ((parameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)context)).length == 0) {
            return false;
        }
        Set ids = StreamEx.of((Object[])parameters).map(el -> el.getGenericId()).toSet();
        List argumentProviders = ContainerUtil.map(arguments, el -> () -> el);
        JSGenericMappings genericArguments = this.inferGenericArgumentsFromCall(parameterTypes, argumentProviders, -1, (PsiElement)context, (Condition<? super JSType>)(condition = type -> type instanceof JSGenericParameterImpl && ids.contains(((JSGenericParameterImpl)type).getGenericId())));
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> mapping = genericArguments.getMapping();
        if (mapping.isEmpty()) {
            return false;
        }
        final Ref hasErrors = Ref.create((Object)false);
        JSGenericTypesEvaluator.GenericErrorReporter reporter = new JSGenericTypesEvaluator.GenericErrorReporter(){

            @Override
            public void error(@NotNull String parameter) {
                if (parameter == null) {
                    1.$$$reportNull$$$0(0);
                }
                hasErrors.set((Object)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$1", "error"));
            }
        };
        JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.intersectGenerics(mapping, (PsiElement)context, reporter);
        if (((Boolean)hasErrors.get()).booleanValue()) {
            return true;
        }
        List<JSType> functionGenerics = TypeScriptGenericTypesEvaluator.buildGenericParameters((TypeScriptTypeParameter[])parameters);
        if (functionGenerics.isEmpty() || functionGenerics.stream().noneMatch(el -> el instanceof JSGenericParameterType && ((JSGenericParameterType)el).getConstraintType() != null)) {
            return false;
        }
        for (JSType generic : functionGenerics) {
            JSTypeUtils.applyGenericArguments(generic, substitutor, true, reporter);
            if (!((Boolean)hasErrors.get()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeSubstitutorForQualifierType(@NotNull JSType qualifierType, @Nullable PsiElement sourceElement, @Nullable PsiElement place) {
        JSType constraintType;
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(27);
        }
        PsiElement context = (PsiElement)ObjectUtils.coalesce((Object)sourceElement, (Object)place);
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if ((qualifierType = JSTypeUtils.unwrapDecorations(qualifierType)) instanceof JSIntersectionType) {
            for (JSType typeToProcess : ((JSIntersectionType)qualifierType).getTypes()) {
                JSTypeSubstitutor candidate = TypeScriptGenericTypesEvaluator.getTypeSubstitutorForQualifierType(typeToProcess, sourceElement, place);
                substitutor.putAll(candidate);
            }
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(28);
            }
            return jSTypeSubstitutor;
        }
        if (qualifierType instanceof JSTypeWithOuterGenerics) {
            JSTypeSubstitutor outerArguments = ((JSTypeWithOuterGenerics)qualifierType).getOuterArguments();
            if (!outerArguments.isEmpty()) {
                substitutor.putAll(outerArguments);
            }
            qualifierType = ((JSTypeWithOuterGenerics)qualifierType).getType();
        }
        if (qualifierType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)qualifierType;
            if (genericType.getType() instanceof TypeScriptGenericThisTypeImpl) {
                qualifierType = new JSGenericTypeImpl(genericType.getSource(), ((TypeScriptGenericThisTypeImpl)genericType.getType()).substituteCompletely(), genericType.getArguments());
            }
        } else if (qualifierType instanceof JSRecordType) {
            PsiElement qualifierSource = qualifierType.getSource().getSourceElement();
            JSType objectType = null;
            if (qualifierSource instanceof TypeScriptObjectType) {
                objectType = ((TypeScriptObjectType)qualifierSource).getJSType();
            } else if (qualifierSource instanceof JSClass) {
                objectType = TypeScriptTypeParser.buildTypeFromClass((JSClass)qualifierSource, false);
            } else if (qualifierSource instanceof JSObjectLiteralExpression && DialectDetector.isTypeScript(qualifierSource)) {
                objectType = JSResolveUtil.getExpressionJSType((JSExpression)qualifierSource);
            }
            if (objectType != null) {
                if (objectType.isEquivalentTo(qualifierType, null, false)) {
                    JSTypeSubstitutor jSTypeSubstitutor = substitutor;
                    if (jSTypeSubstitutor == null) {
                        TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(29);
                    }
                    return jSTypeSubstitutor;
                }
                substitutor.putAll(TypeScriptGenericTypesEvaluator.findAndIntersectGenericsTypeValues(qualifierType, objectType, context));
            }
        } else if (qualifierType instanceof TypeScriptGenericThisTypeImpl) {
            qualifierType = ((TypeScriptGenericThisTypeImpl)qualifierType).getOwnerType();
        }
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        if (arguments == null && qualifierType instanceof TypeScriptGenericParameterImpl && (constraintType = ((TypeScriptGenericParameterImpl)qualifierType).getConstraintType()) != null) {
            qualifierType = constraintType;
            arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        }
        if (sourceElement == null) {
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(30);
            }
            return jSTypeSubstitutor;
        }
        JSClass parentClass = (JSClass)PsiTreeUtil.getContextOfType((PsiElement)sourceElement, (Class[])new Class[]{JSClass.class});
        if (parentClass == null) {
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(31);
            }
            return jSTypeSubstitutor;
        }
        if (arguments != null && JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false) != null || qualifierType instanceof JSNamedType) {
            Collection<JSClass> qualifierClasses = TypeScriptGenericTypesEvaluator.getQualifierClasses(qualifierType, place);
            for (JSClass qualifierClass : qualifierClasses) {
                List<JSType> argumentsList = arguments == null || arguments.isEmpty() ? TypeScriptGenericTypesEvaluator.getArgumentsListForTypeWithOwner(qualifierType, (PsiElement)qualifierClass) : arguments;
                substitutor = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(qualifierClass, argumentsList, parentClass, substitutor);
            }
        } else if (qualifierType instanceof JSAnyType && parentClass instanceof TypeScriptTypeParameterListOwner && (sourceElement instanceof TypeScriptFunction || sourceElement instanceof TypeScriptField)) {
            List<JSType> defaults = TypeScriptGenericTypesEvaluator.getDefaultOrAnyTypes((PsiElement)parentClass);
            if (defaults != null && !defaults.isEmpty()) {
                substitutor = substitutor.combine(TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)parentClass, defaults));
            }
            JSTypeSubstitutor jSTypeSubstitutor = substitutor.transformValues(el -> {
                if (el instanceof TypeScriptNeverJSTypeImpl) {
                    return JSAnyType.get(el.getSource());
                }
                if (el instanceof JSAnyType) {
                    return el;
                }
                return JSTypeUtils.copyWithStrictRecursive(el, false);
            });
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(32);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(33);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static List<JSType> getArgumentsListForTypeWithOwner(@NotNull JSType ownType, @NotNull PsiElement genericOwner) {
        List<JSType> parameters;
        if (ownType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(34);
        }
        if (genericOwner == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(35);
        }
        if (TypeScriptGenericTypesEvaluator.isInstanceJSTypeImpl(ownType) && (parameters = TypeScriptGenericTypesEvaluator.getDefaultOrAnyTypes(genericOwner)) != null) {
            List<JSType> list2 = parameters;
            if (list2 == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(36);
            }
            return list2;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(37);
        }
        return list3;
    }

    @Nullable
    public static List<JSType> getDefaultOrAnyTypes(@NotNull PsiElement genericOwner) {
        Object[] parameters;
        if (genericOwner == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(38);
        }
        if ((parameters = TypeScriptPsiUtil.getTypeParametersForOwner(genericOwner)).length > 0) {
            return ContainerUtil.map((Object[])parameters, JSGenericTypesEvaluatorBase::getTypeParameterDefaultType);
        }
        return null;
    }

    public static boolean isInstanceJSTypeImpl(@NotNull JSType qualifierType) {
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(39);
        }
        return qualifierType instanceof JSTypeImpl && ((JSTypeImpl)qualifierType).getTypeContext().toJSContext() == JSContext.INSTANCE;
    }

    @NotNull
    public static JSType processClassWithGenericArguments(@Nullable JSClass aClass, @NotNull List<? extends JSType> typeArgumentsList, @Nullable JSClass requiredParentClass, @NotNull JSType appliedGenerics) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(40);
        }
        if (appliedGenerics == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(41);
        }
        JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(aClass, typeArgumentsList, requiredParentClass, JSTypeSubstitutor.EMPTY);
        JSType jSType = JSTypeUtils.applyGenericArguments(appliedGenerics, substitutor);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(42);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor processClassWithGenericArguments(@Nullable JSClass startClass, @NotNull List<? extends JSType> typeArgumentsList, @Nullable JSClass expectedGenericOwnerClass, @NotNull JSTypeSubstitutor substitutor) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(43);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(44);
        }
        if (!(expectedGenericOwnerClass instanceof TypeScriptTypeParameterListOwner) || startClass == null) {
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(45);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor typeArguments = startClass instanceof TypeScriptTypeParameterListOwner ? TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)startClass, typeArgumentsList) : JSTypeSubstitutor.EMPTY;
        Ref ref = Ref.create((Object)substitutor);
        JSClassUtils.processClassesInHierarchy(startClass, true, (contextClass, typeSubstitutor, fromImplements) -> {
            if (contextClass.isEquivalentTo((PsiElement)expectedGenericOwnerClass)) {
                if (!substitutor.isEmpty()) {
                    typeSubstitutor = new JSTypeSubstitutor(typeSubstitutor);
                    typeSubstitutor.putAll(substitutor);
                }
                ref.set((Object)typeSubstitutor);
                return false;
            }
            return true;
        }, (Condition<? super JSClass>)((Condition)superCandidate -> JSInheritanceUtil.isParentClass(superCandidate, expectedGenericOwnerClass, false)), typeArguments);
        JSTypeSubstitutor jSTypeSubstitutor = (JSTypeSubstitutor)ref.get();
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(46);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static List<JSType> getTypeArgumentsForDeclarations(@NotNull JSTypeDeclaration[] declarations, @Nullable JSTypeSubstitutor typeArguments) {
        if (declarations == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(47);
        }
        List mappedArguments = ContainerUtil.newSmartList();
        for (JSTypeDeclaration typeArgument : declarations) {
            JSType expandedType = typeArgument.getJSType();
            if (typeArguments != null) {
                expandedType = JSTypeUtils.applyGenericArguments(expandedType, typeArguments);
            }
            mappedArguments.add(expandedType);
        }
        List list2 = mappedArguments;
        if (list2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(48);
        }
        return list2;
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @Nullable JSType genericType) {
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        return arguments == null ? null : TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner, arguments);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @NotNull List<? extends JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(49);
        }
        if (typeParameterListOwner == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(50);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner.getTypeParameterList(), typeArgumentsList);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(51);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterList typeParameterList, @NotNull List<? extends JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(52);
        }
        if (typeArgumentsList.isEmpty() || typeParameterList == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(53);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(parameters, typeArgumentsList);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(54);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@NotNull TypeScriptTypeParameter[] parameters, @NotNull List<? extends JSType> typeArgumentsList) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(55);
        }
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(56);
        }
        if (typeArgumentsList.size() == 0 || parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(57);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor genericArguments = new JSTypeSubstitutor();
        for (int i = 0; i < parameters.length; ++i) {
            String name;
            TypeScriptTypeParameter parameter = parameters[i];
            JSType type = null;
            if (typeArgumentsList.size() > i) {
                type = typeArgumentsList.get(i);
            }
            if (TypeScriptGenericTypesEvaluator.addFromNamedSubstitutor(parameters, genericArguments, type)) continue;
            if (type == null) {
                type = JSTypeUtils.applyGenericArguments(TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter), genericArguments);
            }
            if ((name = parameter.getName()) == null) continue;
            JSTypeSubstitutor.JSTypeGenericId id = parameter.getGenericId();
            genericArguments.put(id, type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = genericArguments;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(58);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private JSTypeSubstitutor getInferredCallLikeTypeSubstitutor(@NotNull PsiElement resolvedFunction, @NotNull JSCallItem callItem, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context, @NotNull JSTypeSubstitutor explicitSubstitutor) {
        if (resolvedFunction == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(59);
        }
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(60);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(61);
        }
        if (explicitSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(62);
        }
        if (!context.inferCallGenerics) {
            JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForDefaultParameters(resolvedFunction);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(63);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.inferGenericTypesForCall(resolvedFunction, callItem, context.reporter, explicitSubstitutor.keys(), context.paramToSkip);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(64);
        }
        return jSTypeSubstitutor;
    }

    @Nullable
    private static PsiElement getResolvedFunction(@Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction) {
        JSFunctionItem functionItem;
        if (resolvedFunction != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolvedFunction, (PsiElement)methodExpression, false)) != null) {
            resolvedFunction = functionItem;
        }
        return resolvedFunction;
    }

    private static JSTypeSubstitutor getSuperExpressionTypeSubstitutor(@Nullable PsiElement resolvedFunction, @NotNull JSExpression methodExpression) {
        JSReferenceList list2;
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(65);
        }
        if (!TypeScriptGenericTypesEvaluator.isConstructorSuperCall(resolvedFunction, (PsiElement)methodExpression)) {
            return JSTypeSubstitutor.EMPTY;
        }
        TypeScriptClass tsClass = (TypeScriptClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)methodExpression, TypeScriptClass.class);
        if (tsClass != null && resolvedFunction instanceof TypeScriptFunction && (list2 = tsClass.getExtendsList()) != null) {
            if (tsClass.getIndirectSuperConstructors().contains(resolvedFunction)) {
                JSExpression element = (JSExpression)ArrayUtil.getFirstElement((Object[])list2.getExpressions());
                List<JSType> typesForGenerics = element != null ? TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(TypeScriptPsiUtil.getNestedTypeArguments(element.getParent()), null) : ContainerUtil.emptyList();
                TypeScriptFunction tsFunction = (TypeScriptFunction)resolvedFunction;
                return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)tsFunction, typesForGenerics);
            }
            JSClass parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolvedFunction, JSClass.class);
            return TypeScriptGenericTypesEvaluator.processClassWithGenericArguments((JSClass)tsClass, (List<? extends JSType>)ContainerUtil.emptyList(), parentClass, JSTypeSubstitutor.EMPTY);
        }
        return JSTypeSubstitutor.EMPTY;
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable PsiElement member, @Nullable PsiElement place, @Nullable JSTypeSubstitutor additionalSubstitutor) {
        if (member instanceof TypeScriptProxyImplicitElement) {
            member = ((TypeScriptProxyImplicitElement)member).getExplicitElement();
        }
        if (!(place instanceof JSExpression) || !(member instanceof JSQualifiedNamedElement)) {
            JSTypeSubstitutor jSTypeSubstitutor = additionalSubstitutor == null ? JSTypeSubstitutor.EMPTY : additionalSubstitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(66);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if (additionalSubstitutor != null) {
            substitutor.putAll(additionalSubstitutor);
        }
        JSCallLikeExpression callLikeExpression = TypeScriptSignatureChooser.getCallLikeExpression(place);
        substitutor.putAll(TypeScriptGenericTypesEvaluator.getInstance().getAllGenericTypeSubstitutor((JSExpression)place, member, member, (JSCallItem)callLikeExpression, DEFAULT_CONTEXT));
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(67);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable JSElement member, @NotNull PsiElement place) {
        List<JSFunctionWithSubstitutor> elements;
        JSFunctionWithSubstitutor functionWithSubstitutor;
        if (place == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(68);
        }
        if (member == null || !DialectDetector.isTypeScript((PsiElement)member) || !(place instanceof JSReferenceExpression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(69);
            }
            return jSTypeSubstitutor;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)place;
        if (referenceExpression.getParent() instanceof JSCallExpression && (functionWithSubstitutor = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(elements = TypeScriptSignatureChooser.resolveConstructorOrCallSignature((PsiElement)referenceExpression))) != null) {
            JSFunctionItem functionItem = functionWithSubstitutor.myFunctionItem;
            JSTypeSubstitutor additionalSubstitutor = functionWithSubstitutor.myTypeSubstitutor;
            JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)functionItem, place, additionalSubstitutor);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(70);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)member, place, null);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(71);
        }
        return jSTypeSubstitutor;
    }

    private static boolean isConstructorSuperCall(@Nullable PsiElement resolveResult, @Nullable PsiElement callExpression) {
        return callExpression instanceof JSSuperExpression && callExpression.getParent() instanceof JSCallExpression && resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor();
    }

    public static void fillExplicitGenericArguments(@NotNull TypeScriptTypeParameter[] typeParameters, @NotNull JSTypeDeclaration[] typeArguments, @NotNull JSTypeSubstitutor genericArguments) {
        if (typeParameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(72);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(73);
        }
        if (genericArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(74);
        }
        if (typeParameters.length == 0 || typeArguments.length == 0) {
            return;
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            JSType type;
            TypeScriptTypeParameter parameter = typeParameters[i];
            JSTypeDeclaration typeArgument = typeArguments.length > i ? typeArguments[i] : null;
            JSType jSType = type = typeArgument != null ? typeArgument.getJSType() : null;
            if (TypeScriptGenericTypesEvaluator.addFromNamedSubstitutor(typeParameters, genericArguments, type)) continue;
            if (type == null) {
                type = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            genericArguments.put(parameter.getGenericId(), type);
        }
    }

    private static boolean addFromNamedSubstitutor(@NotNull TypeScriptTypeParameter[] typeParameters, @NotNull JSTypeSubstitutor genericArguments, JSType type) {
        if (typeParameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(75);
        }
        if (genericArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(76);
        }
        if (!(type instanceof JSNamedTypeSubstitutorType)) {
            return false;
        }
        String genericName = ((JSNamedTypeSubstitutorType)type).getGenericName();
        Optional<TypeScriptTypeParameter> first = Arrays.stream(typeParameters).filter(p -> genericName.equals(p.getName())).findFirst();
        first.ifPresent(parameter -> genericArguments.put(parameter.getGenericId(), ((JSNamedTypeSubstitutorType)type).getRealType()));
        return true;
    }

    @NotNull
    public static JSTypeSubstitutor getCallExplicitTypeSubstitutor(@Nullable PsiElement resolveResult, @Nullable JSCallItem callItem, @Nullable JSTypeSubstitutor genericArguments) {
        TypeScriptTypeParameter[] typeParameters;
        JSClass clazz;
        if (!(resolveResult instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = genericArguments == null ? JSTypeSubstitutor.EMPTY : new JSTypeSubstitutor(genericArguments);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(77);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = genericArguments == null ? new JSTypeSubstitutor() : new JSTypeSubstitutor(genericArguments);
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)resolveResult).getTypeParameterList();
        if (typeParameterList != null) {
            TypeScriptTypeParameter[] typeParameters2 = typeParameterList.getTypeParameters();
            JSTypeDeclaration[] typeArguments = callItem instanceof PsiElement ? TypeScriptPsiUtil.getNestedTypeArguments((PsiElement)callItem) : JSTypeDeclaration.EMPTY_ARRAY;
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters2, typeArguments, substitutor);
        }
        if ((clazz = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolveResult, JSClass.class)) instanceof TypeScriptTypeParameterListOwner && (typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)clazz)).length > 0) {
            JSTypeDeclaration[] typeArguments = callItem instanceof TypeScriptNewExpression ? callItem.getTypeArguments() : JSTypeDeclaration.EMPTY_ARRAY;
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters, typeArguments, substitutor);
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(78);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSType getExplicitTypeOrAnyIfTypeScript(@Nullable PsiElement context, @Nullable JSType type) {
        if (type == null) {
            JSAnyType jSAnyType = JSAnyType.get(context, false);
            if (jSAnyType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(79);
            }
            return jSAnyType;
        }
        if (context == null || !context.isValid()) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(80);
            }
            return jSType;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        if (holder != null && holder.isTypeScript) {
            JSType jSType = TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(context, type);
            if (jSType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(81);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(82);
        }
        return jSType;
    }

    @NotNull
    public static JSType getExplicitTypeOrAny(@NotNull PsiElement expression, @Nullable JSType type) {
        if (expression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(83);
        }
        JSType jSType = type == null ? JSAnyType.get(expression, false) : type;
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(84);
        }
        return jSType;
    }

    @NotNull
    public static Collection<JSClass> getQualifierClasses(@Nullable JSType qualifierType, @Nullable PsiElement place) {
        if (qualifierType == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(85);
            }
            return list2;
        }
        JSTypeSource source = qualifierType.getSource();
        String type = JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false);
        PsiElement element = source.getSourceElement();
        if (type == null || element == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(86);
            }
            return list3;
        }
        Collection<? extends PsiElement> elements = TypeScriptGenericTypesEvaluator.getElementsForQualifierClassName(type, element, place);
        List result2 = ContainerUtil.newSmartList();
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSClass)) continue;
            result2.add((JSClass)psiElement);
        }
        List list4 = result2;
        if (list4 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(87);
        }
        return list4;
    }

    @NotNull
    private static Collection<? extends PsiElement> getElementsForQualifierClassName(@NotNull String type, @NotNull PsiElement element, @Nullable PsiElement place) {
        boolean isJSPlace;
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(88);
        }
        if (element == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(89);
        }
        boolean bl = isJSPlace = place != null && !DialectDetector.isTypeScript(place);
        if (isJSPlace) {
            if (JSCorePredefinedLibrariesProvider.isLibraryElement(element)) {
                Collection<PsiElement> collection = JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(type, place);
                if (collection == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(90);
                }
                return collection;
            }
            if (!DialectDetector.isTypeScript(element)) {
                Collection<PsiElement> elements = new ES6QualifiedNameResolver(element).resolveQualifiedName(type);
                if (elements.size() > 0) {
                    Collection<PsiElement> collection = elements;
                    if (collection == null) {
                        TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(91);
                    }
                    return collection;
                }
                Collection<PsiElement> collection = JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(type, place);
                if (collection == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(92);
                }
                return collection;
            }
        }
        JSTypeResolveResult resolveResults = TypeScriptImportHandler.getInstance().resolveMainElementName(type, element, JSContext.UNKNOWN);
        Collection<? extends PsiElement> collection = resolveResults.getElements();
        if (collection == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(93);
        }
        return collection;
    }

    @NotNull
    public static List<TypeScriptGenericDeclarationTypeImpl> buildGenericParameterDeclarations(@NotNull TypeScriptTypeParameter[] parameters) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(94);
        }
        if (parameters.length == 0) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(95);
            }
            return list2;
        }
        ArrayList<TypeScriptGenericDeclarationTypeImpl> generics = new ArrayList<TypeScriptGenericDeclarationTypeImpl>();
        for (TypeScriptTypeParameter parameter : parameters) {
            TypeScriptGenericDeclarationTypeImpl declaration = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclaration(parameter);
            generics.add(declaration);
        }
        ArrayList<TypeScriptGenericDeclarationTypeImpl> arrayList = generics;
        if (arrayList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(96);
        }
        return arrayList;
    }

    @NotNull
    public static List<JSType> buildGenericParameters(@NotNull TypeScriptTypeParameter[] parameters) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(97);
        }
        List list2 = ContainerUtil.map(TypeScriptGenericTypesEvaluator.buildGenericParameterDeclarations(parameters), el -> el.toGenericParameter());
        if (list2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(98);
        }
        return list2;
    }

    @NotNull
    public static TypeScriptGenericDeclarationTypeImpl buildGenericParameterDeclaration(@NotNull TypeScriptTypeParameter parameter) {
        if (parameter == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(99);
        }
        TypeScriptType constraint = parameter.getTypeConstraint();
        TypeScriptType parameterDefault = parameter.getDefault();
        AtomicNotNullLazyValue constraintType = constraint == null ? null : AtomicNotNullLazyValue.createValue(() -> constraint.getJSType());
        AtomicNotNullLazyValue defaultType = parameterDefault == null ? null : AtomicNotNullLazyValue.createValue(() -> parameterDefault.getJSType());
        JSTypeSubstitutor.JSTypeGenericId genericId = parameter.getGenericId();
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)parameter, true);
        TypeScriptGenericDeclarationTypeImpl typeScriptGenericDeclarationTypeImpl = new TypeScriptGenericDeclarationTypeImpl(genericId, (NotNullLazyValue<? extends JSType>)constraintType, (NotNullLazyValue<? extends JSType>)defaultType, source);
        if (typeScriptGenericDeclarationTypeImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(100);
        }
        return typeScriptGenericDeclarationTypeImpl;
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionTypeImpl functionType, @NotNull JSCallExpression callExpression) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(101);
        }
        if (callExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(102);
        }
        JSType jSType = TypeScriptGenericTypesEvaluator.applyTypeScriptGenericArguments(functionType, (JSCallItem)callExpression, (PsiElement)functionType.getSourceFunctionItem());
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(103);
        }
        return jSType;
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionType functionType, @NotNull JSCallItem callItem, @Nullable PsiElement sourceElement) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(104);
        }
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(105);
        }
        JSType jSType = JSGenericTypesEvaluator.getEvaluator(callItem.getPsiContext()).evaluateGenerics((JSType)functionType, callItem, sourceElement, DEFAULT_CONTEXT);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(106);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForExtendClass(@NotNull JSClass contextClass, @NotNull JSClass genericOwner) {
        if (contextClass == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(107);
        }
        if (genericOwner == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(108);
        }
        if (!(genericOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(109);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)genericOwner).getTypeParameterList();
        if (typeParameterList == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(110);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
        if (parameters.length <= 0) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(111);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(contextClass, (List<? extends JSType>)ContainerUtil.emptyList(), genericOwner, JSTypeSubstitutor.EMPTY);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(112);
        }
        return jSTypeSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 60: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callItem";
                break;
            }
            case 4: 
            case 13: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callLikeExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFunctionOrField";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 15: 
            case 18: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 27: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownType";
                break;
            }
            case 35: 
            case 38: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericOwner";
                break;
            }
            case 40: 
            case 43: 
            case 49: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentsList";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedGenerics";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 55: 
            case 94: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFunction";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitSubstitutor";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArguments";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 101: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationFunction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllGenericTypeSubstitutor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateGenericsFromQualifier";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierTypeSubstitutor";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForQualifierType";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsListForTypeWithOwner";
                break;
            }
            case 42: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "processClassWithGenericArguments";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForTypeArguments";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferredCallLikeTypeSubstitutor";
                break;
            }
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForMember";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallExplicitTypeSubstitutor";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeOrAnyIfTypeScript";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeOrAny";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierClasses";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForQualifierClassName";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameterDeclarations";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameters";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameterDeclaration";
                break;
            }
            case 103: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeScriptGenericArguments";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForExtendClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenerics";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateGenerics";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEvaluationFunction";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllGenericTypeSubstitutor";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenericsFromQualifier";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierTypeSubstitutor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableRecordTypeForThis";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasGenericsCompatibilityErrors";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForQualifierType";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsListForTypeWithOwner";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOrAnyTypes";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceJSTypeImpl";
                break;
            }
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processClassWithGenericArguments";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 49: 
            case 52: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForTypeArguments";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getInferredCallLikeTypeSubstitutor";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getSuperExpressionTypeSubstitutor";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForMember";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "fillExplicitGenericArguments";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "addFromNamedSubstitutor";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitTypeOrAny";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForQualifierClassName";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameterDeclarations";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameters";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameterDeclaration";
                break;
            }
            case 101: 
            case 102: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeScriptGenericArguments";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForExtendClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

