/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.move.FileReferenceContextUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.hash.HashSet;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MoveFileHandler
extends MoveFileHandler {
    private static final Key<Boolean> MARKER = Key.create((String)"marker.not.invalidated");
    private static final Logger LOG = Logger.getInstance(ES6MoveFileHandler.class);

    public boolean canProcessElement(PsiFile file2) {
        return file2 instanceof JSFile && DialectDetector.hasFeature((PsiElement)file2, JSLanguageFeature.IMPORT_DECLARATIONS);
    }

    public void prepareMovedFile(PsiFile file2, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewMap) {
    }

    @Nullable
    public List<UsageInfo> findUsages(PsiFile psiFile, PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        if (!(psiFile instanceof JSFile)) {
            return null;
        }
        List<UsageInfo> result2 = this.doFindUsages(psiFile);
        if (result2.isEmpty()) {
            return null;
        }
        psiFile.putCopyableUserData(MARKER, (Object)true);
        return result2;
    }

    @NotNull
    protected List<UsageInfo> doFindUsages(@NotNull PsiFile psiFile) {
        Map encodedInfo;
        if (psiFile == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(0);
        }
        if ((encodedInfo = FileReferenceContextUtil.encodeFileReferences((PsiElement)psiFile)).isEmpty()) {
            List<UsageInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                ES6MoveFileHandler.$$$reportNull$$$0(1);
            }
            return list2;
        }
        Map<String, VirtualFile> resultMap = ES6MoveFileHandler.convertMap(encodedInfo, el -> el.getVirtualFile());
        List<UsageInfo> list3 = Collections.singletonList(new MyRestoreReferencesUsage(psiFile, resultMap));
        if (list3 == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(2);
        }
        return list3;
    }

    public void retargetUsages(List<UsageInfo> usageInfos, Map<PsiElement, PsiElement> oldToNewMap) {
        HashSet correctlyCopiedElements = new HashSet();
        for (UsageInfo info : usageInfos) {
            PsiElement element;
            if (!(info instanceof RestoreReferencesUsage) || !((element = info.getElement()) instanceof PsiFile) || !element.isValid()) continue;
            Boolean data = (Boolean)element.getCopyableUserData(MARKER);
            if (data != null) {
                if (Boolean.TRUE.equals(data)) {
                    correctlyCopiedElements.add(element);
                }
                element.putCopyableUserData(MARKER, null);
            }
            if (Boolean.TRUE.equals(data) || correctlyCopiedElements.contains(element)) continue;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(ES6MoveFileHandler.getErrorMessage(element));
            } else {
                LOG.warn(ES6MoveFileHandler.getErrorMessage(element));
            }
            ((RestoreReferencesUsage)info).restore((PsiFile)element);
        }
    }

    public void updateMovedFile(PsiFile file2) throws IncorrectOperationException {
        if (DialectDetector.isTypeScript((PsiElement)file2) && file2 instanceof JSFile && ((JSFile)file2).getReferencedPaths().size() > 0) {
            for (PsiComment comment : PsiTreeUtil.findChildrenOfType((PsiElement)file2, PsiComment.class)) {
                FileReferenceContextUtil.decodeFileReferences((PsiElement)comment);
            }
        }
    }

    @NotNull
    private static String getErrorMessage(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(3);
        }
        String path = (file2 = element.getContainingFile()) != null ? file2.getVirtualFile().getPath() : "unknown";
        String string = "Psi file was invalidated after move file: '" + path + "'. All file references will be lost";
        if (string == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static <Old, New> Map<String, New> convertMap(@NotNull Map<String, Old> map, @NotNull NullableFunction<Old, New> func) {
        if (map == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(5);
        }
        if (func == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(6);
        }
        THashMap resultMap = new THashMap();
        for (Map.Entry<String, Old> entry : map.entrySet()) {
            Old value = entry.getValue();
            String key = entry.getKey();
            Object newValue = func.fun(value);
            if (newValue == null) continue;
            resultMap.put(key, newValue);
        }
        THashMap tHashMap = resultMap;
        if (tHashMap == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(7);
        }
        return tHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/refactoring/ES6MoveFileHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/refactoring/ES6MoveFileHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFindUsages";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyRestoreReferencesUsage
    extends RestoreReferencesUsage<Map<String, VirtualFile>> {
        MyRestoreReferencesUsage(@NotNull PsiFile element, Map<String, VirtualFile> refs) {
            if (element == null) {
                MyRestoreReferencesUsage.$$$reportNull$$$0(0);
            }
            super(element, refs);
        }

        @Override
        protected void restore(@NotNull PsiFile file2) {
            if (file2 == null) {
                MyRestoreReferencesUsage.$$$reportNull$$$0(1);
            }
            PsiManager manager2 = file2.getManager();
            Map map = ES6MoveFileHandler.convertMap((Map)this.myRefs, el -> FileReferenceHelper.getPsiFileSystemItem((PsiManager)manager2, (VirtualFile)el));
            FileReferenceContextUtil.decodeFileReferences((PsiElement)file2, (Map)map, (TextRange)file2.getTextRange());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/typescript/refactoring/ES6MoveFileHandler$MyRestoreReferencesUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restore";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class RestoreReferencesUsage<T>
    extends UsageInfo {
        @NotNull
        protected final T myRefs;

        protected RestoreReferencesUsage(@NotNull PsiFile element, @NotNull T refs) {
            if (element == null) {
                RestoreReferencesUsage.$$$reportNull$$$0(0);
            }
            if (refs == null) {
                RestoreReferencesUsage.$$$reportNull$$$0(1);
            }
            super(element);
            this.myRefs = refs;
        }

        protected abstract void restore(@NotNull PsiFile var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refs";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/typescript/refactoring/ES6MoveFileHandler$RestoreReferencesUsage";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

