/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.documentation;

import com.google.gson.Gson;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.actions.JSShowTypeInfoAction;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.documentation.JavaScriptQuickNavigateBuilder;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.QuickInfoCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptQuickInfoResponse;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptQuickNavigateBuilder
extends JavaScriptQuickNavigateBuilder {
    public static final int TIMEOUT_MILLIS = 300;
    private static final Set<String> KEYWORDS = ContainerUtil.immutableSet((Object[])new String[]{"var", "let", "const", "class", "enum", "module", "namespace", "export", "private", "public", "protected", "type", "interface", "static", "readonly", "async"});

    @Override
    @Nullable
    protected String getQuickNavigateInfoForNavigationElement(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        Future<String> future;
        String serviceResult;
        if (element == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(1);
        }
        if (!TypeScriptQuickNavigateBuilder.isWhitelisted(originalElement) && !StringUtil.isEmpty((String)(serviceResult = JSLanguageServiceUtil.awaitFuture(future = TypeScriptQuickNavigateBuilder.requestServiceQuickInfo(element, originalElement), 300L)))) {
            return TypeScriptQuickNavigateBuilder.parseServiceText(element, serviceResult);
        }
        return super.getQuickNavigateInfoForNavigationElement(element, originalElement);
    }

    private static String parseServiceText(@NotNull PsiElement element, @NotNull String originalText) {
        if (element == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(2);
        }
        if (originalText == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(3);
        }
        try {
            int close;
            String processText = originalText;
            String kind = "";
            if (processText.startsWith("(") && (close = processText.indexOf(") ")) > 0) {
                kind = processText.substring(0, close + 2);
                processText = processText.substring(close + 2);
            }
            int space = processText.indexOf(" ");
            int lastKeywordStartOffset = 0;
            while (space >= 0 && KEYWORDS.contains(processText.substring(lastKeywordStartOffset, space))) {
                lastKeywordStartOffset = space;
                space = processText.indexOf(" ", lastKeywordStartOffset);
            }
            String keywords = "";
            if (lastKeywordStartOffset > 0) {
                keywords = processText.substring(0, lastKeywordStartOffset + 1);
                processText = processText.substring(lastKeywordStartOffset + 1);
            }
            if (processText.isEmpty()) {
                return StringUtil.escapeXmlEntities((String)originalText);
            }
            int qNameIndex = 0;
            if (Character.isJavaIdentifierStart(processText.charAt(0))) {
                ++qNameIndex;
                while (processText.length() > qNameIndex && (Character.isJavaIdentifierPart(processText.charAt(qNameIndex)) || '.' == processText.charAt(qNameIndex))) {
                    ++qNameIndex;
                }
            }
            if (qNameIndex == 0) {
                return StringUtil.escapeXmlEntities((String)originalText);
            }
            String restPart = processText.substring(qNameIndex);
            String postfix = "";
            int indexOfOverloads = restPart.indexOf("(+");
            if (indexOfOverloads > 0) {
                postfix = restPart.substring(indexOfOverloads);
                restPart = restPart.substring(0, indexOfOverloads);
            }
            String qName = processText.substring(0, qNameIndex);
            if (keywords.length() > 1) {
                return kind + TypeScriptQuickNavigateBuilder.getQuickNavigateByKeyword(element, restPart, keywords, qName) + postfix;
            }
            return kind + TypeScriptQuickNavigateBuilder.getQuickNavigateByKind(element, restPart, qName, kind) + postfix;
        }
        catch (RuntimeException e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            Logger.getInstance(TypeScriptQuickNavigateBuilder.class).error("Cannot parse service text: " + originalText, (Throwable)e);
            return StringUtil.escapeXmlEntities((String)originalText);
        }
    }

    private static String getQuickNavigateByKind(@NotNull PsiElement element, @NotNull String restPart, @NotNull String qName, @NotNull String kind) {
        if (element == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(4);
        }
        if (restPart == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(5);
        }
        if (qName == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(6);
        }
        if (kind == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(7);
        }
        JSQuickNavigateBuilder.ObjectKind objectKind = TypeScriptQuickNavigateBuilder.toObjectKind(kind);
        switch (objectKind) {
            case FUNCTION: 
            case METHOD: {
                return TypeScriptQuickNavigateBuilder.buildHtmlForFunction(element, "", qName, false, restPart);
            }
        }
        return TypeScriptQuickNavigateBuilder.buildHtmlForVariableOrField(element, "", qName, false, restPart);
    }

    private static JSQuickNavigateBuilder.ObjectKind toObjectKind(@NotNull String kind) {
        if (kind == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(8);
        }
        for (JSQuickNavigateBuilder.ObjectKind value : JSQuickNavigateBuilder.ObjectKind.values()) {
            if (!value.toPrefix().equals(kind)) continue;
            return value;
        }
        return JSQuickNavigateBuilder.ObjectKind.SIMPLE_DECLARATION;
    }

    @NotNull
    private static String getQuickNavigateByKeyword(@NotNull PsiElement element, @NotNull String restPart, @NotNull String keywords, @NotNull String qName) {
        if (element == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(9);
        }
        if (restPart == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(10);
        }
        if (keywords == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(11);
        }
        if (qName == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(12);
        }
        String finalText = keywords + "$$Name$$" + restPart;
        TextRange nameRange = new TextRange(keywords.length(), keywords.length() + "$$Name$$".length());
        String string = TypeScriptQuickNavigateBuilder.getQuickNavigateHtmlHighlighting(element, qName, "", finalText, nameRange);
        if (string == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static boolean isWhitelisted(@NotNull PsiElement originalElement) {
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(14);
        }
        return originalElement instanceof JSThisExpression || originalElement instanceof TypeScriptThisType;
    }

    @Nullable
    private static Future<String> requestServiceQuickInfo(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(15);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(16);
        }
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(element.getProject());
        if (!settings.useService() || !settings.isUseServiceQuickNavigate()) {
            return null;
        }
        if (!DialectDetector.isTypeScript(originalElement)) {
            return null;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
        if (file2 == null) {
            return null;
        }
        TypeScriptCompilerService service = TypeScriptCompilerService.getServiceForFile(element.getProject(), file2);
        if (service == null || !service.isServiceCreated()) {
            return null;
        }
        if (originalElement instanceof PsiNameIdentifierOwner) {
            PsiElement identifier = ((PsiNameIdentifierOwner)originalElement).getNameIdentifier();
            originalElement = (PsiElement)ObjectUtils.coalesce((Object)identifier, (Object)originalElement);
        } else if (originalElement instanceof JSReferenceExpression) {
            originalElement = (PsiElement)ObjectUtils.coalesce((Object)((JSReferenceExpression)originalElement).getReferenceNameElement(), (Object)originalElement);
        }
        TextRange range = originalElement.getTextRange();
        int offset = range.getStartOffset();
        TypeScriptFileLocationRequestArgs location = new TypeScriptFileLocationRequestArgs();
        Document document2 = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(originalElement.getContainingFile());
        if (document2 == null) {
            return null;
        }
        TypeScriptLanguageServiceUtil.fillFilePosition(location, file2, document2, offset);
        QuickInfoCommand command = new QuickInfoCommand(location);
        return service.sendCommand(command, (serviceObject, answer) -> {
            Gson gson = JSLanguageServiceUtil.getGson(service);
            TypeScriptQuickInfoResponse response = TypeScriptLanguageServiceUtil.deserialize(gson, answer, TypeScriptQuickInfoResponse.class);
            return response == null ? null : response.displayString;
        });
    }

    @Override
    protected void appendVariableInitializer(@NotNull JSVariable variable, @NotNull StringBuilder result2) {
        if (variable == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(17);
        }
        if (result2 == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(18);
        }
        if (variable instanceof TypeScriptVariable && variable.isConst()) {
            return;
        }
        String text = variable.getLiteralOrReferenceInitializerText();
        if (text != null) {
            super.appendVariableInitializer(variable, result2);
        }
    }

    @Override
    protected void appendClassExtendsAndImplements(@NotNull JSClass jsClass, PsiElement originalElement, @NotNull String packageNameOrEmptyString, @NotNull StringBuilder result2) {
        if (jsClass == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(19);
        }
        if (packageNameOrEmptyString == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(20);
        }
        if (result2 == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(21);
        }
        if (jsClass instanceof TypeScriptTypeAlias) {
            return;
        }
        super.appendClassExtendsAndImplements(jsClass, originalElement, packageNameOrEmptyString, result2);
    }

    @Override
    protected JSType getVariableOrFieldType(@NotNull JSTypeDeclarationOwner variable) {
        if (variable == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(22);
        }
        return JSShowTypeInfoAction.getTypeForDocumentation((PsiElement)variable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalText";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restPart";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywords";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/documentation/TypeScriptQuickNavigateBuilder";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNameOrEmptyString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/documentation/TypeScriptQuickNavigateBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickNavigateByKeyword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfoForNavigationElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseServiceText";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateByKind";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toObjectKind";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateByKeyword";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isWhitelisted";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "requestServiceQuickInfo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableInitializer";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "appendClassExtendsAndImplements";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

