/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FixAndIntentionAction
implements LocalQuickFix,
IntentionAction {
    protected SmartPsiElementPointer myElementPointer;

    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        if (project == null) {
            FixAndIntentionAction.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            FixAndIntentionAction.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = element = this.myElementPointer == null ? null : this.myElementPointer.getElement();
        if (element == null) {
            return;
        }
        this.applyFix(project, element, null, null);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            FixAndIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public final String getText() {
        String string = this.getName();
        if (string == null) {
            FixAndIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public final boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        PsiElement element;
        if (project == null) {
            FixAndIntentionAction.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = element = this.myElementPointer == null ? null : this.myElementPointer.getElement();
        if (element == null) {
            return false;
        }
        return this.isAvailable(project, element, editor, file2);
    }

    protected abstract void applyFix(Project var1, PsiElement var2, PsiFile var3, Editor var4);

    protected boolean isAvailable(Project project, PsiElement element, Editor editor, PsiFile file2) {
        return true;
    }

    public final void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            FixAndIntentionAction.$$$reportNull$$$0(5);
        }
        assert (this.myElementPointer != null);
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiElement element = this.myElementPointer.getElement();
        if (element == null) {
            return;
        }
        this.applyFix(project, element, element.getContainingFile(), editor);
    }

    @Nullable
    public SmartPsiElementPointer registerElementRefForFix(@NotNull PsiElement nameIdentifier, @Nullable SmartPsiElementPointer pointer) {
        if (nameIdentifier == null) {
            FixAndIntentionAction.$$$reportNull$$$0(6);
        }
        if (this.myElementPointer != null) {
            return pointer;
        }
        if (pointer == null) {
            pointer = SmartPointerManager.getInstance((Project)nameIdentifier.getProject()).createSmartPsiElementPointer(nameIdentifier);
        }
        this.myElementPointer = pointer;
        return pointer;
    }

    public void sharePointer(@NotNull FixAndIntentionAction action) {
        if (action == null) {
            FixAndIntentionAction.$$$reportNull$$$0(7);
        }
        this.myElementPointer = action.myElementPointer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/FixAndIntentionAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/FixAndIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerElementRefForFix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sharePointer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

