/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceToolWindowInfoReporter
implements JSLanguageServiceQueue.ServiceInfoReporter {
    private final Project myProject;
    private final String myName;
    @NotNull
    private final JSLanguageServiceToolWindowManager myManager;
    private final boolean myActive;

    public JSLanguageServiceToolWindowInfoReporter(Project project, @NotNull String name, @NotNull JSLanguageServiceToolWindowManager manager2, boolean setActive) {
        if (name == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(0);
        }
        if (manager2 == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myName = name;
        this.myManager = manager2;
        this.myActive = setActive;
    }

    @Override
    @NotNull
    public String getServiceName() {
        String string = this.myName;
        if (string == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void logError(@NotNull String error) {
        if (error == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myProject.isInitialized()) {
                return;
            }
            this.myManager.logCurrentErrors((List<JSAnnotationError>)JSLanguageServiceAnnotationResult.buildError(error), this.myActive);
        });
    }

    @Override
    public void setProcess(@Nullable String text) {
        ApplicationManager.getApplication().invokeLater(() -> this.myManager.setProgressText(text), this.myProject.getDisposed());
    }

    @Override
    public void logCurrentErrors(@NotNull VirtualFile virtualFile, @NotNull List<JSAnnotationError> results) {
        if (virtualFile == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(4);
        }
        if (results == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile editorFile;
            if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
            if (editor instanceof EditorEx && virtualFile.equals(editorFile = ((EditorEx)editor).getVirtualFile())) {
                this.myManager.logCurrentErrors(results, false);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceToolWindowInfoReporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceToolWindowInfoReporter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logError";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logCurrentErrors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

