/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSCodeFragment {
    @NotNull
    private final List<PsiElement> myStatementElements;
    @Nullable
    private final Pair<JSExpression, TextRange> myExpression;

    JSCodeFragment(@Nullable List<PsiElement> statementElements, @Nullable Pair<JSExpression, TextRange> expression) {
        this.myStatementElements = ContainerUtil.notNullize(statementElements);
        this.myExpression = expression;
    }

    @NotNull
    public List<PsiElement> getStatementElements() {
        List<PsiElement> list2 = this.myStatementElements;
        if (list2 == null) {
            JSCodeFragment.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Nullable
    public Pair<JSExpression, TextRange> getExpression() {
        return this.myExpression;
    }

    @NotNull
    public PsiElement getContextElement() {
        if (this.myExpression != null) {
            PsiElement psiElement = (PsiElement)this.myExpression.first;
            if (psiElement == null) {
                JSCodeFragment.$$$reportNull$$$0(1);
            }
            return psiElement;
        }
        PsiElement statement = (PsiElement)ContainerUtil.getFirstItem(this.myStatementElements);
        assert (statement != null);
        PsiElement psiElement = statement;
        if (psiElement == null) {
            JSCodeFragment.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getTextRange() {
        if (this.myExpression != null) {
            if (this.myExpression.second != null) {
                TextRange textRange = (TextRange)this.myExpression.second;
                if (textRange == null) {
                    JSCodeFragment.$$$reportNull$$$0(3);
                }
                return textRange;
            }
            TextRange textRange = ((JSExpression)this.myExpression.first).getTextRange();
            if (textRange == null) {
                JSCodeFragment.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        TextRange textRange = new TextRange(this.myStatementElements.get(0).getTextRange().getStartOffset(), this.myStatementElements.get(this.myStatementElements.size() - 1).getTextRange().getEndOffset());
        if (textRange == null) {
            JSCodeFragment.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/refactoring/extractMethod/JSCodeFragment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementElements";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

