/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.RecursionVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class RecursionUtils {
    private RecursionUtils() {
    }

    public static boolean statementMayReturnBeforeRecursing(JSStatement statement, JSFunction function) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof JSBreakStatement || statement instanceof JSContinueStatement || statement instanceof JSThrowStatement || statement instanceof JSExpressionStatement || statement instanceof JSEmptyStatement || statement instanceof JSVarStatement) {
            return false;
        }
        if (statement instanceof JSReturnStatement) {
            JSReturnStatement returnStatement = (JSReturnStatement)statement;
            JSExpression returnValue = returnStatement.getExpression();
            return returnValue == null || !RecursionUtils.expressionDefinitelyRecurses(returnValue, function);
        }
        if (statement instanceof JSForStatement) {
            return RecursionUtils.forStatementMayReturnBeforeRecursing((JSForStatement)statement, function);
        }
        if (statement instanceof JSForInStatement) {
            return RecursionUtils.foreachStatementMayReturnBeforeRecursing((JSForInStatement)statement, function);
        }
        if (statement instanceof JSWhileStatement) {
            return RecursionUtils.whileStatementMayReturnBeforeRecursing((JSWhileStatement)statement, function);
        }
        if (statement instanceof JSDoWhileStatement) {
            return RecursionUtils.doWhileStatementMayReturnBeforeRecursing((JSDoWhileStatement)statement, function);
        }
        if (statement instanceof JSBlockStatement) {
            JSBlockStatement blockStatement = (JSBlockStatement)statement;
            return RecursionUtils.codeBlockMayReturnBeforeRecursing(blockStatement, function, false);
        }
        if (statement instanceof JSLabeledStatement) {
            return RecursionUtils.labeledStatementMayReturnBeforeRecursing((JSLabeledStatement)statement, function);
        }
        if (statement instanceof JSIfStatement) {
            return RecursionUtils.ifStatementMayReturnBeforeRecursing((JSIfStatement)statement, function);
        }
        if (statement instanceof JSTryStatement) {
            return RecursionUtils.tryStatementMayReturnBeforeRecursing((JSTryStatement)statement, function);
        }
        if (statement instanceof JSSwitchStatement) {
            return RecursionUtils.switchStatementMayReturnBeforeRecursing((JSSwitchStatement)statement, function);
        }
        return true;
    }

    private static boolean doWhileStatementMayReturnBeforeRecursing(JSDoWhileStatement loopStatement, JSFunction function) {
        JSStatement body = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body, function);
    }

    private static boolean whileStatementMayReturnBeforeRecursing(JSWhileStatement loopStatement, JSFunction function) {
        JSExpression test = loopStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(test, function)) {
            return false;
        }
        JSStatement body = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body, function);
    }

    private static boolean forStatementMayReturnBeforeRecursing(JSForStatement loopStatement, JSFunction function) {
        JSExpression initialization = loopStatement.getInitialization();
        if (RecursionUtils.expressionDefinitelyRecurses(initialization, function)) {
            return false;
        }
        JSExpression test = loopStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(test, function)) {
            return false;
        }
        JSStatement body = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body, function);
    }

    private static boolean foreachStatementMayReturnBeforeRecursing(JSForInStatement loopStatement, JSFunction function) {
        JSExpression test = loopStatement.getCollectionExpression();
        if (RecursionUtils.expressionDefinitelyRecurses(test, function)) {
            return false;
        }
        JSStatement body = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body, function);
    }

    private static boolean switchStatementMayReturnBeforeRecursing(JSSwitchStatement switchStatement, JSFunction function) {
        JSCaseClause[] clauses;
        for (JSCaseClause clause : clauses = switchStatement.getCaseClauses()) {
            JSSourceElement[] statements;
            for (JSSourceElement statement : statements = clause.getStatementListItems()) {
                if (!(statement instanceof JSStatement) || !RecursionUtils.statementMayReturnBeforeRecursing((JSStatement)statement, function)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean tryStatementMayReturnBeforeRecursing(JSTryStatement tryStatement, JSFunction function) {
        JSStatement tryBlock;
        JSStatement finallyBlock = tryStatement.getFinallyStatement();
        if (finallyBlock != null) {
            if (RecursionUtils.statementMayReturnBeforeRecursing(finallyBlock, function)) {
                return true;
            }
            if (RecursionUtils.statementDefinitelyRecurses(finallyBlock, function)) {
                return false;
            }
        }
        if (RecursionUtils.statementMayReturnBeforeRecursing(tryBlock = tryStatement.getStatement(), function)) {
            return true;
        }
        JSCatchBlock catchBlock = tryStatement.getCatchBlock();
        if (catchBlock == null) {
            return false;
        }
        JSStatement catchBlockStatement = catchBlock.getStatement();
        return RecursionUtils.statementMayReturnBeforeRecursing(catchBlockStatement, function);
    }

    private static boolean ifStatementMayReturnBeforeRecursing(JSIfStatement ifStatement, JSFunction function) {
        JSExpression test = ifStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(test, function)) {
            return false;
        }
        JSStatement thenBranch = ifStatement.getThen();
        if (RecursionUtils.statementMayReturnBeforeRecursing(thenBranch, function)) {
            return true;
        }
        JSStatement elseBranch = ifStatement.getElse();
        return elseBranch != null && RecursionUtils.statementMayReturnBeforeRecursing(elseBranch, function);
    }

    private static boolean labeledStatementMayReturnBeforeRecursing(JSLabeledStatement labeledStatement, JSFunction function) {
        JSStatement statement = labeledStatement.getStatement();
        return RecursionUtils.statementMayReturnBeforeRecursing(statement, function);
    }

    private static boolean codeBlockMayReturnBeforeRecursing(JSBlockStatement block, JSFunction function, boolean endsInImplicitReturn) {
        JSSourceElement[] statements;
        if (block == null) {
            return true;
        }
        for (JSSourceElement statement : statements = block.getStatementListItems()) {
            if (!(statement instanceof JSStatement)) continue;
            if (RecursionUtils.statementMayReturnBeforeRecursing((JSStatement)statement, function)) {
                return true;
            }
            if (!RecursionUtils.statementDefinitelyRecurses((JSStatement)statement, function)) continue;
            return false;
        }
        return endsInImplicitReturn;
    }

    public static boolean functionMayRecurse(@NotNull JSFunction function) {
        if (function == null) {
            RecursionUtils.$$$reportNull$$$0(0);
        }
        RecursionVisitor recursionVisitor = new RecursionVisitor(function);
        function.accept((PsiElementVisitor)recursionVisitor);
        return recursionVisitor.isRecursive();
    }

    private static boolean expressionDefinitelyRecurses(JSExpression exp, JSFunction function) {
        if (exp == null) {
            return false;
        }
        if (exp instanceof JSCallExpression) {
            return RecursionUtils.functionCallExpressionDefinitelyRecurses((JSCallExpression)exp, function);
        }
        if (exp instanceof JSAssignmentExpression) {
            return RecursionUtils.assignmentExpressionDefinitelyRecurses((JSAssignmentExpression)exp, function);
        }
        if (exp instanceof JSArrayLiteralExpression) {
            return RecursionUtils.arrayInitializerExpressionDefinitelyRecurses((JSArrayLiteralExpression)exp, function);
        }
        if (exp instanceof JSPrefixExpression) {
            return RecursionUtils.prefixExpressionDefinitelyRecurses((JSPrefixExpression)exp, function);
        }
        if (exp instanceof JSPostfixExpression) {
            return RecursionUtils.postfixExpressionDefinitelyRecurses((JSPostfixExpression)exp, function);
        }
        if (exp instanceof JSBinaryExpression) {
            return RecursionUtils.binaryExpressionDefinitelyRecurses((JSBinaryExpression)exp, function);
        }
        if (exp instanceof JSConditionalExpression) {
            return RecursionUtils.conditionalExpressionDefinitelyRecurses((JSConditionalExpression)exp, function);
        }
        if (exp instanceof JSParenthesizedExpression) {
            return RecursionUtils.parenthesizedExpressionDefinitelyRecurses((JSParenthesizedExpression)exp, function);
        }
        if (exp instanceof JSReferenceExpression) {
            return RecursionUtils.referenceExpressionDefinitelyRecurses((JSReferenceExpression)exp, function);
        }
        if (exp instanceof JSDefinitionExpression) {
            return RecursionUtils.expressionDefinitelyRecurses(((JSDefinitionExpression)exp).getExpression(), function);
        }
        if (exp instanceof JSLiteralExpression || exp instanceof JSThisExpression) {
            return false;
        }
        return false;
    }

    private static boolean conditionalExpressionDefinitelyRecurses(JSConditionalExpression expression, JSFunction function) {
        JSExpression condExpression = expression.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condExpression, function)) {
            return true;
        }
        JSExpression thenExpression = expression.getThen();
        JSExpression elseExpression = expression.getElse();
        return RecursionUtils.expressionDefinitelyRecurses(thenExpression, function) && RecursionUtils.expressionDefinitelyRecurses(elseExpression, function);
    }

    private static boolean binaryExpressionDefinitelyRecurses(JSBinaryExpression expression, JSFunction function) {
        JSExpression lhs = expression.getLOperand();
        if (RecursionUtils.expressionDefinitelyRecurses(lhs, function)) {
            return true;
        }
        IElementType tokenType = expression.getOperationSign();
        if (JSTokenTypes.ANDAND.equals(tokenType) || JSTokenTypes.OROR.equals(tokenType)) {
            return false;
        }
        JSExpression rhs = expression.getROperand();
        return RecursionUtils.expressionDefinitelyRecurses(rhs, function);
    }

    private static boolean arrayInitializerExpressionDefinitelyRecurses(JSArrayLiteralExpression expression, JSFunction function) {
        JSExpression[] initializers;
        for (JSExpression initializer : initializers = expression.getExpressions()) {
            if (!RecursionUtils.expressionDefinitelyRecurses(initializer, function)) continue;
            return true;
        }
        return false;
    }

    private static boolean prefixExpressionDefinitelyRecurses(JSPrefixExpression expression, JSFunction function) {
        JSExpression operand = expression.getExpression();
        return RecursionUtils.expressionDefinitelyRecurses(operand, function);
    }

    private static boolean postfixExpressionDefinitelyRecurses(JSPostfixExpression expression, JSFunction function) {
        JSExpression operand = expression.getExpression();
        return RecursionUtils.expressionDefinitelyRecurses(operand, function);
    }

    private static boolean parenthesizedExpressionDefinitelyRecurses(JSParenthesizedExpression expression, JSFunction function) {
        JSExpression innerExpression = expression.getInnerExpression();
        return RecursionUtils.expressionDefinitelyRecurses(innerExpression, function);
    }

    private static boolean referenceExpressionDefinitelyRecurses(JSReferenceExpression expression, JSFunction function) {
        if (JSPsiImplUtils.isGetterOrSetter(function) && RecursionUtils.processRefExpr(expression, function)) {
            return true;
        }
        JSExpression qualifierExpression = expression.getQualifier();
        return qualifierExpression != null && RecursionUtils.expressionDefinitelyRecurses(qualifierExpression, function);
    }

    private static boolean assignmentExpressionDefinitelyRecurses(JSAssignmentExpression assignmentExpression, JSFunction function) {
        JSExpression rhs = assignmentExpression.getROperand();
        JSExpression lhs = assignmentExpression.getLOperand();
        return RecursionUtils.expressionDefinitelyRecurses(rhs, function) || RecursionUtils.expressionDefinitelyRecurses(lhs, function);
    }

    private static boolean functionCallExpressionDefinitelyRecurses(JSCallExpression exp, JSFunction function) {
        JSExpression[] args;
        JSExpression functionExpression = exp.getMethodExpression();
        if (functionExpression instanceof JSReferenceExpression && RecursionUtils.processRefExpr((JSReferenceExpression)functionExpression, function)) {
            return true;
        }
        if (RecursionUtils.expressionDefinitelyRecurses(functionExpression, function)) {
            return true;
        }
        for (JSExpression arg : args = exp.getArguments()) {
            if (!RecursionUtils.expressionDefinitelyRecurses(arg, function)) continue;
            return true;
        }
        return false;
    }

    private static boolean processRefExpr(JSReferenceExpression reference, JSFunction function) {
        PsiElement referent = reference.resolve();
        if (referent != null) {
            return referent.equals(function);
        }
        JSExpression qualifier = reference.getQualifier();
        if (qualifier == null || qualifier instanceof JSThisExpression) {
            return reference.getText().equals(function.getName());
        }
        return false;
    }

    private static boolean statementDefinitelyRecurses(JSStatement statement, JSFunction function) {
        if (statement == null) {
            return false;
        }
        if (statement instanceof JSBreakStatement || statement instanceof JSContinueStatement || statement instanceof JSThrowStatement || statement instanceof JSEmptyStatement) {
            return false;
        }
        if (statement instanceof JSExpressionStatement) {
            JSExpressionStatement expressionStatement = (JSExpressionStatement)statement;
            JSExpression expression = expressionStatement.getExpression();
            return RecursionUtils.expressionDefinitelyRecurses(expression, function);
        }
        if (statement instanceof JSVarStatement) {
            JSVariable[] declaredElements;
            JSVarStatement declaration = (JSVarStatement)statement;
            for (JSVariable variable : declaredElements = declaration.getVariables()) {
                JSExpression initializer = variable.getInitializer();
                if (!RecursionUtils.expressionDefinitelyRecurses(initializer, function)) continue;
                return true;
            }
            return false;
        }
        if (statement instanceof JSReturnStatement) {
            JSReturnStatement returnStatement = (JSReturnStatement)statement;
            JSExpression returnValue = returnStatement.getExpression();
            return returnValue != null && RecursionUtils.expressionDefinitelyRecurses(returnValue, function);
        }
        if (statement instanceof JSForStatement) {
            return RecursionUtils.forStatementDefinitelyRecurses((JSForStatement)statement, function);
        }
        if (statement instanceof JSForInStatement) {
            return RecursionUtils.foreachStatementDefinitelyRecurses((JSForInStatement)statement, function);
        }
        if (statement instanceof JSWhileStatement) {
            return RecursionUtils.whileStatementDefinitelyRecurses((JSWhileStatement)statement, function);
        }
        if (statement instanceof JSDoWhileStatement) {
            return RecursionUtils.doWhileStatementDefinitelyRecurses((JSDoWhileStatement)statement, function);
        }
        if (statement instanceof JSBlockStatement) {
            return RecursionUtils.codeBlockDefinitelyRecurses((JSBlockStatement)statement, function);
        }
        if (statement instanceof JSLabeledStatement) {
            return RecursionUtils.labeledStatementDefinitelyRecurses((JSLabeledStatement)statement, function);
        }
        if (statement instanceof JSIfStatement) {
            return RecursionUtils.ifStatementDefinitelyRecurses((JSIfStatement)statement, function);
        }
        if (statement instanceof JSTryStatement) {
            return RecursionUtils.tryStatementDefinitelyRecurses((JSTryStatement)statement, function);
        }
        if (statement instanceof JSSwitchStatement) {
            return RecursionUtils.switchStatementDefinitelyRecurses((JSSwitchStatement)statement, function);
        }
        return false;
    }

    private static boolean switchStatementDefinitelyRecurses(JSSwitchStatement switchStatement, JSFunction function) {
        JSExpression switchExpression = switchStatement.getSwitchExpression();
        return RecursionUtils.expressionDefinitelyRecurses(switchExpression, function);
    }

    private static boolean tryStatementDefinitelyRecurses(JSTryStatement tryStatement, JSFunction function) {
        JSStatement tryBlock = tryStatement.getStatement();
        if (RecursionUtils.statementDefinitelyRecurses(tryBlock, function)) {
            return true;
        }
        JSStatement finallyBlock = tryStatement.getFinallyStatement();
        return RecursionUtils.statementDefinitelyRecurses(finallyBlock, function);
    }

    private static boolean codeBlockDefinitelyRecurses(JSBlockStatement block, JSFunction function) {
        JSSourceElement[] statements;
        if (block == null) {
            return false;
        }
        for (JSSourceElement statement : statements = block.getStatementListItems()) {
            if (!(statement instanceof JSStatement)) continue;
            if (RecursionUtils.statementDefinitelyRecurses((JSStatement)statement, function)) {
                return true;
            }
            if (!RecursionUtils.statementMayReturnBeforeRecursing((JSStatement)statement, function)) continue;
            return false;
        }
        return false;
    }

    private static boolean ifStatementDefinitelyRecurses(JSIfStatement ifStatement, JSFunction function) {
        JSExpression condition = ifStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condition, function)) {
            return true;
        }
        JSStatement thenBranch = ifStatement.getThen();
        JSStatement elseBranch = ifStatement.getElse();
        if (thenBranch == null || elseBranch == null) {
            return false;
        }
        return RecursionUtils.statementDefinitelyRecurses(thenBranch, function) && RecursionUtils.statementDefinitelyRecurses(elseBranch, function);
    }

    private static boolean forStatementDefinitelyRecurses(JSForStatement forStatement, JSFunction function) {
        JSExpression initialization = forStatement.getInitialization();
        if (RecursionUtils.expressionDefinitelyRecurses(initialization, function)) {
            return true;
        }
        JSExpression condition = forStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condition, function)) {
            return true;
        }
        if (ControlFlowUtils.isTrue(condition)) {
            JSStatement body = forStatement.getBody();
            return RecursionUtils.statementDefinitelyRecurses(body, function);
        }
        return false;
    }

    private static boolean foreachStatementDefinitelyRecurses(JSForInStatement foreachStatement, JSFunction function) {
        JSExpression iteration = foreachStatement.getCollectionExpression();
        return RecursionUtils.expressionDefinitelyRecurses(iteration, function);
    }

    private static boolean whileStatementDefinitelyRecurses(JSWhileStatement whileStatement, JSFunction function) {
        JSExpression condition = whileStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condition, function)) {
            return true;
        }
        if (ControlFlowUtils.isTrue(condition)) {
            JSStatement body = whileStatement.getBody();
            return RecursionUtils.statementDefinitelyRecurses(body, function);
        }
        return false;
    }

    private static boolean doWhileStatementDefinitelyRecurses(JSDoWhileStatement doWhileStatement, JSFunction function) {
        JSStatement body = doWhileStatement.getBody();
        if (RecursionUtils.statementDefinitelyRecurses(body, function)) {
            return true;
        }
        JSExpression condition = doWhileStatement.getCondition();
        return RecursionUtils.expressionDefinitelyRecurses(condition, function);
    }

    private static boolean labeledStatementDefinitelyRecurses(JSLabeledStatement labeledStatement, JSFunction function) {
        JSStatement body = labeledStatement.getStatement();
        return RecursionUtils.statementDefinitelyRecurses(body, function);
    }

    public static boolean functionDefinitelyRecurses(@NotNull JSFunction function) {
        if (function == null) {
            RecursionUtils.$$$reportNull$$$0(1);
        }
        return RecursionUtils.statementDefinitelyRecurses((JSStatement)function.getBlock(), function);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "function";
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/RecursionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "functionMayRecurse";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "functionDefinitelyRecurses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

