/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdModulesIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.frameworks.gcl.JSGclModuleReference;
import com.intellij.lang.javascript.frameworks.gcl.JSGclReferenceContributor;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSScopeNamesCache;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSLiteralExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSObjectLiteralExpressionStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSFindFirstResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSMergeResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStubBasedPsiTreeUtil {
    static final TokenSet DECLARATIONS_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TypeScriptElementTypes.TYPE_MEMBERS, JSElementTypes.FUNCTION_DECLARATIONS, JSExtendedLanguagesTokenSetProvider.CLASSES, JSExtendedLanguagesTokenSetProvider.VARIABLES, JSExtendedLanguagesTokenSetProvider.MODULES, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.DEFINITION_EXPRESSION, ES6ElementTypes.IMPORT_SPECIFIER, ES6ElementTypes.IMPORT_SPECIFIER_ALIAS, ES6ElementTypes.IMPORTED_BINDING, ES6ElementTypes.EXPORT_SPECIFIER, ES6ElementTypes.EXPORT_SPECIFIER_ALIAS, ES6ElementTypes.EXPORTED_DEFAULT_BINDING, TypeScriptElementTypes.IMPORT_STATEMENT, JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS})});
    private static final TokenSet FUNCTIONS_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTION_DECLARATIONS, JSElementTypes.FUNCTION_EXPRESSIONS});
    private static final TokenSet RETURN_STATEMENT_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.RETURN_STATEMENT});
    private static final Comparator<PsiElement> TEXT_OFFSET_COMPARATOR = (a, b) -> {
        if (a == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(129);
        }
        if (b == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(130);
        }
        if (a instanceof StubBasedPsiElementBase && b instanceof StubBasedPsiElementBase) {
            StubElement aStub = ((StubBasedPsiElementBase)a).getGreenStub();
            StubElement bStub = ((StubBasedPsiElementBase)b).getGreenStub();
            if (aStub instanceof ObjectStubBase && bStub instanceof ObjectStubBase) {
                return Integer.compare(((ObjectStubBase)aStub).getStubId(), ((ObjectStubBase)bStub).getStubId());
            }
        }
        return Integer.compare(a.getTextOffset(), b.getTextOffset());
    };
    private static final Predicate<PsiElement> IS_TARGET = element -> {
        boolean isImport = false;
        if (element instanceof JSVariable) {
            JSExpression initializer = JSDestructuringUtil.getNearestInitializerStubSafely((JSVariable)element);
            isImport = initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall();
        } else if (element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof ES6ImportedExportedDefaultBinding || element instanceof JSExportAssignment) {
            isImport = true;
        }
        if (isImport) {
            return false;
        }
        boolean isExport = false;
        if (element instanceof JSDefinitionExpression || element instanceof ES6Property && ((ES6Property)element).isShorthanded()) {
            JSQualifiedName name = ((JSElementBase)element).getJSNamespace().getQualifiedName();
            isExport = CommonJSUtil.isExportNamespace(name);
        }
        return !isExport;
    };
    private static final Predicate<PsiElement> SEMANTIC_HIGHLIGHTING_STOP_AT = element -> {
        if (!IS_TARGET.test((PsiElement)element)) {
            return false;
        }
        return !(element instanceof JSProperty) || ((JSProperty)element).getInitializerReference() == null;
    };
    private static final Predicate<PsiElement> SEMANTIC_HIGHLIGHTING_STOP_BEFORE = element -> element instanceof JSParameter && !TypeScriptPsiUtil.isFieldParameter((JSParameter)element);

    @Nullable
    public static PsiElement resolveLocally(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(1);
        }
        return JSStubBasedPsiTreeUtil.resolveLocally(name, context, true);
    }

    @Nullable
    public static PsiElement resolveLocally(@NotNull String name, @NotNull PsiElement context, boolean includeDefinitions) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(3);
        }
        if (name.contains(".")) {
            return null;
        }
        JSFindFirstResolveProcessor processor = new JSFindFirstResolveProcessor(name, includeDefinitions);
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(context, processor, true);
        return processor.getResult();
    }

    @NotNull
    public static List<PsiElement> resolveLocallyWithMergedResults(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(5);
        }
        List<PsiElement> list2 = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(name, context, false);
        if (list2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public static List<PsiElement> resolveLocallyWithMergedResults(@NotNull String name, @NotNull PsiElement context, boolean includeDefinitions) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(7);
        }
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(8);
        }
        if (name.contains(".")) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(9);
            }
            return list2;
        }
        JSMergeResolveProcessor processor = new JSMergeResolveProcessor(name, includeDefinitions);
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(context, processor, true);
        List<PsiElement> list3 = processor.getResults();
        if (list3 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(10);
        }
        return list3;
    }

    public static boolean processDeclarationsInScope(@NotNull PsiElement context, @NotNull PsiScopeProcessor processor, boolean includeParentScopes) {
        String name;
        JSElement scope;
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(12);
        }
        if ((scope = JSStubBasedPsiTreeUtil.getScope(context = (PsiElement)ObjectUtils.coalesce((Object)CompletionUtilCoreImpl.getOriginalElement((PsiElement)context), (Object)context))) == null) {
            return true;
        }
        String string = name = processor instanceof JSResolveProcessor ? ((JSResolveProcessor)processor).getName() : null;
        if (!JSStubBasedPsiTreeUtil.hasStub((PsiElement)scope)) {
            return JSTreeUtil.processDeclarationsInScope(context, (PsiElement)scope, processor, name, includeParentScopes);
        }
        return JSStubBasedPsiTreeUtil.processDeclarationsInScopeStubBased(context, scope, processor, name, includeParentScopes);
    }

    @Nullable
    private static JSElement getScope(@NotNull PsiElement context) {
        PsiElement scope;
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(13);
        }
        return (scope = JSStubBasedPsiTreeUtil.getContextOfType(context, JSTreeUtil.ScopeTypesHolder.SCOPE_TYPES, false)) instanceof TypeScriptInterface ? ((TypeScriptInterface)scope).getBody() : (JSElement)scope;
    }

    private static boolean hasStub(@NotNull PsiElement scope) {
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(14);
        }
        return scope instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)scope).getStub() != null || scope instanceof PsiFileImpl && ((PsiFileImpl)scope).getStubTree() != null;
    }

    public static boolean isStubBased(@NotNull PsiElement element) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(15);
        }
        return element instanceof StubBasedPsiElementBase && (((StubBasedPsiElementBase)element).getGreenStub() != null || ((StubBasedPsiElementBase)element).getElementType().shouldCreateStub(element.getNode()));
    }

    private static boolean processDeclarationsInScopeStubBased(@NotNull PsiElement context, @NotNull JSElement scope, @NotNull PsiScopeProcessor processor, @Nullable String name, boolean includeParentScopes) {
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(18);
        }
        while (scope != null) {
            if (!JSStubBasedPsiTreeUtil.processDeclarationsInScopeStubBased(context, scope, processor, name)) {
                return false;
            }
            if (!includeParentScopes || scope instanceof PsiFile || scope instanceof JSEmbeddedContent) {
                return true;
            }
            context = scope;
            scope = (JSElement)JSStubBasedPsiTreeUtil.getContextOfType((PsiElement)scope, JSTreeUtil.ScopeTypesHolder.SCOPE_TYPES, true);
        }
        return true;
    }

    private static boolean processDeclarationsInScopeStubBased(@NotNull PsiElement context, @NotNull JSElement scope, @NotNull PsiScopeProcessor processor, @Nullable String name) {
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(21);
        }
        List<JSElement> elements = scope == context && name != null ? JSScopeNamesCache.findNamedElementsInStubScope(name, (PsiElement)scope) : JSStubBasedPsiTreeUtil.findElementsInStubScopeWithContext(context, scope, name);
        for (PsiElement psiElement : elements) {
            if (processor.execute(psiElement, ResolveState.initial())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static TIntObjectHashMap<Object> buildStubBasedNamesMap(@NotNull PsiElement scope) {
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(22);
        }
        TIntObjectHashMap defs = new TIntObjectHashMap();
        ArrayList declarations = new ArrayList();
        JSStubBasedPsiTreeUtil.addDescendantsRecursively(scope, DECLARATIONS_TOKEN_SET, JSExtendedLanguagesTokenSetProvider.SCOPE_ELEMENTS, scope, null, declarations);
        for (PsiElement declaration : declarations) {
            String name = JSStubBasedPsiTreeUtil.extractName(declaration);
            if (name == null || !JSStubBasedPsiTreeUtil.isAcceptableDeclaration(declaration)) continue;
            JSScopeNamesCache.addElementCompact((TIntObjectHashMap<Object>)defs, (JSElement)declaration, name.hashCode());
        }
        TIntObjectHashMap tIntObjectHashMap = defs;
        if (tIntObjectHashMap == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(23);
        }
        return tIntObjectHashMap;
    }

    @NotNull
    private static List<JSElement> findElementsInStubScopeWithContext(@NotNull PsiElement context, @NotNull JSElement scope, @Nullable String name) {
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(25);
        }
        List<JSElement> declarations = JSScopeNamesCache.getNamedElementsInScope(scope, name, true);
        List result2 = ContainerUtil.newSmartList();
        int declarationsBeforeContext = 0;
        if (name != null && declarations.size() > 1 && (declarationsBeforeContext = Collections.binarySearch(declarations, context, TEXT_OFFSET_COMPARATOR)) < 0) {
            declarationsBeforeContext = -declarationsBeforeContext - 1;
        }
        for (int i = 0; i < declarations.size(); ++i) {
            JSElement declaration = declarations.get(i < declarationsBeforeContext ? declarationsBeforeContext - i - 1 : i);
            String extractedName = JSStubBasedPsiTreeUtil.extractName((PsiElement)declaration);
            if (name != null && !name.equals(extractedName) || !JSStubBasedPsiTreeUtil.isAcceptableDeclaration((PsiElement)declaration)) continue;
            result2.add(declaration);
        }
        List list2 = result2;
        if (list2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(26);
        }
        return list2;
    }

    private static boolean isAcceptableDeclaration(@NotNull PsiElement declaration) {
        if (declaration == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(27);
        }
        if (declaration instanceof JSDefinitionExpression) {
            JSDefinitionExpression definitionExpression = (JSDefinitionExpression)declaration;
            return definitionExpression.getNamespace() == null;
        }
        if (declaration instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)declaration).getAlias() == null;
        }
        return declaration instanceof JSNamedElement;
    }

    @Nullable
    private static String extractName(@NotNull PsiElement declaration) {
        if (declaration == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(28);
        }
        if (declaration instanceof JSDefinitionExpression) {
            JSDefinitionExpression definitionExpression = (JSDefinitionExpression)declaration;
            return definitionExpression.getName();
        }
        if (declaration instanceof JSNamedElement) {
            return ((JSNamedElement)declaration).getName();
        }
        if (declaration instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)declaration).getDeclaredName();
        }
        return null;
    }

    @Nullable
    public static PsiElement getContextOfType(@NotNull PsiElement element, @NotNull TokenSet types2, boolean strict) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(29);
        }
        if (types2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(30);
        }
        if (strict && element instanceof PsiFile) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        if (element == null) {
            return null;
        }
        Object object = element instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)element).getStub() : (stub = element instanceof PsiFileImpl ? ((PsiFileImpl)element).getStub() : null);
        if (stub != null) {
            while (stub != null) {
                PsiElement psi = stub.getPsi();
                if (stub instanceof PsiFileStub) {
                    return types2.contains((IElementType)((PsiFileStub)stub).getType()) ? psi : null;
                }
                if (types2.contains((IElementType)stub.getStubType())) {
                    return psi;
                }
                stub = stub.getParentStub();
            }
        } else {
            ASTNode node = element.getNode();
            while (node != null) {
                if (types2.contains(node.getElementType())) {
                    return node.getPsi();
                }
                if (node instanceof FileASTNode) {
                    return null;
                }
                node = TreeUtil.findParent((ASTNode)node, (TokenSet)types2);
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement resolveReferenceLocally(@NotNull PsiPolyVariantReference reference, @Nullable String referenceName) {
        PsiFile file2;
        PsiElement context;
        if (reference == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(31);
        }
        if (referenceName == null) {
            return null;
        }
        PsiElement element = reference.getElement();
        PsiElement localElement = JSStubBasedPsiTreeUtil.resolveLocally(referenceName, element, false);
        if (localElement == null && (context = JSResolveUtil.getContext((PsiElement)(file2 = element.getContainingFile()))) != null) {
            localElement = JSStubBasedPsiTreeUtil.resolveLocally(referenceName, context, false);
        }
        return localElement;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull IStubElementType<?, T> elementType) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(32);
        }
        if (elementType == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(33);
        }
        Collection<T> collection = JSStubBasedPsiTreeUtil.findDescendants(element, TokenSet.create((IElementType[])new IElementType[]{elementType}));
        if (collection == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(34);
        }
        return collection;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull TokenSet elements) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(35);
        }
        if (elements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(36);
        }
        List<T> list2 = JSStubBasedPsiTreeUtil.findDescendants(element, elements, TokenSet.EMPTY);
        if (list2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(37);
        }
        return list2;
    }

    @NotNull
    public static <T extends PsiElement> List<T> findDescendants(@NotNull PsiElement element, @NotNull TokenSet elements, @NotNull TokenSet stopAt) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(38);
        }
        if (elements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(39);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(40);
        }
        ArrayList result2 = new ArrayList();
        JSStubBasedPsiTreeUtil.addDescendantsRecursively(element, elements, stopAt, null, null, result2);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    private static <T extends PsiElement> void addDescendantsRecursively(@NotNull PsiElement container, @NotNull TokenSet targetElements, @NotNull TokenSet stopAt, @Nullable PsiElement context, @Nullable Ref<Integer> outTargetElementsBeforeContext, Collection<T> out) {
        StubElement stub;
        if (container == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(42);
        }
        if (targetElements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(43);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(44);
        }
        if (!(container instanceof PsiFileImpl || container instanceof StubBasedPsiElementBase || container instanceof LazyParseablePsiElement)) {
            return;
        }
        Object object = container instanceof PsiFileImpl ? ((PsiFileImpl)container).getStub() : (stub = container instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)container).getStub() : null);
        if (stub != null) {
            List stubs = stub.getChildrenStubs();
            for (StubElement child : stubs) {
                IStubElementType type;
                PsiElement psi = child.getPsi();
                if (psi == context && outTargetElementsBeforeContext != null) {
                    outTargetElementsBeforeContext.set((Object)out.size());
                }
                if (targetElements.contains((IElementType)(type = child.getStubType()))) {
                    out.add(psi);
                }
                if (stopAt.contains((IElementType)type)) continue;
                JSStubBasedPsiTreeUtil.addDescendantsRecursively(psi, targetElements, stopAt, context, outTargetElementsBeforeContext, out);
            }
        } else {
            JSStubBasedPsiTreeUtil.addDescendantsRecursively(container.getNode(), targetElements, stopAt, context != null ? context.getNode() : null, outTargetElementsBeforeContext, out);
        }
    }

    private static <T extends PsiElement> void addDescendantsRecursively(@NotNull ASTNode container, @NotNull TokenSet targetElements, @NotNull TokenSet stopAt, @Nullable ASTNode context, @Nullable Ref<Integer> outTargetElementsBeforeContext, Collection<T> out) {
        if (container == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(45);
        }
        if (targetElements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(46);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(47);
        }
        for (ASTNode child = container.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type;
            if (child == context && outTargetElementsBeforeContext != null) {
                outTargetElementsBeforeContext.set((Object)out.size());
            }
            if (targetElements.contains(type = child.getElementType())) {
                out.add(child.getPsi());
            }
            if (stopAt.contains(type)) continue;
            JSStubBasedPsiTreeUtil.addDescendantsRecursively(child, targetElements, stopAt, context, outTargetElementsBeforeContext, out);
        }
    }

    @Nullable
    public static JSDocComment findDocComment(@NotNull PsiElement element) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(48);
        }
        JSDocComment candidate = null;
        if (!(element instanceof StubBasedPsiElementBase) || ((StubBasedPsiElementBase)element).getStub() == null) {
            PsiComment docComment = JSDocumentationUtils.findDocComment(element);
            if (docComment instanceof JSDocComment) {
                candidate = (JSDocComment)docComment;
            }
        } else {
            candidate = JSStubBasedPsiTreeUtil.findOwnDocCommentForStub((StubBasedPsiElementBase)element);
        }
        if (candidate != null && JSDocumentationUtils.mayRelateTo(candidate, element)) {
            return candidate;
        }
        return null;
    }

    @Nullable
    public static JSDocComment findOwnDocComment(@NotNull PsiElement element) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(49);
        }
        JSDocComment candidate = null;
        if (!(element instanceof StubBasedPsiElementBase) || ((StubBasedPsiElementBase)element).getStub() == null) {
            JSDocComment docComment = JSDocumentationUtils.findOwnDocComment(element);
            if (docComment != null) {
                candidate = docComment;
            }
        } else {
            candidate = JSStubBasedPsiTreeUtil.findOwnDocCommentForStub((StubBasedPsiElementBase)element);
        }
        if (candidate != null && JSDocumentationUtils.mayRelateTo(candidate, element)) {
            return candidate;
        }
        return null;
    }

    @Nullable
    private static JSDocComment findOwnDocCommentForStub(@NotNull StubBasedPsiElementBase<?> element) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(50);
        }
        if (element instanceof JSDefinitionExpression) {
            PsiElement prevSibling;
            PsiElement context = ((JSDefinitionExpression)element).getContext();
            if (context != null && (prevSibling = JSStubBasedPsiTreeUtil.getPrevSibling(context)) instanceof JSDocComment) {
                return (JSDocComment)prevSibling;
            }
            return null;
        }
        if (element instanceof JSVariable) {
            JSDocComment varChild = (JSDocComment)element.getStubOrPsiChild(JSStubElementTypes.DOC_COMMENT);
            if (varChild != null) {
                return varChild;
            }
            PsiElement context = element.getContext();
            if (context instanceof JSVarStatement && context instanceof StubBasedPsiElementBase) {
                element = (StubBasedPsiElementBase)context;
            }
        }
        return (JSDocComment)element.getStubOrPsiChild(JSStubElementTypes.DOC_COMMENT);
    }

    @Nullable
    public static PsiElement getNextSibling(@NotNull PsiElement element) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(51);
        }
        if (element instanceof StubBasedPsiElementBase && (stub = ((StubBasedPsiElementBase)element).getStub()) != null) {
            StubElement prevSibling = StubTreeUtil.getNextSibling(stub);
            return prevSibling != null ? prevSibling.getPsi() : null;
        }
        return element.getNextSibling();
    }

    @Nullable
    public static PsiElement getPrevSibling(@NotNull PsiElement element) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(52);
        }
        if (element instanceof StubBasedPsiElementBase && (stub = ((StubBasedPsiElementBase)element).getStub()) != null) {
            StubElement prevSibling = StubTreeUtil.getPrevSibling(stub);
            return prevSibling != null ? prevSibling.getPsi() : null;
        }
        return element.getPrevSibling();
    }

    @NotNull
    public static <T extends JSExpression> Collection<T> findReturnedExpressions(@NotNull JSFunction function, Class<? extends T> ... classes) {
        if (function == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(53);
        }
        List<JSExpression> candidates = JSStubBasedPsiTreeUtil.findReturnedExpressions(function);
        Collection collection = candidates.stream().filter(c -> PsiTreeUtil.instanceOf((Object)c, (Class[])classes)).map(c -> c).collect(Collectors.toList());
        if (collection == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(54);
        }
        return collection;
    }

    @NotNull
    public static List<JSExpression> findReturnedExpressions(@NotNull JSFunction function) {
        if (function == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(55);
        }
        SmartList candidates = new SmartList();
        if (function.getStub() != null) {
            List<Object> candidateParents = function.isShorthandArrowFunction() ? Collections.singletonList(function) : JSStubBasedPsiTreeUtil.findDescendants((PsiElement)function, RETURN_STATEMENT_TOKEN_SET, FUNCTIONS_TOKEN_SET);
            for (StubBasedPsiElement stubBasedPsiElement : candidateParents) {
                StubElement returnStub = stubBasedPsiElement.getStub();
                if (returnStub == null) continue;
                List childrenStubs = returnStub.getChildrenStubs();
                for (StubElement childrenStub : childrenStubs) {
                    PsiElement psi = childrenStub.getPsi();
                    if (!(psi instanceof JSExpression)) continue;
                    candidates.add((JSExpression)psi);
                }
            }
        } else {
            JSExpression expression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(function);
            if ((expression = JSUtils.unparenthesize(expression)) != null) {
                candidates.add(expression);
            } else {
                function.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor((List)candidates){
                    final /* synthetic */ List val$candidates;
                    {
                        this.val$candidates = list2;
                    }

                    public void visitJSFunctionExpression(JSFunctionExpression node) {
                    }

                    public void visitJSFunctionDeclaration(JSFunction node) {
                    }

                    public void visitJSReturnStatement(JSReturnStatement node) {
                        JSExpression expression = node.getExpression();
                        if (expression != null) {
                            this.val$candidates.add(expression);
                        }
                    }
                });
            }
        }
        SmartList smartList = candidates;
        if (smartList == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(56);
        }
        return smartList;
    }

    @Nullable
    public static PsiElement getStubOrPsiChild(@NotNull StubBasedPsiElementBase element, @NotNull TokenSet filter) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(57);
        }
        if (filter == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(58);
        }
        return JSStubBasedPsiTreeUtil.getStubOrPsiChild(element, filter, TokenSet.EMPTY);
    }

    @Nullable
    public static PsiElement getStubOrPsiChild(@NotNull StubBasedPsiElementBase<?> element, @NotNull TokenSet filter, @NotNull TokenSet stopAt) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(59);
        }
        if (filter == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(60);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(61);
        }
        if ((stub = element.getStub()) != null) {
            List childrenStubs = stub.getChildrenStubs();
            for (StubElement childStub : childrenStubs) {
                IStubElementType stubType = childStub.getStubType();
                if (filter.contains((IElementType)stubType)) {
                    return childStub.getPsi();
                }
                if (!stopAt.contains((IElementType)stubType)) continue;
                return null;
            }
        } else {
            for (ASTNode child = element.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
                IElementType elementType = child.getElementType();
                if (filter.contains(elementType)) {
                    return child.getPsi();
                }
                if (!stopAt.contains(elementType)) continue;
                return null;
            }
        }
        return null;
    }

    public static PsiElement[] getChildrenByType(JSElement element, TokenSet type) {
        if (element instanceof JSFileImpl || element instanceof JSStubElementImpl) {
            StubElement stub;
            StubElement stubElement = stub = element instanceof JSFileImpl ? ((JSFileImpl)element).getStub() : ((JSStubElementImpl)element).getStub();
            if (stub != null) {
                return stub.getChildrenByType(type, JSElement.ARRAY_FACTORY);
            }
        }
        ASTNode[] children = element.getNode().getChildren(type);
        PsiElement[] result2 = new PsiElement[children.length];
        for (int i = 0; i < children.length; ++i) {
            result2[i] = children[i].getPsi();
        }
        return result2;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(62);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(63);
        }
        return psiElement;
    }

    @NotNull
    public static Collection<PsiElement> calculateMeaningfulElements(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(64);
        }
        Collection<PsiElement> collection = JSStubBasedPsiTreeUtil.calculateMeaningfulElements(resolveResult, null, x -> false, x -> false);
        if (collection == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(65);
        }
        return collection;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<? super PsiElement> visited) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(66);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, visited, x -> false);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(67);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<? super PsiElement> visited, @NotNull Predicate<? super PsiElement> stopAt) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(68);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(69);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, visited, stopAt, x -> false);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(70);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<? super PsiElement> visited, @NotNull Predicate<? super PsiElement> stopAt, @NotNull Predicate<? super PsiElement> stopBefore) {
        Collection<PsiElement> elements;
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(71);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(72);
        }
        if (stopBefore == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(73);
        }
        if ((elements = JSStubBasedPsiTreeUtil.calculateMeaningfulElements(resolveResult, visited, stopAt, stopBefore)).size() > 1) {
            PsiElement psiElement = resolveResult;
            if (psiElement == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(74);
            }
            return psiElement;
        }
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
        PsiElement psiElement = item == null ? resolveResult : item;
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(75);
        }
        return psiElement;
    }

    @NotNull
    public static Collection<PsiElement> calculateMeaningfulElements(@NotNull PsiElement resolveResult, @Nullable Set<? super PsiElement> visited, @NotNull Predicate<? super PsiElement> stopAt, @NotNull Predicate<? super PsiElement> stopBefore) {
        PsiElement localResolved;
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(76);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(77);
        }
        if (stopBefore == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(78);
        }
        if (stopAt.test((PsiElement)resolveResult)) {
            List list2 = ContainerUtil.createMaybeSingletonList((Object)resolveResult);
            if (list2 == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(79);
            }
            return list2;
        }
        if (visited != null && !visited.add((PsiElement)resolveResult)) {
            List list3 = ContainerUtil.createMaybeSingletonList((Object)resolveResult);
            if (list3 == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(80);
            }
            return list3;
        }
        String initializerReference = null;
        List referencedElements = ContainerUtil.newSmartList();
        boolean referencedViaExportAssignment = false;
        if (resolveResult instanceof JSVariable) {
            PsiReference reference;
            PsiElement parent;
            JSExpression methodExpression;
            JSExpression initializer = ((JSVariable)resolveResult).getInitializerOrStub();
            if (initializer instanceof JSReferenceExpression) {
                Collection<PsiElement> elements = JSResolveResult.resolveReference((PsiPolyVariantReference)((JSReferenceExpression)initializer));
                if (!elements.isEmpty()) {
                    referencedElements.addAll(elements);
                }
            } else if (initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall()) {
                referencedElements.addAll(JSStubBasedPsiTreeUtil.getRequireCallReferencedElement((JSCallExpression)initializer));
            } else if (initializer instanceof JSCallExpression && JSGclReferenceContributor.isGoogRequireCall(((JSCallExpression)initializer).getStubSafeMethodExpression())) {
                JSGclModuleReference reference2 = JSGclReferenceContributor.getGclModuleReference((JSCallExpression)initializer);
                if (reference2 != null) {
                    referencedElements.addAll(JSResolveResult.resolveReference(reference2));
                }
            } else if (initializer instanceof JSCallExpression && (methodExpression = JSUtils.unparenthesize(((JSCallExpression)initializer).getStubSafeMethodExpression())) instanceof JSFunctionExpression) {
                Collection returnedExpressions = JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)((JSFunctionExpression)methodExpression), JSFunctionExpression.class);
                referencedElements.addAll(returnedExpressions);
            }
            String initializerText = ((JSVariable)resolveResult).getLiteralOrReferenceInitializerText();
            if (initializerText != null && JSSymbolUtil.isValidPropertyName(initializerText)) {
                initializerReference = initializerText;
            }
            if ((parent = resolveResult.getParent()) instanceof JSDestructuringProperty && referencedElements.isEmpty() && (reference = parent.getReference()) instanceof JSDestructuringPropertyReference) {
                referencedElements.addAll(JSResolveResult.resolveReference((PsiPolyVariantReference)((JSDestructuringPropertyReference)reference)));
            }
        } else if (resolveResult instanceof JSProperty) {
            if (((JSProperty)resolveResult).isGetProperty() && resolveResult instanceof JSFunction) {
                JSType type = ((JSFunction)resolveResult).getReturnType();
                if (type instanceof JSRequireCallExpressionType) {
                    referencedElements.addAll(JSStubBasedPsiTreeUtil.resolveRequireCallReference(resolveResult, ((JSRequireCallExpressionType)type).getReferencedModule()));
                }
            } else {
                initializerReference = ((JSProperty)resolveResult).getInitializerReference();
            }
        } else if (resolveResult instanceof JSDefinitionExpression) {
            initializerReference = ((JSDefinitionExpression)resolveResult).getInitializerReference();
        } else if (resolveResult instanceof TypeScriptImportStatement) {
            Collection importElements = ((TypeScriptImportStatement)resolveResult).findReferencedElements();
            referencedElements.addAll(importElements);
        } else if (resolveResult instanceof ES6ImportExportSpecifierAlias) {
            PsiElement element = ((ES6ImportExportSpecifierAlias)resolveResult).findAliasedElement();
            ContainerUtil.addIfNotNull((Collection)referencedElements, (Object)element);
        } else if (resolveResult instanceof ES6ImportedExportedDefaultBinding) {
            Collection elements = ((ES6ImportedExportedDefaultBinding)resolveResult).findReferencedElements();
            referencedElements.addAll(elements);
        } else if (resolveResult instanceof JSExportAssignment) {
            initializerReference = ((JSExportAssignment)resolveResult).getInitializerReference();
            if (initializerReference == null) {
                ContainerUtil.addIfNotNull((Collection)referencedElements, (Object)((JSExportAssignment)resolveResult).getStubSafeElement());
            }
            referencedViaExportAssignment = true;
        }
        if (!(initializerReference == null || !referencedElements.isEmpty() || (localResolved = JSStubBasedPsiTreeUtil.resolveLocally(initializerReference, resolveResult)) == null || referencedViaExportAssignment && localResolved instanceof TypeScriptFunction && TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)localResolved).size() != 1)) {
            ContainerUtil.addIfNotNull((Collection)referencedElements, (Object)localResolved);
        }
        if (referencedElements.isEmpty()) {
            List list4 = ContainerUtil.createMaybeSingletonList((Object)resolveResult);
            if (list4 == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(81);
            }
            return list4;
        }
        List result2 = ContainerUtil.newSmartList();
        for (PsiElement element : referencedElements) {
            if (visited == null) {
                visited = new THashSet();
            }
            if (stopBefore.test((PsiElement)element)) {
                List list5 = ContainerUtil.createMaybeSingletonList((Object)resolveResult);
                if (list5 == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(82);
                }
                return list5;
            }
            result2.addAll(JSStubBasedPsiTreeUtil.calculateMeaningfulElements(element, (Set<? super PsiElement>)visited, stopAt, stopBefore));
        }
        List list6 = result2;
        if (list6 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(83);
        }
        return list6;
    }

    @NotNull
    public static PsiElement calculateTargetElement(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(84);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null, IS_TARGET);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(85);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateTargetElementForHighlighting(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(86);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null, SEMANTIC_HIGHLIGHTING_STOP_AT, SEMANTIC_HIGHLIGHTING_STOP_BEFORE);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(87);
        }
        return psiElement;
    }

    @NotNull
    private static Collection<PsiElement> getRequireCallReferencedElement(JSCallExpression initializer) {
        String referencePath;
        JSLiteralExpression argument = JSStubBasedPsiTreeUtil.findRequireCallArgument(initializer);
        String string = referencePath = argument != null ? argument.getSignificantValue() : null;
        if (referencePath == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(88);
            }
            return list2;
        }
        Collection<PsiElement> collection = JSStubBasedPsiTreeUtil.resolveRequireCallReference((PsiElement)initializer, StringUtil.unquoteString((String)referencePath));
        if (collection == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(89);
        }
        return collection;
    }

    @NotNull
    private static Collection<PsiElement> resolveRequireCallReference(@NotNull PsiElement context, @Nullable String unquotedModuleName) {
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(90);
        }
        if (unquotedModuleName == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(91);
            }
            return list2;
        }
        Collection<JSFile> files = CommonJSUtil.resolveReferencedElements(context, unquotedModuleName);
        if (files.isEmpty()) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(92);
            }
            return list3;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (JSFile file2 : files) {
            List candidates = ContainerUtil.newSmartList();
            if (JSAmdPsiUtil.isWithinAmdModule(context)) {
                JSFunctionExpression defaultAmdModule = JSAmdModulesIndex.findDefaultAmdModule(file2);
                if (defaultAmdModule != null) {
                    JSType returnType = defaultAmdModule.getReturnType();
                    if (returnType instanceof JSReferenceType) {
                        ContainerUtil.addIfNotNull((Collection)candidates, (Object)JSStubBasedPsiTreeUtil.resolveLocally(((JSReferenceType)returnType).getReferencedName(), (PsiElement)defaultAmdModule));
                    } else {
                        candidates.addAll(JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)defaultAmdModule, JSExpression.class));
                    }
                }
            } else {
                candidates.addAll(JSResolveUtil.getExportedElements(file2));
            }
            if (candidates.isEmpty()) {
                result2.add((PsiElement)file2);
                continue;
            }
            result2.addAll(candidates);
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(93);
        }
        return arrayList;
    }

    @Nullable
    public static JSLiteralExpression findRequireCallArgument(@NotNull JSCallExpression callExpression) {
        Collection<JSLiteralExpression> expressions;
        if (callExpression == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(94);
        }
        return (expressions = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)callExpression, JSStubElementTypes.LITERAL_EXPRESSION)).size() == 1 ? expressions.iterator().next() : null;
    }

    @Nullable
    public static PsiElement findAssociatedElement(@NotNull JSDocComment psiComment) {
        JSDefinitionExpression definitionExpression;
        if (psiComment == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(95);
        }
        PsiElement parent = psiComment.getContext();
        PsiElement next = null;
        if (parent instanceof JSProperty || parent instanceof JSFunction || parent instanceof JSVariable) {
            next = parent;
        } else if (parent instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)parent).getStubSafeVariables();
            if (variables.length > 0) {
                next = variables[0];
            }
        } else {
            JSDocComment nextDoc;
            next = JSStubBasedPsiTreeUtil.getNextSibling((PsiElement)psiComment);
            while (next instanceof PsiWhiteSpace) {
                next = JSStubBasedPsiTreeUtil.getNextSibling(next);
            }
            if (next != null && (nextDoc = JSStubBasedPsiTreeUtil.findDocComment(next)) != null && nextDoc != psiComment) {
                next = null;
            }
        }
        if (next instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)next).getDefinitionExpression()) != null) {
            next = definitionExpression;
        }
        return next;
    }

    @Nullable
    public static JSExpression findStubSafeChildExpression(StubBasedPsiElementBase<?> element) {
        StubElement stub = element.getStub();
        if (stub != null) {
            StubElement expressionStub = StubTreeUtil.findChildStubByType(stub, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
            return expressionStub != null ? (JSExpression)expressionStub.getPsi() : null;
        }
        ASTNode exprNode = element.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        return exprNode != null ? (JSExpression)exprNode.getPsi() : null;
    }

    public static Stream<? extends PsiElement> getFileOrModuleChildrenStream(@NotNull PsiElement fileOrModule) {
        if (fileOrModule == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(96);
        }
        return JSStubBasedPsiTreeUtil.getFilteredFileOrModuleChildrenStream(fileOrModule, null, null);
    }

    @NotNull
    public static <T extends PsiElement> Stream<T> getFilteredFileOrModuleChildrenStream(@NotNull PsiElement fileOrModule, @Nullable TokenSet stubSearchFilter, @Nullable Class<T> psiSearchFilter) {
        if (fileOrModule == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(97);
        }
        StubElement stub = null;
        if (fileOrModule instanceof PsiFileImpl) {
            stub = ((PsiFileImpl)fileOrModule).getGreenStub();
        } else if (fileOrModule instanceof JSStubElementImpl) {
            stub = ((JSStubElementImpl)fileOrModule).getGreenStub();
        }
        if (stub != null) {
            Stream<PsiElement> stream = stub.getChildrenStubs().stream().filter(el -> stubSearchFilter == null || stubSearchFilter.contains((IElementType)el.getStubType())).map(childStub -> childStub.getPsi());
            if (stream == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(98);
            }
            return stream;
        }
        JBIterable iterable = SyntaxTraverser.psiTraverser().children((Object)fileOrModule);
        if (psiSearchFilter != null) {
            iterable = iterable.filter(psiSearchFilter);
        }
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterable.iterator(), 16);
        Stream stream = StreamSupport.stream(spliterator, false);
        if (stream == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(99);
        }
        return stream;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctions(@NotNull PsiElement element, @Nullable PsiElement methodExpression, boolean includeRawSignatures) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(100);
        }
        Collection<JSFunctionWithSubstitutor> collection = JSStubBasedPsiTreeUtil.calculatePossibleFunctions(element, methodExpression, null, includeRawSignatures);
        if (collection == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(101);
        }
        return collection;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctions(@NotNull PsiElement element, @Nullable PsiElement methodExpression, @Nullable Set<PsiElement> visited, boolean includeRawSignatures) {
        Collection implicitElements;
        JSElementIndexingData data;
        JSExpression initializer;
        boolean isTypeScript;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(102);
        }
        if (element instanceof TypeScriptProxyImplicitElementWithBackingItem) {
            element = ((TypeScriptProxyImplicitElementWithBackingItem)element).getBackingElement();
        }
        if ((element = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element, visited, !(isTypeScript = DialectDetector.isTypeScript(element)) ? x -> false : el -> {
            if (DialectDetector.isTypeScript(el) && el instanceof JSTypeDeclarationOwner) {
                return ((JSTypeDeclarationOwner)el).getTypeElement() != null;
            }
            return false;
        })) instanceof JSFunctionItem) {
            if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadImplementation()) {
                List overloads = ((TypeScriptFunction)element).getOverloadDeclarations();
                List list2 = ContainerUtil.map((Collection)overloads, JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR);
                if (list2 == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(103);
                }
                return list2;
            }
            JSFunctionItem function = ((JSFunctionItem)element).isGetProperty() ? null : (JSFunctionItem)element;
            Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply(function);
            if (collection == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(104);
            }
            return collection;
        }
        if (element instanceof JSInitializerOwner && !isTypeScript) {
            initializer = ((JSInitializerOwner)element).getInitializerOrStub();
            if (initializer instanceof JSFunctionItem) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)initializer);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(105);
                }
                return collection;
            }
            if (initializer instanceof ES6Class) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)((ES6Class)initializer).getConstructor());
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(106);
                }
                return collection;
            }
        }
        if (element instanceof JSVariable) {
            if ((!isTypeScript || ((JSVariable)element).getTypeElement() == null) && (initializer = JSPsiImplUtils.getRightmostInitializer((JSInitializerOwner)((JSVariable)element))) instanceof JSFunctionItem) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)initializer);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(107);
                }
                return collection;
            }
            JSFunctionExpression constructsFunction = JSPsiImplUtils.findConstructsFunction(element);
            if (constructsFunction != null) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)constructsFunction);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(108);
                }
                return collection;
            }
            if (isTypeScript) {
                Collection<JSFunctionWithSubstitutor> collection = TypeScriptSignatureChooser.calculatePossibleFunctionForVariable((JSFieldVariable)((JSVariable)element), methodExpression, visited, includeRawSignatures);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(109);
                }
                return collection;
            }
        } else if (element instanceof JSField) {
            if (isTypeScript) {
                Collection<JSFunctionWithSubstitutor> collection = TypeScriptSignatureChooser.calculatePossibleFunctionForVariable((JSFieldVariable)((JSField)element), methodExpression, visited, includeRawSignatures);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(110);
                }
                return collection;
            }
        } else if (element instanceof JSProperty) {
            JSFunction value = ((JSProperty)element).tryGetFunctionInitializer();
            if (value != null) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)value);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(111);
                }
                return collection;
            }
        } else if (element instanceof JSDefinitionExpression) {
            initializer = ((JSDefinitionExpression)element).getInitializerOrStub();
            if (initializer instanceof JSFunctionItem) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)initializer);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(112);
                }
                return collection;
            }
            JSFunctionExpression constructsFunction = JSPsiImplUtils.findConstructsFunction(element);
            if (constructsFunction != null) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)constructsFunction);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(113);
                }
                return collection;
            }
        } else if (element instanceof JSImplicitElement) {
            PsiElement parent = element.getParent();
            if (parent instanceof JSLiteralExpressionImpl) {
                JSFunction function;
                JSProperty property;
                JSObjectLiteralExpression nextArgument = null;
                JSLiteralExpressionStub stub = (JSLiteralExpressionStub)((JSLiteralExpressionImpl)parent).getStub();
                if (stub != null) {
                    StubElement nextSibling = StubTreeUtil.getNextSibling(stub);
                    if (nextSibling instanceof JSObjectLiteralExpressionStub) {
                        nextArgument = (JSObjectLiteralExpression)((JSObjectLiteralExpressionStub)nextSibling).getPsi();
                    }
                } else {
                    JSExpression[] arguments;
                    PsiElement grandParent = parent.getParent();
                    if (grandParent instanceof JSArgumentList && (arguments = ((JSArgumentList)grandParent).getArguments()).length == 2 && arguments[0] == parent && arguments[1] instanceof JSObjectLiteralExpression) {
                        nextArgument = (JSObjectLiteralExpression)arguments[1];
                    }
                }
                if (nextArgument != null && (property = nextArgument.findProperty("construct")) != null && (function = property.tryGetFunctionInitializer()) != null) {
                    Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)function);
                    if (collection == null) {
                        JSStubBasedPsiTreeUtil.$$$reportNull$$$0(114);
                    }
                    return collection;
                }
            } else if (parent instanceof JSDocComment) {
                JSFunctionExpression constructsFunction;
                PsiElement associatedElement = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)parent);
                JSFunctionExpression jSFunctionExpression = constructsFunction = associatedElement != null ? JSPsiImplUtils.findConstructsFunction(associatedElement) : null;
                if (constructsFunction != null) {
                    Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)constructsFunction);
                    if (collection == null) {
                        JSStubBasedPsiTreeUtil.$$$reportNull$$$0(115);
                    }
                    return collection;
                }
            }
        } else if (element instanceof TypeScriptClass) {
            if (methodExpression != null || includeRawSignatures) {
                Collection<JSFunctionWithSubstitutor> collection = TypeScriptUtil.resolveConstructorFunctions((TypeScriptClass)element, methodExpression);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(116);
                }
                return collection;
            }
        } else {
            if (element instanceof ES6Class) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)((ES6Class)element).getConstructor());
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(117);
                }
                return collection;
            }
            if (element instanceof TypeScriptImportStatement) {
                Collection elements = ((TypeScriptImportStatement)element).findReferencedElements();
                if (visited == null) {
                    visited = new THashSet();
                }
                if (!visited.add((PsiElement)element)) {
                    List list3 = ContainerUtil.emptyList();
                    if (list3 == null) {
                        JSStubBasedPsiTreeUtil.$$$reportNull$$$0(118);
                    }
                    return list3;
                }
                ArrayList<JSFunctionWithSubstitutor> result2 = new ArrayList<JSFunctionWithSubstitutor>();
                for (PsiElement psiElement : elements) {
                    result2.addAll(JSStubBasedPsiTreeUtil.calculatePossibleFunctions(psiElement, methodExpression, (Set<PsiElement>)visited, includeRawSignatures));
                }
                ArrayList<JSFunctionWithSubstitutor> arrayList = result2;
                if (arrayList == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(119);
                }
                return arrayList;
            }
        }
        if (element instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)element).getIndexingData()) != null && (implicitElements = data.getImplicitElements()) != null) {
            for (JSImplicitElement implicitElement : implicitElements) {
                if (!(implicitElement instanceof JSImplicitFunctionImpl)) continue;
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSImplicitFunctionImpl)implicitElement);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(120);
                }
                return collection;
            }
        }
        List list4 = ContainerUtil.emptyList();
        if (list4 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(121);
        }
        return list4;
    }

    @NotNull
    public static <Key, Psi extends PsiElement> boolean processElementsForFile(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, @NotNull PsiFile scope, @NotNull Class<Psi> requiredClass, @NotNull Processor<? super Psi> processor) {
        if (indexKey == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(122);
        }
        if (key == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(123);
        }
        if (project == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(124);
        }
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(125);
        }
        if (requiredClass == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(126);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(127);
        }
        VirtualFile virtualFile = scope.getVirtualFile();
        IdFilter filter = null;
        if (virtualFile instanceof VirtualFileWithId) {
            final int fileId = ((VirtualFileWithId)virtualFile).getId();
            filter = new IdFilter(){

                public boolean containsFileId(int id) {
                    return fileId == id;
                }
            };
        }
        return StubIndex.getInstance().processElements(indexKey, key, project, GlobalSearchScope.fileScope((PsiFile)scope), filter, requiredClass, processor);
    }

    @Nullable
    public static <T, E extends Throwable> T forceAllowTreeLoading(@Nullable PsiFile psiFile, @NotNull ThrowableComputable<? extends T, E> computable) throws E {
        if (computable == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(128);
        }
        if (psiFile == null) {
            return (T)computable.compute();
        }
        return (T)AstLoadingFilter.forceAllowTreeLoading((PsiFile)psiFile, computable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 23: 
            case 26: 
            case 34: 
            case 37: 
            case 41: 
            case 54: 
            case 56: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 23: 
            case 26: 
            case 34: 
            case 37: 
            case 41: 
            case 54: 
            case 56: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 24: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 23: 
            case 26: 
            case 34: 
            case 37: 
            case 41: 
            case 54: 
            case 56: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil";
                break;
            }
            case 12: 
            case 18: 
            case 21: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 15: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: 
            case 59: 
            case 100: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 40: 
            case 44: 
            case 47: 
            case 61: 
            case 69: 
            case 72: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElements";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 76: 
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 73: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopBefore";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiComment";
                break;
            }
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrModule";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClass";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocallyWithMergedResults";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStubBasedNamesMap";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInStubScopeWithContext";
                break;
            }
            case 34: 
            case 37: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "findDescendants";
                break;
            }
            case 54: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "findReturnedExpressions";
                break;
            }
            case 63: 
            case 67: 
            case 70: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMeaningfulElement";
                break;
            }
            case 65: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMeaningfulElements";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateTargetElement";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateTargetElementForHighlighting";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequireCallReferencedElement";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveRequireCallReference";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredFileOrModuleChildrenStream";
                break;
            }
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocally";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocallyWithMergedResults";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 23: 
            case 26: 
            case 34: 
            case 37: 
            case 41: 
            case 54: 
            case 56: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInScope";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasStub";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isStubBased";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInScopeStubBased";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildStubBasedNamesMap";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInStubScopeWithContext";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableDeclaration";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "extractName";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getContextOfType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceLocally";
                break;
            }
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findDescendants";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addDescendantsRecursively";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findOwnDocComment";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findOwnDocCommentForStub";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getNextSibling";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSibling";
                break;
            }
            case 53: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findReturnedExpressions";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiChild";
                break;
            }
            case 62: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "calculateMeaningfulElement";
                break;
            }
            case 64: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "calculateMeaningfulElements";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "calculateTargetElement";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "calculateTargetElementForHighlighting";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "resolveRequireCallReference";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "findRequireCallArgument";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "findAssociatedElement";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getFileOrModuleChildrenStream";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredFileOrModuleChildrenStream";
                break;
            }
            case 100: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleFunctions";
                break;
            }
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "processElementsForFile";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "forceAllowTreeLoading";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "lambda$static$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 23: 
            case 26: 
            case 34: 
            case 37: 
            case 41: 
            case 54: 
            case 56: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

