/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSCacheableTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSInferDecoratorsContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Predicate;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptNarrowTypeByAssignmentOperation
extends JSCacheableTypeOperation {
    @NotNull
    private final JSTypeOperation myPrev;
    @NotNull
    private final Set<JSDecoratedType.TypeDecoration> myInitializerDecorators;
    @Nullable
    private final JSType myInitializerExpressionType;
    private final boolean myForInStatement;
    private final boolean myIsEmptyArray;
    private final boolean myHasInitializer;
    private final boolean myDeclarationPlace;
    private final boolean myReadWrite;

    public TypeScriptNarrowTypeByAssignmentOperation(@NotNull JSTypeOperation prev, @NotNull PsiElement element, @NotNull ReadWriteAccessDetector.Access access, @Nullable JSExpression initializer, boolean isDeclarationPlace) {
        if (prev == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(1);
        }
        if (access == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(2);
        }
        this.myPrev = prev;
        this.myReadWrite = access == ReadWriteAccessDetector.Access.ReadWrite;
        this.myInitializerDecorators = TypeScriptNarrowTypeByAssignmentOperation.getInitializerDecorators(element, initializer);
        this.myInitializerExpressionType = TypeScriptNarrowTypeByAssignmentOperation.getInitializerExpressionType(element, initializer);
        this.myForInStatement = element instanceof JSForInStatement;
        this.myHasInitializer = initializer != null || JSDestructuringUtil.hasDestructuringAssignment(element);
        this.myDeclarationPlace = isDeclarationPlace;
        this.myIsEmptyArray = this.myDeclarationPlace || JSTypeGuardUtil.isEmptyArrayExpression(initializer);
    }

    @Nullable
    private static JSType getInitializerExpressionType(@NotNull PsiElement element, @Nullable JSExpression initializer) {
        if (element == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(3);
        }
        if (initializer == null && element instanceof JSForInStatement) {
            JSExpression collectionExpression = ((JSForInStatement)element).getCollectionExpression();
            return collectionExpression == null ? null : JSTypeGuardUtil.getOperationType(collectionExpression);
        }
        return initializer == null ? null : JSTypeGuardUtil.getOperationType(initializer);
    }

    @NotNull
    public static Set<JSDecoratedType.TypeDecoration> getInitializerDecorators(@NotNull PsiElement element, @Nullable JSExpression initializer) {
        if (element == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(4);
        }
        if (JSDestructuringUtil.isDestructuring(element.getContext())) {
            Set<JSDecoratedType.TypeDecoration> set = Collections.emptySet();
            if (set == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(5);
            }
            return set;
        }
        if (initializer == null) {
            Set<JSDecoratedType.TypeDecoration> set = Collections.emptySet();
            if (set == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(6);
            }
            return set;
        }
        boolean isUndefined = JSSymbolUtil.isUndefinedExpression(initializer);
        if (isUndefined) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED);
            if (enumSet == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(7);
            }
            return enumSet;
        }
        boolean isNull = JSSymbolUtil.isNullLiteral(initializer);
        if (isNull) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_NULL);
            if (enumSet == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(8);
            }
            return enumSet;
        }
        if (TypeScriptNarrowTypeByAssignmentOperation.isNonEmptyExpression(initializer)) {
            if (initializer instanceof JSLiteralExpression) {
                EnumSet<JSDecoratedType.TypeDecoration> enumSet = JSTypeGuardChecker.NOTNULL_UNDEFINED_PRIMITIVE;
                if (enumSet == null) {
                    TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(9);
                }
                return enumSet;
            }
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = JSTypeGuardChecker.NOTNULL_NOTUNDEFINED;
            if (enumSet == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(10);
            }
            return enumSet;
        }
        Set<JSDecoratedType.TypeDecoration> set = Collections.emptySet();
        if (set == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(11);
        }
        return set;
    }

    @Override
    @NotNull
    protected JSType applyWithoutCache(@NotNull JSApplyTypeOperationContext context, @NotNull JSType type) {
        JSType rType;
        if (context == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(12);
        }
        if (type == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(13);
        }
        if (this.myReadWrite) {
            JSType jSType = JSTypeGuardUtil.getBaseTypeOfLiteralType(this.myPrev.apply(context, type));
            if (jSType == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        if (this.myInitializerExpressionType == null) {
            JSType jSType = this.myPrev.apply(context, type);
            if (jSType == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(15);
            }
            return jSType;
        }
        if (context.isAutoArrayType()) {
            JSType initializerType;
            if (this.myDeclarationPlace || this.myIsEmptyArray) {
                JSType jSType = context.getEvolvingArrayType(new TypeScriptNeverJSTypeImpl(context.getDefaultTypeSource()));
                if (jSType == null) {
                    TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(16);
                }
                return jSType;
            }
            if (this.myHasInitializer && (initializerType = this.evaluateInitializerType(context, this.myInitializerExpressionType)) != null) {
                JSType typeToUse = JSTypeGuardUtil.getBaseTypeOfLiteralType(initializerType);
                JSType jSType = TypeScriptTypeRelations.isTypeAssignableTo(typeToUse, context.getDeclaredType(), context.getProcessingContext()) ? typeToUse : JSNamedTypeFactory.createType("Array", context.getDefaultTypeSource(), JSContext.INSTANCE);
                if (jSType == null) {
                    TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(17);
                }
                return jSType;
            }
        }
        if ((rType = this.getAssignmentType(context, this.myInitializerExpressionType)) != null) {
            JSType jSType = rType;
            if (jSType == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(18);
            }
            return jSType;
        }
        JSType jSType = this.myPrev.apply(context, type);
        if (jSType == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(19);
        }
        return jSType;
    }

    @Nullable
    private JSType getAssignmentType(@NotNull JSApplyTypeOperationContext context, @NotNull JSType type) {
        JSType initializerType;
        JSType initializerType2;
        if (context == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(20);
        }
        if (type == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(21);
        }
        if (context.isAutoVariableType() && !this.myDeclarationPlace && (initializerType2 = this.evaluateInitializerType(context, type)) != null) {
            return JSTypeGuardUtil.getBaseTypeOfLiteralType(initializerType2);
        }
        JSType declared = context.getDeclaredType();
        if (declared instanceof JSUnionType && (initializerType = this.evaluateInitializerType(context, type)) != null) {
            return this.getAssignmentReducedType(context, (JSUnionType)declared, initializerType);
        }
        return declared;
    }

    @Override
    @NotNull
    protected Set<JSDecoratedType.TypeDecoration> inferTypeDecoratorsImpl(@NotNull JSInferDecoratorsContext context) {
        if (context == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(22);
        }
        Set<JSDecoratedType.TypeDecoration> set = this.myHasInitializer ? this.myInitializerDecorators : this.myPrev.inferTypeDecorators(context);
        if (set == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(23);
        }
        return set;
    }

    private static boolean isNonEmptyExpression(@Nullable JSExpression initializer) {
        return initializer instanceof JSLiteralExpression || initializer instanceof JSFunctionExpression || initializer instanceof JSObjectLiteralExpression || initializer instanceof JSArrayLiteralExpression || initializer instanceof JSClassExpression;
    }

    @Nullable
    protected JSType evaluateInitializerType(@NotNull JSApplyTypeOperationContext context, @NotNull JSType expressionType) {
        if (context == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(24);
        }
        if (expressionType == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(25);
        }
        JSType type = context.expandOperationType(expressionType);
        if (this.myForInStatement) {
            return JSTypeUtils.getIndexableComponentType(type);
        }
        return type;
    }

    @NotNull
    protected JSType getAssignmentReducedType(@NotNull JSApplyTypeOperationContext context, @NotNull JSUnionType currentType, @NotNull JSType assignmentType) {
        if (context == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(26);
        }
        if (currentType == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(27);
        }
        if (assignmentType == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(28);
        }
        if (TypeScriptTypeRelations.getCanonicalType(currentType).isEquivalentTo(TypeScriptTypeRelations.getCanonicalType(assignmentType), context.getProcessingContext(), true)) {
            JSUnionType jSUnionType = currentType;
            if (jSUnionType == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(29);
            }
            return jSUnionType;
        }
        if (assignmentType instanceof TypeScriptNeverJSTypeImpl) {
            JSType jSType = assignmentType;
            if (jSType == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(30);
            }
            return jSType;
        }
        if (assignmentType instanceof JSAnyType) {
            JSUnionType jSUnionType = currentType;
            if (jSUnionType == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(31);
            }
            return jSUnionType;
        }
        JSType resultType = TypeScriptTypeRelations.filterType(currentType, (Predicate<? super JSType>)((Predicate)el -> TypeScriptTypeRelations.typeMaybeAssignableTo(assignmentType, el, context.getProcessingContext())), (PsiElement)context.getContextReference());
        JSUnionType jSUnionType = resultType instanceof TypeScriptNeverJSTypeImpl ? currentType : resultType;
        if (jSUnionType == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(32);
        }
        return jSUnionType;
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.myPrev.toString() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/TypeScriptNarrowTypeByAssignmentOperation";
                break;
            }
            case 12: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/TypeScriptNarrowTypeByAssignmentOperation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializerDecorators";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "applyWithoutCache";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeDecoratorsImpl";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignmentReducedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInitializerExpressionType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInitializerDecorators";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyWithoutCache";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeDecoratorsImpl";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "evaluateInitializerType";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentReducedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

