/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLocalNamedType
extends JSNamedType {
    @NotNull
    private final JSQualifiedName myName;
    private final boolean myInheritsFunction;
    @NotNull
    private final NullableLazyValue<PsiElement> myLocalScope;

    protected JSLocalNamedType(@NotNull JSQualifiedName qualifiedName, @NotNull JSTypeSource source, @NotNull JSTypeContext jsTypeContext, boolean inheritsFunction) {
        if (qualifiedName == null) {
            JSLocalNamedType.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSLocalNamedType.$$$reportNull$$$0(1);
        }
        if (jsTypeContext == null) {
            JSLocalNamedType.$$$reportNull$$$0(2);
        }
        super(source, jsTypeContext);
        this.myLocalScope = NullableLazyValue.createValue(() -> JSTypeUtils.getLocalScopeFromSource(this));
        this.myName = qualifiedName;
        this.myInheritsFunction = inheritsFunction;
    }

    protected JSLocalNamedType(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSLocalNamedType.$$$reportNull$$$0(3);
        }
        if (inputStream == null) {
            JSLocalNamedType.$$$reportNull$$$0(4);
        }
        super(typeSource, inputStream);
        this.myLocalScope = NullableLazyValue.createValue(() -> JSTypeUtils.getLocalScopeFromSource(this));
        this.myName = JSQualifiedNameImpl.fromQualifiedName(JSTypeSerializer.readString(inputStream));
        this.myInheritsFunction = JSTypeSerializer.readBoolean(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSLocalNamedType.$$$reportNull$$$0(5);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeString(this.myName.getQualifiedName(), outputStream);
        JSTypeSerializer.writeBoolean(this.myInheritsFunction, outputStream);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSLocalNamedType.$$$reportNull$$$0(6);
        }
        return this.myName.equals(((JSLocalNamedType)type).myName) && Objects.equals(this.getLocalScope(), ((JSLocalNamedType)type).getLocalScope()) && this.myInheritsFunction == ((JSLocalNamedType)type).myInheritsFunction;
    }

    @Override
    @NotNull
    public JSQualifiedName getQualifiedName() {
        JSQualifiedName jSQualifiedName = this.myName;
        if (jSQualifiedName == null) {
            JSLocalNamedType.$$$reportNull$$$0(7);
        }
        return jSQualifiedName;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSLocalNamedType.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            JSLocalNamedType.$$$reportNull$$$0(9);
        }
        builder.append(this.myName.getQualifiedName());
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSLocalNamedType.$$$reportNull$$$0(10);
        }
        JSLocalNamedType jSLocalNamedType = new JSLocalNamedType(this.myName, source, this.getTypeContext(), this.myInheritsFunction);
        if (jSLocalNamedType == null) {
            JSLocalNamedType.$$$reportNull$$$0(11);
        }
        return jSLocalNamedType;
    }

    @Override
    @NotNull
    public JSNamespace copyWithTypeContext(@NotNull JSTypeContext typeContext) {
        if (typeContext == null) {
            JSLocalNamedType.$$$reportNull$$$0(12);
        }
        JSLocalNamedType jSLocalNamedType = new JSLocalNamedType(this.myName, this.getSource(), typeContext, this.myInheritsFunction);
        if (jSLocalNamedType == null) {
            JSLocalNamedType.$$$reportNull$$$0(13);
        }
        return jSLocalNamedType;
    }

    public boolean inheritsFunction() {
        return this.myInheritsFunction;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(super.resolvedHashCodeImpl(), this.getClass(), this.myInheritsFunction, this.myName, this.getLocalScope());
    }

    public boolean isLocal() {
        return true;
    }

    @Nullable
    public PsiElement getLocalScope() {
        return (PsiElement)this.myLocalScope.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsTypeContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSLocalNamedType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSLocalNamedType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithTypeContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyWithTypeContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

