/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptImplicitMemberForComputedProperty;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceUtil {
    public static boolean isReferenceTo(@NotNull PsiPolyVariantReference reference, @Nullable String referencedName, @NotNull PsiElement _element) {
        String elementName;
        if (reference == null) {
            JSReferenceUtil.$$$reportNull$$$0(0);
        }
        if (_element == null) {
            JSReferenceUtil.$$$reportNull$$$0(1);
        }
        if (_element instanceof TypeScriptImplicitMemberForComputedProperty) {
            TypeScriptImplicitMemberForComputedProperty _prop = (TypeScriptImplicitMemberForComputedProperty)_element;
            ResolveResult[] resolveResults = reference.multiResolve(false);
            return Arrays.stream(resolveResults).anyMatch(r -> r.getElement() instanceof TypeScriptImplicitMemberForComputedProperty && ((TypeScriptImplicitMemberForComputedProperty)r.getElement()).getName().equals(_prop.getName()) && ((TypeScriptImplicitMemberForComputedProperty)r.getElement()).getExplicitElement() == _prop.getExplicitElement());
        }
        if (_element instanceof TypeScriptProxyImplicitElement) {
            return JSReferenceUtil.isReferenceTo(reference, referencedName, ((TypeScriptProxyImplicitElement)_element).getExplicitElement());
        }
        if (_element instanceof JSImplicitElement) {
            elementName = ((JSImplicitElement)_element).getName();
        } else if (_element instanceof ES6ExportDefaultAssignment) {
            elementName = "default";
        } else if (_element instanceof JSNamedElement) {
            elementName = ((PsiNamedElement)_element).getName();
        } else if (_element instanceof XmlAttributeValue) {
            elementName = ((XmlAttributeValue)_element).getValue();
        } else if (_element instanceof PsiFile) {
            VirtualFile file2 = ((PsiFile)_element).getVirtualFile();
            elementName = file2 != null ? file2.getNameWithoutExtension() : null;
        } else if (_element instanceof PsiDirectoryContainer) {
            elementName = ((PsiNamedElement)_element).getName();
        } else if (_element instanceof JSNamedElementBase) {
            elementName = ((JSNamedElementBase)_element).getName();
        } else if (_element instanceof PsiNamedElement && "JAVA".equals(_element.getLanguage().getID()) && DialectDetector.languageDialectOfElement(reference.getElement()) == JavaScriptSupportLoader.NASHORN_JS) {
            elementName = ((PsiNamedElement)_element).getName();
        } else if (_element instanceof CssClass) {
            String className2 = ((CssClass)_element).getName();
            elementName = className2 != null ? CssClass.kebabToCamelCase((String)className2) : className2;
        } else if (_element instanceof JsonProperty) {
            elementName = ((JsonProperty)_element).getName();
        } else {
            return false;
        }
        if (!Comparing.equal((String)referencedName, (String)elementName, (boolean)true)) {
            return false;
        }
        ResolveResult[] resolveResults = reference.multiResolve(false);
        if (JSResolveResult.isTooManyCandidatesResult(resolveResults)) {
            if (reference instanceof JSReferenceExpressionImpl) {
                ResolveCache.PolyVariantResolver<JSReferenceExpressionImpl> resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)((JSReferenceExpressionImpl)reference)).createReferenceExpressionResolver((JSReferenceExpressionImpl)reference, true);
                if (resolver instanceof JSReferenceExpressionResolver) {
                    ((JSReferenceExpressionResolver)resolver).setLimitingScopeFile(_element.getContainingFile());
                }
                resolveResults = resolver.resolve((PsiPolyVariantReference)((JSReferenceExpressionImpl)reference), false);
            } else {
                return false;
            }
        }
        return JSReferenceUtil.isReferenceTo(reference, _element, resolveResults);
    }

    private static boolean isReferenceTo(@NotNull PsiPolyVariantReference reference, @NotNull PsiElement _element, @NotNull ResolveResult[] resolveResults) {
        ProjectFileIndex index;
        PsiFile containingFile;
        if (reference == null) {
            JSReferenceUtil.$$$reportNull$$$0(2);
        }
        if (_element == null) {
            JSReferenceUtil.$$$reportNull$$$0(3);
        }
        if (resolveResults == null) {
            JSReferenceUtil.$$$reportNull$$$0(4);
        }
        boolean processingSourceRefFromLibrary = false;
        if (_element instanceof JSNamedElement && (containingFile = _element.getContainingFile()) != null && containingFile.getVirtualFile() != null && !DialectDetector.isTypeScript(_element) && (index = ProjectRootManager.getInstance((Project)containingFile.getProject()).getFileIndex()).isInLibrarySource(containingFile.getVirtualFile())) {
            processingSourceRefFromLibrary = true;
        }
        if (_element instanceof JSImplicitElement) {
            return JSReferenceUtil.checkImplicitElement(_element, resolveResults);
        }
        boolean skipDynamicResults = false;
        boolean skipAnyResults = false;
        boolean skipDynamicResultsCalculated = false;
        for (ResolveResult r : resolveResults) {
            ResolveResult[] results;
            PsiReference variableReference;
            JSVariable variable;
            PsiElement parent;
            PsiElement resolvedElement;
            if ((!skipDynamicResultsCalculated || skipDynamicResults || skipAnyResults) && reference instanceof JSReferenceExpression) {
                if (!skipDynamicResultsCalculated) {
                    PsiFile containingFile2 = reference.getElement().getContainingFile();
                    if (containingFile2.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
                        JSAttributeList attributeList;
                        JSExpression qualifier = ((JSReferenceExpressionImpl)reference).getResolveQualifier();
                        JSClass jsClass = null;
                        if (qualifier != null) {
                            String expressionType = ActionScriptResolveUtil.getQualifiedExpressionType(qualifier, containingFile2);
                            if ("*".equals(expressionType)) {
                                skipAnyResults = true;
                            } else if (expressionType != null) {
                                PsiElement qName;
                                PsiElement psiElement = qName = expressionType != null ? JSClassResolver.findClassFromNamespace(expressionType, (PsiElement)containingFile2) : null;
                                if (qName instanceof JSClass) {
                                    jsClass = (JSClass)qName;
                                }
                            }
                        } else {
                            jsClass = JSResolveUtil.getClassOfContext(reference.getElement());
                        }
                        if (jsClass != null && (attributeList = jsClass.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC)) {
                            skipDynamicResults = true;
                        }
                    }
                    skipDynamicResultsCalculated = true;
                }
                if (!r.isValidResult() && skipDynamicResults || skipAnyResults) continue;
            }
            if ((resolvedElement = r.getElement()) instanceof TypeScriptProxyImplicitElement) {
                resolvedElement = ((TypeScriptProxyImplicitElement)resolvedElement).getExplicitElement();
            }
            if (resolvedElement instanceof JSVariable && (parent = (variable = (JSVariable)resolvedElement).getParent()) instanceof JSDestructuringShorthandedProperty && (variableReference = parent.getReference()) instanceof JSDestructuringPropertyReference && (results = ((JSDestructuringPropertyReference)variableReference).multiResolve(false)).length > 0) {
                if (JSReferenceUtil.checkElementsAreEquialent(_element, resolvedElement)) {
                    return true;
                }
                PsiElement finalResolveElement = resolvedElement;
                Collection filteredResult = Arrays.stream(results).filter(result2 -> result2 != null && result2.isValidResult()).map(ResolveResult::getElement).filter(psiElementResult -> psiElementResult != null && psiElementResult != finalResolveElement).collect(Collectors.toList());
                if (filteredResult.size() == 1) {
                    resolvedElement = (PsiElement)ContainerUtil.getFirstItem((Collection)filteredResult);
                }
            }
            if (resolvedElement instanceof JSOffsetBasedImplicitElement) {
                resolvedElement = ((JSOffsetBasedImplicitElement)resolvedElement).getElementAtOffset();
            }
            if (resolvedElement == null) continue;
            if (processingSourceRefFromLibrary) {
                resolvedElement = resolvedElement.getNavigationElement();
            }
            if (JSReferenceUtil.checkElementsAreEquialent(_element, resolvedElement)) {
                return true;
            }
            if (resolvedElement instanceof JSFunctionExpression) {
                ASTNode treeParent;
                ASTNode nameIdentifier = ((JSFunctionExpression)resolvedElement).findNameIdentifier();
                if (nameIdentifier != null && ((treeParent = nameIdentifier.getTreeParent()).getPsi() == _element || treeParent.getTreeParent().getPsi() == _element)) {
                    return true;
                }
            } else if (JSClassUtils.isPossibleHierarchyMember(resolvedElement)) {
                if (JSResolveUtil.isConstructorFunction(resolvedElement) && _element instanceof JSClass && _element.isEquivalentTo((PsiElement)JSUtils.getMemberContainingClass(resolvedElement)) && !JSResolveUtil.isSelfReference(reference.getElement())) {
                    return true;
                }
                if (JSClassUtils.isPossibleHierarchyMember(_element)) {
                    JSClass resolvedElementParent = JSUtils.getMemberContainingClass(resolvedElement);
                    JSClass elementParent = JSUtils.getMemberContainingClass(_element);
                    if (elementParent != null && resolvedElementParent != null && !JSResolveUtil.isSelfReference(reference.getElement()) && JSInheritanceUtil.checkMemberHierarchyIncludeClass((JSPsiElementBase)resolvedElement, elementParent)) {
                        return true;
                    }
                }
            }
            if (TypeScriptPsiUtil.isImplementationAndOverloadFunction(_element, resolvedElement)) {
                return true;
            }
            if (!(resolvedElement instanceof JSClass) && !(resolvedElement instanceof JSNamespaceDeclaration) && !(resolvedElement instanceof JSFunction) && !(resolvedElement instanceof JSVariable) || (!(_element instanceof XmlFile) || resolvedElement.getParent().getContainingFile() != _element) && (!(_element instanceof JSFile) || reference.getElement().getParent() == resolvedElement || !JSReferenceUtil.isPublicEntityReferenceToJSFile(resolvedElement, _element))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkElementsAreEquialent(@NotNull PsiElement _element, @NotNull PsiElement resolvedElement) {
        if (_element == null) {
            JSReferenceUtil.$$$reportNull$$$0(5);
        }
        if (resolvedElement == null) {
            JSReferenceUtil.$$$reportNull$$$0(6);
        }
        return resolvedElement.isEquivalentTo(_element) || _element.isEquivalentTo(resolvedElement) || (_element instanceof JSProperty || _element instanceof XmlAttributeValue) && resolvedElement.getParent() == _element;
    }

    private static boolean isPublicEntityReferenceToJSFile(PsiElement resolvedElement, PsiElement element) {
        PsiElement parent = resolvedElement.getParent();
        if (parent instanceof JSVarStatement) {
            parent = parent.getParent();
        }
        return parent instanceof JSPackageStatement && parent.getParent() == element;
    }

    private static boolean checkImplicitElement(PsiElement _element, ResolveResult[] resolveResults) {
        for (ResolveResult resolveResult : resolveResults) {
            PsiElement resolved = resolveResult.getElement();
            if (_element.isEquivalentTo(resolved)) {
                return true;
            }
            if (!(resolved instanceof TypeScriptProxyImplicitElement) || !_element.isEquivalentTo(((TypeScriptProxyImplicitElement)resolved).getExplicitElement())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasValidResolveResult(@NotNull PsiReference reference) {
        if (reference == null) {
            JSReferenceUtil.$$$reportNull$$$0(7);
        }
        if (reference instanceof PsiMultiReference) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ((PsiMultiReference)reference).multiResolve(false)) {
                if (!result2.isValidResult()) continue;
                return true;
            }
            return false;
        }
        return reference.resolve() != null;
    }

    @NotNull
    public static TextRange getRangeWithoutQuotes(@NotNull PsiElement quoted) {
        if (quoted == null) {
            JSReferenceUtil.$$$reportNull$$$0(8);
        }
        TextRange textRange = new TextRange(1, quoted.getTextLength() - 1);
        if (textRange == null) {
            JSReferenceUtil.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoted";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSReferenceUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSReferenceUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeWithoutQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkElementsAreEquialent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasValidResolveResult";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRangeWithoutQuotes";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

