/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPsiElementFactory {
    @NotNull
    public static JSExpression createJSExpression(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            JSPsiElementFactory.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSPsiElementFactory.$$$reportNull$$$0(1);
        }
        JSExpression jSExpression = JSPsiElementFactory.createJSExpression(text, context, JSExpression.class);
        if (jSExpression == null) {
            JSPsiElementFactory.$$$reportNull$$$0(2);
        }
        return jSExpression;
    }

    @NotNull
    public static <T extends JSExpression> T createJSExpression(@NotNull String text, @NotNull PsiElement context, @NotNull Class<T> expressionClass) {
        if (text == null) {
            JSPsiElementFactory.$$$reportNull$$$0(3);
        }
        if (context == null) {
            JSPsiElementFactory.$$$reportNull$$$0(4);
        }
        if (expressionClass == null) {
            JSPsiElementFactory.$$$reportNull$$$0(5);
        }
        PsiElement psi = JSInheritedLanguagesHelper.getConfigurableProvider(context).createExpressionFromText(text, context);
        JSPsiElementFactory.assertNotNull(text, psi, expressionClass, context.getLanguage());
        JSExpression jSExpression = (JSExpression)JSPsiElementFactory.assertInstanceOf(expressionClass, psi);
        if (jSExpression == null) {
            JSPsiElementFactory.$$$reportNull$$$0(6);
        }
        return (T)jSExpression;
    }

    @NotNull
    public static JSStatement createJSStatement(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            JSPsiElementFactory.$$$reportNull$$$0(7);
        }
        if (context == null) {
            JSPsiElementFactory.$$$reportNull$$$0(8);
        }
        JSStatement jSStatement = JSPsiElementFactory.createJSSourceElement(text, context, JSStatement.class);
        if (jSStatement == null) {
            JSPsiElementFactory.$$$reportNull$$$0(9);
        }
        return jSStatement;
    }

    @NotNull
    public static <T extends JSStatement> T createJSStatement(@NotNull String text, @NotNull PsiElement context, @NotNull Class<T> statementClass) {
        if (text == null) {
            JSPsiElementFactory.$$$reportNull$$$0(10);
        }
        if (context == null) {
            JSPsiElementFactory.$$$reportNull$$$0(11);
        }
        if (statementClass == null) {
            JSPsiElementFactory.$$$reportNull$$$0(12);
        }
        JSStatement jSStatement = (JSStatement)JSPsiElementFactory.createJSSourceElement(text, context, statementClass);
        if (jSStatement == null) {
            JSPsiElementFactory.$$$reportNull$$$0(13);
        }
        return (T)jSStatement;
    }

    @NotNull
    public static JSClass createJSClass(@NotNull String text, @NotNull PsiElement context) {
        JSLanguageDialect dialect;
        if (text == null) {
            JSPsiElementFactory.$$$reportNull$$$0(14);
        }
        if (context == null) {
            JSPsiElementFactory.$$$reportNull$$$0(15);
        }
        if ((dialect = DialectDetector.languageDialectOfElement(context)) != null && dialect.getOptionHolder().isECMA4) {
            JSClass jSClass = (JSClass)Objects.requireNonNull(JSChangeUtil.createStatementFromText(context.getProject(), text, dialect)).getPsi();
            if (jSClass == null) {
                JSPsiElementFactory.$$$reportNull$$$0(16);
            }
            return jSClass;
        }
        JSClass jSClass = JSPsiElementFactory.createJSSourceElement(text, context, JSClass.class);
        if (jSClass == null) {
            JSPsiElementFactory.$$$reportNull$$$0(17);
        }
        return jSClass;
    }

    @NotNull
    public static JSSourceElement createJSSourceElement(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            JSPsiElementFactory.$$$reportNull$$$0(18);
        }
        if (context == null) {
            JSPsiElementFactory.$$$reportNull$$$0(19);
        }
        JSSourceElement jSSourceElement = JSPsiElementFactory.createJSSourceElement(text, context, JSSourceElement.class);
        if (jSSourceElement == null) {
            JSPsiElementFactory.$$$reportNull$$$0(20);
        }
        return jSSourceElement;
    }

    @NotNull
    public static <T extends JSSourceElement> T createJSSourceElement(@NotNull String text, @NotNull PsiElement context, @NotNull Class<T> statementClass) {
        if (text == null) {
            JSPsiElementFactory.$$$reportNull$$$0(21);
        }
        if (context == null) {
            JSPsiElementFactory.$$$reportNull$$$0(22);
        }
        if (statementClass == null) {
            JSPsiElementFactory.$$$reportNull$$$0(23);
        }
        ASTNode statement = JSChangeUtil.createStatementFromTextWithContext(text, context);
        JSPsiElementFactory.assertNotNull(text, statement, statementClass, context.getLanguage());
        JSSourceElement jSSourceElement = (JSSourceElement)JSPsiElementFactory.assertInstanceOf(statementClass, statement.getPsi());
        if (jSSourceElement == null) {
            JSPsiElementFactory.$$$reportNull$$$0(24);
        }
        return (T)jSSourceElement;
    }

    @NotNull
    public static TypeScriptType createTypeScriptType(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            JSPsiElementFactory.$$$reportNull$$$0(25);
        }
        if (context == null) {
            JSPsiElementFactory.$$$reportNull$$$0(26);
        }
        TypeScriptType typeScriptType = JSPsiElementFactory.createTypeScriptType(text, context, TypeScriptType.class);
        if (typeScriptType == null) {
            JSPsiElementFactory.$$$reportNull$$$0(27);
        }
        return typeScriptType;
    }

    @NotNull
    public static <T extends TypeScriptType> T createTypeScriptType(@NotNull String text, @NotNull PsiElement context, @NotNull Class<T> typeClass) {
        if (text == null) {
            JSPsiElementFactory.$$$reportNull$$$0(28);
        }
        if (context == null) {
            JSPsiElementFactory.$$$reportNull$$$0(29);
        }
        if (typeClass == null) {
            JSPsiElementFactory.$$$reportNull$$$0(30);
        }
        PsiElement typeElement = JSChangeUtil.tryCreateTypeElement(text, context);
        TypeScriptType typeScriptType = (TypeScriptType)JSPsiElementFactory.assertInstanceOf(typeClass, typeElement);
        if (typeScriptType == null) {
            JSPsiElementFactory.$$$reportNull$$$0(31);
        }
        return (T)typeScriptType;
    }

    @NotNull
    public static PsiElement createParameterOrVariableItem(@NotNull String destruct, @NotNull PsiElement context, boolean isCatchBlock, boolean isParameter) {
        PsiElement declaration;
        PsiElement elementFromProvider;
        if (destruct == null) {
            JSPsiElementFactory.$$$reportNull$$$0(32);
        }
        if (context == null) {
            JSPsiElementFactory.$$$reportNull$$$0(33);
        }
        if ((elementFromProvider = JSInheritedLanguagesHelper.getConfigurableProvider(context).createParameterOrVariableItem(destruct, context)) != null) {
            declaration = elementFromProvider;
        } else if (isCatchBlock) {
            declaration = ((JSDestructuringArray)Objects.requireNonNull(((JSDestructuringParameter)JSChangeUtil.createParameter("[" + destruct + "]", context)).getTarget())).getElements()[0];
        } else if (isParameter) {
            declaration = JSChangeUtil.createParameter(destruct, context);
        } else {
            JSVarStatement statement = JSPsiElementFactory.createJSStatement("var " + destruct, context, JSVarStatement.class);
            declaration = statement.getDeclarations()[0];
        }
        PsiElement psiElement = declaration;
        if (psiElement == null) {
            JSPsiElementFactory.$$$reportNull$$$0(34);
        }
        return psiElement;
    }

    @NotNull
    public static JSDocComment createJSDocComment(@NotNull String toCreate, @NotNull PsiElement context) {
        if (toCreate == null) {
            JSPsiElementFactory.$$$reportNull$$$0(35);
        }
        if (context == null) {
            JSPsiElementFactory.$$$reportNull$$$0(36);
        }
        JSDocComment jSDocComment = JSPsiElementFactory.createPsiComment(toCreate, context, JSDocComment.class);
        if (jSDocComment == null) {
            JSPsiElementFactory.$$$reportNull$$$0(37);
        }
        return jSDocComment;
    }

    @NotNull
    public static PsiComment createPsiComment(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            JSPsiElementFactory.$$$reportNull$$$0(38);
        }
        if (context == null) {
            JSPsiElementFactory.$$$reportNull$$$0(39);
        }
        PsiComment psiComment = JSPsiElementFactory.createPsiComment(text, context, PsiComment.class);
        if (psiComment == null) {
            JSPsiElementFactory.$$$reportNull$$$0(40);
        }
        return psiComment;
    }

    @NotNull
    private static <T> T createPsiComment(@NotNull String text, @NotNull PsiElement context, @NotNull Class<T> clazz) {
        if (text == null) {
            JSPsiElementFactory.$$$reportNull$$$0(41);
        }
        if (context == null) {
            JSPsiElementFactory.$$$reportNull$$$0(42);
        }
        if (clazz == null) {
            JSPsiElementFactory.$$$reportNull$$$0(43);
        }
        ASTNode node = JSChangeUtil.createJSTreeFromTextWithContext(text, context);
        JSPsiElementFactory.assertNotNull(text, node, clazz, context.getLanguage());
        T t = JSPsiElementFactory.assertInstanceOf(clazz, node.getPsi());
        if (t == null) {
            JSPsiElementFactory.$$$reportNull$$$0(44);
        }
        return t;
    }

    @Contract(value="_, null, _, _ -> fail")
    private static void assertNotNull(String text, Object expression, Class expressionClass, Language language) {
        assert (expression != null) : "cannot create a " + expressionClass.getName() + " from text: " + text + "; language: " + language.getID() + ", " + language.getDisplayName();
    }

    @Contract(value="_, null -> fail")
    private static <T> T assertInstanceOf(Class<T> expectedClass, @Nullable PsiElement psi) {
        Object result2 = ObjectUtils.tryCast((Object)psi, expectedClass);
        assert (result2 != null) : "expected to create: " + expectedClass.getName() + " but created: " + JSPsiElementFactory.describePsi(psi);
        return (T)result2;
    }

    private static String describePsi(PsiElement psi) {
        return psi == null ? "[psi is null]" : psi.getClass().getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 24: 
            case 27: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 24: 
            case 27: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 22: 
            case 26: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 24: 
            case 27: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSPsiElementFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionClass";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementClass";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeClass";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destruct";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCreate";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSPsiElementFactory";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSExpression";
                break;
            }
            case 9: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSStatement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSClass";
                break;
            }
            case 20: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSSourceElement";
                break;
            }
            case 27: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeScriptType";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterOrVariableItem";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSDocComment";
                break;
            }
            case 40: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsiComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createJSExpression";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 24: 
            case 27: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 44: {
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createJSStatement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createJSClass";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createJSSourceElement";
                break;
            }
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createTypeScriptType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createParameterOrVariableItem";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createJSDocComment";
                break;
            }
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createPsiComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 24: 
            case 27: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

