/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.frameworks.flow.validation.FlowJSAnnotatorCheckerProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.ES6AddExportModifierIntention;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.fixes.ES6ConvertDefaultImportToSpecifierFix;
import com.intellij.lang.javascript.validation.fixes.ES6ConvertSpecifierToDefaultFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J/\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0004J\"\u0010%\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0004\u00a8\u0006&"}, d2={"Lcom/intellij/lang/javascript/modules/ES6CheckImportInspection;", "Lcom/intellij/lang/javascript/inspections/JSInspection;", "()V", "addSpecifierError", "", "node", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportSpecifier;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "elementForError", "Lcom/intellij/psi/PsiElement;", "name", "", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getDefaultLevel", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "getFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "importExportPart", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportDeclarationPart;", "resolveResult", "resolveProblemKey", "(Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportDeclarationPart;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lcom/intellij/codeInspection/LocalQuickFix;", "isSpecialReactSvgImport", "", "fromClause", "Lcom/intellij/lang/ecmascript6/psi/ES6FromClause;", "isUnresolvedFromPart", "visitES6ImportedBindingImpl", "importedBinding", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportedBinding;", "visitSpecifierImpl", "intellij.javascript.impl"})
public class ES6CheckImportInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        if (FlowJSAnnotatorCheckerProvider.isServiceActive((PsiElement)holder.getFile())) {
            JSElementVisitor jSElementVisitor = JSElementVisitor.NOP_ELEMENT_VISITOR;
            Intrinsics.checkExpressionValueIsNotNull((Object)jSElementVisitor, (String)"JSElementVisitor.NOP_ELEMENT_VISITOR");
            return (PsiElementVisitor)jSElementVisitor;
        }
        return (PsiElementVisitor)new JSElementVisitor(this, holder){
            final /* synthetic */ ES6CheckImportInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitES6ImportedBinding(@NotNull ES6ImportedBinding importedBinding) {
                Intrinsics.checkParameterIsNotNull((Object)importedBinding, (String)"importedBinding");
                if (!DialectDetector.isES6((PsiElement)importedBinding)) {
                    return;
                }
                ES6CheckImportInspection.visitES6ImportedBindingImpl$default(this.this$0, importedBinding, this.$holder, null, 4, null);
            }

            public void visitES6ImportExportSpecifier(@NotNull ES6ImportExportSpecifier specifier) {
                Intrinsics.checkParameterIsNotNull((Object)specifier, (String)"specifier");
                if (!DialectDetector.isES6((PsiElement)specifier)) {
                    return;
                }
                ES6CheckImportInspection.visitSpecifierImpl$default(this.this$0, this.$holder, specifier, null, 4, null);
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightDisplayLevel, (String)"HighlightDisplayLevel.WEAK_WARNING");
        return highlightDisplayLevel;
    }

    protected final void visitES6ImportedBindingImpl(@NotNull ES6ImportedBinding importedBinding, @NotNull ProblemsHolder holder, @NotNull ProblemHighlightType problemHighlightType) {
        Intrinsics.checkParameterIsNotNull((Object)importedBinding, (String)"importedBinding");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)problemHighlightType, (String)"problemHighlightType");
        if (importedBinding.isNamespaceImport()) {
            return;
        }
        ES6ImportDeclaration parent = importedBinding.getDeclaration();
        if (parent != null) {
            Collection collection = importedBinding.findReferencedElements();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"importedBinding.findReferencedElements()");
            Collection referencedElements = collection;
            ES6FromClause fromClause = parent.getFromClause();
            if (fromClause != null && referencedElements.isEmpty()) {
                Collection collection2 = fromClause.resolveReferencedElements();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"fromClause.resolveReferencedElements()");
                Collection modules = collection2;
                PsiElement module = (PsiElement)ContainerUtil.getFirstItem((Collection)modules);
                if (modules.size() == 1 && module instanceof JSFile && ((JSFile)module).getModuleStatus() == JSFile.ModuleStatus.ES6) {
                    PsiElement psiElement = importedBinding.getNameIdentifier();
                    if (psiElement == null) {
                        psiElement = (PsiElement)importedBinding;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"importedBinding.nameIdentifier ?: importedBinding");
                    PsiElement elementForError = psiElement;
                    LocalQuickFix[] localQuickFixArray = this.getFixes((ES6ImportExportDeclarationPart)importedBinding, null, null);
                    holder.registerProblem(elementForError, JSBundle.message((String)"es6.default.export.not.declared", (Object[])new Object[0]), problemHighlightType, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                }
            }
        }
    }

    public static /* synthetic */ void visitES6ImportedBindingImpl$default(ES6CheckImportInspection eS6CheckImportInspection, ES6ImportedBinding eS6ImportedBinding, ProblemsHolder problemsHolder, ProblemHighlightType problemHighlightType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: visitES6ImportedBindingImpl");
        }
        if ((n & 4) != 0) {
            problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        eS6CheckImportInspection.visitES6ImportedBindingImpl(eS6ImportedBinding, problemsHolder, problemHighlightType);
    }

    protected final void visitSpecifierImpl(@NotNull ProblemsHolder holder, @NotNull ES6ImportExportSpecifier node, @NotNull ProblemHighlightType problemHighlightType) {
        ES6FromClause fromClause;
        ES6ImportExportDeclaration declaration;
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)problemHighlightType, (String)"problemHighlightType");
        ES6ImportExportDeclaration eS6ImportExportDeclaration = declaration = node.getDeclaration();
        Object object = fromClause = eS6ImportExportDeclaration != null ? eS6ImportExportDeclaration.getFromClause() : null;
        if (fromClause == null || this.isUnresolvedFromPart(fromClause) || this.isSpecialReactSvgImport(node, fromClause)) {
            return;
        }
        ResolveResult[] resolveResultArray = node.multiResolve(false);
        Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"node.multiResolve(false)");
        ResolveResult[] results = resolveResultArray;
        PsiElement psiElement = node.getReferenceNameElement();
        if (psiElement == null) {
            psiElement = (PsiElement)node;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"node.referenceNameElement ?: node");
        PsiElement elementForError = psiElement;
        ResolveResult[] resolveResultArray2 = results;
        boolean bl = false;
        if (resolveResultArray2.length == 0) {
            this.addSpecifierError(node, holder, elementForError, node.getReferenceName(), problemHighlightType);
        } else {
            List<PsiElement> list2 = JSResolveResult.toElements(results);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"JSResolveResult.toElements(results)");
            List<PsiElement> elements = list2;
            Collection collection = elements;
            int n = 0;
            if (!collection.isEmpty()) {
                return;
            }
            for (ResolveResult result2 : results) {
                String resolveProblemKey;
                if (!(result2 instanceof JSResolveResult) || (resolveProblemKey = ((JSResolveResult)result2).getResolveProblemKey()) == null) continue;
                LocalQuickFix[] fixes = this.getFixes((ES6ImportExportDeclarationPart)node, ((JSResolveResult)result2).getElement(), resolveProblemKey);
                holder.registerProblem(elementForError, JSBundle.message((String)resolveProblemKey, (Object[])new Object[0]), problemHighlightType, Arrays.copyOf(fixes, fixes.length));
                return;
            }
            this.addSpecifierError(node, holder, elementForError, node.getReferenceName(), problemHighlightType);
        }
    }

    public static /* synthetic */ void visitSpecifierImpl$default(ES6CheckImportInspection eS6CheckImportInspection, ProblemsHolder problemsHolder, ES6ImportExportSpecifier eS6ImportExportSpecifier, ProblemHighlightType problemHighlightType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: visitSpecifierImpl");
        }
        if ((n & 4) != 0) {
            problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        eS6CheckImportInspection.visitSpecifierImpl(problemsHolder, eS6ImportExportSpecifier, problemHighlightType);
    }

    private final boolean isSpecialReactSvgImport(ES6ImportExportSpecifier node, ES6FromClause fromClause) {
        String string = fromClause.getReferenceText();
        if (string == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fromClause.referenceText ?: return false");
        String referenceText = string;
        String string2 = JSStringUtil.unquoteStringLiteralValue(referenceText);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JSStringUtil.unquoteStri\u2026teralValue(referenceText)");
        if (StringsKt.endsWith$default((String)string2, (String)".svg", (boolean)false, (int)2, null)) {
            String specifierName = node.getReferenceName();
            return Intrinsics.areEqual((Object)"ReactComponent", (Object)specifierName);
        }
        return false;
    }

    private final boolean isUnresolvedFromPart(ES6FromClause fromClause) {
        String string = JSStringUtil.unquoteStringLiteralValue(StringUtil.notNullize((String)fromClause.getReferenceText()));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSStringUtil.unquoteStri\u2026romClause.referenceText))");
        CharSequence charSequence = string;
        boolean bl = false;
        return charSequence.length() > 0 && fromClause.resolveReferencedElements().isEmpty();
    }

    private final void addSpecifierError(ES6ImportExportSpecifier node, ProblemsHolder holder, PsiElement elementForError, String name, ProblemHighlightType problemHighlightType) {
        LocalQuickFix[] localQuickFixArray = this.getFixes((ES6ImportExportDeclarationPart)node, null, null);
        holder.registerProblem(elementForError, JSBundle.message((String)"es6.validate.import.error", (Object[])new Object[]{name}), problemHighlightType, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
    }

    private final LocalQuickFix[] getFixes(ES6ImportExportDeclarationPart importExportPart, PsiElement resolveResult, String resolveProblemKey) {
        LocalQuickFixAndIntentionActionOnPsiElement fix = null;
        if (importExportPart instanceof ES6ImportSpecifier) {
            fix = new ES6ConvertSpecifierToDefaultFix((ES6ImportSpecifier)importExportPart);
        } else if (importExportPart instanceof ES6ImportedBinding) {
            fix = new ES6ConvertDefaultImportToSpecifierFix((ES6ImportedBinding)importExportPart);
        }
        if (fix != null && fix.isAvailable(importExportPart.getProject(), null, importExportPart.getContainingFile())) {
            return new LocalQuickFix[]{(LocalQuickFix)fix};
        }
        if (Intrinsics.areEqual((Object)resolveProblemKey, (Object)"javascript.element.need.to.be.exported") && resolveResult instanceof JSNamedElement) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
            LocalQuickFixOnPsiElement localQuickFixOnPsiElement = ES6AddExportModifierIntention.createFixForElement((JSNamedElement)resolveResult);
            Intrinsics.checkExpressionValueIsNotNull((Object)localQuickFixOnPsiElement, (String)"ES6AddExportModifierInte\u2026ForElement(resolveResult)");
            localQuickFixArray[0] = (LocalQuickFix)localQuickFixOnPsiElement;
            return localQuickFixArray;
        }
        LocalQuickFix[] localQuickFixArray = JSReferenceChecker.getCreateFixesForUnresolvedRef(importExportPart);
        Intrinsics.checkExpressionValueIsNotNull((Object)localQuickFixArray, (String)"JSReferenceChecker.getCr\u2026lvedRef(importExportPart)");
        return localQuickFixArray;
    }
}

