/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.config;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigFileType;
import com.intellij.lang.javascript.linter.jscs.config.JscsOption;
import com.intellij.lang.javascript.linter.jscs.config.JscsOptionDescriptor;
import com.intellij.lang.javascript.linter.jscs.config.ValueType;
import com.intellij.lang.javascript.linter.jshint.config.JSHintOptionCompletionObject;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsConfigFileCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        block9: {
            JscsOptionDescriptor.ValueDescription description;
            boolean topLevel;
            JscsOptionDescriptor descriptor2;
            Convertor valueConvertor;
            block10: {
                block11: {
                    PsiElement position;
                    PsiFile containingFile;
                    if (parameters == null) {
                        JscsConfigFileCompletionContributor.$$$reportNull$$$0(0);
                    }
                    if (result2 == null) {
                        JscsConfigFileCompletionContributor.$$$reportNull$$$0(1);
                    }
                    if ((containingFile = (position = parameters.getPosition()).getContainingFile()) == null) {
                        return;
                    }
                    PsiFile originalFile = containingFile.getOriginalFile();
                    VirtualFile vFile = originalFile.getViewProvider().getVirtualFile();
                    if (!((Object)((Object)JscsConfigFileType.INSTANCE)).equals(vFile.getFileType())) break block9;
                    PsiElement positionParent = position.getParent();
                    boolean insideStringLiteral = JSLinterConfigFileUtil.isStringLiteral(positionParent);
                    valueConvertor = o -> {
                        if (insideStringLiteral) {
                            return o;
                        }
                        return StringUtil.wrapWithDoubleQuote((String)o);
                    };
                    JsonPosition jsonPosition = JscsConfigFileCompletionContributor.findPosition(position);
                    List<String> propChain = jsonPosition.getPropChain();
                    if (propChain.isEmpty()) {
                        return;
                    }
                    descriptor2 = JscsConfigFileCompletionContributor.findOptionDescriptor(jsonPosition, !jsonPosition.isValue());
                    boolean bl = topLevel = jsonPosition.getPropChain().size() == 1;
                    if (!jsonPosition.isValue()) break block10;
                    if (!topLevel) break block11;
                    JscsOption jscsOption = JscsOption.safeValueOf(propChain.get(0));
                    if (jscsOption == null) {
                        return;
                    }
                    JscsConfigFileCompletionContributor.fillVariantsInsideValue(parameters, result2, (Convertor<String, String>)valueConvertor, jscsOption.getDescriptor());
                    break block9;
                }
                if (descriptor2 == null) break block9;
                JscsConfigFileCompletionContributor.fillVariantsInsideValue(parameters, result2, (Convertor<String, String>)valueConvertor, descriptor2);
                break block9;
            }
            if (topLevel) {
                JscsConfigFileCompletionContributor.completePropertyNames(result2, (Convertor<String, String>)valueConvertor);
            } else if (descriptor2 != null && (description = descriptor2.getTypes().get((Object)ValueType.obj)) instanceof JscsOptionDescriptor.ValuesObject) {
                Set<Map.Entry<String, JscsOptionDescriptor>> entries = ((JscsOptionDescriptor.ValuesObject)description).getFields().entrySet();
                for (Map.Entry<String, JscsOptionDescriptor> entry : entries) {
                    JscsConfigFileCompletionContributor.addPropertyNameCompletionVariant(result2, (Convertor<String, String>)valueConvertor, entry.getKey(), entry.getValue().getDescription());
                }
            }
        }
    }

    private static void fillVariantsInsideValue(CompletionParameters parameters, CompletionResultSet result2, Convertor<String, String> valueConvertor, JscsOptionDescriptor descriptor2) {
        ArrayList<String> variants = new ArrayList<String>();
        PsiElement position = parameters.getPosition();
        PsiElement positionParent = position.getParent();
        boolean insideStringLiteral = JSLinterConfigFileUtil.isStringLiteral(positionParent);
        boolean isInArray = JSLinterConfigFileUtil.isArray(positionParent.getParent()) || insideStringLiteral && JSLinterConfigFileUtil.isArray(positionParent.getParent().getParent());
        JscsOptionDescriptor.ValueDescription strDescr = descriptor2.getTypes().get((Object)ValueType.str);
        JscsOptionDescriptor.ValueDescription arrDescr = descriptor2.getTypes().get((Object)ValueType.array);
        if (strDescr instanceof JscsOptionDescriptor.ValuesCollection) {
            JscsConfigFileCompletionContributor.addCollectionsVariants(valueConvertor, variants, (JscsOptionDescriptor.ValuesCollection)strDescr);
        }
        if (arrDescr instanceof JscsOptionDescriptor.ValuesCollection) {
            JscsConfigFileCompletionContributor.addCollectionsVariants(valueConvertor, variants, (JscsOptionDescriptor.ValuesCollection)arrDescr);
        }
        if (!insideStringLiteral && !isInArray && descriptor2.getTypes().containsKey((Object)ValueType.bool)) {
            variants.add(Boolean.TRUE.toString());
        }
        if (!insideStringLiteral && !isInArray && descriptor2.getTypes().containsKey((Object)ValueType.true_or_false)) {
            variants.add(Boolean.TRUE.toString());
            variants.add(Boolean.FALSE.toString());
        }
        for (String variant : variants) {
            LookupElementBuilder builder = LookupElementBuilder.create((String)variant);
            result2.addElement((LookupElement)builder);
        }
        JSLinterConfigFileUtil.skipOtherCompletionContributors(parameters, result2);
    }

    private static void addCollectionsVariants(Convertor<String, String> valueConvertor, List<String> variants, JscsOptionDescriptor.ValuesCollection strDescr) {
        String[] values = strDescr.getArrValues();
        if (values != null) {
            for (String value : values) {
                value = "\t".equals(value) ? "\\t" : value;
                variants.add((String)valueConvertor.convert((Object)value));
            }
        }
    }

    private static void completePropertyNames(CompletionResultSet result2, Convertor<String, String> valueConvertor) {
        for (JscsOption option : JscsOption.values()) {
            JscsConfigFileCompletionContributor.addPropertyNameCompletionVariant(result2, valueConvertor, option.name(), option.getDescription());
        }
    }

    private static void addPropertyNameCompletionVariant(@NotNull CompletionResultSet result2, Convertor<String, String> valueConvertor, String variant, final @Nullable String description) {
        if (result2 == null) {
            JscsConfigFileCompletionContributor.$$$reportNull$$$0(2);
        }
        String lookupString = (String)valueConvertor.convert((Object)variant);
        LookupElementBuilder builder = LookupElementBuilder.create((Object)new JSHintOptionCompletionObject(lookupString), (String)lookupString);
        if (description != null) {
            builder = builder.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

                public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                    presentation.setItemText(element.getLookupString());
                    presentation.setTypeGrayed(true);
                    presentation.setTypeText(description);
                }
            });
        }
        result2.addElement((LookupElement)builder);
    }

    private static JscsOptionDescriptor findOptionDescriptor(JsonPosition position, boolean forParent) {
        int bound;
        List<String> chain = position.getPropChain();
        if (chain.isEmpty()) {
            return null;
        }
        if (chain.size() == 1) {
            return null;
        }
        JscsOption option = JscsOption.safeValueOf(chain.get(0));
        if (option == null) {
            return null;
        }
        JscsOptionDescriptor descriptor2 = option.getDescriptor();
        JscsOptionDescriptor.ValueDescription description = option.getDescriptor().getTypes().get((Object)ValueType.obj);
        int n = bound = forParent ? chain.size() - 1 : chain.size();
        for (int idx = 1; idx < bound; ++idx) {
            if (!(description instanceof JscsOptionDescriptor.ValuesObject)) {
                return null;
            }
            descriptor2 = ((JscsOptionDescriptor.ValuesObject)description).getFields().get(chain.get(idx));
            if (descriptor2 == null) {
                return null;
            }
            description = descriptor2.getTypes().get((Object)ValueType.obj);
        }
        return descriptor2;
    }

    private static JsonPosition findPosition(PsiElement element) {
        JsonProperty property;
        PsiElement position = element;
        JsonStringLiteral value = (JsonStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)element, JsonStringLiteral.class, (boolean)false);
        JsonProperty firstProp = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        boolean isValue = firstProp != null && (value == null && firstProp.getNameElement() != element.getParent() || value != null && value != firstProp.getNameElement());
        ArrayList<String> names = new ArrayList<String>();
        while (position != null && (property = JSLinterConfigFileUtil.getProperty(position.getParent())) != null) {
            names.add(property.getName());
            position = property;
        }
        Collections.reverse(names);
        return new JsonPosition(names, isValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addPropertyNameCompletionVariant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JsonPosition {
        private final List<String> myPropChain;
        private final boolean myIsValue;

        JsonPosition(List<String> propChain, boolean isValue) {
            this.myPropChain = propChain;
            this.myIsValue = isValue;
        }

        public List<String> getPropChain() {
            return this.myPropChain;
        }

        public boolean isValue() {
            return this.myIsValue;
        }
    }
}

