/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptModifierIntention
extends JavaScriptIntention
implements LowPriorityAction {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(1);
        }
        return super.isAvailable(project, editor, element) && DialectDetector.isTypeScript(element) && (this.checkForField(element) || this.checkForFunction(project, element));
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSVariable field;
        if (project == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(3);
        }
        if ((field = this.getField(element)) != null) {
            this.invokeForField(field);
            return;
        }
        TypeScriptFunction method = this.getFunction(element);
        if (method != null) {
            this.invokeForFunction(project, (JSFunction)method);
        }
    }

    private void invokeForField(@NotNull JSVariable field) {
        if (field == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(4);
        }
        JSVisibilityUtil.Options defaultVisibilityOptions = JSVisibilityUtil.DEFAULT_OPTIONS;
        JSAttributeList.AccessType newVisibility = this.getInspectionAccessType();
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> ReferencesSearch.search((PsiElement)field, (SearchScope)field.getUseScope()).forEach(reference -> {
            if (reference instanceof JSElement) {
                JSRefactoringConflictsUtil.checkAccessibility((JSAttributeListOwner)field, null, newVisibility.toString(), (PsiElement)((JSElement)reference), (MultiMap<PsiElement, String>)conflicts, true, defaultVisibilityOptions);
            }
        })), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, field.getProject())) {
            return;
        }
        if (!BaseRefactoringProcessor.processConflicts((Project)field.getProject(), (MultiMap)conflicts)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)field, newVisibility, null));
    }

    private void invokeForFunction(@NotNull Project project, @NotNull JSFunction method) {
        if (project == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(5);
        }
        if (method == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(6);
        }
        if ((method = this.getParentFunction(method, project)) == null) {
            return;
        }
        JSParameterInfo[] infos = (JSParameterInfo[])ContainerUtil.toArray(JSMethodDescriptor.getParameters(method), JSParameterInfo.ARRAY_FACTORY);
        JSType type = method.getReturnType();
        String stringType = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
        PsiElement returnTypeElement = method.getReturnTypeElement();
        JSChangeSignatureProcessor processor = new JSChangeSignatureProcessor(method, this.getInspectionAccessType(), method.getName(), returnTypeElement == null ? null : stringType, infos, Collections.emptySet(), Collections.emptySet());
        processor.setPrepareSuccessfulSwingThreadCallback(() -> {});
        processor.run();
    }

    @Nullable
    protected JSFunction getParentFunction(@Nullable JSFunction method, @NotNull Project project) {
        if (project == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(7);
        }
        if (method == null) {
            return null;
        }
        Map<JSClass, JSPsiElementBase> map = JSInheritanceUtil.findDeclaringClassesMap((JSQualifiedNamedElement)method);
        if (map.size() != 1) {
            return method;
        }
        Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(map.entrySet());
        if (item == null) {
            return method;
        }
        JSPsiElementBase value = (JSPsiElementBase)item.getValue();
        if (!(value instanceof JSFunction)) {
            return null;
        }
        if (value.equals(method)) {
            return method;
        }
        return this.getParentFunction((JSFunction)value, project);
    }

    protected boolean checkForFunction(@NotNull Project project, @NotNull PsiElement element) {
        JSClass parentClass;
        TypeScriptFunction function;
        if (project == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(8);
        }
        if (element == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(9);
        }
        if ((function = this.getFunction(element)) == null || function.getAttributeList() == null || function.isConstructor()) {
            return false;
        }
        JSClass jsClass = JSUtils.getMemberContainingClass((PsiElement)function);
        if (jsClass == null || jsClass.isInterface()) {
            return false;
        }
        JSFunction parentFunction = this.getParentFunction((JSFunction)function, project);
        if (parentFunction != function && ((parentClass = JSUtils.getMemberContainingClass((PsiElement)parentFunction)) == null || parentClass.isInterface())) {
            return false;
        }
        if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)function, JSAttributeList.ModifierType.ABSTRACT) && this.getInspectionAccessType() == JSAttributeList.AccessType.PRIVATE) {
            return false;
        }
        JSAttributeList.AccessType modifier = this.getCurrentModifier((JSAttributeListOwner)function);
        return modifier != this.getInspectionAccessType();
    }

    protected boolean checkForField(@NotNull PsiElement element) {
        JSVariable field;
        if (element == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(10);
        }
        if ((field = this.getField(element)) == null || field.getAttributeList() == null) {
            return false;
        }
        JSAttributeList.AccessType modifier = this.getCurrentModifier((JSAttributeListOwner)field);
        if (modifier == this.getInspectionAccessType()) {
            return false;
        }
        if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)field, JSAttributeList.ModifierType.ABSTRACT) && this.getInspectionAccessType() == JSAttributeList.AccessType.PRIVATE) {
            return false;
        }
        Collection<JSPsiElementBase> members = JSInheritanceUtil.findTopMembers((JSQualifiedNamedElement)field);
        return members.stream().anyMatch(el -> el == field);
    }

    @Nullable
    protected JSAttributeList.AccessType getCurrentModifier(@NotNull JSAttributeListOwner owner) {
        JSAttributeList list2;
        if (owner == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(11);
        }
        if ((list2 = owner.getAttributeList()) == null) {
            return null;
        }
        return list2.getAccessType();
    }

    @Nullable
    protected JSVariable getField(@NotNull PsiElement current) {
        JSVariable variable;
        if (current == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(12);
        }
        if ((variable = JavaScriptIntention.findParentVariable(current, JSVariable.class)) == null) {
            return null;
        }
        return JSUtils.isMember((PsiElement)variable) ? variable : null;
    }

    @Nullable
    protected TypeScriptFunction getFunction(@NotNull PsiElement current) {
        if (current == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(13);
        }
        return JavaScriptIntention.findParentNamedElement(current, TypeScriptFunction.class);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"typescript.fix.change.member.access", (Object[])new Object[]{JSVisibilityUtil.accessTypeToKeyword(this.getInspectionAccessType(), DialectOptionHolder.TS)});
        if (string == null) {
            TypeScriptModifierIntention.$$$reportNull$$$0(15);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public abstract JSAttributeList.AccessType getInspectionAccessType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invokeForField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeForFunction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParentFunction";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkForFunction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkForField";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentModifier";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFunction";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

