/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSUnnecessarySemicolonInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.unnecessary.semicolon.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSUnnecessarySemicolonInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSEmptyStatement(JSEmptyStatement node) {
                ASTNode astNode;
                ASTNode start;
                PsiElement parent = node.getParent();
                if (parent instanceof JSLoopStatement || parent instanceof JSIfStatement) {
                    return;
                }
                if (parent instanceof JSFile && parent.getContext() == null) {
                    PsiElement prevSibling;
                    JSEmptyStatement elt = node;
                    while ((prevSibling = elt.getPrevSibling()) != null && (prevSibling instanceof PsiWhiteSpace || prevSibling instanceof PsiComment)) {
                        elt = prevSibling;
                    }
                    if (parent.getFirstChild() == elt) {
                        return;
                    }
                }
                ASTNode aSTNode = start = (astNode = node.getNode()).getFirstChildNode() == astNode.getLastChildNode() && astNode.getFirstChildNode() != null ? astNode : TreeUtil.findChildBackward((ASTNode)astNode, (IElementType)JSTokenTypes.SEMICOLON);
                if (start != null) {
                    LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("js.unnecessary.semicolon.fix.name", true, start.getPsi(), start.getPsi());
                    holder.registerProblem(start.getPsi(), JSBundle.message((String)"js.unnecessary.semicolon.problem", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                }
            }
        };
        if (jSElementVisitor == null) {
            JSUnnecessarySemicolonInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSUnnecessarySemicolonInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

