/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSMethodToImplement;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSHierarchyProcessor;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSClosureCompilerSyntaxInspection
extends JSInspection {
    private static final Pattern TYPE_VALUE_PATTERN = Pattern.compile("\\{\\s*(.*)\\s*}");
    private static final int MAGIC_INITIAL_CAPACITY = 3;

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.closure.compiler.syntax.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(2);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSDocComment(JSDocComment docComment) {
                String className2;
                if (!DialectDetector.isJavaScript((PsiElement)docComment)) {
                    return;
                }
                PsiElement errorElement = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)docComment);
                THashSet commentInterfaces = new THashSet();
                boolean hasImplements = false;
                boolean hasExtends = false;
                for (JSDocTag tag : docComment.getTags()) {
                    JSDocumentationUtils.DocTag docTag = JSDocumentationUtils.getDocTag(tag.getText());
                    if (docTag == null) continue;
                    if (docTag.type == JSDocumentationProcessor.MetaDocType.IMPLEMENTS) {
                        hasImplements = true;
                        JSDocTagValue tagValue = tag.getValue();
                        if (tagValue == null) continue;
                        JSType type = JSTypeUtils.createType(docTag.matchName, JSTypeSourceFactory.createTypeSource((PsiElement)docComment, true));
                        if (type instanceof JSGenericTypeImpl) {
                            type = ((JSGenericTypeImpl)type).getType();
                        }
                        if (!(type instanceof JSTypeImpl)) continue;
                        JSResolvedTypeInfo info = ((JSTypeImpl)type).resolveType();
                        Collection<? extends PsiElement> declarations = info.getDeclarations();
                        boolean hasResolvedInterfaces = false;
                        for (PsiElement psiElement : declarations) {
                            String name2;
                            if (!(psiElement instanceof JSElementBase) || ((JSElementBase)psiElement).isClassOrInterface() != JSElementBase.ClassOrInterface.INTERFACE || (name2 = ((JSElementBase)psiElement).getQualifiedName()) == null) continue;
                            commentInterfaces.add(name2);
                            hasResolvedInterfaces = true;
                        }
                        if (hasResolvedInterfaces || JSSymbolUtil.isInterface(type.getTypeText(JSType.TypeTextFormat.SIMPLE), (PsiElement)docComment)) {
                            commentInterfaces.add(docTag.matchName);
                            continue;
                        }
                        holder.registerProblem((PsiElement)tagValue, JSBundle.message((String)"js.closure.compiler.syntax.implements.not.interface", (Object[])new Object[]{docTag.matchName}), new LocalQuickFix[0]);
                        continue;
                    }
                    if (docTag.type == JSDocumentationProcessor.MetaDocType.EXTENDS) {
                        hasExtends = true;
                        continue;
                    }
                    this.checkTypeInDocTag(tag, docTag);
                }
                String qualifiedClassName = className2 = docComment.findNameOfClassAppliedTo();
                JSQualifiedName namespace = docComment.getNamespace();
                if (namespace != null && className2 != null && className2.indexOf(46) == -1) {
                    qualifiedClassName = namespace.getQualifiedName() + "." + className2;
                }
                if (className2 != null && (hasImplements || hasExtends)) {
                    PsiElement elementToHighlight = errorElement != null ? errorElement : docComment;
                    OrderedSet implementedInterfaces = new OrderedSet();
                    OrderedSet classesInHierarchy = new OrderedSet();
                    implementedInterfaces.addAll((Collection)commentInterfaces);
                    JSClosureCompilerSyntaxInspection.collectHierarchyMembers(qualifiedClassName, docComment, (OrderedSet<? super String>)implementedInterfaces, (OrderedSet<? super String>)classesInHierarchy, (Consumer<? super String>)((Consumer)s -> JSClosureCompilerSyntaxInspection.reportCyclicReference(holder, elementToHighlight, s)), (Set<String>)commentInterfaces);
                    if (JSSymbolUtil.isInterface(qualifiedClassName, (PsiElement)docComment)) {
                        return;
                    }
                    GlobalSearchScope scope = JSResolveUtil.getResolveScope(elementToHighlight);
                    Function classMembersCollector = name -> JSClassResolver.getInstance().findNamespaceMembers((String)name, scope);
                    JSClosureCompilerSyntaxInspection.processUnimplementedMethods(className2, elementToHighlight, (Set)implementedInterfaces, (Set)classesInHierarchy, classMembersCollector, t -> t, holder);
                }
            }

            private void checkTypeInDocTag(@NotNull JSDocTag psiTag, JSDocumentationUtils.DocTag tag) {
                if (psiTag == null) {
                    1.$$$reportNull$$$0(0);
                }
                String type = JSDocumentationProcessor.TYPE_AS_VALUE_TAGS.contains((Object)tag.type) ? tag.matchValue : (JSDocumentationProcessor.NAMEPATH_AS_NAME_TAGS.contains((Object)tag.type) ? tag.matchName : null);
                JSDocTagValue value = psiTag.getValue();
                if (value != null && type != null) {
                    if (type.trim().isEmpty()) {
                        holder.registerProblem((PsiElement)value, JSBundle.message((String)"js.closure.compiler.syntax.empty.type", (Object[])new Object[0]), new LocalQuickFix[0]);
                    } else {
                        boolean parsedCorrectly;
                        boolean bl = parsedCorrectly = (tag.type == JSDocumentationProcessor.MetaDocType.PARAMETER ? new JSTypeParser(type, JSTypeSource.EMPTY).parseParameterType() : new JSTypeParser(type, JSTypeSource.EMPTY).parse()) != null;
                        if (!parsedCorrectly) {
                            Matcher matcher = TYPE_VALUE_PATTERN.matcher(value.getText());
                            if (matcher.matches()) {
                                TextRange range = new TextRange(matcher.start(1), matcher.end(1));
                                holder.registerProblem((PsiElement)value, range, JSBundle.message((String)"js.closure.compiler.syntax.invalid.type", (Object[])new Object[0]), new LocalQuickFix[0]);
                            } else {
                                holder.registerProblem((PsiElement)value, JSBundle.message((String)"js.closure.compiler.syntax.invalid.type", (Object[])new Object[0]), new LocalQuickFix[0]);
                            }
                        }
                    }
                }
            }

            public void visitJSNewExpression(JSNewExpression node) {
                super.visitJSNewExpression(node);
                if (!DialectDetector.isJavaScript((PsiElement)node)) {
                    return;
                }
                JSExpression expression = node.getMethodExpression();
                if (expression instanceof JSReferenceExpression) {
                    JSDocComment docComment;
                    PsiElement resolveResult = ((JSReferenceExpression)expression).resolve();
                    if (resolveResult == null) {
                        return;
                    }
                    JSElementBase classOrInterface = (JSElementBase)ObjectUtils.tryCast((Object)JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult), JSElementBase.class);
                    if (classOrInterface == null) {
                        return;
                    }
                    if (classOrInterface.isClassOrInterface() == JSElementBase.ClassOrInterface.INTERFACE) {
                        holder.registerProblem((PsiElement)expression, JSBundle.message((String)"javascript.interface.can.not.be.instantiated.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                    } else if (classOrInterface.isClassOrInterface() == JSElementBase.ClassOrInterface.CLASS && (docComment = JSClosureCompilerSyntaxInspection.findDocComment((JSElement)classOrInterface)) != null && docComment.hasAbstractTag()) {
                        holder.registerProblem((PsiElement)expression, JSBundle.message((String)"javascript.abstract.class.can.not.be.instantiated.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitJSParameterList(JSParameterList node) {
                if (!DialectDetector.isJavaScript((PsiElement)node)) {
                    return;
                }
                boolean foundRest = false;
                for (JSParameterListElement parameter : node.getParameters()) {
                    if (parameter.getTypeDecorator().isRest() && !parameter.isRest()) {
                        foundRest = true;
                        continue;
                    }
                    if (!foundRest) continue;
                    holder.registerProblem((PsiElement)parameter, JSBundle.message((String)"javascript.validation.message.parameter.is.not.allowed.after.rest.parameter", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            public void visitJSClass(JSClass aClass) {
                if (!DialectDetector.isJavaScript((PsiElement)aClass)) {
                    return;
                }
                JSDocComment docComment = JSClosureCompilerSyntaxInspection.findDocComment((JSElement)aClass);
                if (docComment != null && docComment.hasAbstractTag()) {
                    return;
                }
                Set<JSClass> superClasses = JSClosureCompilerSyntaxInspection.collectSuperClasses(aClass);
                JSClosureCompilerSyntaxInspection.processUnimplementedMethods(aClass, (PsiElement)aClass, Collections.emptySet(), superClasses, superClass -> Arrays.asList(superClass.getFunctions()), JSClass::getName, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiTag", "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection$1", "checkTypeInDocTag"));
            }
        };
        if (jSElementVisitor == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(3);
        }
        return jSElementVisitor;
    }

    public static void collectHierarchyMembers(final @Nullable String typeName, final JSDocComment docComment, final OrderedSet<? super String> implementedInterfaces, final OrderedSet<? super String> classesInHierarchy, final Consumer<? super String> highlightCyclicReference, final Set<String> commentInterfaces) {
        if (typeName == null) {
            return;
        }
        classesInHierarchy.add((Object)typeName);
        JSTypeEvaluateManager.iterateTypeHierarchy(typeName, new JSHierarchyProcessor(){

            @Override
            public boolean processNamespace(String serializedType, VirtualFile file2) {
                String qName = JSTypeUtils.getTypeMatchingNamespace(serializedType);
                this.processQName(qName);
                return true;
            }

            @Override
            public boolean processClass(@NotNull JSClass clazz) {
                String name;
                if (clazz == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((name = clazz.getQualifiedName()) != null) {
                    this.processQName(name);
                }
                return true;
            }

            @Override
            public boolean processObjectLiteral(JSObjectLiteralExpression objectLiteral) {
                return true;
            }

            private void processQName(@NotNull String qName) {
                if (qName == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (typeName.equals(qName)) {
                    highlightCyclicReference.consume((Object)typeName);
                } else if (commentInterfaces.contains(qName) || JSSymbolUtil.isInterface(qName, (PsiElement)docComment)) {
                    implementedInterfaces.add((Object)qName);
                } else {
                    classesInHierarchy.add((Object)qName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processQName";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (PsiElement)docComment, true, false, false);
    }

    private static void reportCyclicReference(ProblemsHolder holder, PsiElement elementToHighlight, String className2) {
        holder.registerProblem(elementToHighlight, JSBundle.message((String)"js.closure.compiler.syntax.cyclic.inheritance", (Object[])new Object[]{className2}), new LocalQuickFix[0]);
    }

    @NotNull
    public static Set<JSClass> collectSuperClasses(JSClass aClass) {
        OrderedSet superClasses = new OrderedSet();
        JSClassUtils.processClassesInHierarchy(aClass, false, (arg_0, arg_1, arg_2) -> JSClosureCompilerSyntaxInspection.lambda$collectSuperClasses$0((Set)superClasses, arg_0, arg_1, arg_2));
        OrderedSet orderedSet = superClasses;
        if (orderedSet == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(4);
        }
        return orderedSet;
    }

    public static String getNotImplementedTextId(boolean isAbstract, boolean isGetter, boolean isSetter) {
        String key;
        String string = key = isAbstract ? "abstract" : "interface";
        if (isGetter) {
            return "javascript.validation.message." + key + ".get.accessor.not.implemented";
        }
        if (isSetter) {
            return "javascript.validation.message." + key + ".set.accessor.not.implemented";
        }
        return "javascript.validation.message." + key + ".method.not.implemented";
    }

    private static <T> void processUnimplementedMethods(@NotNull T sourceClass, @NotNull PsiElement errorElement, @NotNull Set<? extends T> implementedInterfaces, @NotNull Set<? extends T> classesInHierarchy, @NotNull Function<? super T, ? extends Collection<JSPsiElementBase>> getClassMethods, @NotNull Function<? super T, String> getName, @NotNull ProblemsHolder holder) {
        JSSourceElement parent;
        List<JSMethodToImplement> notImplemented;
        if (sourceClass == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(5);
        }
        if (errorElement == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(6);
        }
        if (implementedInterfaces == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(7);
        }
        if (classesInHierarchy == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(8);
        }
        if (getClassMethods == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(9);
        }
        if (getName == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(11);
        }
        if (!(notImplemented = JSClosureCompilerSyntaxInspection.getNotImplementedMethods(sourceClass, implementedInterfaces, classesInHierarchy, getClassMethods, getName)).isEmpty() && (parent = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)errorElement, JSSourceElement.class, (boolean)false)) != null) {
            THashMap notImplementedNames = new THashMap(notImplemented.size());
            for (int i = 0; i < notImplemented.size(); ++i) {
                PsiElement nameIdentifier;
                LocalQuickFix[] fix;
                LocalQuickFix[] localQuickFixArray;
                JSMethodToImplement toImplement = notImplemented.get(i);
                JSMethodToImplement.MethodKey notImplementedName = toImplement.getKey();
                notImplementedNames.put(notImplementedName, toImplement);
                String key = JSClosureCompilerSyntaxInspection.getNotImplementedTextId(toImplement.isAbstractMethod(), toImplement.isGetAccessor(), toImplement.isSetAccessor());
                String message = JSBundle.message((String)key, (Object[])new Object[]{toImplement.getName(), toImplement.getBaseClassName()});
                String className2 = (String)getName.fun(sourceClass);
                if (className2 == null) {
                    className2 = "<doc>";
                }
                if (i == notImplemented.size() - 1) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = JSFixFactory.getInstance().implementJSDocMethodsFix(className2, (Map<JSMethodToImplement.MethodKey, JSMethodToImplement>)notImplementedNames);
                } else {
                    localQuickFixArray = fix = LocalQuickFix.EMPTY_ARRAY;
                }
                if (errorElement instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)errorElement).getNameIdentifier()) != null) {
                    errorElement = nameIdentifier;
                }
                holder.registerProblem(errorElement, message, fix);
            }
        }
    }

    @NotNull
    public static <T> List<JSMethodToImplement> getNotImplementedMethods(@NotNull T sourceClass, @NotNull Set<? extends T> implementedInterfaces, @NotNull Set<? extends T> classesInHierarchy, @NotNull Function<? super T, ? extends Collection<JSPsiElementBase>> getClassMethods, @NotNull Function<? super T, String> getName) {
        if (sourceClass == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(12);
        }
        if (implementedInterfaces == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(13);
        }
        if (classesInHierarchy == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(14);
        }
        if (getClassMethods == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(15);
        }
        if (getName == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(16);
        }
        THashMap methodsToImplement = new THashMap();
        HashSet<JSMethodToImplement.MethodKey> implementedMethods = new HashSet<JSMethodToImplement.MethodKey>(3);
        for (T superClass : classesInHierarchy) {
            for (JSPsiElementBase member : (Collection)getClassMethods.fun(superClass)) {
                if (member.getJSContext() == JSContext.STATIC) continue;
                JSDocComment docComment = JSClosureCompilerSyntaxInspection.findDocComment((JSElement)member);
                if (docComment != null && docComment.hasAbstractTag() && !sourceClass.equals(superClass)) {
                    methodsToImplement.putIfAbsent(JSMethodToImplement.MethodKey.create((JSElement)member), new JSMethodToImplement(member, true, (String)getName.fun(superClass)));
                    continue;
                }
                implementedMethods.add(JSMethodToImplement.MethodKey.create((JSElement)member));
            }
        }
        for (T implementedInterface : implementedInterfaces) {
            for (JSPsiElementBase member : (Collection)getClassMethods.fun(implementedInterface)) {
                if (member.getJSContext() != JSContext.INSTANCE) continue;
                methodsToImplement.putIfAbsent(JSMethodToImplement.MethodKey.create((JSElement)member), new JSMethodToImplement(member, false, (String)getName.fun(implementedInterface)));
            }
        }
        ArrayList<JSMethodToImplement> notImplemented = new ArrayList<JSMethodToImplement>(3);
        for (Map.Entry entry : methodsToImplement.entrySet()) {
            JSMethodToImplement.MethodKey methodToImplement = (JSMethodToImplement.MethodKey)entry.getKey();
            if (implementedMethods.contains(methodToImplement)) continue;
            notImplemented.add((JSMethodToImplement)entry.getValue());
        }
        ArrayList<JSMethodToImplement> arrayList = notImplemented;
        if (arrayList == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @Nullable
    private static JSDocComment findDocComment(@NotNull JSElement member) {
        if (member == null) {
            JSClosureCompilerSyntaxInspection.$$$reportNull$$$0(18);
        }
        return JSStubBasedPsiTreeUtil.findDocComment((PsiElement)member);
    }

    private static /* synthetic */ boolean lambda$collectSuperClasses$0(Set superClasses, JSClass superClass, JSTypeSubstitutor substitutor, boolean __) {
        superClasses.add(superClass);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorElement";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementedInterfaces";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesInHierarchy";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getClassMethods";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSuperClasses";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotImplementedMethods";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processUnimplementedMethods";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNotImplementedMethods";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

