/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class ES6BindWithArrowFunctionInspection
extends JSInspection
implements ES6CoolRefactoring {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression function) {
                Pair pair;
                if (function == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)function)) {
                    return;
                }
                boolean anonymousArrow = function.isArrowFunction();
                if (anonymousArrow && (pair = ES6BindWithArrowFunctionInspection.checkForBindingFunctions(function)) != null && pair.getFirst() != null && pair.getSecond() != null) {
                    JSExpression expression = ((JSCallExpression)pair.getSecond()).getMethodExpression();
                    holder.registerProblem((PsiElement)(expression instanceof JSReferenceExpression ? ((JSReferenceExpression)expression).getReferenceNameElement() : expression), JSBundle.message((String)"js.suspicious.bind.with.arrow.function", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
                super.visitJSFunctionExpression(function);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/inspections/ES6BindWithArrowFunctionInspection$1", "visitJSFunctionExpression"));
            }
        };
        if (jSElementVisitor == null) {
            ES6BindWithArrowFunctionInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static Pair<String, JSCallExpression> checkForBindingFunctions(@NotNull JSFunctionExpression function) {
        JSCallExpression callExpression;
        JSExpression[] arguments;
        PsiElement parent;
        if (function == null) {
            ES6BindWithArrowFunctionInspection.$$$reportNull$$$0(1);
        }
        if ((parent = function.getParent()) instanceof JSParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof JSReferenceExpression && parent.getParent() instanceof JSCallExpression && "bind".equals(ES6BindWithArrowFunctionInspection.getCallExpressionName((JSCallExpression)parent.getParent())) && (arguments = (callExpression = (JSCallExpression)parent.getParent()).getArguments()).length == 1) {
            return Pair.create((Object)"bind", (Object)callExpression);
        }
        return null;
    }

    private static String getCallExpressionName(@NotNull JSCallExpression call) {
        if (call == null) {
            ES6BindWithArrowFunctionInspection.$$$reportNull$$$0(2);
        }
        if (call.getMethodExpression() instanceof JSReferenceExpression) {
            return ((JSReferenceExpression)call.getMethodExpression()).getReferenceName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6BindWithArrowFunctionInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6BindWithArrowFunctionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkForBindingFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCallExpressionName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

