/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.injections;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInjectionUtil {
    private static final String EXTERNAL_FRAGMENT = "EXTERNAL_FRAGMENT";

    private JSInjectionUtil() {
    }

    @NotNull
    public static PsiElement getTopElement(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            JSInjectionUtil.$$$reportNull$$$0(0);
        }
        PsiLanguageInjectionHost parent = host;
        while (parent.getParent() instanceof JSBinaryExpression && ((JSBinaryExpression)parent.getParent()).getOperationSign() == JSTokenTypes.PLUS || parent.getParent() instanceof JSParenthesizedExpression) {
            parent = parent.getParent();
        }
        PsiLanguageInjectionHost psiLanguageInjectionHost = parent;
        if (psiLanguageInjectionHost == null) {
            JSInjectionUtil.$$$reportNull$$$0(1);
        }
        return psiLanguageInjectionHost;
    }

    @NotNull
    public static List<JSLiteralExpression> getConcatenationParts(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionUtil.$$$reportNull$$$0(2);
        }
        if (topElement instanceof JSLiteralExpression) {
            List<JSLiteralExpression> list2 = Collections.singletonList((JSLiteralExpression)topElement);
            if (list2 == null) {
                JSInjectionUtil.$$$reportNull$$$0(3);
            }
            return list2;
        }
        final ArrayList<JSLiteralExpression> results = new ArrayList<JSLiteralExpression>();
        topElement.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof JSBinaryExpression && ((JSBinaryExpression)element).getOperationSign() == JSTokenTypes.PLUS || element instanceof JSParenthesizedExpression) {
                    super.visitElement(element);
                }
            }

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                if (node.isQuotedLiteral()) {
                    results.add(node);
                }
            }
        });
        ArrayList<JSLiteralExpression> arrayList = results;
        if (arrayList == null) {
            JSInjectionUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static String getConcatenationText(@NotNull List<? extends JSLiteralExpression> parts) {
        if (parts == null) {
            JSInjectionUtil.$$$reportNull$$$0(5);
        }
        String string = StringUtil.join(parts, JSInjectionUtil::getQuotedLiteralText, (String)"");
        if (string == null) {
            JSInjectionUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getConcatenationText(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionUtil.$$$reportNull$$$0(7);
        }
        String string = JSInjectionUtil.getConcatenationText(JSInjectionUtil.getConcatenationParts(topElement));
        if (string == null) {
            JSInjectionUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static List<PlaceInfo> getConcatenationPlaces(@NotNull List<JSLiteralExpression> parts, @Nullable Language language, @Nullable String prefix, @Nullable String suffix) {
        if (parts == null) {
            JSInjectionUtil.$$$reportNull$$$0(9);
        }
        ArrayList<PlaceInfo> result2 = new ArrayList<PlaceInfo>(parts.size());
        for (int i = 0; i < parts.size(); ++i) {
            JSLiteralExpression literalExpression = parts.get(i);
            result2.addAll(JSInjectionUtil.getQuotedLiteralPlaces(literalExpression, language, i == 0 ? prefix : null, i == parts.size() - 1 ? suffix : null));
        }
        ArrayList<PlaceInfo> arrayList = result2;
        if (arrayList == null) {
            JSInjectionUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public static List<PlaceInfo> injectInQuotedLiteral(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull JSLiteralExpression literalExpression, @Nullable String prefix, @Nullable String suffix) {
        if (registrar == null) {
            JSInjectionUtil.$$$reportNull$$$0(11);
        }
        if (language == null) {
            JSInjectionUtil.$$$reportNull$$$0(12);
        }
        if (literalExpression == null) {
            JSInjectionUtil.$$$reportNull$$$0(13);
        }
        List<PlaceInfo> list2 = JSInjectionUtil.injectInQuotedLiteral(registrar, language, null, literalExpression, prefix, suffix);
        if (list2 == null) {
            JSInjectionUtil.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    public static List<PlaceInfo> injectInQuotedLiteral(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @Nullable String extension, @NotNull JSLiteralExpression literalExpression, @Nullable String prefix, @Nullable String suffix) {
        List<PlaceInfo> places;
        if (registrar == null) {
            JSInjectionUtil.$$$reportNull$$$0(15);
        }
        if (language == null) {
            JSInjectionUtil.$$$reportNull$$$0(16);
        }
        if (literalExpression == null) {
            JSInjectionUtil.$$$reportNull$$$0(17);
        }
        if (!(places = JSInjectionUtil.getQuotedLiteralPlaces(literalExpression, language, prefix, suffix)).isEmpty()) {
            registrar.startInjecting(language, extension);
            JSInjectionUtil.injectForPlaces(registrar, places);
            registrar.doneInjecting();
        }
        List<PlaceInfo> list2 = places;
        if (list2 == null) {
            JSInjectionUtil.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    public static List<PlaceInfo> concatenationAwareInject(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull List<JSLiteralExpression> parts, @NotNull PsiElement contextElement, @Nullable String prefix, @Nullable String suffix) {
        List<PlaceInfo> places;
        if (registrar == null) {
            JSInjectionUtil.$$$reportNull$$$0(19);
        }
        if (language == null) {
            JSInjectionUtil.$$$reportNull$$$0(20);
        }
        if (parts == null) {
            JSInjectionUtil.$$$reportNull$$$0(21);
        }
        if (contextElement == null) {
            JSInjectionUtil.$$$reportNull$$$0(22);
        }
        if ((places = JSInjectionUtil.getConcatenationPlaces(parts, language, prefix, suffix)).isEmpty()) {
            List<PlaceInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                JSInjectionUtil.$$$reportNull$$$0(23);
            }
            return list2;
        }
        if (!ContainerUtil.exists(places, place -> PsiTreeUtil.isAncestor((PsiElement)contextElement, (PsiElement)place.getHost(), (boolean)false))) {
            List<PlaceInfo> list3 = Collections.emptyList();
            if (list3 == null) {
                JSInjectionUtil.$$$reportNull$$$0(24);
            }
            return list3;
        }
        registrar.startInjecting(language);
        JSInjectionUtil.injectForPlaces(registrar, places);
        registrar.doneInjecting();
        List<PlaceInfo> list4 = places;
        if (list4 == null) {
            JSInjectionUtil.$$$reportNull$$$0(25);
        }
        return list4;
    }

    private static void injectForPlaces(@NotNull MultiHostRegistrar registrar, @NotNull List<PlaceInfo> places) {
        if (registrar == null) {
            JSInjectionUtil.$$$reportNull$$$0(26);
        }
        if (places == null) {
            JSInjectionUtil.$$$reportNull$$$0(27);
        }
        for (PlaceInfo place : places) {
            registrar.addPlace(place.getPrefix(), place.getSuffix(), place.getHost(), place.getRange());
        }
    }

    @NotNull
    public static String getQuotedLiteralText(@NotNull JSLiteralExpression literalExpression) {
        if (literalExpression == null) {
            JSInjectionUtil.$$$reportNull$$$0(28);
        }
        String text = literalExpression.getText();
        StringBuilder result2 = new StringBuilder();
        for (PlaceInfo place : JSInjectionUtil.getQuotedLiteralPlaces(literalExpression, null, null, null)) {
            if (place.getPrefix() != null) {
                result2.append(place.getPrefix());
            }
            result2.append(text, place.getRange().getStartOffset(), place.getRange().getEndOffset());
            if (place.getSuffix() == null) continue;
            result2.append(place.getSuffix());
        }
        String string = result2.toString();
        if (string == null) {
            JSInjectionUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static List<PlaceInfo> getQuotedLiteralPlaces(@NotNull JSLiteralExpression literalExpression, @Nullable Language language, @Nullable String injectionPrefix, @Nullable String injectionSuffix) {
        if (literalExpression == null) {
            JSInjectionUtil.$$$reportNull$$$0(30);
        }
        PsiLanguageInjectionHost injectionHost = (PsiLanguageInjectionHost)literalExpression;
        if (literalExpression instanceof JSStringTemplateExpression) {
            JSStringTemplateExpression templateExpression = (JSStringTemplateExpression)literalExpression;
            TextRange[] ranges = templateExpression.getStringRanges();
            Object[] arguments = templateExpression.getArguments();
            if (ranges.length > 0) {
                boolean endsWitArgument;
                ArrayList<PlaceInfo> result2 = new ArrayList<PlaceInfo>(ranges.length);
                boolean startsWithArgument = ranges[0].getStartOffset() > 1;
                boolean bl = endsWitArgument = ranges[ranges.length - 1].getEndOffset() < literalExpression.getTextLength() - 1;
                if (injectionPrefix != null && startsWithArgument) {
                    result2.add(new PlaceInfo(injectionPrefix, TextRange.from((int)1, (int)0), null, injectionHost));
                }
                for (int i = 0; i < ranges.length; ++i) {
                    TextRange range = ranges[i];
                    Object argument = i < arguments.length ? arguments[i] : null;
                    String placeholder = JSInjectionUtil.getPlaceholder((JSExpression)argument, language, i);
                    String prefix = i == 0 && startsWithArgument ? placeholder : (result2.isEmpty() ? injectionPrefix : null);
                    String suffix = i != ranges.length - 1 || endsWitArgument ? placeholder : injectionSuffix;
                    result2.add(new PlaceInfo(prefix, range, suffix, injectionHost));
                }
                if (injectionSuffix != null && endsWitArgument) {
                    result2.add(new PlaceInfo(null, TextRange.from((int)(literalExpression.getTextLength() - 1), (int)0), injectionSuffix, injectionHost));
                }
                ArrayList<PlaceInfo> arrayList = result2;
                if (arrayList == null) {
                    JSInjectionUtil.$$$reportNull$$$0(31);
                }
                return arrayList;
            }
            if (!ArrayUtil.isEmpty((Object[])arguments)) {
                List list2 = ContainerUtil.emptyList();
                if (list2 == null) {
                    JSInjectionUtil.$$$reportNull$$$0(32);
                }
                return list2;
            }
        }
        int endOffset = Math.max(literalExpression.getTextLength() - 1, 1);
        List<PlaceInfo> list3 = Collections.singletonList(new PlaceInfo(injectionPrefix, TextRange.create((int)1, (int)endOffset), injectionSuffix, injectionHost));
        if (list3 == null) {
            JSInjectionUtil.$$$reportNull$$$0(33);
        }
        return list3;
    }

    @NotNull
    private static String getPlaceholder(@Nullable JSExpression argument, @Nullable Language language, int index) {
        String referenceName;
        Object value;
        if (argument instanceof JSLiteralExpression && (value = ((JSLiteralExpression)argument).getValue()) != null) {
            String string = value.toString();
            if (string == null) {
                JSInjectionUtil.$$$reportNull$$$0(34);
            }
            return string;
        }
        if (language != null && StringUtil.containsIgnoreCase((String)language.getDisplayName(), (String)"SQL")) {
            referenceName = JSInjectionUtil.getPlaceholderForDynamicExpression(argument);
            if (referenceName != null) {
                String string = "${" + referenceName + "}";
                if (string == null) {
                    JSInjectionUtil.$$$reportNull$$$0(35);
                }
                return string;
            }
            String string = "${p" + index + "}";
            if (string == null) {
                JSInjectionUtil.$$$reportNull$$$0(36);
            }
            return string;
        }
        referenceName = JSInjectionUtil.getPlaceholderForDynamicExpression(argument);
        if (referenceName != null) {
            String string = referenceName;
            if (string == null) {
                JSInjectionUtil.$$$reportNull$$$0(37);
            }
            return string;
        }
        if (EXTERNAL_FRAGMENT == null) {
            JSInjectionUtil.$$$reportNull$$$0(38);
        }
        return EXTERNAL_FRAGMENT;
    }

    @Nullable
    private static String getPlaceholderForDynamicExpression(@Nullable JSExpression argument) {
        String referenceName;
        if (argument instanceof JSReferenceExpression && ((JSReferenceExpression)argument).getQualifier() == null && (referenceName = ((JSReferenceExpression)argument).getReferenceName()) != null) {
            return referenceName;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/injections/JSInjectionUtil";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topElement";
                break;
            }
            case 5: 
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 11: 
            case 15: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 13: 
            case 17: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/injections/JSInjectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenationParts";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenationText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenationPlaces";
                break;
            }
            case 14: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "injectInQuotedLiteral";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "concatenationAwareInject";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuotedLiteralText";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuotedLiteralPlaces";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTopElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenationParts";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenationText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenationPlaces";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "injectInQuotedLiteral";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "concatenationAwareInject";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "injectForPlaces";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getQuotedLiteralText";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getQuotedLiteralPlaces";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PlaceInfo {
        private final String myPrefix;
        private final TextRange myRange;
        private final String mySuffix;
        private final PsiLanguageInjectionHost myHost;

        public PlaceInfo(@Nullable String prefix, @NotNull TextRange range, @Nullable String suffix, @NotNull PsiLanguageInjectionHost host) {
            if (range == null) {
                PlaceInfo.$$$reportNull$$$0(0);
            }
            if (host == null) {
                PlaceInfo.$$$reportNull$$$0(1);
            }
            this.myPrefix = prefix;
            this.myRange = range;
            this.mySuffix = suffix;
            this.myHost = host;
        }

        @Nullable
        public String getPrefix() {
            return this.myPrefix;
        }

        @Nullable
        public String getSuffix() {
            return this.mySuffix;
        }

        @NotNull
        public TextRange getRange() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                PlaceInfo.$$$reportNull$$$0(2);
            }
            return textRange;
        }

        @NotNull
        public PsiLanguageInjectionHost getHost() {
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
            if (psiLanguageInjectionHost == null) {
                PlaceInfo.$$$reportNull$$$0(3);
            }
            return psiLanguageInjectionHost;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/injections/JSInjectionUtil$PlaceInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/injections/JSInjectionUtil$PlaceInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHost";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

