/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.BaseJSGenerateAction;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.TypeScriptGenerateConstructorUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.JSConstructorChecker;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.NotNull;

public class JavaScriptGenerateConstructorHandler
extends BaseJSGenerateHandler {
    @Override
    protected String getTitleKey() {
        return "generate.constructor.overloads.and.fields.chooser.title";
    }

    @Override
    protected BaseCreateMembersFix createFix(final PsiElement jsClass) {
        return new BaseCreateMembersFix<JSElement>(jsClass){

            @Override
            public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                Set<JSElement> toProcess = super.getElementsToProcess();
                JSCodeStyleSettings codeStyleSettings = (JSCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file2, JSCodeStyleSettings.class);
                this.evalAnchor(editor, file2);
                Ref ctorRef = Ref.create(null);
                if (!DialectDetector.isTypeScript((PsiElement)file2) || this.shouldGenerateSingleOverloadConstructor(toProcess, (Ref<TypeScriptFunction>)ctorRef)) {
                    LinkedHashSet<JSVariable> toProcessVars = new LinkedHashSet<JSVariable>(toProcess.size());
                    TypeScriptFunction ctor = (TypeScriptFunction)ctorRef.get();
                    if (ctor != null) {
                        ContainerUtil.addAll(toProcessVars, (Object[])ctor.getParameterVariables());
                    } else {
                        JavaScriptGenerateConstructorHandler.addConstructorVars(toProcessVars, jsClass);
                    }
                    for (JSElement process : toProcess) {
                        if (!(process instanceof JSVariable)) continue;
                        toProcessVars.add((JSVariable)process);
                    }
                    this.doAddOneMethod(project, this.createSingleOverloadConstructor(file2, codeStyleSettings, toProcessVars, project), this.anchor);
                } else {
                    HashSet<JSFunction> overloads = new HashSet<JSFunction>();
                    ArrayList<JSVariable> variables = new ArrayList<JSVariable>();
                    for (JSElement element : toProcess) {
                        if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isConstructor()) {
                            overloads.add((JSFunction)element);
                            continue;
                        }
                        if (element instanceof JSVariable) {
                            variables.add((JSVariable)element);
                            continue;
                        }
                        throw new NotImplementedError("Trying to operate on unknown element " + element.getClass());
                    }
                    String constructor = TypeScriptGenerateConstructorUtil.createMultiOverloadConstructor(file2, codeStyleSettings, variables, overloads, project, jsClass);
                    JSClass stub = JSPsiElementFactory.createJSClass("class Foo {" + constructor + "}", jsClass);
                    for (Object member : stub.getMembers()) {
                        this.anchor = 1.addOneMethodToClass(jsClass, project, ((JSElement)member).getText(), this.anchor);
                    }
                }
            }

            private boolean shouldGenerateSingleOverloadConstructor(@NotNull Set<JSElement> toProcess, @NotNull Ref<TypeScriptFunction> ctorRef) {
                if (toProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ctorRef == null) {
                    1.$$$reportNull$$$0(2);
                }
                int ctors = 0;
                for (JSElement e : toProcess) {
                    if (e instanceof TypeScriptFunction && ((TypeScriptFunction)e).isConstructor()) {
                        ctorRef.set((Object)((TypeScriptFunction)e));
                        if (++ctors <= 1) continue;
                        return false;
                    }
                    if (e instanceof JSVariable) continue;
                    return false;
                }
                return true;
            }

            private String createSingleOverloadConstructor(@NotNull PsiFile file2, @NotNull JSCodeStyleSettings codeStyleSettings, @NotNull Set<JSVariable> toProcess, @NotNull Project project) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (codeStyleSettings == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (toProcess == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (project == null) {
                    1.$$$reportNull$$$0(6);
                }
                StringBuilder functionText = new StringBuilder(JSClassUtils.createConstructorSignatureForClass((JSClass)jsClass, true));
                functionText.append('(');
                StringBuilder initialization = new StringBuilder();
                boolean first = true;
                String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)file2);
                Iterator<JSVariable> variableIterator = toProcess.iterator();
                boolean hadSuperClassConstructorInitializationBefore = false;
                boolean hadSuperClassConstructorInitialization = false;
                HashSet<String> names = new HashSet<String>(toProcess.size());
                while (variableIterator.hasNext()) {
                    boolean mangle;
                    boolean isDuplicateName;
                    JSVariable var = variableIterator.next();
                    String name = var.getName();
                    boolean bl = isDuplicateName = !names.add(name);
                    if (name == null) continue;
                    if (!first && !isDuplicateName) {
                        functionText.append(", ");
                    }
                    first = false;
                    String parameterName = JSRefactoringUtil.transformVarNameToAccessorName(name, codeStyleSettings);
                    boolean bl2 = mangle = !JSRefactoringUtil.isValidIdentifier(parameterName, project);
                    if (mangle) {
                        parameterName = JavaScriptGenerateConstructorHandler.mangleParameterName(parameterName);
                    }
                    String insertedOwnName = JSSymbolUtil.handleSpecialPropertyNames(name, JSCodeStyleSettings.getQuoteChar((PsiElement)file2));
                    boolean hasBracket = insertedOwnName.startsWith("[");
                    String typeString = BaseCreateMembersFix.getProcessedType(var.getJSType(), jsClass, (PsiElement)var);
                    if (!isDuplicateName) {
                        functionText.append(parameterName);
                        if (typeString != null) {
                            functionText.append(':').append(typeString);
                        }
                    }
                    if (JSResolveUtil.findParent((PsiElement)var) == jsClass) {
                        if (hadSuperClassConstructorInitializationBefore) {
                            initialization.append(')').append(semicolon).append('\n');
                            hadSuperClassConstructorInitializationBefore = false;
                        }
                        if (parameterName.equals(name)) {
                            initialization.append(mangle ? (hasBracket ? "this" : "this[") : (JSUtils.isPrivateSharpItem((PsiElement)var) ? "this.#" : "this."));
                        } else {
                            String qualifier = JSClassUtils.getDefaultFieldQualifier(jsClass, true);
                            if (qualifier != null) {
                                if (mangle && qualifier.length() > 1) {
                                    initialization.append(qualifier, 0, qualifier.length() - 1);
                                    if (!hasBracket) {
                                        initialization.append("[");
                                    }
                                } else {
                                    initialization.append(qualifier);
                                }
                            }
                        }
                        initialization.append(insertedOwnName).append(mangle && !hasBracket ? "]" : "").append(" = ").append(parameterName).append(semicolon).append("\n");
                        continue;
                    }
                    initialization.append(hadSuperClassConstructorInitializationBefore ? ", " : "super(").append(parameterName);
                    hadSuperClassConstructorInitializationBefore = true;
                    hadSuperClassConstructorInitialization = true;
                }
                if (hadSuperClassConstructorInitializationBefore) {
                    initialization.append(")").append(semicolon).append("\n");
                } else if (DialectDetector.isJavaScriptFamily(jsClass) && !hadSuperClassConstructorInitialization && ((JSClass)jsClass).getSuperClasses().length > 0) {
                    initialization.insert(0, "super()" + semicolon + "\n");
                }
                functionText.append(") {\n");
                functionText.append((CharSequence)initialization);
                functionText.append("}");
                return functionText.toString();
            }

            @Override
            public Set<JSElement> getElementsToProcess() {
                LinkedHashSet<JSElement> vars = new LinkedHashSet<JSElement>();
                JavaScriptGenerateConstructorHandler.addConstructorVars(vars, jsClass);
                vars.addAll(super.getElementsToProcess());
                return vars;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "toProcess";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ctorRef";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "codeStyleSettings";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/generation/JavaScriptGenerateConstructorHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "invoke";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldGenerateSingleOverloadConstructor";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createSingleOverloadConstructor";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    static <T extends JSElement> void addConstructorVars(@NotNull Collection<T> vars, @NotNull PsiElement jsClass) {
        JSFunction nontrivialSuperClassConstructor;
        if (vars == null) {
            JavaScriptGenerateConstructorHandler.$$$reportNull$$$0(0);
        }
        if (jsClass == null) {
            JavaScriptGenerateConstructorHandler.$$$reportNull$$$0(1);
        }
        if ((nontrivialSuperClassConstructor = JSConstructorChecker.getNontrivialSuperClassConstructor((JSClass)jsClass)) instanceof TypeScriptFunction && ((TypeScriptFunction)nontrivialSuperClassConstructor).isOverloadDeclaration()) {
            nontrivialSuperClassConstructor = TypeScriptPsiUtil.getLastOverload((TypeScriptFunction)nontrivialSuperClassConstructor);
        }
        if (nontrivialSuperClassConstructor != null) {
            JSParameter[] variables;
            for (JSParameter variable : variables = nontrivialSuperClassConstructor.getParameterVariables()) {
                vars.add(variable);
            }
        }
    }

    @NotNull
    static String mangleParameterName(@NotNull String name) {
        if (name == null) {
            JavaScriptGenerateConstructorHandler.$$$reportNull$$$0(2);
        }
        StringBuilder builder = new StringBuilder();
        if (name.startsWith("[") && name.endsWith("]")) {
            name = name.substring(1, name.length() - 1);
        }
        for (int i = 0; i < name.length(); ++i) {
            char iChar = name.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(iChar) || i != 0 && !Character.isJavaIdentifierPart(iChar)) {
                builder.append('_');
                continue;
            }
            if (i == 0 && Character.isUpperCase(iChar)) {
                iChar = Character.toLowerCase(iChar);
            }
            builder.append(iChar);
        }
        String string = builder.toString();
        if (string == null) {
            JavaScriptGenerateConstructorHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
        JavaScriptGenerateConstructorHandler.collectJSVariables(clazz, candidates, false, false, true, true, false, false, true);
        TypeScriptGenerateConstructorUtil.addTypeScriptOverloadCandidates(clazz, candidates);
    }

    @Override
    protected boolean isValidForTarget(PsiElement jsClass) {
        return BaseJSGenerateAction.isClassWithMembersToGenerate(jsClass);
    }

    @Override
    protected boolean canHaveEmptySelectedElements() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/generation/JavaScriptGenerateConstructorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/generation/JavaScriptGenerateConstructorHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "mangleParameterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addConstructorVars";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "mangleParameterName";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

