/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.extjs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.frameworks.extjs.ExtXTypeReference;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ext4FrameworkHandler
extends FrameworkIndexingHandler {
    private static final String MODELS = "models";
    private static final String STORES = "stores";
    private static final String VIEWS = "views";
    private static final String CONTROLLERS = "controllers";
    private static final String REF = "ref";
    private static final String CONFIG = "config";
    private static final String ALIAS = "alias";
    private static final String DEFINE = "define";
    public static final String[] INTERESTED_METHOD_NAMES = new String[]{"define"};
    public static final String CLASS_NAME_PROPERTY = "$className";

    @Override
    public boolean processProperty(@Nullable String name, @NotNull JSProperty property, final @NotNull JSElementIndexingData outData) {
        if (property == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(0);
        }
        if (outData == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(1);
        }
        JSExpression value = property.getValue();
        if ((MODELS.equals(name) || STORES.equals(name) || VIEWS.equals(name) || CONTROLLERS.equals(name)) && value instanceof JSArrayLiteralExpression) {
            String suffix = null;
            for (JSExpression e : StreamEx.of((Stream)((JSArrayLiteralExpression)value).getExpressionStream())) {
                String s;
                if (!(e instanceof JSLiteralExpression) || (s = StringUtil.unquoteString((String)e.getText())).length() <= 0 || !StringUtil.isJavaIdentifier((String)s)) continue;
                if (suffix == null) {
                    suffix = StringUtil.toTitleCase((String)name);
                    suffix = suffix.substring(0, suffix.length() - 1);
                }
                s = StringUtil.toTitleCase((String)s);
                JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder("get" + s + suffix, (PsiElement)e).setProperties(JSImplicitElement.Property.GetFunction);
                outData.addImplicitElement((JSImplicitElement)builder.toImplicitElement());
            }
            return false;
        }
        if (REF.equals(name) && value instanceof JSLiteralExpression) {
            String s = StringUtil.unquoteString((String)value.getText());
            if (s.length() > 0 && StringUtil.isJavaIdentifier((String)s)) {
                JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder("get" + StringUtil.toTitleCase((String)s), (PsiElement)value).setProperties(JSImplicitElement.Property.GetFunction);
                outData.addImplicitElement((JSImplicitElement)builder.toImplicitElement());
            }
            return false;
        }
        if (CONFIG.equals(name) && value instanceof JSObjectLiteralExpression) {
            PsiElement parent = value.getParent().getParent();
            if (!(parent instanceof JSObjectLiteralExpression) || !JSSymbolUtil.isArgumentOfCallWithName((JSExpression)((JSObjectLiteralExpression)parent), "Ext", DEFINE)) {
                return true;
            }
            JSObjectLiteralExpression objectLiteral = (JSObjectLiteralExpression)value;
            outData.addAccessorsFromObjectLiteral(objectLiteral);
            JSSymbolUtil.forEachIdentifierProperty(objectLiteral, new JSSymbolUtil.PropertyProcessor(){

                @Override
                public void process(String titleCasedPropName, JSProperty property) {
                    outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl("apply" + titleCasedPropName, (PsiElement)property));
                }
            });
            return false;
        }
        if (Ext4FrameworkHandler.isXTypeDefinition(name, (JSElement)value)) {
            boolean isExt = ALIAS.equals(name);
            String className2 = Ext4FrameworkHandler.findExtClassName(value.getParent().getParent());
            List<Object> expressions = value instanceof JSArrayLiteralExpression ? Arrays.asList(((JSArrayLiteralExpression)value).getExpressions()) : (value instanceof JSLiteralExpression ? Collections.singletonList(value) : Collections.emptyList());
            for (JSExpression jSExpression : expressions) {
                boolean addAlias;
                if (!(jSExpression instanceof JSLiteralExpression) || !((JSLiteralExpression)jSExpression).isQuotedLiteral()) continue;
                String alias = StringUtil.unquoteString((String)jSExpression.getText());
                boolean bl = addAlias = className2 != null;
                if (isExt) {
                    String widgetPrefix = "widget.";
                    if (alias.startsWith("widget.")) {
                        alias = alias.substring("widget.".length());
                    } else {
                        addAlias = false;
                    }
                }
                if (!addAlias) continue;
                outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(alias, (PsiElement)jSExpression));
                outData.addTypedef(alias, ExtXTypeReference.markExtXType(className2));
            }
            return false;
        }
        return true;
    }

    @Nullable
    private static String findExtClassName(PsiElement configObject) {
        if (!(configObject instanceof JSObjectLiteralExpression)) {
            return null;
        }
        PsiElement parent = configObject.getParent();
        if (parent instanceof JSReturnStatement && (parent = PsiTreeUtil.getParentOfType((PsiElement)parent, JSFunction.class)) != null) {
            configObject = parent;
            parent = parent.getParent();
        }
        if (parent instanceof JSArgumentList) {
            JSExpression[] arguments = ((JSArgumentList)parent).getArguments();
            if (arguments.length < 2 || configObject != arguments[1]) {
                return null;
            }
            if (!(arguments[0] instanceof JSLiteralExpression) || !((JSLiteralExpression)arguments[0]).isQuotedLiteral()) {
                return null;
            }
            PsiElement callExpression = parent.getParent();
            if (!(callExpression instanceof JSCallExpression)) {
                return null;
            }
            JSExpression methodExpression = ((JSCallExpression)callExpression).getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression) || !DEFINE.equals(((JSReferenceExpression)methodExpression).getReferencedName())) {
                return null;
            }
            return StringUtil.unquoteString((String)arguments[0].getText());
        }
        return null;
    }

    @Contract(value="_, null -> false")
    private static boolean isXTypeDefinition(String name, JSElement value) {
        if (value == null) {
            return false;
        }
        if (ALIAS.equals(name)) {
            return true;
        }
        if (!"xtype".equals(name)) {
            return false;
        }
        PsiElement property = value.getParent();
        if (!(property instanceof JSProperty)) {
            return false;
        }
        PsiElement objectLiteral = property.getParent();
        return objectLiteral instanceof JSObjectLiteralExpression && JSSymbolUtil.isArgumentOfCallWithName((JSExpression)((JSObjectLiteralExpression)objectLiteral), "Ext", DEFINE);
    }

    @Override
    @NotNull
    public String[] interestedProperties() {
        String[] stringArray = new String[]{MODELS, CONTROLLERS, VIEWS, STORES, REF, CONFIG, ALIAS, "xtype"};
        if (stringArray == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @Override
    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        JSExpression methodExpression;
        if (outData == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(3);
        }
        if (!((methodExpression = callExpression.getMethodExpression()) instanceof JSReferenceExpression)) {
            return;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)methodExpression;
        if (JSSymbolUtil.isAccurateReferenceExpressionName(referenceExpression, "Ext", "reg") || JSSymbolUtil.isAccurateReferenceExpressionName(referenceExpression, "Ext", "ComponentMgr", "registerType")) {
            JSLiteralExpression literalExpression;
            JSExpression[] arguments = callExpression.getArguments();
            if (!(arguments.length == 2 && arguments[0] instanceof JSLiteralExpression && (literalExpression = (JSLiteralExpression)arguments[0]).isQuotedLiteral() && arguments[1] instanceof JSReferenceExpression)) {
                return;
            }
            String xtype = StringUtil.unquoteString((String)literalExpression.getText());
            outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(xtype, (PsiElement)literalExpression));
            outData.addTypedef(xtype, ExtXTypeReference.markExtXType(arguments[1].getText()));
        }
    }

    @Override
    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        ASTNode methodExpression = node.getFirstChildNode();
        if (methodExpression.getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
            return false;
        }
        ASTNode referencedNameElement = methodExpression.getLastChildNode();
        String referencedName = referencedNameElement.getText();
        if ("reg".equals(referencedName)) {
            ASTNode qualifier = methodExpression.getFirstChildNode();
            return qualifier.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && qualifier.getFirstChildNode() == qualifier.getLastChildNode() && "Ext".equals(qualifier.getText());
        }
        if ("registerType".equals(referencedName)) {
            ASTNode qualifier = methodExpression.getFirstChildNode();
            ASTNode qualifierQualifier = qualifier.getFirstChildNode();
            return qualifierQualifier != null && qualifierQualifier.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && qualifierQualifier.getFirstChildNode() == qualifierQualifier.getLastChildNode() && "ComponentMgr".equals(qualifier.getLastChildNode().getText()) && "Ext".equals(qualifierQualifier.getText());
        }
        return false;
    }

    @Override
    public String resolveContextFromProperty(JSObjectLiteralExpression objectLiteralExpression, boolean returnPropertiesNamespace) {
        JSExpression value;
        String value2;
        if (!returnPropertiesNamespace && (value2 = Ext4FrameworkHandler.resolveXType(objectLiteralExpression)) != null) {
            return value2;
        }
        JSProperty classNameProperty = objectLiteralExpression.findProperty(CLASS_NAME_PROPERTY);
        if (classNameProperty != null && (value = classNameProperty.getValue()) instanceof JSLiteralExpression && ((JSLiteralExpression)value).isQuotedLiteral()) {
            return StringUtil.unquoteString((String)value.getText());
        }
        return null;
    }

    private static String resolveXType(JSObjectLiteralExpression objectLiteralExpression) {
        JSExpression value;
        PsiElement parent;
        JSProperty property = objectLiteralExpression.findProperty("xtype");
        if (property == null && (parent = objectLiteralExpression.getParent()) instanceof JSProperty) {
            JSObjectLiteralExpression parentObjectLiteral = (JSObjectLiteralExpression)parent.getParent();
            property = parentObjectLiteral.findProperty("xtype");
        }
        if (property != null && (value = property.getValue()) instanceof JSLiteralExpression && ((JSLiteralExpression)value).isQuotedLiteral()) {
            return StringUtil.unquoteString((String)value.getText());
        }
        return null;
    }

    @Override
    @NotNull
    public String[] implicitProviderMethodNames() {
        if (INTERESTED_METHOD_NAMES == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(4);
        }
        return INTERESTED_METHOD_NAMES;
    }

    @Override
    @NotNull
    public String[] inheritanceMethodNames() {
        if (INTERESTED_METHOD_NAMES == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(5);
        }
        return INTERESTED_METHOD_NAMES;
    }

    @Override
    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(@NotNull String calledMethodName) {
        if (calledMethodName == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(6);
        }
        if (DEFINE.equals(calledMethodName)) {
            return new JSLiteralImplicitElementProvider(){

                @Override
                public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                    JSExpression qualifier;
                    JSExpression expression;
                    if (argument == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (callExpression == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (outIndexingData == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if ((expression = callExpression.getMethodExpression()) instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)expression).getQualifier()) != null && "Ext".equals(qualifier.getText())) {
                        JSExpression[] arguments = callExpression.getArguments();
                        for (int i = 0; i < arguments.length - 1; ++i) {
                            if (arguments[i] != argument) continue;
                            if (!(arguments[i + 1] instanceof JSObjectLiteralExpression) || ((JSObjectLiteralExpression)arguments[i + 1]).findProperty("extend") != null) break;
                            String className2 = StringUtil.unquoteString((String)argument.getText());
                            outIndexingData.addBaseType(className2, "Ext.Base");
                            break;
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "argument";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "callExpression";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outIndexingData";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler$2";
                    objectArray[2] = "fillIndexingData";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return super.createLiteralImplicitElementProvider(calledMethodName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "interestedProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "implicitProviderMethodNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "inheritanceMethodNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processProperty";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processCallExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralImplicitElementProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

