/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InsetPresentation;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.editing.JSMethodChainsInlayProvider;
import com.intellij.lang.javascript.editing.JSTypeHintsInlayProviderKt;
import com.intellij.lang.javascript.editing.JSTypeHintsPresentationFactory;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import com.intellij.util.ui.JBUI;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0014J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J\u0012\u0010\u001f\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010!H\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/intellij/lang/javascript/editing/JSMethodChainsInlayProvider;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/lang/javascript/editing/JSMethodChainsInlayProvider$Settings;", "()V", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "name", "", "getName", "()Ljava/lang/String;", "previewText", "getPreviewText", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "settings", "createSettings", "getBaseLanguage", "Lcom/intellij/lang/Language;", "getCollectorFor", "Lcom/intellij/codeInsight/hints/FactoryInlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "isLanguageSupported", "", "language", "isSupportedDialect", "dialectOfElement", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "Companion", "Settings", "intellij.javascript.impl"})
public class JSMethodChainsInlayProvider
implements InlayHintsProvider<Settings> {
    @NotNull
    private static final SettingsKey<Settings> ourKey;
    public static final Companion Companion;

    @NotNull
    public FactoryInlayHintsCollector getCollectorFor(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Settings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        return new FactoryInlayHintsCollector(this, settings, file2, editor, editor){
            final /* synthetic */ JSMethodChainsInlayProvider this$0;
            final /* synthetic */ Settings $settings;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Editor $editor;

            /*
             * WARNING - void declaration
             */
            public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
                JSCallExpression expression;
                int index;
                void $this$filterTo$iv$iv2;
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                PsiElement psiElement = element;
                if (!(psiElement instanceof JSCallExpression)) {
                    psiElement = null;
                }
                JSCallExpression jSCallExpression = (JSCallExpression)psiElement;
                if (jSCallExpression == null) {
                    return true;
                }
                JSCallExpression call = jSCallExpression;
                PsiElement psiElement2 = call.getParent();
                if ((psiElement2 != null ? psiElement2.getParent() : null) instanceof JSCallExpression) {
                    return true;
                }
                if (!this.this$0.isSupportedDialect(DialectDetector.dialectOfElement((PsiElement)call))) {
                    return true;
                }
                if (DumbService.isDumb((Project)((JSCallExpression)element).getProject())) {
                    return false;
                }
                Iterable $this$filter$iv = this.collectChain(call);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv22 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv2) {
                    PsiWhiteSpace nextSibling;
                    JSCallExpression it = (JSCallExpression)element$iv$iv;
                    boolean bl = false;
                    PsiElement psiElement3 = it.getNextSibling();
                    if (!(psiElement3 instanceof PsiWhiteSpace)) {
                        psiElement3 = null;
                    }
                    boolean bl2 = (PsiWhiteSpace)psiElement3 == null ? false : nextSibling.textContains('\n');
                    if (!bl2) continue;
                    destination$iv$iv22.add(element$iv$iv);
                }
                List chain = (List)destination$iv$iv22;
                if (chain.isEmpty()) {
                    return true;
                }
                $i$f$filter = false;
                Map existingTypes = new LinkedHashMap<K, V>();
                boolean $this$filterTo$iv$iv2 = false;
                Map numToType = new LinkedHashMap<K, V>();
                int totalTypes = 0;
                boolean destination$iv$iv22 = false;
                for (JSCallExpression expression2 : (Iterable)chain) {
                    JSType expressionType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getExpressionJSType((JSExpression)expression2));
                    if (expressionType != null && !JSTypeUtils.isAnyType(expressionType)) {
                        boolean found = false;
                        for (JSType jsType : existingTypes.keySet()) {
                            if (!jsType.isEquivalentTo(expressionType, null)) continue;
                            V v = existingTypes.get(jsType);
                            if (v == null) {
                                Intrinsics.throwNpe();
                            }
                            existingTypes.put(jsType, ((Number)v).intValue() + 1);
                            found = true;
                        }
                        if (!found) {
                            existingTypes.put(expressionType, 1);
                        }
                        numToType.put(index, expressionType);
                        ++totalTypes;
                    }
                    ++index;
                }
                if (totalTypes != chain.size()) {
                    return true;
                }
                if (existingTypes.size() < this.$settings.getUniqueTypeCount()) {
                    return true;
                }
                if (chain.isEmpty()) {
                    return true;
                }
                index = 0;
                Iterator<T> iterator = ((Iterable)chain).iterator();
                while (iterator.hasNext() && !((expression = (JSCallExpression)iterator.next()) instanceof JSNewExpression)) {
                    Project project;
                    Intrinsics.checkExpressionValueIsNotNull((Object)this.$file.getProject(), (String)"file.project");
                    JSTypeHintsPresentationFactory jSTypeHintsPresentationFactory = new JSTypeHintsPresentationFactory(this.getFactory(), 3);
                    V v = numToType.get(index);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    InlayPresentation presentation = jSTypeHintsPresentationFactory.typeHint((JSType)v);
                    InsetPresentation finalPresentation = JSTypeHintsInlayProviderKt.createPresentationWithAction(presentation, project, this.this$0.getBaseLanguage(), this.this$0, new AnAction[0]);
                    TextRange textRange = expression.getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"expression.textRange");
                    sink.addInlineElement(textRange.getEndOffset(), true, (InlayPresentation)finalPresentation);
                    ++index;
                }
                return true;
            }

            private final List<JSCallExpression> collectChain(JSCallExpression call) {
                List chain = CollectionsKt.mutableListOf((Object[])new JSCallExpression[]{call});
                JSExpression current = call.getMethodExpression();
                while (current instanceof JSReferenceExpression) {
                    JSCallExpression nextCall;
                    JSExpression jSExpression = ((JSReferenceExpression)current).getQualifier();
                    if (!(jSExpression instanceof JSCallExpression)) {
                        jSExpression = null;
                    }
                    if ((nextCall = (JSCallExpression)jSExpression) == null) break;
                    chain.add(nextCall);
                    current = nextCall.getMethodExpression();
                }
                return chain;
            }
            {
                this.this$0 = $outer;
                this.$settings = $captured_local_variable$1;
                this.$file = $captured_local_variable$2;
                this.$editor = $captured_local_variable$3;
                super($super_call_param$4);
            }
        };
    }

    protected boolean isSupportedDialect(@Nullable DialectOptionHolder dialectOfElement) {
        return dialectOfElement != null && dialectOfElement.isJavaScript();
    }

    @NotNull
    protected Language getBaseLanguage() {
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)javascriptLanguage, (String)"JavascriptLanguage.INSTANCE");
        return (Language)javascriptLanguage;
    }

    @NotNull
    public SettingsKey<Settings> getKey() {
        return ourKey;
    }

    @NotNull
    public Settings createSettings() {
        return new Settings(0, 1, null);
    }

    @NotNull
    public String getName() {
        return "Method return types in call chains";
    }

    @Nullable
    public String getPreviewText() {
        return "var z = [1, 2, 3];\n\nz\n    .map(function(e) { return String(e) })\n    .map(function(e) { return Number(e) })\n    .map(function(e) { return String(e) })\n    .map(function(e) { return Number(e) });";
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        return !JSTypeHintsInlayProviderKt.isTypeScript(language);
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull Settings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        return new ImmediateConfigurable(settings){
            @NotNull
            private final String uniqueTypeCountName = "Minimal unique type count to show hints";
            private final JBIntSpinner uniqueTypeCount;
            final /* synthetic */ Settings $settings;

            @NotNull
            public final String getUniqueTypeCountName() {
                return this.uniqueTypeCountName;
            }

            @NotNull
            public JPanel createComponent(@NotNull com.intellij.codeInsight.hints.ChangeListener listener2) {
                Row row$iv;
                LayoutBuilder builder$iv;
                Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
                this.uniqueTypeCount.setNumber(this.$settings.getUniqueTypeCount());
                this.uniqueTypeCount.addChangeListener(new ChangeListener(this, listener2){
                    final /* synthetic */ createConfigurable.1 this$0;
                    final /* synthetic */ com.intellij.codeInsight.hints.ChangeListener $listener;

                    public final void stateChanged(ChangeEvent it) {
                        createConfigurable.1.access$handleChange(this.this$0, this.$listener);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$listener = changeListener;
                    }
                });
                Object[] constraints$iv = new LCFlags[]{};
                String title$iv = null;
                boolean $i$f$panel = false;
                LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder((!ArraysKt.contains((Object[])constraints$iv, (Object)LCFlags.disableMagic) ? 1 : 0) != 0);
                boolean bl = false;
                LayoutBuilder this_$iv = $this$panel;
                JLabel label$iv = null;
                boolean separated$iv = false;
                boolean $i$f$row = false;
                Row $this$row = row$iv = this_$iv.getBuilder().newRow(label$iv, this_$iv.getButtonGroup(), separated$iv);
                boolean bl2 = false;
                Cell.label$default((Cell)$this$row, (String)this.uniqueTypeCountName, (int)0, null, null, (boolean)false, (int)30, null);
                Cell.invoke$default((Cell)$this$row, (JComponent)((JComponent)this.uniqueTypeCount), (CCFlags[])new CCFlags[]{$this$row.getPushX()}, (int)0, null, null, (int)14, null);
                DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
                builder$iv.getBuilder().build((Container)panel$iv, (LCFlags[])constraints$iv);
                panel$iv.setPreferredFocusedComponent(builder$iv.getBuilder().getPreferredFocusedComponent());
                panel$iv.setValidateCallbacks(builder$iv.getBuilder().getValidateCallbacks());
                panel$iv.setApplyCallbacks(builder$iv.getBuilder().getApplyCallbacks());
                panel$iv.setResetCallbacks(builder$iv.getBuilder().getResetCallbacks());
                panel$iv.setModifiedCallbacks(builder$iv.getBuilder().isModifiedCallbacks());
                DialogPanel panel = panel$iv;
                panel.setBorder(JBUI.Borders.empty((int)5));
                return (JPanel)panel;
            }

            private final void handleChange(com.intellij.codeInsight.hints.ChangeListener listener2) {
                this.$settings.setUniqueTypeCount(this.uniqueTypeCount.getNumber());
                listener2.settingsChanged();
            }
            {
                this.$settings = $captured_local_variable$0;
                this.uniqueTypeCountName = "Minimal unique type count to show hints";
                this.uniqueTypeCount = new JBIntSpinner(1, 1, 10);
            }

            public static final /* synthetic */ void access$handleChange(createConfigurable.1 $this, com.intellij.codeInsight.hints.ChangeListener listener2) {
                $this.handleChange(listener2);
            }
        };
    }

    static {
        Companion = new Companion(null);
        ourKey = new SettingsKey("js.chain.hints");
    }

    public boolean isVisibleInSettings() {
        return InlayHintsProvider.DefaultImpls.isVisibleInSettings((InlayHintsProvider)this);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/editing/JSMethodChainsInlayProvider$Settings;", "", "uniqueTypeCount", "", "(I)V", "getUniqueTypeCount", "()I", "setUniqueTypeCount", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.javascript.impl"})
    public static final class Settings {
        private int uniqueTypeCount;

        public final int getUniqueTypeCount() {
            return this.uniqueTypeCount;
        }

        public final void setUniqueTypeCount(int n) {
            this.uniqueTypeCount = n;
        }

        public Settings(int uniqueTypeCount) {
            this.uniqueTypeCount = uniqueTypeCount;
        }

        public /* synthetic */ Settings(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 2;
            }
            this(n);
        }

        public Settings() {
            this(0, 1, null);
        }

        public final int component1() {
            return this.uniqueTypeCount;
        }

        @NotNull
        public final Settings copy(int uniqueTypeCount) {
            return new Settings(uniqueTypeCount);
        }

        public static /* synthetic */ Settings copy$default(Settings settings, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = settings.uniqueTypeCount;
            }
            return settings.copy(n);
        }

        @NotNull
        public String toString() {
            return "Settings(uniqueTypeCount=" + this.uniqueTypeCount + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.uniqueTypeCount);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Settings)) break block3;
                    Settings settings = (Settings)object;
                    if (!(this.uniqueTypeCount == settings.uniqueTypeCount)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/editing/JSMethodChainsInlayProvider$Companion;", "", "()V", "ourKey", "Lcom/intellij/codeInsight/hints/SettingsKey;", "Lcom/intellij/lang/javascript/editing/JSMethodChainsInlayProvider$Settings;", "getOurKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "intellij.javascript.impl"})
    public static final class Companion {
        @NotNull
        public final SettingsKey<Settings> getOurKey() {
            return ourKey;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

