/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSQualifiedElementNameCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static boolean isModulePrivate(@NotNull TypeScriptModule module) {
        JSAttributeList attList;
        if (module == null) {
            JSQualifiedElementNameCompletionProvider.$$$reportNull$$$0(0);
        }
        return (attList = module.getAttributeList()) != null && attList.getAccessType() == JSAttributeList.AccessType.PRIVATE;
    }

    private static boolean isSameModuleElement(@Nullable PsiElement element, @Nullable PsiElement otherElement) {
        if (element == null && otherElement == null) {
            return true;
        }
        if (element == null || otherElement == null) {
            return false;
        }
        if (element == otherElement) {
            return true;
        }
        if (!(element instanceof TypeScriptModule) || !(otherElement instanceof TypeScriptModule)) {
            return false;
        }
        return Objects.equals(((TypeScriptModule)element).getQualifiedName(), ((TypeScriptModule)otherElement).getQualifiedName()) && element.getNode().getStartOffset() == otherElement.getNode().getStartOffset();
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiElement scope;
        if (parameters == null) {
            JSQualifiedElementNameCompletionProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JSQualifiedElementNameCompletionProvider.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            JSQualifiedElementNameCompletionProvider.$$$reportNull$$$0(3);
        }
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        assert (parent instanceof JSQualifiedNamedElement) : "must be filtered in JSPatternBasedCompletionContributor";
        if (parent instanceof JSPackageStatement) {
            return;
        }
        if (parent.getParent() instanceof JSDestructuringShorthandedProperty) {
            return;
        }
        if (parent instanceof TypeScriptModule) {
            String ns;
            boolean isPrivateModuleContext = JSQualifiedElementNameCompletionProvider.isModulePrivate((TypeScriptModule)parent);
            PsiElement grandParent = parent.getParent();
            String string = ns = grandParent instanceof TypeScriptModule ? ((TypeScriptModule)grandParent).getQualifiedName() : "";
            if (ns != null) {
                Collection<JSPsiElementBase> children = TypeScriptClassResolver.getInstance().findChildren(ns, (PsiElement)parent.getContainingFile());
                HashSet<String> added = new HashSet<String>();
                for (JSPsiElementBase child : children) {
                    String childName;
                    if (!(child instanceof TypeScriptModule) || JSQualifiedElementNameCompletionProvider.isModulePrivate((TypeScriptModule)child) && !JSQualifiedElementNameCompletionProvider.isSameModuleElement(child.getParent(), grandParent) || isPrivateModuleContext && !JSQualifiedElementNameCompletionProvider.isSameModuleElement(child.getParent(), grandParent) || child.getNode().getStartOffset() == parent.getNode().getStartOffset() || (childName = child.getName()) == null || !added.add(childName)) continue;
                    LookupElement item = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)child, childName, JSLookupPriority.SMART_PRIORITY);
                    assert (item != null);
                    result2.addElement(item);
                }
            }
        }
        if ((scope = JSUseScopeProvider.getLexicalScopeOrFile(parent)) != null && !parameters.isAutoPopup()) {
            final THashSet unresolvedReferences = new THashSet();
            scope.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

                public void visitJSReferenceExpression(JSReferenceExpression node) {
                    super.visitJSReferenceExpression(node);
                    if (node.getQualifier() == null && (node = (JSReferenceExpression)CompletionUtil.getOriginalOrSelf((PsiElement)node)).multiResolve(false).length == 0) {
                        unresolvedReferences.add((Object)node.getReferenceName());
                    }
                }

                public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                }

                public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "node";
                    objectArray2[1] = "com/intellij/lang/javascript/completion/JSQualifiedElementNameCompletionProvider$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionDeclaration";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            unresolvedReferences.forEach(s -> result2.addElement((LookupElement)LookupElementBuilder.create((String)s)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSQualifiedElementNameCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isModulePrivate";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

