/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.beforeRun;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.HyperlinkListeningExecutionException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.gulp.beforeRun.GulpBeforeRunTask;
import com.intellij.lang.javascript.buildTools.gulp.beforeRun.GulpBeforeRunTaskDialog;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpConfigurationType;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.util.PathUtil;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpBeforeRunTaskProvider
extends BeforeRunTaskProvider<GulpBeforeRunTask> {
    static final Key<GulpBeforeRunTask> PROVIDER_ID = Key.create((String)"GulpBeforeRunTask");

    public Key<GulpBeforeRunTask> getId() {
        return PROVIDER_ID;
    }

    public String getName() {
        return JSBundle.message((String)"gulp.before.run.task", (Object[])new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.BuildTools.Gulp16;
    }

    @Nullable
    public Icon getTaskIcon(@NotNull GulpBeforeRunTask task) {
        if (task == null) {
            GulpBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        return JavaScriptLanguageIcons.BuildTools.Gulp16;
    }

    public String getDescription(@NotNull GulpBeforeRunTask task) {
        String path;
        if (task == null) {
            GulpBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        if ((path = task.getSettings().getGulpfilePath()).isEmpty()) {
            return JSBundle.message((String)"gulp.before.run.task", (Object[])new Object[0]);
        }
        String fileName = PathUtil.getFileName((String)path);
        String parentPath = PathUtil.getParentPath((String)path);
        String parentName = PathUtil.getFileName((String)parentPath);
        String folderAndFile = parentName.isEmpty() ? fileName : parentName + File.separator + fileName;
        List<String> tasks = task.getSettings().getTasks();
        String presentableTasks = StringUtil.join(tasks, s -> "'" + s + "'", (String)", ");
        return JSBundle.message((String)"gulp.before.run.task.descr", (Object[])new Object[]{tasks.size(), presentableTasks, folderAndFile});
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public GulpBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            GulpBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        return new GulpBeforeRunTask();
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull GulpBeforeRunTask task) {
        if (runConfiguration == null) {
            GulpBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        if (task == null) {
            GulpBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        GulpRunSettings oldSettings = task.getSettings();
        GulpBeforeRunTaskDialog dialog = new GulpBeforeRunTaskDialog(runConfiguration.getProject(), oldSettings);
        if (!dialog.showAndGet()) {
            return false;
        }
        GulpRunSettings newSettings = dialog.getSettings();
        if (newSettings.equals(oldSettings)) {
            return false;
        }
        task.setSettings(newSettings);
        return true;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull GulpBeforeRunTask task) {
        if (configuration == null) {
            GulpBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        if (task == null) {
            GulpBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        try {
            GulpRunConfiguration.checkRunSettings(configuration.getProject(), task.getSettings());
        }
        catch (RuntimeConfigurationError error) {
            return false;
        }
        return true;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull GulpBeforeRunTask task) {
        if (context == null) {
            GulpBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            GulpBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        if (env == null) {
            GulpBeforeRunTaskProvider.$$$reportNull$$$0(9);
        }
        if (task == null) {
            GulpBeforeRunTaskProvider.$$$reportNull$$$0(10);
        }
        try {
            GulpRunConfiguration.checkRunSettings(configuration.getProject(), task.getSettings());
        }
        catch (RuntimeConfigurationError e) {
            String message = e.getMessage() + "<br><a href=''>Edit run configuration</a>";
            HyperlinkListeningExecutionException exception = new HyperlinkListeningExecutionException(message, () -> {
                RunManager.getInstance((Project)env.getProject()).setSelectedConfiguration(env.getRunnerAndConfigurationSettings());
                new EditConfigurationsDialog(env.getProject()).show();
            });
            ExecutionUtil.handleExecutionError((Project)env.getProject(), (String)ToolWindowId.RUN, (String)"Gulp task before launch", (Throwable)((Object)exception));
            return false;
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)env.getProject()).createConfiguration("", GulpConfigurationType.class);
        GulpRunConfigurationProducer.setupConfigurationFromSettings((GulpRunConfiguration)settings.getConfiguration(), task.getSettings());
        return JsbtUtil.executeBeforeRunTask(env, settings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/beforeRun/GulpBeforeRunTaskProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTaskIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "configureTask";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "canExecuteTask";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

