/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvailablePackageVersions {
    public static final String LATEST_DIST_TAG = "latest";
    private static final Logger LOG = Logger.getInstance(AvailablePackageVersions.class);
    private final List<Pair<String, SemVer>> myDistTags;
    private final SortedMap<SemVer, VersionInfo> myVersions;

    @NotNull
    public static AvailablePackageVersions parseFromPackageMetadata(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(0);
        }
        AvailablePackageVersions availablePackageVersions = new AvailablePackageVersions(reader);
        if (availablePackageVersions == null) {
            AvailablePackageVersions.$$$reportNull$$$0(1);
        }
        return availablePackageVersions;
    }

    private AvailablePackageVersions() {
        this.myDistTags = Collections.emptyList();
        this.myVersions = Collections.emptySortedMap();
    }

    private AvailablePackageVersions(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(2);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            this.myDistTags = Collections.emptyList();
            this.myVersions = Collections.emptySortedMap();
        } else {
            this.myDistTags = new ArrayList<Pair<String, SemVer>>();
            this.myVersions = new TreeMap(Comparator.reverseOrder());
            this.readPackageMetadata(reader);
        }
    }

    @NotNull
    public List<SemVer> getVersions() {
        ArrayList<SemVer> arrayList = new ArrayList<SemVer>(this.myVersions.keySet());
        if (arrayList == null) {
            AvailablePackageVersions.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public List<Pair<String, SemVer>> getDistTags() {
        List<Pair<String, SemVer>> list2 = Collections.unmodifiableList(this.myDistTags);
        if (list2 == null) {
            AvailablePackageVersions.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public SortedMap<SemVer, VersionInfo> getVersionsInfo() {
        SortedMap<SemVer, VersionInfo> sortedMap = Collections.unmodifiableSortedMap(this.myVersions);
        if (sortedMap == null) {
            AvailablePackageVersions.$$$reportNull$$$0(5);
        }
        return sortedMap;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
    @NotNull
    public SortedMap<SemVer, String> getVersionUrlMap() {
        SortedMap sortedMap = (SortedMap)EntryStream.of(this.myVersions).mapValues(info -> ((VersionInfo)info).myUrl).nonNullValues().into(new TreeMap(Comparator.reverseOrder()));
        if (sortedMap == null) {
            AvailablePackageVersions.$$$reportNull$$$0(6);
        }
        return sortedMap;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
    @NotNull
    public SortedMap<SemVer, String> getDeprecationMap() {
        SortedMap sortedMap = (SortedMap)EntryStream.of(this.myVersions).mapValues(info -> info.isDeprecated() ? "true" : null).nonNullValues().into(new TreeMap(Comparator.reverseOrder()));
        if (sortedMap == null) {
            AvailablePackageVersions.$$$reportNull$$$0(7);
        }
        return sortedMap;
    }

    @Nullable
    public SemVer findVersionByDistTag(@NotNull String distTagName) {
        if (distTagName == null) {
            AvailablePackageVersions.$$$reportNull$$$0(8);
        }
        for (Pair<String, SemVer> tag : this.myDistTags) {
            if (!distTagName.equals(tag.getFirst())) continue;
            return (SemVer)tag.getSecond();
        }
        return null;
    }

    @Nullable
    public String findDistTagByVersion(@NotNull SemVer version) {
        if (version == null) {
            AvailablePackageVersions.$$$reportNull$$$0(9);
        }
        return this.myDistTags.stream().filter(pair -> version.getRawVersion().equals(((SemVer)pair.second).getRawVersion())).map(pair -> (String)pair.first).findFirst().orElse(null);
    }

    private void readPackageMetadata(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(10);
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("dist-tags".equals(name)) {
                this.readDistTags(reader);
                continue;
            }
            if ("versions".equals(name)) {
                this.readVersions(reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    private void readDistTags(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(11);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return;
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String distTagName = reader.nextName();
            String versionStr = JsonUtil.nextStringOrSkip((JsonReader)reader);
            SemVer version = SemVer.parseFromText((String)versionStr);
            if (version == null) {
                LOG.info("Cannot parse dist-tag version from " + versionStr);
                continue;
            }
            this.myDistTags.add((Pair<String, SemVer>)Pair.create((Object)distTagName, (Object)version));
        }
        reader.endObject();
    }

    private void readVersions(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(12);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return;
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            SemVer version = SemVer.parseFromText((String)name);
            if (version != null) {
                this.readVersionInfo(reader, version);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    private void readVersionInfo(@NotNull JsonReader reader, @NotNull SemVer version) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(13);
        }
        if (version == null) {
            AvailablePackageVersions.$$$reportNull$$$0(14);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return;
        }
        reader.beginObject();
        boolean isDeprecated = false;
        String url = null;
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("dist") && reader.peek() == JsonToken.BEGIN_OBJECT) {
                reader.beginObject();
                while (reader.hasNext()) {
                    name = reader.nextName();
                    if (name.equals("tarball") && reader.peek() == JsonToken.STRING) {
                        url = reader.nextString();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                continue;
            }
            if (name.equals("deprecated")) {
                if (reader.peek() == JsonToken.STRING) {
                    reader.skipValue();
                    isDeprecated = true;
                    continue;
                }
                if (reader.peek() == JsonToken.BOOLEAN) {
                    isDeprecated = reader.nextBoolean();
                    continue;
                }
                reader.skipValue();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        this.myVersions.put(version, new VersionInfo(url, isDeprecated));
    }

    @NotNull
    public static AvailablePackageVersions createEmpty() {
        AvailablePackageVersions availablePackageVersions = new AvailablePackageVersions();
        if (availablePackageVersions == null) {
            AvailablePackageVersions.$$$reportNull$$$0(15);
        }
        return availablePackageVersions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/AvailablePackageVersions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distTagName";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/AvailablePackageVersions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFromPackageMetadata";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistTags";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionsInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionUrlMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeprecationMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFromPackageMetadata";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findVersionByDistTag";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDistTagByVersion";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readPackageMetadata";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readDistTags";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readVersions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readVersionInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VersionInfo {
        private final boolean myDeprecated;
        private final String myUrl;

        public VersionInfo(@Nullable String url, boolean deprecated) {
            this.myUrl = url;
            this.myDeprecated = deprecated;
        }

        public boolean isDeprecated() {
            return this.myDeprecated;
        }

        @Nullable
        public String getUrl() {
            return this.myUrl;
        }
    }
}

