/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterRefResolveResult;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpreterRef {
    static final String PROJECT_LEVEL = "project";
    private final String myReferenceName;

    private NodeJsInterpreterRef(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(0);
        }
        this.myReferenceName = FileUtil.toSystemIndependentName((String)referenceName);
    }

    private NodeJsInterpreterRef(@Nullable NodeJsInterpreter interpreter) {
        this.myReferenceName = interpreter == null ? "" : FileUtil.toSystemIndependentName((String)interpreter.getReferenceName());
    }

    @NotNull
    public String getReferenceName() {
        String string = this.myReferenceName;
        if (string == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isProjectRef() {
        return PROJECT_LEVEL.equals(this.myReferenceName);
    }

    public boolean isConstantRef() {
        return !PROJECT_LEVEL.equals(this.myReferenceName) && !NodeJsLocalInterpreterType.isNodeFromPathRef(this);
    }

    @Nullable
    public NodeJsInterpreter resolve(@NotNull Project project) {
        NodeInterpreterRefResolveResult result2;
        if (project == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(2);
        }
        return (result2 = this.resolveResult(project)) != null ? (NodeJsInterpreter)result2.getInterpreter() : null;
    }

    @Nullable
    NodeInterpreterRefResolveResult resolveResult(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(3);
        }
        NodeJsInterpreterRef ref = this;
        if (PROJECT_LEVEL.equals(this.myReferenceName)) {
            ref = NodeJsInterpreterManager.getInstance(project).getInterpreterRef();
        }
        return ref.resolveResultWithoutAliases(project);
    }

    @NotNull
    public NodeJsInterpreter resolveNotNull(@NotNull Project project) throws ExecutionException {
        NodeJsInterpreter interpreter;
        if (project == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(4);
        }
        if ((interpreter = this.resolve(project)) != null) {
            NodeJsInterpreter nodeJsInterpreter = interpreter;
            if (nodeJsInterpreter == null) {
                NodeJsInterpreterRef.$$$reportNull$$$0(5);
            }
            return nodeJsInterpreter;
        }
        throw new ExecutionException("Please specify Node.js interpreter");
    }

    @NotNull
    public NodeJsLocalInterpreter resolveAsLocal(@NotNull Project project) throws ExecutionException {
        if (project == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(6);
        }
        NodeJsInterpreter interpreter = this.resolve(project);
        NodeJsLocalInterpreter nodeJsLocalInterpreter = NodeJsLocalInterpreter.cast(interpreter);
        if (nodeJsLocalInterpreter == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(7);
        }
        return nodeJsLocalInterpreter;
    }

    @Nullable
    NodeJsInterpreter resolveWithoutAliases(@NotNull Project project) {
        NodeInterpreterRefResolveResult result2;
        if (project == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(8);
        }
        return (result2 = this.resolveResultWithoutAliases(project)) != null ? (NodeJsInterpreter)result2.getInterpreter() : null;
    }

    @Nullable
    NodeInterpreterRefResolveResult resolveResultWithoutAliases(@Nullable Project project) {
        if (this.myReferenceName.isEmpty()) {
            return null;
        }
        NodeInterpreterRefResolveResult result2 = null;
        for (NodeJsInterpreterType type : NodeJsInterpreterRef.interpreterTypes()) {
            if (!type.isAvailable()) continue;
            NodeInterpreterRefResolveResult localResult = type.resolveReference(project, this.myReferenceName);
            if (localResult != null && localResult.getInterpreter() != null) {
                return localResult;
            }
            if (localResult == null) continue;
            result2 = localResult;
        }
        return result2;
    }

    private static NodeJsInterpreterType[] interpreterTypes() {
        return new NodeJsInterpreterType[]{NodeJsRemoteInterpreterType.getInstance(), WslNodeInterpreterType.getInstance(), NodeJsLocalInterpreterType.getInstance(), NodeJsDownloadableInterpreterType.getInstance()};
    }

    @NotNull
    public static NodeJsInterpreterRef createProjectRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = new NodeJsInterpreterRef(PROJECT_LEVEL);
        if (nodeJsInterpreterRef == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(9);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public static NodeJsInterpreterRef create(@Nullable String referenceName) {
        NodeJsInterpreterRef nodeJsInterpreterRef = new NodeJsInterpreterRef(StringUtil.notNullize((String)referenceName, (String)PROJECT_LEVEL));
        if (nodeJsInterpreterRef == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(10);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public static NodeJsInterpreterRef create(@Nullable NodeJsInterpreter interpreter) {
        NodeJsInterpreterRef nodeJsInterpreterRef = new NodeJsInterpreterRef(interpreter);
        if (nodeJsInterpreterRef == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(11);
        }
        return nodeJsInterpreterRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeJsInterpreterRef ref = (NodeJsInterpreterRef)o;
        return this.myReferenceName.equals(ref.myReferenceName);
    }

    public int hashCode() {
        return this.myReferenceName.hashCode();
    }

    public String toString() {
        return this.myReferenceName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROJECT_LEVEL;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNotNull";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAsLocal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectRef";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveResult";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveNotNull";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsLocal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithoutAliases";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

