/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonDependency;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowablePairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonData {
    private static final Logger LOG = Logger.getInstance(PackageJsonData.class);
    private static final String DESCRIPTION = "description";
    private static final String JSNEXT_MAIN = "jsnext:main";
    private static final String ESNEXT = "esnext";
    private static final String MODULE = "module";
    private static final String ES2015 = "es2015";
    private static final String MAIN = "main";
    private static final String WEB_TYPES = "web-types";
    private static final Map<String, PairConsumer<Holder, String>> ourParsers = ContainerUtil.immutableMapBuilder().put((Object)"name", (holder, value) -> Holder.access$002(holder, value)).put((Object)"main", (holder, value) -> Holder.access$102(holder, value)).put((Object)"description", (holder, value) -> Holder.access$302(holder, value)).put((Object)"version", (holder, value) -> Holder.access$802(holder, value)).put((Object)"types", (holder, value) -> Holder.access$402(holder, value)).put((Object)"typings", (holder, value) -> Holder.access$402(holder, value)).put((Object)"web-types", (holder, value) -> Holder.access$902(holder, value)).put((Object)"jsnext:main", (holder, value) -> ((Holder)holder).myAdditionalMainProperties.put(JSNEXT_MAIN, value)).put((Object)"module", (holder, value) -> ((Holder)holder).myAdditionalMainProperties.put(MODULE, value)).put((Object)"es2015", (holder, value) -> ((Holder)holder).myAdditionalMainProperties.put(ES2015, value)).put((Object)"tsconfig", (holder, value) -> Holder.access$702(holder, value)).build();
    private static final Map<String, ThrowablePairConsumer<Holder, JsonReader, IOException>> ourCustomParsers = ContainerUtil.newHashMap((Pair)Pair.create((Object)"bin", (holder, reader) -> {
        if (reader.peek() == JsonToken.BEGIN_OBJECT) {
            reader.beginObject();
            ((Holder)holder).myBinMap = new HashMap(1);
            while (reader.hasNext()) {
                String name = reader.nextName();
                String value = JsonUtil.nextStringOrSkip((JsonReader)reader);
                if (name == null || value == null) continue;
                ((Holder)holder).myBinMap.put(name, value);
            }
            reader.endObject();
        } else {
            ((Holder)holder).myBinMap = Collections.singletonMap(null, JsonUtil.nextStringOrSkip((JsonReader)reader));
        }
    }), (Pair[])new Pair[]{Pair.create((Object)"workspaces", (holder, reader) -> Holder.access$1102(holder, PackageJsonData.parseWorkspaces(reader))), Pair.create((Object)"esnext", (holder, reader) -> {
        JsonToken tokenType = reader.peek();
        String value = tokenType == JsonToken.BEGIN_OBJECT ? JsonUtil.getChildAsString((JsonReader)reader, (String)MAIN, null) : JsonUtil.nextStringOrSkip((JsonReader)reader);
        ((Holder)holder).myAdditionalMainProperties.put(ESNEXT, value);
    })});
    private final String myName;
    private final String myMain;
    private final String myTypings;
    private final String myDescription;
    private final Map<String, String> myBinMap;
    private final SemVer myVersion;
    private final Map<String, PackageJsonDependency> myTypeByDependencyNameMap;
    private final Map<String, String> myAdditionalMainProperties;
    private final Set<String> myScopes;
    private final Set<String> myTopLevelProperties;
    private final List<String> myWorkspaces;
    private final String myTsConfig;
    private final String myWebTypes;

    @NotNull
    private static List<String> parseWorkspaces(@NotNull JsonReader reader) {
        if (reader == null) {
            PackageJsonData.$$$reportNull$$$0(0);
        }
        JsonElement element = new JsonParser().parse(reader);
        List result2 = null;
        if (element instanceof JsonObject) {
            result2 = JsonUtil.getChildAsStringList((JsonObject)((JsonObject)element), (String)"packages");
        } else if (element instanceof JsonArray) {
            result2 = JsonUtil.getAsStringList((JsonElement)element);
        }
        List list2 = ContainerUtil.notNullize((List)result2);
        if (list2 == null) {
            PackageJsonData.$$$reportNull$$$0(1);
        }
        return list2;
    }

    private PackageJsonData(@NotNull Holder holder) {
        if (holder == null) {
            PackageJsonData.$$$reportNull$$$0(2);
        }
        this.myName = holder.myName;
        this.myMain = holder.myMain;
        this.myAdditionalMainProperties = holder.myAdditionalMainProperties;
        this.myDescription = holder.myDescription;
        this.myTypings = holder.myTypings;
        this.myTopLevelProperties = holder.myTopLevelProperties;
        this.myBinMap = holder.myBinMap;
        this.myTsConfig = holder.myTsConfig;
        this.myVersion = SemVer.parseFromText((String)StringUtil.notNullize((String)holder.myVersion));
        this.myWebTypes = holder.myWebTypes;
        HashMap typeByDependencyNameMap = new HashMap();
        HashSet<String> scopes = new HashSet<String>();
        for (Map.Entry entry : holder.myDependenciesByType.entrySet()) {
            for (String dependencyName : (List)entry.getValue()) {
                typeByDependencyNameMap.put(dependencyName, entry.getKey());
                PackageJsonData.addScope(dependencyName, scopes);
            }
        }
        this.myScopes = ImmutableSet.copyOf(scopes);
        this.myTypeByDependencyNameMap = ImmutableMap.copyOf(typeByDependencyNameMap);
        this.myWorkspaces = ImmutableList.copyOf((Collection)holder.myWorkspaces);
    }

    private static void addScope(@NotNull String dependencyName, @NotNull Set<String> scopes) {
        String scope;
        if (dependencyName == null) {
            PackageJsonData.$$$reportNull$$$0(3);
        }
        if (scopes == null) {
            PackageJsonData.$$$reportNull$$$0(4);
        }
        if ((scope = NodeModuleSearchUtil.getScopeByPackageName(dependencyName)) != null) {
            scopes.add(scope);
        }
    }

    public boolean containsDependencyWithScope(@NotNull String scope) {
        if (scope == null) {
            PackageJsonData.$$$reportNull$$$0(5);
        }
        return this.myScopes.contains(scope);
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getTsConfig() {
        return this.myTsConfig;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @Nullable
    public String getMain() {
        return this.myMain;
    }

    @Nullable
    public String getJsNextMain() {
        String esnext = this.myAdditionalMainProperties.get(ESNEXT);
        if (esnext != null) {
            return esnext;
        }
        String module = this.myAdditionalMainProperties.get(MODULE);
        if (module != null) {
            return module;
        }
        String es2015 = this.myAdditionalMainProperties.get(ES2015);
        if (!StringUtil.isEmptyOrSpaces((String)es2015)) {
            return es2015;
        }
        String jsNext = this.myAdditionalMainProperties.get(JSNEXT_MAIN);
        if (!StringUtil.isEmptyOrSpaces((String)jsNext)) {
            return jsNext;
        }
        return null;
    }

    public Set<String> getTopLevelProperties() {
        return this.myTopLevelProperties;
    }

    @NotNull
    public Collection<String> getAdditionalMains() {
        Collection<String> collection = this.myAdditionalMainProperties.values();
        if (collection == null) {
            PackageJsonData.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public boolean hasTypings() {
        return !StringUtil.isEmptyOrSpaces((String)this.myTypings);
    }

    @Nullable
    public String getDefaultMain() {
        if (!StringUtil.isEmptyOrSpaces((String)this.myTypings)) {
            return this.myTypings;
        }
        String additionalMain = this.getJsNextMain();
        if (!StringUtil.isEmptyOrSpaces((String)additionalMain)) {
            return additionalMain;
        }
        return this.myMain;
    }

    @Deprecated
    @Nullable
    public String getBinPath() {
        return this.myName != null ? this.getBinPath(this.myName) : null;
    }

    @Nullable
    public String getBinPath(@NotNull String executableName) {
        String value;
        if (executableName == null) {
            PackageJsonData.$$$reportNull$$$0(7);
        }
        String string = value = Objects.equals(this.myName, executableName) ? this.myBinMap.get(null) : null;
        if (value == null) {
            value = this.myBinMap.get(executableName);
        }
        return value;
    }

    @Nullable
    public SemVer getVersion() {
        return this.myVersion;
    }

    public String getWebTypes() {
        return this.myWebTypes;
    }

    public boolean isDependencyOfAnyType(@NotNull String name) {
        if (name == null) {
            PackageJsonData.$$$reportNull$$$0(8);
        }
        return this.myTypeByDependencyNameMap.containsKey(name);
    }

    public boolean containsOneOfDependencyOfAnyType(String ... names) {
        if (names == null) {
            PackageJsonData.$$$reportNull$$$0(9);
        }
        for (String name : names) {
            if (!this.myTypeByDependencyNameMap.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isDependencyOfAnyTypeExcludeDev(@NotNull String name) {
        PackageJsonDependency field;
        if (name == null) {
            PackageJsonData.$$$reportNull$$$0(10);
        }
        return (field = this.myTypeByDependencyNameMap.get(name)) != null && field != PackageJsonDependency.devDependencies;
    }

    @NotNull
    public Set<String> getAllDependencies() {
        Set<String> set = this.myTypeByDependencyNameMap.keySet();
        if (set == null) {
            PackageJsonData.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public List<String> getWorkspaces() {
        List<String> list2 = this.myWorkspaces;
        if (list2 == null) {
            PackageJsonData.$$$reportNull$$$0(12);
        }
        return list2;
    }

    public String toString() {
        return this.myTypeByDependencyNameMap.keySet().toString();
    }

    @NotNull
    public static PackageJsonData getOrCreate(@NotNull VirtualFile packageJsonFile) {
        if (packageJsonFile == null) {
            PackageJsonData.$$$reportNull$$$0(13);
        }
        PackageJsonData packageJsonData = PackageJsonUtil.getOrCreateData(packageJsonFile);
        if (packageJsonData == null) {
            PackageJsonData.$$$reportNull$$$0(14);
        }
        return packageJsonData;
    }

    @NotNull
    public static PackageJsonData parse(@NotNull VirtualFile packageJsonFile, @Nullable Document packageJsonDocument) {
        CharSequence text;
        if (packageJsonFile == null) {
            PackageJsonData.$$$reportNull$$$0(15);
        }
        if (!StringUtil.isEmpty((CharSequence)(text = PackageJsonData.loadText(packageJsonFile, packageJsonDocument)))) {
            PackageJsonData packageJsonData;
            block5: {
                try {
                    Holder holder = PackageJsonData.doParse(packageJsonFile, text);
                    packageJsonData = new PackageJsonData(holder);
                    if (packageJsonData != null) break block5;
                }
                catch (Exception e) {
                    LOG.info("Failed to parse " + packageJsonFile.getPath() + ": " + e.getMessage());
                }
                PackageJsonData.$$$reportNull$$$0(16);
            }
            return packageJsonData;
        }
        PackageJsonData packageJsonData = new PackageJsonData(new Holder());
        if (packageJsonData == null) {
            PackageJsonData.$$$reportNull$$$0(17);
        }
        return packageJsonData;
    }

    @Nullable
    private static CharSequence loadText(@NotNull VirtualFile packageJsonFile, @Nullable Document packageJsonDocument) {
        if (packageJsonFile == null) {
            PackageJsonData.$$$reportNull$$$0(18);
        }
        if (packageJsonDocument != null) {
            return packageJsonDocument.getCharsSequence();
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)packageJsonFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private static Holder doParse(@NotNull VirtualFile packageJson, @NotNull CharSequence text) throws IOException {
        if (packageJson == null) {
            PackageJsonData.$$$reportNull$$$0(19);
        }
        if (text == null) {
            PackageJsonData.$$$reportNull$$$0(20);
        }
        JsonReader reader = new JsonReader((Reader)new CharSequenceReader(text));
        reader.setLenient(true);
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            throw new IOException("Top level element should be object");
        }
        reader.beginObject();
        Holder holder = new Holder();
        EnumMap<PackageJsonDependency, List<String>> dependenciesByType = new EnumMap<PackageJsonDependency, List<String>>(PackageJsonDependency.class);
        while (reader.hasNext()) {
            String key = reader.nextName();
            holder.myTopLevelProperties.add(key);
            if (ourCustomParsers.containsKey(key)) {
                ourCustomParsers.get(key).consume((Object)holder, (Object)reader);
                continue;
            }
            if (ourParsers.containsKey(key)) {
                String value = JsonUtil.nextStringOrSkip((JsonReader)reader);
                ourParsers.get(key).consume((Object)holder, (Object)value);
                continue;
            }
            PackageJsonDependency dependencyType = PackageJsonDependency.findDependencyByName(key);
            if (dependencyType != null) {
                List<String> dependencies = PackageJsonData.readPackages(reader, packageJson, dependencyType);
                dependenciesByType.put(dependencyType, dependencies);
                continue;
            }
            reader.skipValue();
        }
        holder.myDependenciesByType = dependenciesByType;
        reader.endObject();
        Holder holder2 = holder;
        if (holder2 == null) {
            PackageJsonData.$$$reportNull$$$0(21);
        }
        return holder2;
    }

    @NotNull
    private static List<String> readPackages(@NotNull JsonReader reader, @NotNull VirtualFile packageJson, @NotNull PackageJsonDependency dependencyType) throws IOException {
        if (reader == null) {
            PackageJsonData.$$$reportNull$$$0(22);
        }
        if (packageJson == null) {
            PackageJsonData.$$$reportNull$$$0(23);
        }
        if (dependencyType == null) {
            PackageJsonData.$$$reportNull$$$0(24);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            LOG.info("Failed to parse '" + (Object)((Object)dependencyType) + "' of " + packageJson.getPath() + ": expected " + JsonToken.BEGIN_OBJECT + ", actual " + reader.peek());
            reader.skipValue();
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                PackageJsonData.$$$reportNull$$$0(25);
            }
            return list2;
        }
        reader.beginObject();
        ArrayList<String> packages = new ArrayList<String>();
        while (reader.hasNext()) {
            String key = reader.nextName();
            packages.add(key);
            reader.skipValue();
        }
        reader.endObject();
        ArrayList<String> arrayList = packages;
        if (arrayList == null) {
            PackageJsonData.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/PackageJsonData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFile";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/PackageJsonData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWorkspaces";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalMains";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencies";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspaces";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doParse";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "readPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseWorkspaces";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsDependencyWithScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOfAnyType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsOneOfDependencyOfAnyType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOfAnyTypeExcludeDev";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doParse";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readPackages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private String myWebTypes;
        private String myName;
        private final Map<String, String> myAdditionalMainProperties = new HashMap<String, String>();
        private String myMain;
        private String myTypings;
        private String myDescription;
        private Map<String, String> myBinMap = Collections.emptyMap();
        private String myTsConfig;
        private String myVersion;
        private Map<PackageJsonDependency, List<String>> myDependenciesByType = Collections.emptyMap();
        private final Set<String> myTopLevelProperties = new HashSet<String>();
        private List<String> myWorkspaces = ImmutableList.of();

        private Holder() {
        }
    }
}

