/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import icons.DockerIcons;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerFileDeploymentSourceType
extends DockerSingletonDeploymentSourceType {
    static final String ID = "dockerfile";

    public static DockerFileDeploymentSourceType getInstance() {
        return (DockerFileDeploymentSourceType)DockerFileDeploymentSourceType.findExtension(DockerFileDeploymentSourceType.class);
    }

    public DockerFileDeploymentSourceType() {
        super(ID, DockerBundle.getText("DockerFileDeploymentSourceType.name", new Object[0]), DockerIcons.DockerFile_1);
    }

    @Override
    @Nullable
    public String suggestConfigurationName(@NotNull DockerDeploymentConfiguration configuration) {
        String sourceFilePath;
        if (configuration == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces((String)(sourceFilePath = configuration.getSourceFilePath()))) {
            return null;
        }
        String lastTwo = DockerFileDeploymentSourceType.lastTwoSegments(sourceFilePath);
        return DockerBundle.getText("DockerFileDeploymentSourceType.suggestRunConfigurationName", lastTwo);
    }

    @Override
    @NotNull
    public String getPresentableDeploymentName(@NotNull DockerDeploymentConfiguration configuration, @Nullable DockerApplicationRuntime runtime) {
        if (configuration == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(1);
        }
        String namePiece = configuration.isBuildOnly() ? DockerFileDeploymentSourceType.getPresentableImageNamePiece(configuration, runtime) : DockerFileDeploymentSourceType.getPresentableContainerNamePiece(configuration, runtime);
        String path = configuration.getSourceFilePath();
        String string = DockerBundle.getText("DockerFileDeploymentSourceType.deploymentName", namePiece, path);
        if (string == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getPresentableImageNamePiece(@NotNull DockerDeploymentConfiguration configuration, @Nullable DockerApplicationRuntime runtime) {
        List tags;
        if (configuration == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(3);
        }
        String result = runtime == null ? configuration.getImageTag() : ((tags = Optional.ofNullable(runtime.getImageRepoTags()).orElse(Collections.emptySet()).stream().map(DockerUtil::shortedId).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList())).size() > 1 ? tags.toString() : tags.stream().findAny().orElse(DockerUtil.shortedId((String)runtime.getImageId())));
        String string = StringUtil.isEmptyOrSpaces((String)result) ? "<unknown>" : result;
        if (string == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void checkDeploymentConfiguration(@NotNull Project project, @NotNull DockerDeploymentConfiguration configuration) throws RuntimeConfigurationException {
        if (project == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(6);
        }
        super.checkDeploymentConfiguration(project, configuration);
        File dockerFile = DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(project, configuration);
        if (dockerFile == null) {
            throw new RuntimeConfigurationError(DockerBundle.getText("DockerFileDeploymentSourceType.error.path.required", new Object[0]));
        }
        if (!dockerFile.exists() || !dockerFile.isFile()) {
            throw new RuntimeConfigurationError(DockerBundle.getText("DockerFileDeploymentSourceType.error.dockerfile.does.not.exist", dockerFile));
        }
        DockerFileDeploymentSourceType.checkImageTagFormat(configuration);
        DockerFileDeploymentSourceType.checkContainerNameFormat(configuration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deploymentSource/DockerFileDeploymentSourceType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deploymentSource/DockerFileDeploymentSourceType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableDeploymentName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableImageNamePiece";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestConfigurationName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableDeploymentName";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableImageNamePiece";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkDeploymentConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

