/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerFileSearchUtil;
import com.intellij.docker.agent.cli.CliParserBase;
import com.intellij.docker.cli.DockerBuildCliBuilder;
import com.intellij.docker.cli.DockerBuildCliSplitter;
import com.intellij.docker.cli.NormalizedCommandLine;
import com.intellij.docker.deployment.ui.DockerCliOptionsField;
import com.intellij.docker.deployment.ui.DockerDeploymentSourcePathCombo;
import com.intellij.docker.deployment.ui.DockerEnvVarFieldWithBrowseButton;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerBuildSettingsUI {
    private final Project myProject;
    private ContextFolderListener myContextFolderListener;
    private JPanel myMainPanel;
    private JTextField myImageTextField;
    private ComboBox mySourcePathCombo;
    private TextFieldWithBrowseButton myBuildArgsField;
    private TextFieldWithBrowseButton myContextFolderField;
    private ExpandableTextField myBuildCliOptionsField;
    private File myLastReportedContextFolder;

    public DockerBuildSettingsUI(@NotNull Project project) {
        if (project == null) {
            DockerBuildSettingsUI.$$$reportNull$$$0(0);
        }
        this.myContextFolderListener = ContextFolderListener.NULL;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.getContextFolderField().getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                DockerBuildSettingsUI.this.notifyContextFolderChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/deployment/ui/DockerBuildSettingsUI$1", "textChanged"));
            }
        });
        this.getSourcePathCombo().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                DockerBuildSettingsUI.this.onDockerfileChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/deployment/ui/DockerBuildSettingsUI$2", "textChanged"));
            }
        });
        this.getSourcePathCombo().addBrowseFolderActionListener(this.myProject, DockerBundle.getText("DockerBuildSettingsUI.sourcePathCombo.dialogTitle", new Object[0]), DockerBundle.getText("DockerBuildSettingsUI.sourcePathCombo.dialogDescription", new Object[0]), FileChooserDescriptorFactory.createSingleFileDescriptor());
        for (VirtualFile nextDockerfile : DockerFileSearchUtil.getDockerFiles(this.myProject, false)) {
            this.getSourcePathCombo().addPredefinedFile(this.myProject, nextDockerfile);
        }
    }

    public void setContextFolderListener(@Nullable ContextFolderListener listener) {
        this.myContextFolderListener = Optional.ofNullable(listener).orElse(ContextFolderListener.NULL);
        this.myLastReportedContextFolder = null;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void resetEditorFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerBuildSettingsUI.$$$reportNull$$$0(1);
        }
        ((DockerDeploymentSourcePathCombo)this.mySourcePathCombo).resetUiFrom(configuration);
        this.myImageTextField.setText(configuration.getImageTag());
        this.getBuildArgsField().setEnvVars(configuration.getBuildArgs());
        this.getContextFolderField().resetUiFrom(configuration);
        this.getBuildCliOptionsField().resetEditorFrom(configuration);
    }

    public void applyEditorTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerBuildSettingsUI.$$$reportNull$$$0(2);
        }
        this.getSourcePathCombo().applyUiTo(configuration);
        configuration.setImageTag(this.myImageTextField.getText());
        configuration.setBuildArgs(this.getBuildArgsField().getEnvVars());
        this.getContextFolderField().applyUiTo(configuration);
        this.getBuildCliOptionsField().applyValueTo(configuration);
    }

    public DockerBuildCliBuilder prepareBuildCliBuilder() {
        DockerBuildCliBuilder builder = new DockerBuildCliBuilder();
        builder.setDockerFile(this.getSourcePathCombo().getValueToApply());
        for (Map.Entry<String, String> argEntry : this.getBuildArgsField().getPairs().entrySet()) {
            if (argEntry.getKey() == null) continue;
            builder.addBuildArg(argEntry.getKey(), argEntry.getValue());
        }
        builder.setImageTag(this.getNotEmptyImageTag());
        try {
            NormalizedCommandLine userOptions = this.getBuildCliOptionsField().getParsedOptions();
            if (userOptions != null) {
                builder.setCustomBuildOptions(userOptions);
            }
        }
        catch (CliParserBase.IllegalOptionException | ParseException throwable) {
            // empty catch block
        }
        return builder;
    }

    @NotNull
    public String getNotEmptyImageTag() {
        String imageTag = this.myImageTextField.getText();
        String string = StringUtil.isEmptyOrSpaces((String)imageTag) ? "<image_tag>" : imageTag;
        if (string == null) {
            DockerBuildSettingsUI.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void onDockerfileChanged() {
        String path = this.getSourcePathCombo().getValueToApply();
        File file2 = DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(this.myProject, path);
        this.getContextFolderField().setDockerfile(file2);
        this.notifyContextFolderChanged();
    }

    private void notifyContextFolderChanged() {
        File newContextFolder = this.getContextFolderField().getContextFolder();
        if (!FileUtil.filesEqual((File)this.myLastReportedContextFolder, (File)newContextFolder)) {
            this.myContextFolderListener.onContextFolderChanged(newContextFolder);
            this.myLastReportedContextFolder = newContextFolder;
        }
    }

    private void createUIComponents() {
        this.mySourcePathCombo = new DockerDeploymentSourcePathCombo();
        this.myBuildArgsField = new BuildArgsField();
        this.myContextFolderField = new ContextFolderField(this.myProject);
        this.myBuildCliOptionsField = new DockerBuildOptionsField();
    }

    private DockerBuildOptionsField getBuildCliOptionsField() {
        return (DockerBuildOptionsField)this.myBuildCliOptionsField;
    }

    private DockerDeploymentSourcePathCombo getSourcePathCombo() {
        return (DockerDeploymentSourcePathCombo)this.mySourcePathCombo;
    }

    private ContextFolderField getContextFolderField() {
        return (ContextFolderField)this.myContextFolderField;
    }

    private BuildArgsField getBuildArgsField() {
        return (BuildArgsField)this.myBuildArgsField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerBuildSettingsUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerBuildSettingsUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotEmptyImageTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Dockerfile:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboBox comboBox = this.mySourcePathCombo;
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Image tag:");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myImageTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Build args:");
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myBuildArgsField;
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myContextFolderField;
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Context folder:");
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Build options:");
        jPanel.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ExpandableTextField expandableTextField = this.myBuildCliOptionsField;
        jPanel.add((Component)expandableTextField, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)comboBox);
        jBLabel2.setLabelFor(jTextField);
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel3.setLabelFor((Component)textFieldWithBrowseButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static interface ContextFolderListener {
        public static final ContextFolderListener NULL = folder -> {};

        public void onContextFolderChanged(@Nullable File var1);
    }

    private static class DockerBuildOptionsField
    extends DockerCliOptionsField {
        private DockerBuildOptionsField() {
            super(new DockerBuildCliSplitter());
        }

        @Override
        protected void storeRawText(@NotNull DockerDeploymentConfiguration configuration) {
            if (configuration == null) {
                DockerBuildOptionsField.$$$reportNull$$$0(0);
            }
            configuration.setBuildCliOptions(this.getText());
        }

        @Override
        public void resetEditorFrom(@NotNull DockerDeploymentConfiguration configuration) {
            if (configuration == null) {
                DockerBuildOptionsField.$$$reportNull$$$0(1);
            }
            String optionsLine = configuration.getBuildCliOptions();
            this.setText(optionsLine);
        }

        @Override
        protected void handleParseException(ParseException e) throws ConfigurationException {
            throw new RuntimeConfigurationWarning(DockerBundle.getText("DockerBuildSettingsUI.DockerBuildOptionsField.onParseError", e.getMessage()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "configuration";
            objectArray2[1] = "com/intellij/docker/deployment/ui/DockerBuildSettingsUI$DockerBuildOptionsField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeRawText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resetEditorFrom";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ContextFolderField
    extends TextFieldWithBrowseButton {
        private final Project myProject;
        private File myDefaultFolder;

        ContextFolderField(@NotNull Project project) {
            if (project == null) {
                ContextFolderField.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> browseListener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(DockerBundle.getText("DockerBuildSettingsUI.ContextFolderField.dialogTitle", new Object[0]), DockerBundle.getText("DockerBuildSettingsUI.ContextFolderField.dialogDescription", new Object[0]), (ComponentWithBrowseButton)this, this.myProject, chooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

                @NotNull
                protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                    if (chosenFile == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String string = DockerDeploymentConfiguration.ProjectAwareHelper.getPathToStore(myProject, chosenFile);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @Nullable
                protected VirtualFile getInitialFile() {
                    int pos;
                    File context = this.getContextFolder();
                    if (context == null) {
                        return null;
                    }
                    String directoryName = FileUtil.toSystemIndependentName((String)context.getAbsolutePath());
                    VirtualFile path = LocalFileSystem.getInstance().findFileByPath(this.expandPath(directoryName));
                    while (path == null && directoryName.length() > 0 && (pos = directoryName.lastIndexOf(47)) > 0) {
                        directoryName = directoryName.substring(0, pos);
                        path = LocalFileSystem.getInstance().findFileByPath(directoryName);
                    }
                    return path;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "chosenFile";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/docker/deployment/ui/DockerBuildSettingsUI$ContextFolderField$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/docker/deployment/ui/DockerBuildSettingsUI$ContextFolderField$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "chosenFileToResultingText";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "chosenFileToResultingText";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            this.addActionListener((ActionListener)browseListener);
            this.installPathCompletion(chooserDescriptor);
            this.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.refreshColor();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/deployment/ui/DockerBuildSettingsUI$ContextFolderField$2", "textChanged"));
                }
            });
        }

        public void resetUiFrom(@NotNull DockerDeploymentConfiguration configuration) {
            if (configuration == null) {
                ContextFolderField.$$$reportNull$$$0(1);
            }
            this.doSetDockerFile(DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(this.myProject, configuration));
            this.setContextFolderPath(configuration.getContextFolderPath());
        }

        public void applyUiTo(@NotNull DockerDeploymentConfiguration configuration) {
            File asShown;
            if (configuration == null) {
                ContextFolderField.$$$reportNull$$$0(2);
            }
            String folderPathToStore = this.isDefaultValue(asShown = this.getValueAsShown()) ? null : this.transformToPath(asShown);
            configuration.setContextFolderPath(folderPathToStore);
        }

        public File getContextFolder() {
            return this.hasDefaultValue() ? this.myDefaultFolder : this.getValueAsShown();
        }

        public void setDockerfile(@Nullable File dockerFile) {
            boolean wasDefault = this.hasDefaultValue();
            this.doSetDockerFile(dockerFile);
            if (wasDefault) {
                this.resetToDefault();
            }
            this.refreshColor();
        }

        private void setContextFolderPath(@Nullable String folderPath) {
            File newValue = this.transformToFile(folderPath);
            if (this.isDefaultValue(newValue)) {
                this.resetToDefault();
            } else {
                this.setText(folderPath);
            }
            this.refreshColor();
        }

        private void doSetDockerFile(@Nullable File dockerFile) {
            this.myDefaultFolder = dockerFile == null ? null : dockerFile.getParentFile();
        }

        private void resetToDefault() {
            String path = this.myDefaultFolder == null ? "" : this.transformToPath(this.myDefaultFolder);
            this.getTextField().setText(path);
        }

        private void refreshColor() {
            this.getTextField().setForeground(this.hasDefaultValue() ? UIUtil.getLabelDisabledForeground() : UIUtil.getLabelForeground());
        }

        private boolean hasDefaultValue() {
            return this.isDefaultValue(this.getValueAsShown());
        }

        private boolean isDefaultValue(@Nullable File file2) {
            return file2 == null || FileUtil.filesEqual((File)file2, (File)this.myDefaultFolder);
        }

        @Nullable
        private File transformToFile(@Nullable String path) {
            return StringUtil.isEmptyOrSpaces((String)path) ? null : DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(this.myProject, path);
        }

        @Nullable
        String transformToPath(@Nullable File file2) {
            return file2 == null ? null : DockerDeploymentConfiguration.ProjectAwareHelper.getPathToStore(this.myProject, file2);
        }

        @Nullable
        private File getValueAsShown() {
            return this.transformToFile(this.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/deployment/ui/DockerBuildSettingsUI$ContextFolderField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resetUiFrom";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyUiTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BuildArgsField
    extends DockerEnvVarFieldWithBrowseButton {
        BuildArgsField() {
            super(DockerBundle.getText("DockerBuildSettingsUI.BuildArgsField.dialogTitle", new Object[0]), DockerBundle.getText("DockerBuildSettingsUI.BuildArgsField.dialogEmptyText", new Object[0]));
        }
    }
}

