/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import com.intellij.docker.agent.CreateContainerCmdValueTransfers;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentApplicationBase;
import com.intellij.docker.agent.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.DockerBuildCliParser;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.DockerRunCliParser;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.VolumeMapper;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerAgentDeploymentImpl
extends DockerAgentApplicationBase
implements DockerAgentDeployment {
    private static final String[] NO_TAGS = new String[0];
    private final DockerAgentDeploymentConfig myConfig;
    private final CloudAgentLoggingHandler myLoggingHandler;
    private final VolumeMapper myVolumeMapper;
    private volatile String myImageId;
    private volatile String myImageTag;

    public DockerAgentDeploymentImpl(DockerAgentContext context, DockerAgentDeploymentConfig config, CloudAgentLoggingHandler loggingHandler, DockerAgentPathMapper pathMapper) {
        super(context);
        this.myConfig = config;
        this.myLoggingHandler = loggingHandler;
        this.myVolumeMapper = new VolumeMapper(pathMapper);
    }

    public DockerAgentApplication.ContainerUpdateResult deploy() {
        return (DockerAgentApplication.ContainerUpdateResult)new ApiTaskBase<DockerAgentApplication.ContainerUpdateResult>(this.getErrorHandler()){

            @Override
            protected DockerAgentApplication.ContainerUpdateResult doPerform() throws IOException, ApiTaskException {
                DockerAgentSourceType sourceType = DockerAgentSourceType.valueOf((String)DockerAgentDeploymentImpl.this.myConfig.sourceType());
                return new SingleDeployTask(sourceType).deploy();
            }
        }.perform();
    }

    @Override
    protected Bind[] prepareBinds(Bind[] binds) {
        return this.myVolumeMapper.expandPath(binds);
    }

    private void buildImage() throws IOException, ApiTaskException {
        if (!this.getAgent().isConnected()) {
            throw new ApiTaskException("Not connected to docker");
        }
        this.myLoggingHandler.println("Building image...");
        BuildImageCmdWithCleanup buildImageCmd = BuildImageCmdWithCleanup.forConfig(this.getClient(), this.myConfig);
        buildImageCmd.withTag(this.myConfig.getImageTag());
        buildImageCmd.withCliOptions(this.myConfig.getCustomBuildOptions());
        buildImageCmd.withBuildArgs(this.myConfig.getBuildArgs());
        buildImageCmd.execBuildImage(new BuildCallback());
        if (this.myImageId == null) {
            throw new ApiTaskException("Can't retrieve image ID from build stream");
        }
    }

    @Override
    public void showLog(CloudAgentLoggingHandler loggingHandler) {
        super.showLog(this.myLoggingHandler);
    }

    @Override
    public void attach(CloudAgentLoggingHandler loggingHandler) {
        super.attach(this.myLoggingHandler);
    }

    @Override
    public OngoingProcess exec(CloudAgentLoggingHandler loggingHandler, String[] command, String logName) {
        return super.exec(this.myLoggingHandler, command, logName);
    }

    public String getContainerName() {
        return null;
    }

    public String getImageId() {
        return this.myImageId;
    }

    public String[] getImageRepoTags() {
        String[] stringArray;
        if (this.myImageTag == null) {
            stringArray = NO_TAGS;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.myImageTag;
        }
        return stringArray;
    }

    public String[] getContainerNames() {
        return null;
    }

    public String getImageParentId() {
        return null;
    }

    @Nullable
    public String getPresentableName() {
        return null;
    }

    @NotNull
    public String getUniqueName() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String getName() {
        throw new UnsupportedOperationException();
    }

    public String getContainerStatus() {
        return null;
    }

    @Override
    protected void setupContainerConfig(CreateContainerCmd target) {
        super.setupContainerConfig(target);
        if (this.myImageId != null) {
            target.withImage(this.myImageId);
        }
    }

    private static Predicate<Container> withContainerName(@NotNull String name) {
        if (name == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(0);
        }
        String searchPattern = name.startsWith("/") ? name : "/" + name;
        return container -> {
            String[] containerNames = container.getNames();
            return containerNames != null && Arrays.asList(containerNames).contains(searchPattern);
        };
    }

    private static Predicate<Container> withLabel(@NotNull String label, @NotNull String value) {
        if (label == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(1);
        }
        if (value == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(2);
        }
        return container -> {
            Map allLabels = container.getLabels();
            return allLabels != null && value.equals(allLabels.get(label));
        };
    }

    private static Predicate<Image> idStartsWith(@NotNull String idOrTag) {
        if (idOrTag == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(3);
        }
        return img -> img.getId() != null && DockerAgentDeploymentImpl.trimShaPrefix(img.getId()).startsWith(DockerAgentDeploymentImpl.trimShaPrefix(idOrTag));
    }

    private static String trimShaPrefix(@NotNull String imageId) {
        if (imageId == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(4);
        }
        return imageId.startsWith("sha256:") ? imageId.substring("sha256:".length()) : imageId;
    }

    private static boolean safeValueOf(@Nullable Boolean bool) {
        return bool != null && bool != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idOrTag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/agent/DockerAgentDeploymentImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withContainerName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withLabel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "idStartsWith";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "trimShaPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class SingleDeployTask
    extends DeployTask {
        private CreateContainerCmdConfig myContainerCmdConfig;
        private final DockerAgentSourceType mySourceType;

        SingleDeployTask(DockerAgentSourceType sourceType) {
            this.mySourceType = sourceType;
        }

        @Override
        protected String doPrepareDeploy() throws IOException, ApiTaskException {
            CreateContainerCmdConfig cmdConfig = new CreateContainerCmdConfig();
            this.applyCustomRunCliOptions((CreateContainerCmd)cmdConfig);
            this.myContainerCmdConfig = cmdConfig;
            if (this.mySourceType == DockerAgentSourceType.IMAGE) {
                DockerAgentDeploymentImpl.this.myImageId = this.pullImageIfNeeded();
            } else {
                DockerAgentDeploymentImpl.this.buildImage();
            }
            return DockerAgentDeploymentImpl.this.myConfig.getContainerName();
        }

        private void applyCustomRunCliOptions(CreateContainerCmd cmd) throws ApiTaskException {
            String[] cliOptions = DockerAgentDeploymentImpl.this.myConfig.getCustomRunOptions();
            if (cliOptions == null) {
                return;
            }
            File context = DockerAgentDeploymentImpl.this.myConfig.getCustomContextFolder();
            if (context == null && DockerAgentDeploymentImpl.this.myConfig.getFile() != null) {
                context = DockerAgentDeploymentImpl.this.myConfig.getFile().getParentFile();
            }
            DockerRunCliParser parser = new DockerRunCliParser();
            if (context != null) {
                parser.setContextFolder(context);
            }
            parser.parse(cmd, cliOptions);
        }

        @Override
        protected CreateContainerCmdConfig getContainerCmdConfig() {
            return this.myContainerCmdConfig;
        }

        @Override
        protected DockerAgentContainerConfigImpl getPriorityConfig() {
            return new DockerAgentContainerConfigImpl((DockerAgentContainerConfig)DockerAgentDeploymentImpl.this.myConfig);
        }

        @Override
        protected void setContainerId(String containerId) {
            DockerAgentDeploymentImpl.this.setContainerId(containerId);
        }

        private String pullImageIfNeeded() throws ApiTaskException {
            DockerRepoTag tag;
            String imageTagOrId = DockerAgentDeploymentImpl.this.myConfig.getImageTag();
            Predicate<Image> filter = DockerAgentDeploymentImpl.idStartsWith(imageTagOrId);
            if (imageTagOrId.startsWith("sha256:")) {
                tag = null;
            } else {
                tag = DockerRepoTag.fromString((String)imageTagOrId);
                filter = filter.or(img -> tag.matchesOneOfRepoTags(img.getRepoTags()));
            }
            Image localImage = this.findImageLocally(filter);
            if (localImage != null) {
                return localImage.getId();
            }
            if (tag == null) {
                return imageTagOrId;
            }
            DockerAgentDeploymentImpl.this.myLoggingHandler.println(MessageFormat.format("Unable to find image ''{0}'' locally", tag.getFullyQualifiedReference()));
            DockerAgentRepositoryConfig endpoint = new DockerAgentRepositoryConfig(){

                public DockerAuthConfig getAuthConfig() {
                    return null;
                }

                @NotNull
                public String getQualifiedRepository() {
                    String string = tag.getQualifiedRepository();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public String getTag() {
                    return tag.getTagNotNull();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/agent/DockerAgentDeploymentImpl$SingleDeployTask$1", "getQualifiedRepository"));
                }
            };
            class PullCallback
            implements DockerAgentProgressCallback {
                private volatile String myErrorMessage;

                PullCallback() {
                }

                public void step(String status, long current, long total) {
                    if (total != 0L) {
                        DockerAgentDeploymentImpl.this.myLoggingHandler.println(status + " " + current + "/" + total);
                    } else {
                        DockerAgentDeploymentImpl.this.myLoggingHandler.println(status);
                    }
                }

                public void succeeded(String message) {
                    DockerAgentDeploymentImpl.this.myLoggingHandler.println(message);
                }

                public void failed(String message) {
                    this.myErrorMessage = message;
                    DockerAgentDeploymentImpl.this.myLoggingHandler.println(message);
                }

                public void rethrowError() throws ApiTaskException {
                    if (this.myErrorMessage != null) {
                        throw new ApiTaskException(this.myErrorMessage);
                    }
                }
            }
            PullCallback callback = new PullCallback();
            OngoingProcess process = DockerAgentDeploymentImpl.this.getAgent().pullImage(endpoint, (DockerAgentProgressCallback)callback);
            process.await();
            callback.rethrowError();
            localImage = this.findImageLocally(filter);
            if (localImage == null) {
                throw new ApiTaskException("No such image " + tag.getFullyQualifiedReference());
            }
            return localImage.getId();
        }

        private Image findImageLocally(Predicate<Image> filter) {
            List images = (List)DockerAgentDeploymentImpl.this.getClient().listImagesCmd().withShowAll(Boolean.TRUE).exec();
            if (images == null || images.isEmpty()) {
                return null;
            }
            return images.stream().filter(filter).findAny().orElse(null);
        }
    }

    private abstract class DeployTask {
        private DeployTask() {
        }

        public DockerAgentApplication.ContainerUpdateResult deploy() throws IOException, ApiTaskException {
            String containerName = this.doPrepareDeploy();
            DockerAgentApplicationBase.ContainerUpdateResultImpl deployResult = new DockerAgentApplicationBase.ContainerUpdateResultImpl(DockerAgentDeploymentImpl.this.myImageId);
            if (DockerAgentDeploymentImpl.this.myConfig.isBuildImageOnly()) {
                return deployResult;
            }
            if (!DockerAgentDeploymentImpl.this.getAgent().isConnected()) {
                return deployResult;
            }
            String oldContainerId = this.findPreviousContainer();
            if (oldContainerId != null) {
                DockerAgentDeploymentImpl.this.myLoggingHandler.println("Existing container found: " + oldContainerId + ", removing...");
                DockerAgentDeploymentImpl.this.getClient().removeContainerCmd(oldContainerId).withForce(Boolean.TRUE).exec();
                deployResult.setRemovedContainerId(oldContainerId);
            }
            DockerAgentDeploymentImpl.this.myLoggingHandler.println("Creating container...");
            CreateContainerCmd createContainerCmd = DockerAgentDeploymentImpl.this.getClient().createContainerCmd(DockerAgentDeploymentImpl.this.myImageId);
            if (containerName != null) {
                createContainerCmd.withName(containerName);
            }
            CreateContainerCmdConfig cmdConfig = this.getContainerCmdConfig();
            CreateContainerCmdValueTransfers.createMergeForDeploy(binds -> DockerAgentDeploymentImpl.this.prepareBinds((Bind[])binds)).mergeWithPriority(this.getPriorityConfig(), cmdConfig, createContainerCmd);
            DockerAgentDeploymentImpl.this.setupContainerConfig(createContainerCmd);
            if (DockerAgentDeploymentImpl.this.myLoggingHandler.isTtySupported()) {
                createContainerCmd.withTty(Boolean.TRUE);
            }
            CreateContainerResponse createContainerResponse = createContainerCmd.exec();
            String containerId = createContainerResponse.getId();
            this.setContainerId(containerId);
            String[] warnings = createContainerResponse.getWarnings();
            if (warnings != null) {
                for (String warning : warnings) {
                    DockerAgentDeploymentImpl.this.myLoggingHandler.println("Warning: " + warning);
                }
            }
            if (DockerAgentDeploymentImpl.this.getAgent().isConnected() && !DockerAgentDeploymentImpl.this.myConfig.isCreateContainerOnly()) {
                boolean attach = DockerAgentDeploymentImpl.safeValueOf(cmdConfig.isAttachStdin()) && DockerAgentDeploymentImpl.safeValueOf(cmdConfig.isStdinOpen());
                this.startContainer(containerId, containerName, attach);
            }
            return deployResult;
        }

        private void startContainer(@NotNull String containerId, @Nullable String containerName, boolean attach) throws IOException, ApiTaskException {
            InspectContainerResponse inspectResponse;
            if (containerId == null) {
                DeployTask.$$$reportNull$$$0(0);
            }
            DockerAgentDeploymentImpl.this.myLoggingHandler.println("Container Id: " + containerId);
            if ((containerName == null || containerName.isEmpty()) && (inspectResponse = DockerAgentDeploymentImpl.this.getClient().inspectContainerCmd(containerId).exec()) != null && inspectResponse.getName() != null) {
                containerName = inspectResponse.getName();
            }
            String containerMessageSuffix = this.safeQuote(containerName);
            DockerAgentDeploymentImpl.this.myLoggingHandler.println("Container name: " + containerMessageSuffix);
            if (attach) {
                DockerAgentDeploymentImpl.this.myLoggingHandler.println("Attaching to container " + containerMessageSuffix + "...");
                DockerAgentDeploymentImpl.this.doAttach(containerId, DockerAgentDeploymentImpl.this.myLoggingHandler);
            } else {
                DockerAgentDeploymentImpl.this.doShowLog(containerId, DockerAgentDeploymentImpl.this.myLoggingHandler);
            }
            DockerAgentDeploymentImpl.this.myLoggingHandler.println("Starting container " + containerMessageSuffix);
            StartContainerCmd startContainerCmd = DockerAgentDeploymentImpl.this.getClient().startContainerCmd(containerId);
            startContainerCmd.exec();
        }

        @Nullable
        private String findPreviousContainer() {
            Predicate condition = null;
            String containerName = DockerAgentDeploymentImpl.this.myConfig.getContainerName();
            if (containerName != null && containerName.length() > 0) {
                condition = DockerAgentDeploymentImpl.withContainerName(containerName);
            } else if (DockerAgentDeploymentImpl.this.myConfig.getLabels() != null) {
                condition = Stream.of(DockerAgentDeploymentImpl.this.myConfig.getLabels()).filter(l -> "com.intellij.docker.source.run.configuration".equals(l.getKey())).findAny().map(label -> DockerAgentDeploymentImpl.withLabel("com.intellij.docker.source.run.configuration", label.getValue())).orElse(null);
            }
            if (condition == null) {
                return null;
            }
            return ((List)DockerAgentDeploymentImpl.this.getClient().listContainersCmd().withShowAll(Boolean.TRUE).exec()).stream().filter(condition).findAny().map(Container::getId).orElse(null);
        }

        protected abstract void setContainerId(String var1);

        protected abstract String doPrepareDeploy() throws IOException, ApiTaskException;

        protected abstract CreateContainerCmdConfig getContainerCmdConfig();

        protected abstract DockerAgentContainerConfigImpl getPriorityConfig();

        private String safeQuote(String text) {
            return text == null ? "" : "'" + text + "'";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerId", "com/intellij/docker/agent/DockerAgentDeploymentImpl$DeployTask", "startContainer"));
        }
    }

    private static class BuildImageCmdWithCleanup {
        private final BuildImageCmd myCmd;
        private final Runnable myCleanup;

        public static BuildImageCmdWithCleanup forConfig(@NotNull DockerClient client, @NotNull DockerAgentDeploymentConfig config) throws IOException, ApiTaskException {
            if (client == null) {
                BuildImageCmdWithCleanup.$$$reportNull$$$0(0);
            }
            if (config == null) {
                BuildImageCmdWithCleanup.$$$reportNull$$$0(1);
            }
            File file = config.getFile();
            if (config.isFileArchive()) {
                return new BuildImageCmdWithCleanup(client.buildImageCmd((InputStream)new FileInputStream(file)));
            }
            File customContextFolder = config.getCustomContextFolder();
            if (customContextFolder == null || file != null && customContextFolder.equals(file.getParentFile())) {
                return new BuildImageCmdWithCleanup(client.buildImageCmd(file));
            }
            Path copiedDockerfile = customContextFolder.toPath().resolve(file.getName());
            if (copiedDockerfile.toFile().exists()) {
                throw new IOException("Dockerfile already exist in context folder " + copiedDockerfile + ", can't copy from " + file);
            }
            Files.copy(file.toPath(), copiedDockerfile, new CopyOption[0]);
            Runnable cleanupCopiedDockerfile = () -> {
                try {
                    Files.delete(copiedDockerfile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            };
            BuildImageCmd cmd = client.buildImageCmd().withBaseDirectory(customContextFolder).withDockerfile(copiedDockerfile.toFile());
            return new BuildImageCmdWithCleanup(cmd, cleanupCopiedDockerfile);
        }

        private BuildImageCmdWithCleanup(@NotNull BuildImageCmd wrappedCmd) {
            if (wrappedCmd == null) {
                BuildImageCmdWithCleanup.$$$reportNull$$$0(2);
            }
            this(wrappedCmd, null);
        }

        private BuildImageCmdWithCleanup(@NotNull BuildImageCmd wrappedCmd, @Nullable Runnable cleanup) {
            if (wrappedCmd == null) {
                BuildImageCmdWithCleanup.$$$reportNull$$$0(3);
            }
            this.myCmd = wrappedCmd;
            this.myCleanup = cleanup;
        }

        public void withTag(@Nullable String tag) {
            if (tag != null) {
                this.myCmd.withTags(Collections.singleton(tag));
            }
        }

        public void withBuildArgs(@Nullable DockerEnvVar[] args) {
            if (args == null) {
                return;
            }
            for (DockerEnvVar next : args) {
                String nextName = next.getName();
                if (nextName == null || nextName.length() == 0) continue;
                this.myCmd.withBuildArg(nextName, next.getValue());
            }
        }

        public void withCliOptions(String[] cliOptions) throws ApiTaskException {
            if (cliOptions == null) {
                return;
            }
            DockerBuildCliParser parser = new DockerBuildCliParser();
            parser.parse(this.myCmd, cliOptions);
        }

        public void execBuildImage(@NotNull BuildCallback buildCallback) throws ApiTaskException, IOException {
            if (buildCallback == null) {
                BuildImageCmdWithCleanup.$$$reportNull$$$0(4);
            }
            try {
                buildCallback = (BuildCallback)this.myCmd.exec((ResultCallback)buildCallback);
                buildCallback.waitFor();
            }
            finally {
                if (this.myCleanup != null) {
                    this.myCleanup.run();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappedCmd";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildCallback";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/agent/DockerAgentDeploymentImpl$BuildImageCmdWithCleanup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "forConfig";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execBuildImage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class BuildCallback
    implements ResultCallback<BuildResponseItem> {
        private final Object myMutex = new Object();
        private String myError;
        private boolean myClosed = false;

        private BuildCallback() {
        }

        public void onStart(Closeable closeable) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(BuildResponseItem item) {
            Object object = this.myMutex;
            synchronized (object) {
                String progress;
                String imageTag;
                String imageId = item.getImageId();
                if (imageId != null) {
                    DockerAgentDeploymentImpl.this.myImageId = imageId;
                }
                if ((imageTag = this.getImageTag(item)) != null) {
                    DockerAgentDeploymentImpl.this.myImageTag = imageTag;
                }
                String error = item.getError();
                String stream = item.getStream();
                String status = item.getStatus();
                if (error != null) {
                    this.myError = error;
                    String errorMessage = error;
                    ResponseItem.ErrorDetail errorDetail = item.getErrorDetail();
                    if (errorDetail != null) {
                        errorMessage = errorDetail.toString();
                    }
                    DockerAgentDeploymentImpl.this.myLoggingHandler.println("Error: " + errorMessage);
                }
                if (stream != null) {
                    DockerAgentDeploymentImpl.this.myLoggingHandler.println(stream);
                }
                StringBuilder statusLine = new StringBuilder();
                if (status != null) {
                    statusLine.append("Status: ");
                    statusLine.append(status);
                }
                if ((progress = item.getProgress()) != null) {
                    statusLine.append(" Progress: ");
                    statusLine.append(progress);
                }
                if (statusLine.length() != 0) {
                    DockerAgentDeploymentImpl.this.myLoggingHandler.println(statusLine.toString());
                }
            }
        }

        private String getImageTag(BuildResponseItem item) {
            if (item.isErrorIndicated()) {
                return null;
            }
            String TAGGED_MESSAGE = "Successfully tagged";
            return Optional.ofNullable(item.getStream()).filter(s -> s.contains("Successfully tagged")).map(s -> s.replace("Successfully tagged", "")).map(String::trim).orElse(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable throwable) {
            Object object = this.myMutex;
            synchronized (object) {
                this.myError = throwable.getMessage();
                this.doClose();
            }
        }

        public void onComplete() {
            this.doClose();
        }

        public void close() throws IOException {
            this.doClose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doClose() {
            Object object = this.myMutex;
            synchronized (object) {
                this.myClosed = true;
                this.myMutex.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFor() throws ApiTaskException {
            Object object = this.myMutex;
            synchronized (object) {
                try {
                    while (!this.myClosed) {
                        this.myMutex.wait();
                    }
                }
                catch (InterruptedException e) {
                    DockerAgentDeploymentImpl.this.getLogger().debugEx((Exception)e);
                }
                if (this.myError != null) {
                    throw new ApiTaskException(this.myError);
                }
            }
        }
    }
}

