/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/netty/bootstrap/BootstrapUtil;", "", "()V", "initAndRegister", "Lio/netty/channel/ChannelFuture;", "channel", "Lio/netty/channel/Channel;", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "intellij.platform.ide.util.io"})
public final class BootstrapUtil {
    public static final BootstrapUtil INSTANCE;

    @NotNull
    public final ChannelFuture initAndRegister(@NotNull Channel channel, @NotNull Bootstrap bootstrap) throws Throwable {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)bootstrap, (String)"bootstrap");
        try {
            bootstrap.init(channel);
        }
        catch (Throwable e) {
            channel.unsafe().closeForcibly();
            throw e;
        }
        ChannelFuture registrationFuture = bootstrap.group().register(channel);
        if (registrationFuture.cause() != null) {
            if (channel.isRegistered()) {
                channel.close();
            } else {
                channel.unsafe().closeForcibly();
            }
        }
        ChannelFuture channelFuture = registrationFuture;
        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"registrationFuture");
        return channelFuture;
    }

    private BootstrapUtil() {
    }

    static {
        BootstrapUtil bootstrapUtil;
        INSTANCE = bootstrapUtil = new BootstrapUtil();
    }
}

