/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.ByteBuffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u0007*\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u000b\u001a\u00020\u0002*\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u00a8\u0006\f"}, d2={"getUnsignedByte", "", "Lkotlinx/io/ByteBuffer;", "getUnsignedInt", "", "getUnsignedShort", "readExactNBytes", "", "Ljava/io/InputStream;", "Lkotlinx/io/InputStream;", "bytes", "readToByteBuffer", "kotlinx-serialization-runtime"})
public final class UtilKt {
    @NotNull
    public static final byte[] readExactNBytes(@NotNull InputStream $this$readExactNBytes, int bytes) {
        int i;
        Intrinsics.checkParameterIsNotNull((Object)$this$readExactNBytes, (String)"$this$readExactNBytes");
        byte[] array = new byte[bytes];
        for (int read = 0; read < bytes; read += i) {
            i = $this$readExactNBytes.read(array, read, bytes - read);
            if (i != -1) continue;
            throw (Throwable)new IOException("Unexpected EOF");
        }
        return array;
    }

    @NotNull
    public static final ByteBuffer readToByteBuffer(@NotNull InputStream $this$readToByteBuffer, int bytes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readToByteBuffer, (String)"$this$readToByteBuffer");
        byte[] arr = UtilKt.readExactNBytes($this$readToByteBuffer, bytes);
        ByteBuffer buf = ByteBuffer.Companion.allocate(bytes);
        buf.put(arr).flip();
        return buf;
    }

    public static final int getUnsignedByte(@NotNull ByteBuffer $this$getUnsignedByte) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getUnsignedByte, (String)"$this$getUnsignedByte");
        return $this$getUnsignedByte.get() & 0xFF;
    }

    public static final int getUnsignedShort(@NotNull ByteBuffer $this$getUnsignedShort) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getUnsignedShort, (String)"$this$getUnsignedShort");
        return $this$getUnsignedShort.getShort() & 0xFFFF;
    }

    public static final long getUnsignedInt(@NotNull ByteBuffer $this$getUnsignedInt) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getUnsignedInt, (String)"$this$getUnsignedInt");
        return (long)$this$getUnsignedInt.getInt() & 0xFFFFFFFFL;
    }
}

